<?php
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/web/Form.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
abstract class ABMFormMinimal extends Form {
  /**
   * @var ORM la instancia del manejador de objetos que mantiene la clase
   */
  protected $orm;

  /**
   * Crea una instancia de Form.
   * 
   * @return Form
   */
  public function __construct(&$context, &$orm)
  {
    // Bouml preserved body begin 0016E205
	parent::__construct();
	$this->context = $context;
	$this->orm     = $orm;
	return $this;
    // Bouml preserved body end 0016E205
  }

  /**
   * Funcin invocada para crear una instancia del objeto que representa el formulario
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali bien y un FALSE sino.
   */
  public abstract function fresh($context, $orm)
  ;
  /**
   * Funcin invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali bien y un FALSE sino.
   */
  public abstract function modify($context, $orm)
  ;
  /**
   * Funcin invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali bien y un FALSE sino.
   */
  public abstract function saveNew($context, $orm)
  ;
  /**
   * Funcin invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali bien y un FALSE sino.
   */
  public abstract function saveModify($context, $orm)
  ;
  /**
   * Funcin invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali bien y un FALSE sino.
   */
  public abstract function delete($context, $orm)
  ;
  /**
   * Solicita al formulario que realice la tarea para la que est configurado.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return Renderable la pantalla que debe mostrar.
   */
  public function deploy(&$context = null, &$orm = null)
  {
    // Bouml preserved body begin 0016E505
	$this->context = $context;
    $this->orm = $orm;

	$form_action = $this->getValueOf('user_action');
	
	switch($form_action) {
        case 'NEW':
			$user_action = new HiddenComponent();
			$user_action->setId('id_user_action')
						->setName('user_action')
						->setValue('SAVENEW');
			$this->addComponent($user_action);
			$this->fresh($context, $orm);
			return parent::deploy($context);
			break;
        case 'MODIFY':
			$user_action = new HiddenComponent();
			$user_action->setId('id_user_action')
						->setName('user_action')
						->setValue('SAVEMODIFY');
			$this->addComponent($user_action);
			
			$this->modify($context, $orm);
			return parent::deploy($context);
			break;
        case 'SAVENEW':
		case 'SAVEMODIFY':
			$resFunc = array();
			$aErrors = array("title" => "No se cumplen las validaciones");
			$valido = $this->validate();
			if ($valido === true) {
				try {
					if ($form_action == 'SAVENEW') $resFunc = $this->saveNew($context, $orm);
					if ($form_action == 'SAVEMODIFY') $resFunc = $this->saveModify($context, $orm);
				} catch (Exception $e) {
					$resFunc = array_merge($resFunc, array($e->getMessage()));
				}
			} else {
				$resFunc = $valido;
			}
			if ($resFunc === true) {
				$context->set('UWS_BACK_ACTION', $this->getValueOf('UWS_BACK_ACTION'));
				$context->set('UWS_LIST_FILTER', urldecode(urldecode($this->getValueOf('UWS_LIST_FILTER'))));
				return new Renderable($this->successTemplate);
			} else {
				if (is_array($resFunc)) {
					foreach ($resFunc as $k => $v) {
						$aDesc = array("field" => $k, "descriptions" => $v);
						$aErrors["messages"][] = $aDesc;
					}
				}
				$user_action = new HiddenComponent();
				$user_action->setId('id_user_action')
							->setName('user_action')
							->setValue($form_action);
				$this->addComponent($user_action);
				
				if ((isset($aErrors["messages"])) && (count($aErrors["messages"]) > 0)) {
					$this->context->set('errors', $aErrors);
				}
				return parent::deploy($context);
			}
			break;
        case 'DELETE':
			$resFunc = array();
			$aErrors = array("title" => "No se cumplen las validaciones");
			try {
				$resFunc = $this->delete($context, $orm);
			} catch (Exception $e) {
				krumo($e); die();
				$resFunc = array_merge($resFunc, array($e->getMessage()));
			}
			if ($resFunc === true) {
				$context->set('UWS_BACK_ACTION', $this->getValueOf('UWS_BACK_ACTION'));
				$context->set('UWS_LIST_FILTER', urldecode(urldecode($this->getValueOf('UWS_LIST_FILTER'))));
				return new Renderable($this->successTemplate);
			} else {
				foreach ($resFunc as $k => $v) {
					$aDesc = array("field" => $k, "descriptions" => $v);
					$aErrors["messages"][] = $aDesc;
				}
				if ((isset($aErrors["messages"])) && (count($aErrors["messages"]) > 0)) {
					$this->context->set('errors', $aErrors);
				}
			}
			return new Renderable($this->formTemplate);
			break;
		default:
			echo "Sin accion, error";
			return new Renderable("sorry.xhtml");
    }
    // Bouml preserved body end 0016E505
  }

}
?>