<?php
require_once 'iplan/orm/ORM.php';
require_once 'iplan/web/Form.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
abstract class ABMForm extends Form {
  /**
   * @var string es el nombre de la clase sobre la que se modela el formulario, es opcional
   */
  private $class;

  /**
   * @var ORM la clase que gestiona las definiciones del objeto. Esta variable es de uso interno del Form.
   */
  private $orm;

  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00133905
	parent::__construct();
	$this->context = $context;
	$this->orm     = $orm;
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00133905
  }

  /**
   * Configura el ORM a mano. Este ser� pisado por Deploy().
   * 
   * @param ORM $value el ORM que se quiere emplear en caso de llamada directa a los m�todos fresh(), modify(), save() y delete().
   * 
   * @return ABMForm El formulario con el ORM configurado.
   */
  public function setORM(&$orm)
  {
    // Bouml preserved body begin 00133985
	$this->orm=$orm;
	return $this;
    // Bouml preserved body end 00133985
  }

  /**
   * Recupera la clase pivot del formulario.
   * 
   * @return string El nombre de la clase que sirve de pivot al ABMForm
   */
  final public function getClass()
  {
    return $this->class;
  }

  /**
   * Configura la clase base del formulario
   * @param string $class la clase sobre la que pivotea el formulario
   * 
   * @return Form El formulario configurado con la clase indicada
   */
  public function setClass($class)
  {
    // Bouml preserved body begin 000E6D05
    $this->class = $class;
    return $this;
    // Bouml preserved body end 000E6D05
  }

  /**
   * Configura los valores de POST/GET en los atributos adecuados del objeto pasado por par�metro, usando para ello las definiciones de los "maps" de cada componente y la "class" del Form.
   * Esta funci�n integra el ORM con la l�gica de formularios.
   * 
   * @param ORMObject $object el objeto sobre el cual se deben aplicar los cambios.
   * 
   * @return boolean En caso que todo salga bien devuelve TRUE y si sucedio un error FALSE.
   */
  public function setValuesToObject(&$object)
  {
    // Bouml preserved body begin 000FCB05
    $def = $this->orm->getDefinition(get_class($object));
    $comps = $this->getComponent();
	for ($i = 0; $i < count($comps); $i++) {
		$mps = $comps[$i]->getMaps();
		$name=$comps[$i]->getName();
		if (!$name) $name=$mps;
		if (strpos($mps, '.')!= false) continue;
		if (($mps) && (!is_a($comps[$i], "LabelComponent")) && (!is_a($comps[$i], "ActionComponent"))) {
			$setAtr = "set" . ucfirst($mps);
			$definido = $def->getFieldDefinition($mps);
			if ($definido) {
				switch ($definido["type"]) {
					case ORM_TYPES::ORM_ENTITY:
						$valor = $this->getValueOf($name);
						if ($valor) {
							$obj = $this->orm->retrieve($definido["class"], $valor);
							if (!$obj)
								$obj = $this->orm->load($definido["class"], $valor);
							$object->$setAtr($obj);
						} else {
							$object->$setAtr(null);
						}
						break;
					case ORM_TYPES::BOOLEAN:
						$object->$setAtr((bool)$this->getValueOf($name));
						break;
					default:
						$object->$setAtr($this->getValueOf($name));
						break;

				}
			} else {
				$esRelacion = $def->getRelationDefinition($mps);
				if ($esRelacion) {
					$valores = $this->getValueOf($name);
					//Si hay valores seleccionados LOS AGREGO
					if (!is_null($valores)) {
						$addAtr = "add" . ucfirst($mps);
						if (!is_array($valores)) {
							$valores = array($valores);
						}
						for ($j = 0; $j < count($valores); $j++) {
							if ($valores[$j]) { //Salva el caso de que sea null el valor indicado
								$obj = $this->orm->retrieve($esRelacion["class"], $valores[$j]);
								if (!$obj)
									$obj = $this->orm->load($esRelacion["class"], $valores[$j]);
								$object->$addAtr($obj);
							}
						}
					}
					//Chequeo que los valores que quedaron sean exclusivamente los seleccionados,
					//si hay más entonces los borro.
					$getAtr= 'get'. ucfirst($mps);
					if (Count($valores) != Count($object->$getAtr())) {
						$delAtr = 'del'. ucfirst($mps);
						foreach($object->$getAtr() as $relatedObj) {
							if ((is_null($valores)) || !in_array($relatedObj->getId(), $valores))
								$object->$delAtr($relatedObj);
						}
					}
				} else {
					// ERROR metio cualquier cosa
					throw new Exception("Se consignó un 'maps' inválido en el formulario: ".get_class($this).
										", componente de tipo ".get_class($comps[$i])." (name=>'".$comps[$i]->getName()."', '$mps')");
				}
			}
		}
	}
    // Bouml preserved body end 000FCB05
  }

  /**
   * Configura los valores predeterminados del form con los atributos correspondientes del objeto pasado por par�metro, usando para ello las definiciones de los "maps" de cada componente y la "class" del Form.
   * Esta funci�n integra el ORM con la l�gica de formularios.
   * 
   * @param ORMObject $object el objeto sobre el cual se deben basar los campos del formulario.
   * 
   * @return boolean En caso que todo salga bien devuelve TRUE y si sucedio un error FALSE.
   */
  public function getValuesFromObject(&$object)
  {
    // Bouml preserved body begin 00101985
    //TODO: revisar - el código debe transcribir los Instance a su ID correspondiente y pasarlo al component??
    //TODO: revisar - no se contemplan las relaciones
	if (!is_a($object, $this->class)) {
		throw new Exception("Se pasó un objeto de tipo incorrecto a getValuesFromObject()");
	}
    $comps = $this->getComponent();
	$def = $this->orm->getDefinition($this->class);

    for ($i = 0; $i < count($comps); $i++) {
		$null = false;
		$mpsStr = $comps[$i]->getMaps();
		$mps = explode('.', $mpsStr);
		$obj2 = $object;
		$def2=$def;
		if (count($mps)>1) {
			for($j=1;$j<count($mps);$j++) {
				if (($dd=$def2->getFieldDefinition($mps[$j-1]))) {
					$def2 = $this->orm->getDefinition($dd['class']);
				} elseif (($dd = $def2->getRelationDefinition($mps[$j-1]))) {
					$def2 = $this->orm->getDefinition($dd['class']);
				} else {
					throw new Exception("Error al acceder a $mpsStr desde una instancia de la clase $this->class. Por favor verifique que los mapeos y definiciones sean correctos");
				}
				$get = 'get'.ucfirst($mps[$j-1]);
				$obj2 = $obj2->$get();
				if ($obj2 == null) {
					$null=true;
					break;
				}
			}
		}
		if ($null) continue;
		$mp=$mps[count($mps)-1];
		$busca = $comps[$i]->getName() ? $comps[$i]->getName() : $mp;
		if ($mp) {
			//Esta mapeado
			$definido = $def2->getFieldDefinition($mp);
			$strAtr = "get" . ucfirst($mp);
			if ($definido) {
				switch ($definido["type"]) {
					case ORM_TYPES::ORM_ENTITY:
						$valor = $obj2->$strAtr();
						if (is_a($valor, 'ORMObject')) {
							$this->setValueOf($busca, $valor->getId());
							if (is_a($comps[$i], 'SelectComponent'))
								$comps[$i]->setSelected($valor->getId());
						}
						break;
					default:
						$this->setValueOf($busca, $obj2->$strAtr());
						break;
				}
			} else {
				$esRelacion = $def2->getRelationDefinition($mp);
				if ($esRelacion) {//Es una relacion xd
					switch ($esRelacion["type"]) {
						case ORM_RELATION_TYPE::OneToOne:
							$this->setValueOf($busca, $obj2->$strAtr()->getId());
							break;
						case ORM_RELATION_TYPE::OneToMany:
						case ORM_RELATION_TYPE::ManyToMany:
							$lista = $obj2->$strAtr();
							$aIdcitos = array();
							if ((count($lista)> 0)) {
								foreach ($lista as $itemcin) {
									$aIdcitos[] = $itemcin->getId();
								}
							}
							$this->setValueOf($busca, $aIdcitos);
							break;
						default:
							//error WTF xd
							break;
					}
				} else {
					//Error esta mapeado y no es relacion ni definicion.. mm...kb xD
				}
			}
		}
    }
    // Bouml preserved body end 00101985
  }

  /**
   * Realiza una verificaci�n sobre los par�metros de POST y GET (depende qu� se consigne en el Form) seg�n las definiciones de campos que se hayan realizado.
   * 
   * @return TRUE|array Devuelve un valor TRUE si todas las definiciones de componentes tienen una contraparte v�lida y acorde a las validaciones impuestas. En caso que algo falle retorna una matr�z con el siguiente formato:
   * 
   * array (
   * 	0 = > array (
   * 		Component, array("Error 1", "Error 2")
   * 		)
   * 	...
   * )
   */
  public function validate()
  {
    // Bouml preserved body begin 00108305
    $comps = $this->getComponent();
    $vals = $this->orm->getDefinition($this->class)->getValidation();
    $res = parent::validate();
    for ($i = 0; $i < count($comps); $i++) {
        $mps = $comps[$i]->getMaps();
		$name = $comps[$i]->getName();
		if (!$name) $name = $mps;
        $tempRes = array();
        if (($mps) && (isset($vals[$mps])) /* && is_array($vals[$mps]) && (count($vals[$mps]) > 0)*/) {
            foreach ($vals[$mps] as $validation => $expressions) {

                if (!Validation::isComplexValidation($validation)) {
                    $expressions = array("");
                }
                foreach($expressions as $expression) {
                    $oValida = Validation::getValidation($validation, $expression);
                    $tmpRes = $oValida->validate($this->getValueOf($name));
                    if ($tmpRes !== true) {
                        if (isset($res[$mps])) {
                            $res[$mps][]=$tmpRes;
                            $res[$mps]=array_unique($res[$mps], SORT_STRING);
                        }
                    }
                }
            }
        }
    }

    if (count($res) > 0) return $res;
    else return true;
    // Bouml preserved body end 00108305
  }

  /**
   * M�todo de uso interno utilizado para completar las validaciones y nombres de los componentes.
   * 
   * @return ABMForm el formulario con la informaci�n de nombres y validaciones completada.
   */
  public function completeValidations()
  {
    // Bouml preserved body begin 0012DA05
	//Agrego el seteo de los componentes contra el objeto
	$comps = $this->getComponent();
	$aFields = $this->orm->getDefinition($this->class)->getFieldDefinition();
	$aValidations = $this->orm->getDefinition($this->class)->getValidation();
        
    //Extraigo los nombres de los atributos que tienen definición
	$attributes = array_keys($aFields);
        
    //Para cada componente del form hago un conjunto de tareas que completan la
	//definición del mismo y que agregan las validaciones no explicitadas por
	//el programador.
	for ($i = 0; $i < count($comps); $i++) {
        //...obtengo los "maps" y veo si ese nombre está entre los nombres de los atributos de la clase
		$mps = $comps[$i]->getMaps();
		if ((!is_a($comps[$i], 'LabelComponent')) && ($mps) && ( array_search($mps, $attributes) !== false)) {
			//Adicionalmente si el componente no tienen nombre, le pongo por default el del maps
			if ($comps[$i]->getName() == "")
				$comps[$i]->setName($mps);
			//...y si no tienen ID le creo uno como "id_" concatenado con el maps.
			if ($comps[$i]->getId() == "")
				$comps[$i]->setId("id_$mps");
			
			//Para el caso de los strings y potencialmente para otros tipos a futuro, por eso se
			//hace un switch, se agregan limitaciones.
			switch ($aFields[$mps]["type"]) {
				case ORMDefinition::STRING:
					//Si no se configuró el Maxlength y en la definición del ORM hay un máximo para
					//el string, configuro el tamaño máximo igual al de la definición.
					if ((!$comps[$i]->getMaxlength()) && ($aFields[$mps]["length"])) {
						$comps[$i]->setMaxlength($aFields[$mps]["length"]);
					}
					break;
					//A futuro acá podría haber más cosas por el estilo
			}
		}
		if ((isset($aValidations[$mps])) && is_array($aValidations[$mps]) && (count($aValidations[$mps]) > 0)) {
			$agregar_valida = array();
			foreach ($aValidations[$mps] as $valida => $expresiones) {					
				if (is_array($expresiones)) {
					for ($j = 0; $j < count($expresiones); $j++)
						if ($expresiones[$j] != "") {					
							if (isset($aFields[$mps]) && in_array($valida, array("min", "max")) && 
							    in_array($aFields[$mps]['type'], array(ORM_TYPES::BIGINT, ORM_TYPES::DECIMAL, 
																	   ORM_TYPES::INTEGER, ORM_TYPES::SMALLINT)))
							$agregar_valida[] = $valida . "value " . $expresiones[$j];
							else $agregar_valida[] = $valida . " " . $expresiones[$j];
						} else {
							$agregar_valida[] = $valida;
						}
				} else {
					$agregar_valida[] = $valida;
				}
			}
			//Obtengo las validaciones existentes del objeto en forma de Array
			$aValidasExistentes = is_array($comps[$i]->getValidate()) ? $comps[$i]->getValidate() : (($comps[$i]->getValidate() != "") ?  array($comps[$i]->getValidate()) : array());

			//Agrego las existentes a las calculadas desde la definición del ORM.
			$agregar_valida = array_merge($agregar_valida, $aValidasExistentes);
			$comps[$i]->setValidate($agregar_valida);
		}

	}
	return $this;
    // Bouml preserved body end 0012DA05
  }

  /**
   * Solicita al formulario que realice la tarea para la que est� configurado.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return Renderable la pantalla que debe mostrar.
   */
  public function deploy(&$context = null, &$orm = null)
  {
    // Bouml preserved body begin 00108385
	if (($context === null) || ($orm === null)) throw new Exception("No se puede invocar al método ABMForm::deploy() sin parámetros o con null en alguno de ellos");
    $this->context = $context;
    $this->orm = $orm;
	
	$this->completeValidations();
	
//	$form_action = $context->getParam('user_action', null, 'PG');
//	$id = $context->getParam('id', null, 'PG');
	$form_action = $this->getValueOf('user_action');
	$id = $this->getValueOf('id');
	
    if (is_null($form_action)) {
		if ($id === null) {
			$form_action = 'NEW';
		} else {
			$form_action = 'MODIFY';
		}
    }

	$eventName = $this->getValueOf('UWS_EVENT');
	if (!is_null($eventName)) {
		return parent::deploy($context);
	}
	
	//$ok = false;
	try {
		$this->checkAccess($context, $orm, $form_action, $id);
	} catch (Exception $e) {
		$aErrors = array("title" => "Error de acceso",
						 "messages" => array(array("descriptions" => array($e->getMessage()))));
		$this->context->set('errors', $aErrors);
		return new Renderable($this->formTemplate);
	}
	
	switch($form_action) {
		case 'NEW':
			$user_action = new HiddenComponent();
			$user_action->setId('id_user_action')
						->setName('user_action')
						->setValue('SAVE');
			$this->addComponent($user_action);
			$this->fresh($context, $orm);
			return parent::deploy($context);
			break;
		case 'MODIFY':
			$user_action = new HiddenComponent();
			$user_action->setId('id_user_action')
						->setName('user_action')
						->setValue('SAVE');
			$this->addComponent($user_action);

			$id_component = new HiddenComponent();
			$id_component->setId('id')
						->setName('id')
						->setValue($id);
			$this->addComponent($id_component);

			$this->modify($context, $orm);
			if ($this->getValueOf('uwsSubmit')==1)
				$this->loadValues();
			return parent::deploy($context);
			break;
		case 'SAVE':
			$resFunc = array();
			$aErrors = array("title" => "No se cumplen las validaciones");
			//Seteo los valores del post a los componentes
			try {
				$this->loadValues();
				$resFunc = $this->save($context, $orm);
			} catch (ORMValidationException $e) {
				$resFunc = array_merge($resFunc, $e->getFails());
			} catch (Exception $e) {
				$resFunc = array_merge($resFunc, array($e->getMessage()));
			}

			if (is_a($resFunc, 'ORMObject')) {
				$context->set('UWS_BACK_ACTION', $this->getValueOf('UWS_BACK_ACTION'));
				$context->set('UWS_LIST_FILTER', urldecode(urldecode($this->getValueOf('UWS_LIST_FILTER'))));
				return new Renderable($this->successTemplate);
			} else {
				if (is_array($resFunc)) {
					foreach ($resFunc as $k => $v) {
						$aDesc = array("field" => $k, "descriptions" => $v);
						$aErrors["messages"][] = $aDesc;
					}
				}
				$user_action = new HiddenComponent();
				$user_action->setId('id_user_action')
							->setName('user_action')
							->setValue('SAVE');
				$this->addComponent($user_action);
				
				if ($id === null) {
					$this->fresh($context, $orm);
					$this->loadValues();
				} else {
					$this->modify($context, $orm);
					$this->loadValues();
					
					$id_component = new HiddenComponent();
					$id_component->setId('id')
							->setName('id')
							->setValue($id);
					$this->addComponent($id_component);
				}

				
				//$this->context->set('options', $this->toArray($this->prefix, $this->suffix));
				if ((isset($aErrors["messages"])) && (count($aErrors["messages"]) > 0)) {
					$this->context->set('errors', $aErrors);
				}
				//return new Renderable($this->formTemplate);
				return parent::deploy($context);
			}
			break;
		case 'DELETE':
			$resFunc = array();
			$aErrors = array("title" => "No se cumplen las validaciones");
			try {
				$resFunc = $this->delete($context, $orm);
			}
			catch (ORMValidationException $e) {
				$resFunc = array_merge($resFunc, $e->getFails());
			}
			catch (Exception $e) {
				$resFunc = array_merge($resFunc, array($e->getMessage()));
			}
			if ($resFunc === true) {
				$context->set('UWS_BACK_ACTION', $this->getValueOf('UWS_BACK_ACTION'));
				$context->set('UWS_LIST_FILTER', urldecode(urldecode($this->getValueOf('UWS_LIST_FILTER'))));
				return new Renderable($this->successTemplate);
			} else {
				if (is_array($resFunc)) {
					foreach ($resFunc as $k => $v) {
						$aDesc = array("field" => $k, "descriptions" => $v);
						$aErrors["messages"][] = $aDesc;
					}
				} else {
					$aErrors["messages"][]=array("field" => 'Problema no conocido', "descriptions" => print_r($resFunc));
				}
				if ((isset($aErrors["messages"])) && (count($aErrors["messages"]) > 0)) {
					$this->context->set('errors', $aErrors);
				}
			}
			return new Renderable($this->formTemplate);
			break;
		default:
			throw new Exception('Error en ABMForm::deploy() => Función no soportada');
			break;
	}
	
    // Bouml preserved body end 00108385
  }

  /**
   * Funci�n invocada para crear una instancia del objeto que representa el formulario
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function fresh($context, $orm)
  {
    // Bouml preserved body begin 00127385
	return true;
    // Bouml preserved body end 00127385
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 00126C05
	$id = $this->getValueOf('id');
	$valido = $this->validate();
	if ($valido === true) {
		if ($id == null) {
			$class = $this->class;
			$object = new $class();
			$this->setValuesToObject($object);
		} else {
			//Caso modificar
			$object = $orm->retrieve($this->class, $this->getValueOf('id'));
			if (!is_object($object))
				$object = $orm->load($this->class, $this->getValueOf('id'));
			$this->setValuesToObject($object);
		}
		$orm->save($object);
		return $object;
	} else {
		return $valido;
	}
    // Bouml preserved body end 00126C05
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00126C85
	$object = $orm->query($this->class)->filterBy("id", "=", $this->getValueOf('id'))->findOne();
	if ($object) $this->getValuesFromObject($object); else throw new Exception("Objeto no encontrado");
	return true;
    // Bouml preserved body end 00126C85
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 00126D05
	$object = $orm->query($this->class)->filterBy("id", "=", $this->getValueOf('id'))->findOne();
	if ($object) $orm->delete($object); else throw new Exception("Objeto no encontrado");
	return true;
    // Bouml preserved body end 00126D05
  }

  /**
   * Esta función se encarga de validar si un usuario tiene acceso a trabajar con una cierta entidad. La intención es verificar en este paso que el usuario tiene permiso para crear, editar o borrar la entidad que solicitó.
   * 
   * @param ApplicationContext $context el contexto en el cual se mandó a ejecutar la acción. De aquí se puede obtener la información de User, Domain y Provider.
   * @param ORM $orm la instancia del ORM
   * @param string $action un texto que indica lo que se pretende hacer. Puede tomar valores de: 'NEW', 'MODIFY', 'SAVE' o 'DELETE'.
   * @param mixed $id el identificador de la entidad que se pasó por parámetro
   * 
   * @return boolean La función debe devolver True si el usuario puede realizar la acción o arrojar una excepción con la descripción del problema.
   */
  public function checkAccess(&$context, &$orm, $action, $id = null)
  {
    // Bouml preserved body begin 001C8D05
	return true;
    // Bouml preserved body end 001C8D05
  }

}
?>