<?php
require_once "iplan/twig/tokenParser/ActionTokenParser.php";
require_once "iplan/twig/tokenParser/ShowTokenParser.php";

class IPlanExtension extends Twig_Extension {
    private $application;
    private $twig;
	private $cachedActions;
	private $permittedActions;
	private $params_for_parse;

    public function __construct($application) {
        $this->application = $application;
        $loader = new Twig_Loader_String();
        $this->twig = new Twig_Environment($loader);
		$this->twig->addExtension($this);
		$this->cachedActions = array();
		$this->permittedActions=array();
		$this->params_for_parse=array();
    }

    public function getName() {
        return 'IPlan';
    }

    public function getGlobals() {
        return parent::getGlobals();
    }

    public function getFilters() {
        //return parent::getFilters();
        /*Examples:
         *         return array(
         *               'rot13' => new Twig_Filter_Method($this, 'rot13Filter'),
         *          );
         */
        return array(
                'parse'   => new Twig_Filter_Method($this, 'parse_filter', array('needs_environment' => true)),
                'register'=> new Twig_Filter_Method($this, 'register_filter', array('needs_environment' => true)),
                'first'   => new Twig_Filter_Method($this, 'first_function'),
                'last'   => new Twig_Filter_Method($this, 'last_function'),
				'mac'   => new Twig_Filter_Method($this, 'mac_filter')
        );
    }
	
    public function getTokenParsers() {
        return array(new ActionTokenParser($this->application), new ShowTokenParser());
    }

    /**
     * Returns a list of global functions to add to the existing list.
     *
     * @return array An array of global functions
     */
    public function getFunctions()
    {
        return array(
            'link' => new Twig_Function_Method($this, 'link'),
            'AJAH' => new Twig_Function_Method($this, 'AJAH'),
			'actionInfo'=> new Twig_Function_Method($this, 'actionInfo'),
            'first' => new Twig_Function_Method($this, 'first_function'),
            'last' => new Twig_Function_Method($this, 'last_function'),
			'assureArray' => new Twig_Function_Method($this, 'assureArray')
            );
    }

    /**
     * Returns a list of filters to add to the existing list.
     *
     * @return array An array of filters
     */
    public function getTests()
    {
        return array(
            'anArray'        => new Twig_Test_Function('is_array'),
            'string'         => new Twig_Test_Function('is_string')
        );
    }

    /**
     * Dada una acción verifica que exista algún perfil para el usuario/proveedor
     * actual que la permita.
     * @param Action $action la acción a verificar
     * @return boolean TRUE si la acción está permitida, FALSE en caso contrario.
     */
    private function __isPermitted($action) {
	if (!is_null($action)) {
		if (isset($this->permittedActions[$action->getId()]))
			return $this->permittedActions[$action->getId()];
	    $orm = $this->application->getORM();
	    $context = $this->application->getContext();
	    //Chequeo que dicha acción esté en un perfil asociado al usuario para este proveedor
	    $queryPermission = $orm->query('Profile')
				->filterBy('users.id','=',$context->getUser()->getId())
				->filterBy('provider.id','=',$context->getProvider()->getId())
				->filterBy('domains.id','=',$context->getDomain()->getId())
				->filterBy('actions.id', '=',$action->getId())
				->orderBy('id ASC');
	    $permited = $queryPermission->findOne() != FALSE;
		$this->permittedActions[$action->getId()]=$permited;
		return $permited;
	} else { return false; }
    }

    /**
     * Dado un texto de la forma Alias.Action desarma las partes y retorna la
     * acción indicada siempre y cuando el usuario tenga permiso.
     * @param string $text el texto del template
     * @return Array(bool, Action|string) Un arreglo cuya primer componente es el status de la
     *  operación y la segunda es la acción ó un mensaje de error en caso que algo no esté bien.
     */
    private function __getActionFromString($text) {
		if (isset($this->cachedActions[$text])) {
			return array(true, $this->cachedActions[$text]);
		}
        $status = false; $result = null;
        if (strpos($text, ".")) { //Si no tiene Alias.Action está mal
            $parts = explode('.', $text);
            if (count($parts)==2) {
                $module_alias = $parts[0];
                $action_name = $parts[1];
                //Busco si la acción existe.
                $context = $this->application->getContext();
                $orm = $this->application->getORM();
                $queryAction = $orm->query('Action')
                                ->filterBy('alias', '=', $action_name)
                                ->filterBy('facade.alias','=', $module_alias)
                                ->orderBy('id ASC');
                $action = $queryAction->findOne();
                if ($action != FALSE) {
                    $status = true;
					$this->cachedActions[$text]=$action;
                    $result = $action;
                } else {
                    $result = "La acción $text no existe";
                }
            } else $result = "Error en la sintaxis de $text";
        } else $result = "La acción $text no existe";
        return array($status, $result);
    }

    /**
     * Traduce una acción a la URL correspondiente para ejecutarla.
     * 
     * @param string|Action|Menu $action la función admite la forma corta de FacadeAlias.urlCode o instancias de Action y Menu.
     * @param string $extraParams son parámetros que se adjuntan a la URL natural de la acción.
     * @return string Una dirección URL con todos los parámetros propios de la acción más aquellos pasados por parámetro.
     */
    public function link($action, $extraParams=null) {
        //Obtengo el contexto de ejecución
        $context = $this->application->getContext();
        //Primero pruebo si es un string de la forma FacadeAlias.actionAlias...
        if (is_string($action)) {
            list($status, $action2) = $this->__getActionFromString($action);
            if (!$status) return $context->getDomain()->getBaseURL()."?action=showError&mainicon=delete&title=Error de formato&icon=document_delete2&msg=$action2.";
            $action = $action2;
        //...sino chequeo si es un Menu, en cuyo caso extraigo la acción.
        } elseif (is_a($action, 'Menu')) {
            $menu = $action;
            $action = $menu->getAction();
        }  elseif (is_a($action, 'MenuLink')) {
            $menu = $action->getMenu();
            $action = $menu->getAction();
        }

        //Valido que el usuario tenga permiso para ejecutar esa acción, de lo contrario devuelvo una URL con el error
        if ($this->__isPermitted($action)) {
            //Formo la URL inicialmente con los datos que me pasaron por parámetro
			$actionValue = ($action->getUrlCode() == "default") ? "" : "?action=".$action->getUrlCode();
            $value=$context->getDomain()->getBaseURL(). $actionValue .( ($extraParams != "") ? "&$extraParams" : '' );
            //Agrego parámetros de la acción
            if ($action->getParams() != "")
                $value.='&'.$action->getParams();
            //Luego agrego los parámetros del menu si fuera el caso
            if (isset($menu) && is_string($menu->getParams()) && ($menu->getParams() != ""))
                $value .= '&'.$menu->getParams();
            //return htmlspecialchars($value);
			return $value;
        } else {
            //return htmlspecialchars($context->getProvider()->getBaseURL()."index.php?action=showError&mainicon=delete&title=Error de Permisos&icon=user_delete2&msg=Usted no tiene permisos para ejecutar esta acción");
			return $context->getDomain()->getBaseURL()."?action=showError&mainicon=delete&title=Error de Permisos&icon=user_delete2&msg=Usted no tiene permisos para ejecutar esta acción";
        }
    }
    
    /**
     * Esta función retorna un string con el javascript necesario para ejecutar la acción mediante AJAH (Asynchronous Javascript And HTML).
     *
     * @param string|Action|Menu $action Puede ser un string de la forma FacadeAlias.ActionCode ó puede ser un objeto Menu o Action.
     * @param string $params son parámetros adicionales que se adjuntarán a la URL
     * @param string $target indica el nombre del "div" en el cual se colocará lo que retorne el llamado a la función. Por default es "desktop_center_content"
     * @param string $block indica el tipo de bloqueo de pantalla que se utilizará.
     * @return string Devuelve una URL de la forma:
     * <code>return uws_load('http://misitio.com/request.php?action=actionCode&params', {'action':urlCode, 'param1':value1,...});</code>
     * en el caso que algo no funcione retorna un "alert()" con el texto explicativo del fallo. A posteriori se podría informar con algo
     * más lindo que un "alert()".
     */
    public function AJAH($action, $params=null, $target=null, $block=null) {
        //Recupero el contexto y asumo de antemano que todo está OK
        $context = $this->application->getContext();
        $status = true;
        
        //Si es un string, tengo que decodificar el Facade y la acción a través de su urlCode...
        if (is_string($action))
            list($status, $action) = $this->__getActionFromString($action);
        //...si, en cambio, es un Menu, se toma la acción del menú y se crea la variable $menu.
        elseif (is_a($action, 'Menu')) {
            $menu = $action;
            $action = $menu->getAction();
        }  elseif (is_a($action, 'MenuLink')) {
            $menu = $action->getMenu();
            $action = $menu->getAction();
        }

        //Si hasta acá está todo bien es que la acción es válida, sino tiro el error correspondiente
        if ($status) {
            //Verifico que el usuario tenga permiso para la acción, de lo contrario informo.
            if ($this->__isPermitted($action)) {
				//Si el usuario indicó explíscitamente que no se use AJAH para esta acción retorno "".
				if (!$action->getUseAjax()) return "";
				
                //Empiezo a crear la URL en $url y me reservo una variable para los parametros.
                $url=$context->getDomain()->getBaseURL()."request.php";
                $str_params="";
                
                //Obtengo los parámetros y en el caso del Menu sumo los parámetros del Menu a los del Action
                $action_params = explode("&", $action->getParams());
                if (isset($menu) && is_array($menu->getParams()))
                        $action_params = array_merge ($action_params, $menu->getParams());
                
                //Agrego los params que se me pasaron
                if (!is_null($params)) {
                    $user_params = explode('&',$params);
                    $action_params = array_merge ($action_params, $user_params);
                }
                
                //Si los parámetros existen entonces se crea el string para pasarle al javascript
                if (is_array($action_params)) {
                    foreach ($action_params as $param) {
                        if ($param != '') {
                            list($key, $value)=explode("=",$param);
                            $str_params .= "'$key':'$value',";
                        }
                    }
                }

                if (is_null($target)) $target="desktop_center_content";
                if ($block)
                    return "return uws_load('$url', {'action':'".$action->getUrlCode()."', $str_params },'$target', '$block');";
                else
                    return "return uws_load('$url', {'action':'".$action->getUrlCode()."',$str_params },'$target');";
            } else {
                return "alert('El usuario actual no tiene permisos para ejecutar esta acción');return false;";
            }
        } else {
            return "alert('$action');return false;";
        }
    }

    public function action($action) {
        $context = $this->application->getContext();
        if (is_string($action)) {
            list($status, $action) = $this->__getActionFromString($action);
            if (!$status) return "javascript:alert('No se pudo reconocer la acción');return false;";
        }
        if ($this->__isPermitted($action)) {
			$actionValue = ($action->getUrlCode() == "default") ? "" : "?action=".$action->getUrlCode();
            $value=$context->getDomain()->getBaseURL() . $actionValue;
            return $value;
        } else {
            return "javascript:alert('El usuario actual no tiene permisos para ejecutar esta acción');return false;";
        }
    }
	
	public function actionInfo($action, $params=null, $target=null, $block=null) {
		if (is_string($action)) {
			list($status, $realAction) = $this->__getActionFromString($action);
			/* @var $realAction Action */
			if ($status) {
				if ($this->__isPermitted($realAction)) {
					$info['ok']=true;
					$info['name']=$realAction->getAlias();
					$info['description']=$realAction->getDescription();
					$info['hint']=$realAction->getHint();
					$info['icon']=$realAction->getIcon();
					$info['urlCode']=$realAction->getUrlCode();
					$info['link']=$this->link($realAction, $params);
					$info['request']=str_replace('index.php', 'request.php', $info['link']);
					$info['AJAH']=$this->AJAH($realAction, $params, $target, $block);
					$info['script']=substr($info['AJAH'], 7);
				} else {
					$info['ok']=false;
					$info['error']= "Acción no autorizada [$action]";
				}
			} else {
				$info['ok']=false;
				$info['error']= "Acción no encontrada [$action]";
			}
		} else {
			$info['ok']=false;
			$info['error']= "Formato de acción no reconocido [$action]";
		}
		return $info;
	}

    public function parse_filter(Twig_Environment $env, $string, $clear=true) {
		if ($string !== "") {
			$template = $this->twig->loadTemplate($string);
			$display = $template->render($this->params_for_parse);
			if ($clear)
				$this->params_for_parse=array();
			return $display;
		} else return "";
		
    }

    public function register_filter(Twig_Environment $env, $name, $value) {
        //$this->twig->addGlobal($name, $value);
		$this->params_for_parse[$name]=$value;
        return '';
    }

    public function first_function($string, $count) {
        return substr($string, 0, $count);
    }

    public function last_function($string, $count) {
        return substr($string, $count*-1);
    }

	public function getActionByAlias($text) {
		list($status, $action) = $this->__getActionFromString($text);
		if ($status) {
			if ($this->__isPermitted($action))
				 return $action;
			else return null;
		} else return null;
	}

	public function assureArray($value) {
		if (!is_array($value))
			return array($value);
		else return $value;
	}
	
	public function mac_filter($value) {
		return implode(":", str_split($value, 2));
		
	}
}
?>