<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class UserProfileForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00152705
	parent::__construct($orm, $context);
 
	$compPerfiles = new MultiselectComponent();
	$compPerfiles->setLabel("Perfiles")
				 ->setMaps('profiles')
				 ->setRows('5');
				 
	$layout = new GridLayout(1 /*2*/,1);
	$layout->addComponent($compPerfiles, 1, 1)/*
		   ->addComponent(new ButtonComponent('Guardar', 'submit'), 2, 1)*/;
	
	$this->setClass("User")
		 ->setTitle("Seleccionar Perfiles de Usuario")
		 ->setMethod("post")
		 ->setId("id_form")
		 ->setFormType(Form::FORM_OK_CANCEL)
		 ->addComponent($layout)
		 ->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00152705
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00152785
	$user = $orm->retrieve('User', $this->getValueOf('id'));
	if (!$user) $user = $orm->load('User', $this->getValueOf('id'));
	$profileOptions = $orm->query('Profile')
                           ->filterBy('provider.id', '=', $user->getProvider()->getId())
                           ->attributes('id AS value', 'name AS description')
						   ->orderBy('name')
                           ->find();
	$this->getComponent('profiles')->setOptions($profileOptions);
	return parent::modify($context, $orm);
    // Bouml preserved body end 00152785
  }

}
?>