<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/User.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class UserForm extends ABMForm {
  /**
   * Crea un formulario de ABM de Usuarios
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122905
	parent::__construct($orm, $context);

	$usaLogin = $context->getDomain()->getLoginUnificado();
	
	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider');
	$securityManager = $context->getManager('Security');
	$selProvider->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));
	
	$oLayout1 = new GridLayout(3, 3);
	$oLayout1->addComponent(new TextComponent(array('label'=>'Usuario','size'=>20, 'maps'=>'username', 'maxLength'=>10, 'validate'=>'alphanumeric')), 1, 1)
			 ->addComponent(new TextComponent(array('label'=>'Nombre', 'size'=>20, 'maps'=>'name')), 1, 2)
			 ->addComponent(new TextComponent(array('label'=>'Apellido', 'size'=>20, 'maps'=>'surname')), 1, 3)
			 ->addComponent(new TextComponent(array('label'=>'Email', 'size'=>30, 'maps'=>'mail', 'validate'=>'mail')), 2, 1)
			 ->addComponent($selProvider, 2, 2)
			 ->addComponent(new SelectComponent(array('label'=>'Estado','name'=>'status','maps'=>'status', 'optional'=>false,
													  'options'=>array(array('value' => User::USER_ACTIVE, 'description' => "Activo"),
																	   array('value' => User::USER_DISABLED, 'description' => "Inactivo")
													))), 2, 3)
			 ->addComponent(new PasswordComponent(array('label'=>'Password', 'maps'=>'password', 'size'=>20/*, 'validate'=>array('required', 'alphanumeric')*/)), 3, 1)
			 ->addComponent(new PasswordComponent(array('label'=>'Conf. Password', 'name'=>'conf_password', 'size'=>20/*, 'validate'=>array('required', 'alphanumeric')*/)), 3, 2);
	if ($usaLogin) {
		$oLayout1->addComponent(new CheckboxComponent('¿Usa Login Unificado?', 'loginUnificado', 'loginUnificado', 1, 0), 3, 3);
	}

	$this->setClass("User")
		   ->setTitle("Usuario")
		   ->setMethod("post")
		   ->setId("id_form")
			->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122905
  }

  /**
   * Funcin invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00127F85
	$oUsuarioModificar = $orm->retrieve('User', $this->getValueOf('id'));
	if (!$oUsuarioModificar) $oUsuarioModificar = $orm->load('User', $this->getValueOf('id'));
	$this->getValuesFromObject($oUsuarioModificar);
	$this->setValueOf('password', '');
	$this->setValueOf('conf_password', '');
	return true;
    // Bouml preserved body end 00127F85
  }

  /**
   * Funcin invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return User el objeto ya guardado si todo sali bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 00128005
	$id = $this->getValueOf('id');
	//Validaciones
	$valido = $this->validate();
	$password = $this->getValueOf('password');
	$conf_password = $this->getValueOf('conf_password');
	if  ($password != $conf_password) {
		if (!is_array($valido)) $valido = array();
		$valido["password"] = "Los password no coinciden";
		return $valido;
	}
	if ($id === null) {
		//Caso alta
		$oUser = new User();
		$this->setValuesToObject($oUser);
		$oUser->setPassword(sha1($oUser->getPassword()));
		if (($oUser->getLoginUnificado() == false) && ($password == "")) {
			if (!is_array($valido)) $valido = array();
			$valido["password"] = "El password no puede ser vacío para usuarios locales nuevos.";
			return $valido;
		}
	} else {
		//Caso modificar
		$oUser = $orm->retrieve('User', $this->getValueOf('id'));
		if (!$oUser) $oUser = $orm->load('User', $this->getValueOf('id'));
		$oldpass = $oUser->getPassword();
		$this->setValuesToObject($oUser);
		if (($password == "") || ($password === null)) {
			$oUser->setPassword($oldpass);
		} else {
			$oUser->setPassword(sha1($oUser->getPassword()));
		}
	}
	if ($valido === true) {
		$orm->save($oUser);
		return $oUser;
	} else {
		return $valido;
	}
    // Bouml preserved body end 00128005
  }

}
?>