<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/Provider.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ProviderForm extends ABMForm {
  /**
   * Crea un formulario de ABM de Provider
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122685
	parent::__construct($orm, $context);

	$securityManager = $context->getManager('Security');/*@var $securityManager SecurityManager  */
	$owner = new SelectComponent('Propietario', 'owner', 'owner');
	$owner->setOptional(false)
		  ->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id AS value', 'name AS description'), true));
	
	$facadeOptions = $orm->query('Facade')
						 ->attributes('id AS value', 'alias AS description')
						 ->find();
	$compFacade = new MultiselectComponent('Accede a', 'facades', 'facades');
	$compFacade->setRows('5')
			   ->setOptions($facadeOptions);

	$compBotonete = new ButtonComponent('Aceptar', 'submit');

	$oLayout1 = new GridLayout(6, 3);
	$oLayout1->setName("ProviderLayout");
	$oLayout1->addComponent(new TextComponent('Nombre', 'name', 'name'), 1, 1)
			 ->addComponent(new TextComponent('Máximo tamaño de fetch', 'maxFetchRows', 'maxFetchRows'),1,2)
			 ->addComponent($compFacade, 3, 1,1,2)
			 ->addComponent($owner, 3, 2)
			;
	
	$this->setClass("Provider")
		   ->setTitle("Proveedor")
		   ->setMethod("post")
		   ->setId("id_form_provider")
		   ->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());

	return $this;
    // Bouml preserved body end 00122685
  }

  /**
   * Funci�n invocada para crear una instancia del objeto que representa el formulario
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function fresh($context, $orm)
  {
    // Bouml preserved body begin 00127405
	//Agrego un nombre de dominio en el caso que sea un Provider nuevo
	$usuarios = $orm->query('Profile')
					->attributes('id AS value', 'name AS description')
					->filterBy("provider", "=", $context->getProvider()->getId())
					->find();
	$oLayout = $this->getComponent("ProviderLayout");/*@var $oLayout GridLayout*/
	$oLayout->addComponent(new TextComponent(array('label'=>'Dominio Predeterminado', 'name'=>'domain', 'size'=>60)), 5, 1, 3)
			->addComponent(new SelectComponent(array('label'=>'Perfil Administrador', 'name'=>'admin', 'optional'=>false, 'options'=>$usuarios)), 6, 1)
			->addComponent(new SelectComponent(array('label'=>'Perfil Usuario', 'name'=>'registered', 'optional'=>false, 'options'=>$usuarios)), 6, 2)
			->addComponent(new SelectComponent(array('label'=>'Perfil Anónimo', 'name'=>'anonymous', 'optional'=>false, 'options'=>$usuarios)), 6, 3)
			;
	//$oLayout->addComponent(new TextComponent('Dominio Predeterminado', 'domain'), 4, 1, 3);
	return true;
    // Bouml preserved body end 00127405
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return Provider el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 00127485
		$id = $this->getValueOf('id');
		$valido = $this->validate();
		if ($valido === true) {
			$createUsers = false;
			if ($id === null) { //Caso alta
				$oProvider = new Provider();
				$createUsers = true;
			} else {            //Caso modificar
				$oProvider=$orm->retrieve('Provider', $this->getValueOf('id'));
				if (!is_object($oProvider)) {
					$oProvider = $orm->load('Provider', $this->getValueOf('id'));
				}
				$this->addComponent(new HiddenComponent(null, 'anonymous', 'anonymous'));
				$this->addComponent(new HiddenComponent(null, 'mainDomain', 'mainDomain'));
			}/*@var $oProvider Provider */
			$this->setValuesToObject($oProvider);
			$ok = $orm->save($oProvider);
			
			if ($createUsers && $ok) {
				$admin = new User($orm);
				$admin->setUsername('admin')
					  ->setLoginUnificado(false)
					  ->setName('Administrador')
					  ->setSurname($oProvider->getName())
					  ->setProvider($oProvider)
					  ->setStatus(User::USER_ACTIVE)
					;
				$anonymous = new User($orm);
				$anonymous->setUsername('anonimous')
					  ->setLoginUnificado(false)
					  ->setName('Usuario No Registrado')
					  ->setSurname($oProvider->getName())
					  ->setProvider($oProvider)
					  ->setStatus(User::USER_ACTIVE)
					;
			//Crear Perfiles para Admin, Registrado y Anónimo
			//en base a los perfiles seleccionados
				
				//Guardo los usuarios:
				if ($admin->save() && $anonymous->save()) {
					$profileAdmin = new Profile($orm);
					$profileRegistered = new Profile($orm);
					$profileAnonymous = new Profile($orm);
					
					throw new Exception('Atención, el provider fue creado, se registraron usuarios Admin y Anónimo, pero no se completó el proceso de migración de perfiles porque falta implementarlo. Es decir, los perfiles hágalos usted mismo');
				} else {
					throw new Exception('El Provider se ha creado, pero no se pudieron crear los usuarios de adminitración y anónimos');
				}
				
			}
			
			return $oProvider;
		} else {
			return $valido;
		}
    // Bouml preserved body end 00127485
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00127505
	$oProviderModificar = $orm->retrieve('Provider', $this->getValueOf('id'));
	if (!$oProviderModificar) $oProviderModificar = $orm->load('Provider', $this->getValueOf('id'));
	$oLayout = $this->getComponent("ProviderLayout");/*@var $oLayout GridLayout*/
	
	$oLayout->addComponent(new SelectComponent(array('label'=>'Usuario Anónimo', 'maps'=>'anonymous', 'optional'=>true,
													 'options'=>$orm->query('User')
																	->attributes('id AS value', 'username AS description')
																	->filterBy("provider", "=", $oProviderModificar->getId())
																	->find())), 3, 3)
			->addComponent(new SelectComponent(array('label'=>'Dominio Principal', 'maps'=>'mainDomain', 'optional'=>false,
													 'options'=>$orm->query('Domain')
																	->attributes('id AS value', 'baseURL AS description')
																	->filterBy("provider", "=", $oProviderModificar->getId())
																	->find())), 4, 1)
			;
	
	
	//Si el provider no tiene owner, entonces puede dejar sin elegir el owner y hacer un "Provider independiente" :)
	if (is_null($oProviderModificar->getOwner())) {
		$this->getComponent('owner')->setOptional(true);
	}

	$this->getValuesFromObject($oProviderModificar);

	return true;
    // Bouml preserved body end 00127505
  }

}
?>