<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ProfileGroupForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001D5B85
	parent::__construct($orm, $context);
	
	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider');
	$securityManager = $context->getManager('Security');
	$selProvider->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));
    $selProvider->addEvent(Component::EVENT_CHANGE, 
							function (ApplicationContext $context, Form $form, ORM $orm) {
		
								$providerId = $context->getParam('provider_id');
								
								$profileOptions = $orm->query("Profile")->attributes("id as value", "name as description")->filterBy("provider.id", "=", $providerId)->find();
								
								$selProfiles = $form->getComponent('profiles');
								$selProfiles->setOptions($profileOptions);
								
								$selAdminProfile = $form->getComponent('adminProfile');
								$selAdminProfile->setOptions($profileOptions);
								
								$form->updated('profiles', 'adminProfile');
								return true;
							}, $orm
						);
	//$profileOptions = $orm->query("Profile")->attributes("id as value", "name as description")->filterBy("provider.id", "IN", $securityManager->getOwnedProvidersIds($context->getProvider(), true))->find();
	$profileOptions = array();
	$selAdminProfile = new SelectComponent('Perfil Administrador', 'adminProfile', 'adminProfile');
	$selAdminProfile->setOptions($profileOptions)->setOptional(false);
	
	$selProfiles = new MultiselectComponent('Perfiles', 'profiles', 'profiles');
	$selProfiles->setOptions($profileOptions)->setOptional(false);
	

	$oLayout1 = new GridLayout(5, 2);
	$oLayout1->addComponent($selProvider, 1, 1)
			 ->addComponent(new TextComponent(array('label'=>'Nombre', 'maps'=>'name', 'size'=>20)), 2, 1)
			 ->addComponent(new TextComponent(array('label'=>'Descripción', 'maps'=>'description', 'size'=>30)), 3, 1)
			 ->addComponent($selAdminProfile, 4, 1)
			 ->addComponent($selProfiles, 5, 1);
	
	$this->setClass("ProfileGroup")
		   ->setTitle("Grupo de perfil")
		   ->setMethod("post")
		   ->setId("id_form")
		   ->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);

	return $this;
    // Bouml preserved body end 001D5B85
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 001D7505
	
	$profileGroup = $orm->retrieve('ProfileGroup', $context->getParam('id'));/*@var $profileGroup ProfileGroup*/
	if (!$profileGroup) $profileGroup = $orm->load('ProfileGroup', $context->getParam('id'));
	$providerId = $profileGroup->getProvider()->getId();
	
	$profileOptions = $orm->query("Profile")->attributes("id as value", "name as description")->filterBy("provider.id", "=", $providerId)->find();
	
	$selAdminProfile = $this->getComponent('adminProfile');
	$selAdminProfile->setOptions($profileOptions);
	
	$selProfiles = $this->getComponent('profiles');
	$selProfiles->setOptions($profileOptions);
	
	return parent::modify($context, $orm);
	
    // Bouml preserved body end 001D7505
  }

}
?>