<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ProfileForm extends ABMForm {
  /**
   * Crea un formulario de ABM de un Perfil
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122985
	parent::__construct($orm, $context);
	
	/**
	* Modifica el arreglo para que se vea nas lindo el combo de menu: "name" ("parent_name")
	* 
	* @param array $aMenues Un arreglo con la lista de menues que se quiere modificar.
	*/
	function parentMenu(&$aMenues, $name = "description", $parent_name = "parentName") {
		if (is_array($aMenues) && (count($aMenues) > 0)) {
			foreach ($aMenues as $key => $menu) {
				if ($menu[$parent_name]) {
					$aMenues[$key][$name] = $menu[$name] . " (" . $menu[$parent_name] . ")";
					unset($aMenues[$key][$parent_name]);
				}
			}
		}
	}
	
	//manual_load_path
	//manual_storage_path
	
	$query = $orm->query('Action')
						 ->attributes('id AS value', 'name AS description', 'alias','facade.alias AS group')
						 ->filterBy('facade.providers.id', '=', $context->getProvider()->getId())
						 ->orderBy('facade.alias', 'name');
	$actionOptions=$query->find();
	$menuOptions = $orm->query('Menu')
						 ->attributes('id AS value', 'name AS description', 'action.facade.alias AS group')
						 ->filterBy('provider', '=', $context->getProvider()->getId())
						 ->orderBy('action.facade.alias DESC', 'name')
						 ->dontWorryAbout('action', 'action.facade')
						 ->find();
	for ($i = 0; $i < count($menuOptions); $i++)
		$ids[]=$menuOptions[$i]["value"];
	if(isset($ids)) {
		$secondaryResult = $orm->query("MenuLink")
								->attributes("menu.id AS menuId", "parent.menu.name AS parentName")
								->filterBy("menu.id", "IN", $ids)
								->find();
		
	}
	Utils::merge($menuOptions, array('value'=>'menuId'), $secondaryResult);
	for ($i = 0; $i < count($menuOptions); $i++)
		if (is_array($menuOptions[$i]["parentName"]))
			$menuOptions[$i]["parentName"] = implode(", ", $menuOptions[$i]["parentName"]);
	
	parentMenu($menuOptions);
	parentMenu($actionOptions, 'description', 'alias');
	//var_dump($menuOptions);
	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider');
	$securityManager = $context->getManager('Security');
	$selProvider->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));

	
	$actions = new MultiselectComponent();
	$actions->setLabel("Acciones")
		    ->setMaps("actions")
			->setSize('10')
			->setOptions($actionOptions);

	$menues = new MultiselectComponent();
	$menues->setLabel("Menues")
		    ->setMaps("menus")
			->setSize('10')
			->setOptions($menuOptions);
	
	$fileManual = new FileComponent("Manual", "file_manual");


	$oLayout1 = new GridLayout(6, 2);
	$oLayout1->addComponent(new TextComponent(array('label'=>'Nombre', 'maps'=>'name', 'size'=>30)), 1, 1)
			 ->addComponent(new TextComponent(array('label'=>'Descripción', 'maps'=>'description', 'size'=>30)), 2, 1)
			 ->addComponent(new TextComponent(array('label'=>'Template de Bienvenida', 'maps'=>'welcome', 'size'=>70)), 3, 1)
			->addComponent(new TextComponent(array('label'=>'Manual', 'maps'=>'manual', 'size'=>70)), 4, 1)->addComponent($fileManual, 4, 2)
			 ->addComponent($selProvider, 5, 1)
			 ->addComponent($actions, 6, 1)
			 ->addComponent($menues, 6, 2);
	
	$this->setClass("Profile")
		   ->setTitle("Perfil")
		   ->setMethod("post")
		   ->setId("id_form")
		   ->setFormType(Form::FORM_OK_CANCEL)
			->setEnctype("multipart/form-data")
		   ->addComponent($oLayout1);

	return $this;
    // Bouml preserved body end 00122985
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 001DB585
	$manual  = $this->getValueOf("manual");
	$dir_storage = $context->getProvider()->getGlobal("manual_storage_path");
	$fileManualValue = $this->getValueOf("file_manual");
	$fileManualComponent = $this->getComponent("file_manual");
	if ($fileManualValue) {
		//Si me postearon un archivo
		//$temporal_leido = file_get_contents($fileManualValue['tmp_name']);
		$fileManualComponent->placeIn($fileManualValue, $dir_storage, basename($manual));
	}
	return parent::save($context, $orm);
    // Bouml preserved body end 001DB585
  }

}
?>