<?php
require_once 'iplan/web/Form.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class PasswordRecoveryForm extends Form {
  /**
   * Crea una instancia de Form.
   * 
   * @param ApplicationContext $context el contexto.
   * 
   * @return Form
   */
  public function __construct(&$context)
  {
    // Bouml preserved body begin 001CE605
	parent::__construct();
	$this->setContext($context);
	
	$this->setMethod("post")
		->setFormType(Form::FORM_OK_CANCEL)
		->setId("id_recover_password");
	
	$cUsuario = new TextComponent(array("label" => "Usuario", "name" => "user", "validate" => "required alphanumeric"));
	$cMail = new TextComponent(array("label" => "Email", "name" => "mail", "validate" => "required mail"));

	$oLayout1 = new GridLayout(6, 1);
	$oLayout1->addComponent(new LabelComponent("Si olvido su contraseña cargue los siguientes datos y se le enviará un mail", "description"), 1, 1)
			->addComponent($cUsuario, 2, 1)
			->addComponent($cMail, 3, 1)
			;
	
	
	$this->addComponent($oLayout1);
	
	$this->setAction("Security.passwordRecoverySend");
    // Bouml preserved body end 001CE605
  }

}
?>