<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class PasswordChange extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00163F05
	parent::__construct($orm, $context);
	
	$this->setClass("User")
			->setMethod("post")
			->setFormType(Form::FORM_OK_CANCEL)
			->setId("id_form_user")
			->setTitle("Cambio de contraseña");
	
	$compPasswordActual = new PasswordComponent();
	$compPasswordActual->setLabel("Contraseña actual")
				 ->setName('old_password')
				 ->setValidate('required')
				 ->setSize("20")
				 ->setValue('');
	
	$compPasswordNuevo = new PasswordComponent();
	$compPasswordNuevo->setLabel("Contraseña nueva")
				 ->setMaps('password')
				 ->setValidate('alphanumeric', 'required')
				 ->setSize("20")
				 ->setValue('');

	$compConfPassword = new PasswordComponent();
	$compConfPassword->setLabel("Confirmación de contraseña")
					 ->setName('conf_password')
					 ->setSize("20")
					 ->setValidate('alphanumeric', 'required')
					->setValue('');
	
	$oLayout1 = new GridLayout(6, 1);
	$oLayout1->addComponent(new LabelComponent("Usuario", "username"), 1, 1)
			->addComponent(new LabelComponent("Nombre", "name"), 2, 1)
			->addComponent(new LabelComponent("Apellido", "surname"), 3, 1)
			->addComponent($compPasswordActual, 4, 1)
			->addComponent($compPasswordNuevo, 5, 1)
			->addComponent($compConfPassword, 6, 1);
	
	
	$this->addComponent($oLayout1);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00163F05
  }

  /**
   * Funci�n invocada para crear una instancia del objeto que representa el formulario
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function fresh($context, $orm)
  {
    // Bouml preserved body begin 001D0185
	$ret = $this->modify($context, $orm);
	if ($this->getValueOf('uwsSubmit')==1)
		$this->loadValues();
	return $ret;
    // Bouml preserved body end 001D0185
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00164005
	//$object = $orm->load($this->class, );
	$usuario = $context->getUser();
	//if ($usuario->ge)
	if ($usuario->getForcePasswordChange()) {
		$labelPass = new LabelComponent("Ud. tiene un cambio de contraseña forzado, deberá cambiar su password para poder continuar", "force_pass");
		$labelPass->setStyle("color: red;");
		$this->addComponent($labelPass);
	}
	if ($usuario->getLoginUnificado()) {
		$labelCom = new LabelComponent("Usuario de Login Unifiado", "user_lu", "user_lu", "Esta acción modificará el password de esta cuenta, para todas las plataformas que tenga acceso.");
		$labelCom->setStyle("color: red;");
		$this->addComponent($labelCom);
	}
	$this->setValueOf('password', '');
	$this->setValueOf('conf_password', '');
	$this->setValueOf('name', $usuario->getName());
	$this->setValueOf('surname', $usuario->getSurname());
	$this->setValueOf('username', $usuario->getUsername());
	$usuario->setPassword("");
	$this->getValuesFromObject($usuario);
	return true;
    // Bouml preserved body end 00164005
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 00164085
	//Caso modificar
	//$object = $orm->load($this->class, $this->getValueOf('id'));
	$usuario = $context->getUser();
	$passwordActual = $this->getValueOf('old_password');
	$passwordNuevo = $this->getValueOf('password');
	$passwordConfPassowrd = $this->getValueOf('conf_password');
	
	$this->setValueOf('name', $usuario->getName());
	$this->setValueOf('surname', $usuario->getSurname());
	$this->setValueOf('username', $usuario->getUsername());
	
	$valido = $this->validate();
	$aRes = array();
	//$valido = true;
	if ($passwordConfPassowrd != $passwordNuevo) {
		$aRes["password"] = "Los password no coinciden";
		return $aRes;
	}
	
	if ($usuario->getLoginUnificado()) {
		$userValidoLU = false;
		$login = new CLL_Login(); //Creo un objeto de Login
		$login->setUsername($usuario->getUsername());
		$login->setPassword($passwordActual);
		try {
			$userValid = CLL_Authenticate($login); //Pregunto si está autenticado (debería ser una confirmación positiva)
			if ($userValid->answer === true) {
				//Passwd Valido
				$userValidoLU = true;
			}
		} catch(Exception $e) {
			$aRes["LoginUnificado"] = 'No se pudo conectar con el servio de autenticacion de Login Unificado.';
		}
		if (!$userValidoLU) {
			$aRes["LoginUnificado"] = "El password actual es inválido";
		} else {
			//Actualizo
			try {
				$answer = Cll_ModifyPassword($login, $passwordNuevo);
				if (is_a($answer, 'CLL_Answer')) {
					if ($answer->answer !== true) {
						//Passwd inválido
						$aRes["LoginUnificado"] = "No se pudo actualizar el password de Login Unificado";
					} else {
						return $usuario;
					}
				} else {
					$aRes["LoginUnificado"] = "No se pudo actualizar el password de Login Unificado, respuesta incorrecta";
				}
			} catch(Exception $e) {
				$aRes["LoginUnificado"] = "No se pudo actualizar el password de Login Unificado, error de ejecución.";
			}
		}
	} else {
		if (sha1($passwordActual) == $usuario->getPassword()) {
			$usuario->setPassword(sha1($passwordNuevo));
		} else {
			$aRes["password"] = "El password actual es inválido";
		}
	}
	if (count($aRes) > 0) {
		return $aRes;
	}
	//$this->setValuesToObject($object);
	if ($valido === true) {
		$usuario->setForcePasswordChange(false);
		$orm->save($usuario);
		return $usuario;
	} else {
		//Seteo error de contexto de validacion xd.-
		return $valido;
	}
    // Bouml preserved body end 00164085
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 00164105
	throw new Exception("No se puede eliminar");
    // Bouml preserved body end 00164105
  }

}
?>