<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/web/Form.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class MenuLinkForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001A0005
	parent::__construct($orm, $context);
	$this->setAction($context->getCurrentAction()->getStringCommand());
	
	$layout = new GridLayout(6, 1);
	$layout->addComponent(new SelectComponent(array('label'=>'Dominio', 'maps'=>'domain', 'name'=>'domain',
													'options'=>$orm->query('Domain')
																->attributes('id as value', 'baseURL as description', 'provider.name as group')
																->filterBy('provider', '=', $context->getProvider()->getId(), null, 'OR')
																->filterBy('provider.owner', '=', $context->getProvider()->getId(), null, 'OR')
																->orderBy('provider.name', 'baseURL')
																->find())), 1, 1)
		   ->addComponent(new SelectComponent(array('label'=>'Menu', 'optional'=>false, 'maps'=>'menu', 'name'=>'menu')), 2, 1)
		   ->addComponent(new TextComponent(array('label'=>'Orden', 'maps'=>'order')), 3, 1)
		   ->addComponent(new TextComponent(array('label'=>'CSS Class', 'maps'=>'cssClass')), 4, 1)
		   ->addComponent(new SelectComponent(array('label'=>'Padre', 'maps'=>'parent', 'name'=>'parent')), 5, 1)
		   ;
	$this->setClass("MenuLink")
		 ->setTitle("Enlace a menú")
		 ->setMethod("post")
		 ->setFormType(Form::FORM_OK_CANCEL)
		 ->addComponent($layout);

	
	$this->getComponent('domain')->addEvent(Component::EVENT_CHANGE, 'domainChanged', $orm);
	return $this;
    // Bouml preserved body end 001A0005
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 001A0205
	$menuLink = $orm->retrieve('MenuLink', $context->getParam('id'));/*@var $menuLink MenuLink*/
	if (!$menuLink) $menuLink = $orm->load('MenuLink', $context->getParam('id'));
	/**
	* Modifica el arreglo para que se vea nas lindo el combo de menu: "name" ("parent_name")
	* 
	* @param array $aMenues Un arreglo con la lista de menues que se quiere modificar.
	*/
	function parentMenu(&$aMenues, $name = "description", $parent_name = "parentName") {
		if (is_array($aMenues) && (count($aMenues) > 0)) {
			foreach ($aMenues as $key => $menu) {
				if ($menu[$parent_name]) {
					$aMenues[$key][$name] = $menu[$name] . " (" . $menu[$parent_name] . ")";
					unset($aMenues[$key][$parent_name]);
				}
			}
		}
	}
	
	if ($menuLink) {
		$selMenu = $this->getComponent('menu');
		$aMenues = $orm->query('MenuLink')
							   ->filterBy('menu.provider', '=', $menuLink->getDomain()->getProvider()->getId(), null, 'OR')
							   ->attributes('menu.id as value', 'menu.name as description', 'parent.menu.name as parentName','menu.action.facade.alias as group')
							   ->dontWorryAbout('menu.action', 'menu.action.facade', 'parent')
							   ->orderBy('menu.action.facade.alias DESC', 'menu.name')
							   ->find();
		parentMenu($aMenues);
		$selMenu->setOptions($aMenues);
		$selParent = $this->getComponent('parent');
		$aParentMenu = $orm->query('MenuLink')
							->filterBy('domain', '=', $menuLink->getDomain()->getId())
							->attributes('id as value', 'menu.name as description', 'parent.menu.name as parentName','menu.action.facade.alias as group')
							->dontWorryAbout('menu.action', 'menu.action.facade', 'parent', 'parent.menu')
							->orderBy('menu.action.facade.alias DESC', 'menu.name')
							->find();
		parentMenu($aParentMenu);
		$selParent->setOptions($aParentMenu);
		$this->getValuesFromObject($menuLink);
		return true;
	} else return false;
    // Bouml preserved body end 001A0205
  }

  /**
   * Actualiza las listas de selección de Menú y Padre si el dominio cambia.
   */
  public function domainChanged(&$context, &$form, &$orm)
  {
    // Bouml preserved body begin 001A0285
	/**
	* Modifica el arreglo para que se vea nas lindo el combo de menu: "name" ("parent_name")
	* 
	* @param array $aMenues Un arreglo con la lista de menues que se quiere modificar.
	*/
	function parentMenu(&$aMenues, $name = "description", $parent_name = "parentName") {
		if (is_array($aMenues) && (count($aMenues) > 0)) {
			foreach ($aMenues as $key => $menu) {
				if ($menu[$parent_name]) {
					$aMenues[$key][$name] = $menu[$name] . " (" . $menu[$parent_name] . ")";
					unset($aMenues[$key][$parent_name]);
				}
			}
		}
	}
	  
	$domainId = $this->getValueOf('domain');
	if ($domainId) {
		$selMenu = $this->getComponent('menu');
		$aMenues = $orm->query('Menu')
					->distinct()
					->filterBy('provider.id', '=', $context->getProvider()->getId())
					->filterBy('profiles.domains.id', '=', $domainId)
					->attributes('id as value', 'name as description', 'links.parent.menu.name as parentName' ,'action.facade.alias as group')
					->dontWorryAbout('action', 'action.facade', 'links', 'links.parent', 'links.parent.menu')
					->orderBy('action.facade.alias DESC', 'name')
					->find();
		parentMenu($aMenues);
		$selMenu->setOptions($aMenues);
		$selParent = $this->getComponent('parent');
		$aParentMenu = $orm->query('MenuLink')
							->filterBy('domain', '=', $domainId)
							->attributes('id as value', 'menu.name as description', 'parent.menu.name as parentName','menu.action.facade.alias as group')
							->dontWorryAbout('menu.action', 'menu.action.facade', 'parent', 'parent.menu')
							->orderBy('menu.action.facade.alias DESC', 'menu.name')
							->find();
		parentMenu($aParentMenu);
		$selParent->setOptions($aParentMenu);
		$this->updated('menu', 'parent');
		return true;
	} else return false;
    // Bouml preserved body end 001A0285
  }

}
?>