<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/Menu.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class MenuForm extends ABMForm {
  /**
   * Crea un formulario de ABM de Menues
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122A05
	parent::__construct($orm, $context);
	$this->setAction($context->getCurrentAction()->getStringCommand());
	$layout = new GridLayout(6, 1);
	$layout->addComponent(new TextComponent(array('label'=>'Nombre', 'size'=>30, 'maps'=>'name')), 1, 1)
		   ->addComponent(new TextComponent(array('label'=>'Ícono', 'size'=>30, 'maps'=>'icon')), 2, 1)
		   ->addComponent(new TextComponent(array('label'=>'Acción', 'size'=>40, 'name'=>'actionAlias')), 3, 1)
		   ->addComponent(new TextComponent(array('label'=>'Parámetros', 'size'=>50, 'maps'=>'params')), 4, 1)
		   ->addComponent(new SelectComponent(array('label'=>'¿Es visible?', 'optional'=>false, 'maps'=>'visible', 
												'options'=>array(array("value" => "1", "description" => "Sí"), 
																 array("value" => "0", "description" => "No")))), 5, 1)
		   ->addComponent(new SelectComponent(array('label'=>'¿Es dinámico?', 'optional'=>false, 'maps'=>'dynamic', 
												'options'=>array(array("value" => "1", "description" => "Sí"), 
																 array("value" => "0", "description" => "No")))), 6, 1)
			;
	
	$this->setClass("Menu")
		 ->setTitle("Menu")
		 ->setMethod("post")
		 ->setFormType(Form::FORM_OK_CANCEL)
		 ->addComponent($layout);
	
	return $this;
    // Bouml preserved body end 00122A05
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00127805
	$oMenu = $orm->retrieve('Menu', $this->getValueOf('id'));
	if (!$oMenu) $oMenu = $orm->load('Menu', $this->getValueOf('id'));
	$this->getValuesFromObject($oMenu);
	if (!is_null($oMenu->getAction()))
		$this->setValueOf('actionAlias', $oMenu->getAction()->getStringCommand());
	return true;
    // Bouml preserved body end 00127805
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return Menu el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 00127785
	$id = $this->getValueOf('id');
	$valido = $this->validate();
	if ($valido === true) {
		if ($id === null) //Caso alta
			$oMenu = new Menu();
		else {            //Caso modificar
			$oMenu = $orm->retrieve('Menu', $this->getValueOf('id'));
			if (!$oMenu) $oMenu = $orm->load('Menu', $this->getValueOf('id'));
		}
		$this->setValuesToObject($oMenu);
		$oMenu->setProvider($context->getProvider());
		$actionAlias = $this->getValueOf('actionAlias');
		if (!is_null($actionAlias)) {
			$action = $context->getActionByAlias($actionAlias);
			$oMenu->setAction($action);
		}
		$orm->save($oMenu);
		return $oMenu;
	} else {
		return $valido;
	}
    // Bouml preserved body end 00127785
  }

}
?>