<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ManagedUserForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001D7685
	parent::__construct($orm, $context);
	
	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider');
	/*$securityManager = $context->getManager('Security');
	$aProviderOptions = $securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true);*/
	$selProvider->setOptional(false);
	
	$selProvider->addEvent(Component::EVENT_CHANGE, 
							function (ApplicationContext $context, Form $form, ORM $orm) {
								//Busco Perfiles que administra
								$provider_id = $context->getParam("provider_id", null);
								$aIdProfiles = array();
								$aPerfiles = $context->getUser()->getProfiles();
								if (is_a($aPerfiles, 'ORMCollection') && count($aPerfiles) > 0) {
									foreach ($aPerfiles as $perfil) {
										$aIdProfiles[] = $perfil->getId();
									}
								}
								
								$qry = $orm->query("Profile")
											->attributes("id as value", "name as description")
											->filterBy("profileGroups.adminProfile.id", "IN", $aIdProfiles);
								if ($provider_id)
									$qry->filterBy("provider.id", "=", $provider_id);
								
								$profileOptions = $qry->find();
								
								$selProfiles = $form->getComponent('profiles');
								$selProfiles->setOptions($profileOptions);
								
								$form->updated('profiles');
								return true;
							}, $orm
						);
	
	$selProfiles = new MultiselectComponent('Perfiles', 'profiles', 'profiles');
	$selProfiles->setOptional(false);
	
	$oLayout1 = new GridLayout(6, 1);
	$oLayout1->addComponent($selProvider, 1, 1)
			 ->addComponent(new TextComponent(array('label'=>'Usuario','size'=>20, 'maps'=>'username', 'maxLength'=>10, 'validate'=>'alphanumeric')), 2, 1)
			 ->addComponent(new TextComponent(array('label'=>'Email', 'size'=>30, 'maps'=>'mail', 'validate'=>'mail')), 3, 1)
			 ->addComponent(new TextComponent(array('label'=>'Nombre', 'size'=>20, 'maps'=>'name')), 4, 1)
			 ->addComponent(new TextComponent(array('label'=>'Apellido', 'size'=>20, 'maps'=>'surname')), 5, 1)
			 ->addComponent($selProfiles, 6, 1)
			 ;
	
	$this->setClass("User")
		   ->setTitle("Administración de Usuarios")
		   ->setMethod("post")
		   ->setId("id_form")
		   ->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);
	return $this;
    // Bouml preserved body end 001D7685
  }

  /**
   * Funci�n invocada para crear una instancia del objeto que representa el formulario
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function fresh($context, $orm)
  {
    // Bouml preserved body begin 001D9905
	$selProvider = $this->getComponent('provider_id');
	$securityManager = $context->getManager('Security');
	$aProviderOptions = $securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true);
	$selProvider->setOptions($aProviderOptions);
	$aDefaultProvider = current($aProviderOptions);
	$idDefaultProvider = $aDefaultProvider["value"];
	$selProvider->setValue($idDefaultProvider);
	
	$aIdProfiles = array();
	$aPerfiles = $context->getUser()->getProfiles();
	if (is_a($aPerfiles, 'ORMCollection') && count($aPerfiles) > 0) {
		foreach ($aPerfiles as $perfil) {
			$aIdProfiles[] = $perfil->getId();
		}
	}
	$provider_id = $selProvider->getValue();
	$profileOptions = $orm->query("Profile")
							->attributes("id as value", "name as description")
							->filterBy("profileGroups.adminProfile.id", "IN", $aIdProfiles)
							->filterBy("provider.id", "=", $provider_id)
							->find();
	$selProfiles = $this->getComponent('profiles');
	$selProfiles->setOptions($profileOptions);
	
	return true;
    // Bouml preserved body end 001D9905
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 001D7705
	/*$oUser = $orm->retrieve('User', $context->getParam('id'));
	if (!$oUser) $oUser = $orm->load('User', $context->getParam('id'));
	$providerId = $oUser->getProvider()->getId();*/
	$aUser = $orm->query("User")->filterBy("id", "=", $context->getParam('id'))->findOne();
	$providerId = $aUser->getProvider()->getId();
			
	$selProvider = $this->getComponent('provider_id');
	$securityManager = $context->getManager('Security');
	$aProviderOptions = $securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true);
	$selProvider->setOptions($aProviderOptions);
	$aDefaultProvider = current($aProviderOptions);
	$idDefaultProvider = $aDefaultProvider["value"];
	$selProvider->setValue($idDefaultProvider);
	
	$aIdProfiles = array();
	$aPerfiles = $context->getUser()->getProfiles();
	if (is_a($aPerfiles, 'ORMCollection') && count($aPerfiles) > 0) {
		foreach ($aPerfiles as $perfil) {
			$aIdProfiles[] = $perfil->getId();
		}
	}
	
	$profileOptions = $orm->query("Profile")
							->attributes("id as value", "name as description")
							->filterBy("profileGroups.adminProfile.id", "IN", $aIdProfiles)
							->filterBy("provider.id", "=", $providerId)
							->find();
	
	$selProfiles = $this->getComponent('profiles');
	$selProfiles->setOptions($profileOptions);
	
	if ($aUser) $this->getValuesFromObject($aUser); else throw new Exception("Objeto no encontrado");
	return true;
    // Bouml preserved body end 001D7705
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 001D7785
	$id = $this->getValueOf('id');
	$valido = $this->validate();
	if ($valido === true) {
		if ($id == null) {
			$oUser = new User();
			$this->setValuesToObject($oUser);
			$oUser->setLoginUnificado(false);
			$password =  substr(sha1(microtime()), 0, 8);
			$oUser->setPassword(sha1($password));
			$cPerfilUsuarioRegistrado = "Usuarios Registrados - iPlan";
			$oPerfilUsuarioRegistrado = $orm->query("Profile")->filterBy("name", "=", $cPerfilUsuarioRegistrado)->findOne();
			$oUser->addProfile($oPerfilUsuarioRegistrado);
			
			$aNombres = array();
			if ($oUser->getName())
				$aNombres[] = $oUser->getName();
			if ($oUser->getSurname())
				$aNombres[] = $oUser->getSurname();
			
			$aParametros = array();
			$aParametros["usuario"] = implode(", ", $aNombres);
			$aParametros["user"] = $oUser->getUsername();
			$aParametros["password"] = $password;
			$aParametros["domain"] = $context->getDomain()->getBaseURL();
			$aParametros["accion"] = "nuevousuario";
			$aParametros["titulo_mail"] = "IPLAN - Nuevo usuario";
			
			/* Parseo el template de mail y lo mando */
			$genManager = $context->getManager("Application");
			$app = Application::getInstance();
			$mail = $oUser->getMail();
			$template_mail = $app->parse("lib/recover_password.xhtml", $aParametros);
			$resultado_mail = $genManager->mailTo("notificacionesaltaservicio@iplan.com.ar", $mail, "IPLAN - Alta de usuario", $template_mail);
			if (!$resultado_mail) {
				throw new Exception("Ha ocurrido un error al enviar el mail al usuario, se cancelará la acción.");
			}
		} else {
			$resultado_mail = true;
			//Caso modificar
			$oUser = $orm->retrieve("User", $this->getValueOf('id'));
			if (!is_object($oUser))
				$oUser = $orm->load("User", $this->getValueOf('id'));
			$aIdProfiles = array();
			$aPerfiles = $context->getUser()->getProfiles();
			if (is_a($aPerfiles, 'ORMCollection') && count($aPerfiles) > 0) {
				foreach ($aPerfiles as $perfil) {
					$aIdProfiles[] = $perfil->getId();
				}
			}
			//Sacar los perf que administra
			$provider_id = $oUser->getProvider()->getId();
			$profileOptions = $orm->query("Profile")
								->attributes("id")
								->filterBy("profileGroups.adminProfile.id", "IN", $aIdProfiles)
								->filterBy("provider.id", "=", $provider_id)
								->find();
			$aTodosPerfiles = array();
			if ($profileOptions)
				for ($i = 0; $i < count($profileOptions); $i++)
					$aTodosPerfiles[] = $profileOptions[$i]["id"]; //$oUser->delProfile($profileOptions[$i]);


			$aPerfilesSeleccionados = $this->getValueOf("profiles");
			if (!is_array($aPerfilesSeleccionados))
				$aPerfilesSeleccionados = array($aPerfilesSeleccionados);
			
			//$aPerfilesSeleccionados = array_diff($aPerfilesSeleccionados, $aIdProfiles);
			$aPerfilesQuitar = array_values(array_diff($aTodosPerfiles, $aPerfilesSeleccionados));
			//var_dump($aPerfilesQuitar);
			for($i = 0; $i < count($aPerfilesQuitar); $i++){
				if ($aPerfilesQuitar[$i]) {
					$obj = $orm->retrieve("Profile", $aPerfilesQuitar[$i]);
					if (!$obj)
						$obj = $orm->load("Profile", $aPerfilesQuitar[$i]);
					$oUser->delProfile($obj);
				}
			}
			for ($j = 0; $j < count($aPerfilesSeleccionados); $j++) {
				if ($aPerfilesSeleccionados[$j]) {
					$obj = $orm->retrieve("Profile", $aPerfilesSeleccionados[$j]);
					if (!$obj)
						$obj = $orm->load("Profile", $aPerfilesSeleccionados[$j]);
					$oUser->addProfile($obj);
				}
			}
			
			//$this->setValuesToObject($object);
		}
		if ($resultado_mail) {
			//Ok
			$orm->save($oUser);
			return $oUser;
		} else {
			return ;
		}
	} else {
		return $valido;
	}
    // Bouml preserved body end 001D7785
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 001D7805
	$oUser = $orm->query("User")->filterBy("id", "=", $this->getValueOf('id'))->findOne();
	
	if ($oUser) {
		$provider_id = $oUser->getProvider()->getId();
		$aIdProfiles = array();
		$aPerfiles = $context->getUser()->getProfiles();
		if (is_a($aPerfiles, 'ORMCollection') && count($aPerfiles) > 0) {
			foreach ($aPerfiles as $perfil) {
				$aIdProfiles[] = $perfil->getId();
			}
		}
		$profileOptions = $orm->query("Profile")
								->filterBy("profileGroups.adminProfile.id", "IN", $aIdProfiles)
								->filterBy("provider.id", "=", $provider_id)
								->find();
		if ($profileOptions) {
			for ($i = 0; $i < count($profileOptions); $i++) {
				$oUser->delProfile($profileOptions[$i]);
			}
		}
		if (count($oUser->getProfiles()) < 2) {
			$orm->delete($oUser);
		} else {
			$orm->save($oUser);
		}
	} else {
		 throw new Exception("Objeto no encontrado");
	}
	return true;
    // Bouml preserved body end 001D7805
  }

}
?>