<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GlobalForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001C7005
	parent::__construct($orm, $context);
	
	$this->setClass("GlobalData")
		 ->setTitle("Datos Globales")
		 ->setMethod("post")
		 ->setFormType(Form::FORM_OK_CANCEL)
		 ->addComponent(new TextComponent(array('label'=>'Nombre', 'maps'=>'name', 'size'=>20)))
		 ->addComponent(new TextComponent(array('label'=>'Valor', 'maps'=>'value', 'size'=>50)))
		 ->addComponent(new SelectComponent(array(	'label'=>'Provider', 
													'name'=>'provider_id',
													'maps'=>'provider',
													'options'=>$orm->query('Provider')
																		->attributes('id as value', 'name as description')
																		->find(),
													'optional' => true
												 )
											)
						)
		 ->addComponent(new SelectComponent(array(	'label'=>'Domain', 
													'name'=>'domain_id',
													'maps'=>'domain',
													'options'=>$orm->query('Domain')
																		->attributes('id as value', 'baseURL as description')
																		->find(),
													'optional' => true
												 )
											)
						)
		 ->addComponent(new SelectComponent(array(	'label'=>'Facade', 
													'name'=>'facade_id',
													'maps'=>'facade',
													'options'=>$orm->query('Facade')
																		->attributes('id as value', 'alias as description')
																		->find(),
													'optional' => true
												 )
											)
						)
		
		;
	return $this;
    // Bouml preserved body end 001C7005
  }

}
?>