<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class FacadeForm extends ABMForm {
  /**
   * Crea un formulario de ABM de Facades
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122A85
	parent::__construct($orm, $context);
	
	$this->setClass("Facade")
		 ->setTitle("Facade")
		 ->setMethod("post")
		 ->setFormType(Form::FORM_OK_CANCEL)
		 ->addComponent(new TextComponent(array('label'=>'Archivo', 'maps'=>'file', 'size'=>50)))
		 ->addComponent(new TextComponent(array('label'=>'Nombre de la Clase', 'maps'=>'class', 'size'=>30)))
		 ->addComponent(new TextComponent(array('label'=>'Alias de la Clase', 'maps'=>'alias', 'size'=>30)))
		;
	return $this;
    // Bouml preserved body end 00122A85
  }

}
?>