<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class DomainForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0019E485
	parent::__construct($orm, $context);
	$this->setAction($context->getCurrentAction()->getStringCommand());
	$layout = new GridLayout(9, 2);
	$layout->addComponent(new TextComponent(array('label'=>'URL', 'size'=>30, 'maps'=>'baseURL')), 1, 1)
		   ->addComponent(new TextComponent(array('label'=>'Alias de Directorio', 'size'=>40, 'maps'=>'alias')), 2, 1)
		   ->addComponent(new TextComponent(array('label'=>'Filas del Paginado', 'size'=>3, 'maps'=>'pageRows')), 3, 1)
		   ->addComponent(new SelectComponent(array('label'=>'¿Usa Logín Unificado?', 'optional'=>false, 'maps'=>'loginUnificado', 
											'options'=>array(array("value" => "1", "description" => "Sí"), 
															 array("value" => "0", "description" => "No")))), 7, 1)
		   ->addComponent(new MultiSelectComponent(array('label'=>'Perfiles', 'maps'=>'profiles', 'size'=>6,
											'options'=>$orm->query('Profile')
														   ->filterBy('provider', '=', $context->getProvider()->getId(), null, 'OR')
														   ->filterBy('provider.owner', '=', $context->getProvider()->getId(), null, 'OR')
														   ->attributes('id as value', 'name as description', 'provider.name as group')
														   ->orderBy('provider.name', 'name')
														   ->find())), 1, 2, 1, 4)
		   ;
	
	$this->setClass("Domain")
		 ->setTitle("Dominio")
		 ->setMethod("post")
		 ->setFormType(Form::FORM_OK_CANCEL)
		 ->addComponent($layout);

	return $this;
    // Bouml preserved body end 0019E485
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 0019E505
	//Fuerzo que el provider sea del provider actual
	$_POST['provider']=$context->getProvider()->getId();
	$this->addComponent(new HiddenComponent(null, 'provider', 'provider', $context->getProvider()->getId()));
	return parent::save($context, $orm);
    // Bouml preserved body end 0019E505
  }

}
?>