<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ActionForm extends ABMForm {
  /**
   * Crea un formulario de ABM de Acciones
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122B05
	parent::__construct($orm, $context);
	$facadeOptions = $orm->query('Facade')
						 ->attributes('id AS value', 'alias AS description')
						 ->find();
	
	$profileOptions = $orm->query('Profile')
					  ->filterBy('provider.id', '=', $context->getProvider()->getId())
					  ->attributes('id AS value', 'name AS description')
					  ->find();

	$profiles = new MultiselectComponent();
	$profiles->setLabel("Perfiles con acceso")
		     ->setMaps("actions")
			 ->setRows('10')
			 ->setOptions($profileOptions);


	$nombre = new TextComponent();
	$nombre->setLabel("Nombre")
			->setMaps('name')->setSize(30);
	
	$alias = new TextComponent();
	$alias->setLabel("Alias")
			->setMaps('alias')->setSize(20);

	$icon = new TextComponent();
	$icon->setLabel("Icono")
			->setMaps('icon')->setSize(20);
	
	$description = new TextArea();
	$description->setLabel("Descripción")
				->setSize('50')
		        ->setMaps("description");
		
	$facade = new SelectComponent();
	$facade->setLabel("Pertenece a")
				 ->setMaps('facade')
				 ->setOptions($facadeOptions);
	
	$method = new TextComponent();
	$method->setLabel("Method")
		        ->setMaps("method")->setSize(30);
	
	$params = new TextComponent();
	$params->setLabel("Parámetros")
			->setSize('50')
		    ->setMaps("params");
	
	$urlCode = new TextComponent();
	$urlCode->setLabel("Url Code")
		        ->setMaps("urlCode")->setSize(30);
	
	$hint = new TextComponent();
	$hint->setLabel("Hint")
		  ->setMaps("hint")->setSize(30);

	$useAjax = new SelectComponent();
	$useAjax->setLabel("¿Usa Ajax?")
				 ->setMaps('useAjax')
				 ->setOptions(array(array("value" => "1", "description" => "Si"), array("value" => "0", "description" => "No")))
				 ->setOptional(false);

	$oLayout1 = new GridLayout(10, 1);
	$oLayout1->addComponent($nombre, 1, 1)
			 ->addComponent($alias, 2, 1)
			 ->addComponent($description, 3, 1)
			 ->addComponent($icon, 4, 1)
			 ->addComponent($method, 5, 1)
			 ->addComponent($params, 6, 1)
			 ->addComponent($urlCode, 7, 1)
			 ->addComponent($hint, 8, 1)
			 ->addComponent($facade, 9, 1)
			 ->addComponent($useAjax, 10, 1);
	
	$this->setClass("Action")
		   ->setTitle("Action")
		   ->setMethod("post")
		   ->setId("id_form")
			->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);
	return $this;
    // Bouml preserved body end 00122B05
  }

}
?>