<?php
require_once 'iplan/orm/ORMQuery.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class Utils {
  /**
   * @var string describe el formato de fecha
   */
  static $FMT_DATE = 'd/m/Y';

  /**
   * @var string describe el formato de fecha corta
   */
  static $FMT_DATE_SHORT = 'j-n-y';

  /**
   * @var string describe el formato de fecha y hora
   */
  static $FMT_DATETIME = 'd/m/Y H:i:s';

  /**
   * @var string describe el formato de fecha y hora cortos
   */
  static $FMT_DATETIME_SHORT = 'j-n-y G:i';

  /**
   * @var string describe el formato de hora
   */
  static $FMT_TIME = 'H:i:s';

  /**
   * @var string describe el formato de hora corto
   */
  static $FMT_TIME_SHORT = 'G:i';

  /**
   * Agrupa una lista de elementos seg�n los valores de las claves indicadas.
   * 
   * @param array $by una lista de las claves por las cuales agrupar los datos.
   * @param array $items   la lista de items que deben ser agrupados.
   * 
   * @return array otra lista donde los valores de los campos agrupados no se repiten.
   */
  public static function group($by, &$items)
  {
    // Bouml preserved body begin 000CF685
    $tmpList = array();
    $list = array();

    $allkeys   = array_keys(current($items));
    $otherKeys = array_diff($allkeys, $by);

    //Agrupo
    foreach($items as $item) {
        $ref = &$tmpList;
        foreach($by as $key) {
            if (!is_null($item[$key]))
                $ref = &$ref[$item[$key]];
            else
                $ref = &$ref['NULL'];
        }
        foreach($otherKeys as $key) {
            $ref[$key][]=$item[$key];
        }
    }

    //Reconvierto
    $list = self::combine_recursive($tmpList, $by, array());
    return $list;
    // Bouml preserved body end 000CF685
  }

  /**
   * Usado internamente por group(); esta funci�n reconstruye los conjuntos agrupados en su representaci�n final.
   */
  protected static function combine_recursive(&$collection, $groups, $head)
  {
    // Bouml preserved body begin 000CF785
    $list = array();

    if (count($groups)!=0) {
        $col = array_shift($groups);
        foreach($collection as $key=>$data) {
            if ($key == 'NULL')
                $head[$col]=null;
            else
                $head[$col]=$key;
            if (count($groups)==1)
                $list[]=self::combine_recursive($collection[$key], $groups, $head);
            else
                $list = array_merge ($list, self::combine_recursive($collection[$key], $groups, $head));
        }
        return $list;
    } else {
        if (!is_null($collection))
            return array_merge($head, $collection);
        else return $head;
    }
    // Bouml preserved body end 000CF785
  }

  /**
   * Une al primer arreglo los elementos del segundo siempre que las columnas especificadas de ambos coincidan.
   * 
   * @param array $first la lista sobre la que se adicionar�n los elementos
   * @param array $by un arreglo donde cada clave y valor corresponden a las columnas de filtro del arreglo principal y el secundario respectivamente.
   * @param array $second la lista que se va a adicionar a la primera
   * @param array $rename otro arreglo donde las claves son los nombres de las columnas del $secondaryList que se desean renombrar al pasar a $mainList. (La clave es la key original y el valor es la key "nueva")
   * 
   * @return boolean true si la uni�n se hizo con �xito en todos los elementos o false si hubo elementos que no combinaban.
   */
  public static function merge(&$first, $by, &$second, $rename = array())
  {
    // Bouml preserved body begin 000CF705
	if (is_array($second)) reset($second);
	if (is_array($first)) reset($first);
	if (is_array($second) && (count($second) > 0) && (is_array(current($second)))) {
		$allkeys   = array_keys(current($second));
		$otherKeys = array_diff($allkeys, $by);
		for($j=0;$j < count($first); $j++) {
			$macheo = false;
			for($i=0;$i < count($second); $i++) {
				$ok = true;
				foreach($by as $mainKey=>$secondaryKey)
					$ok = $ok && ($first[$j][$mainKey]==$second[$i][$secondaryKey]);
				if ($ok) {
					$macheo = true;
					foreach($otherKeys as $key) {
						$newKey = (isset($rename[$key]))?$rename[$key]:$key;
						if (isset($first[$j][$newKey])) {
							if (is_array($first[$j][$newKey])) {
								$first[$j][$newKey][]=$second[$i][$key];
							} else {
								$first[$j][$newKey]=array($first[$j][$newKey], $second[$i][$key]);
							}
						} else {
							$first[$j][$newKey]=$second[$i][$key];
						}
					}
					
				}
			}
			if (!$macheo) {
				foreach($otherKeys as $key) {
					$newKey = (isset($rename[$key]))?$rename[$key]:$key;
					$first[$j][$newKey] = null;
				}
			}
			if ($j == count($first)+1) return false;
		}
		return true;
	} else {
		return false;
	}
    
    // Bouml preserved body end 000CF705
  }

  /**
   * Funci�n de debug.
   * 
   * @param ORMQuery la consulta a debugear.
   * 
   * @return string El SQL generado.
   */
  public static function debugQuery($query)
  {
    // Bouml preserved body begin 0010A485
    list($q, $g, $o) = $query->build();
    $res = $query->decrypt($q);
    return $res[0]['SALIDA'];
    // Bouml preserved body end 0010A485
  }

}
?>