<?php
require_once 'iplan/security/PasswordChangeRequest.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';

require_once('iplan/security/login_unificado/CLL_client_lib.php');

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa un usuario del sistema; es decir, identifica a una persona que accede a las funciones del sistema para hacer alguna tarea.
 * 
 * @method string getName()
 * @method User setName()
 * @method string getSurname()
 * @method User setSurname()
 * @method string getUsername()
 * @method User setUsername()
 * @method string getPassword()
 * @method User setPassword()
 * @method array getProfiles()
 * @method User addProfile()
 * @method User delProfile()
 * @method Provider getProvider()
 * @method User setProvider()
 * @method User setLoginUnificado()
 * @method boolean getLoginUnificado()
 * @method User setRefreshLoginUnificado()
 * @method boolean getRefreshLoginUnificado()
 * @method int getStatus()
 * @method User setStatus()
 * @method User setMail()
 * @method string getMail()
 * @method User setForcePasswordChange()
 * @method boolean getForcePasswordChange()
 */
class User extends ORMObject {
  /**
   * @const int Un estado que indica que el usuario est� deshabilitado.
   */
  const USER_DISABLED = '1';

  /**
   * @var int Un c�digo de estado que indica que el usuario est� activo.
   */
  const USER_ACTIVE = '0';

  /**
   * @var string $name el nombre real del usuario
   */
  protected $name;

  /**
   * @var string $surname el apellido real del usuario
   */
  protected $surname;

  /**
   * @var string $username el nombre de usuario escogido por o para el usuario
   */
  protected $username;

  /**
   * @var string $password el hash de la clave del usuario
   */
  protected $password;

  /**
   * @var boolean indica si el usuario es de login unificado o no.
   */
  protected $loginUnificado;

  /**
   * @var int un c�digo de estado.
   */
  protected $status;

  /**
   * @var string el mail del usuario. Se registra a los fines de recuperar el password.
   */
  protected $mail;

  /**
   * @var boolean un flag que indica si se deben refrescar los permisos del usuario de Login Unificado
   */
  protected $refreshLoginUnificado;

  /**
   * @var boolean un flag que indica si el usuario está obligado a cambiar su password.
   */
  protected $forcePasswordChange;

  /**
   * @var ORMCollection la lista de pedidos de restauración de password que tiene el usuario
   */
  protected $passwordChangeRequests;

  /**
   * @var Provider el proveedor al que pertenece el usuario
   */
  protected $provider;

  /**
   * @var array $profiles la lista de perfiles que tiene habilitado el usuario
   */
  protected $profiles;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 000A5F85
    return parent::define($orm)
               ->setClass('User')
               ->setTable('UWS_USER')
               ->addField('id', 'USER_ID', ORMDefinition::INTEGER, 10, 0, FALSE)
               ->setKey('id')
               ->addField('name', 'USER_NAME', ORMDefinition::STRING, 70, 0, FALSE)
               ->addField('surname', 'USER_SURNAME', ORMDefinition::STRING, 50, 0, true)
               ->addField('username', 'USER_USERNAME', ORMDefinition::STRING, 25, 0, FALSE)
               ->addField('password', 'USER_PASSWORD', ORMDefinition::STRING, 40, 0)
			   ->addField('loginUnificado', 'USER_LOGINUNIFICADO', ORMDefinition::BOOLEAN)
			   ->addField('refreshLoginUnificado', 'USER_LOGINUNIFICADOREFRESH', ORMDefinition::BOOLEAN)
			   ->addField('status', 'USER_STATUS', ORMDefinition::INTEGER, 1, 0, false, User::USER_ACTIVE)
			   ->addField('mail', 'USER_MAIL', ORMDefinition::STRING, 255, null)
			   ->addField('forcePasswordChange', 'USER_FORCEPASSCHANGE', ORMDefinition::BOOLEAN, null, null, true, true)
               ->addRelationNxM('profiles', 'UWS_USER_PROFILE', 'USER_ID', 'Profile')
               ->addInstance('provider', 'PROVIDER_ID', 'Provider', FALSE)
			   ->addRelation1xN('passwordChangeRequests', 'USER_ID', 'PasswordChangeRequest')
		  ;
    // Bouml preserved body end 000A5F85
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este m�todo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto s�lo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar� una excepci�n.
   * 
   * Se pens� en que se podr�a hacer el cambio de un ORM a otro, pero el ID deber�a limpiarse, con lo cual s�lo un INSERT se podr�a hacer sobre el destino y los objetos relacionados estar�an a�n con otro ORM lo cual es complicado (manejo de objetos distribu�dos) por lo cual se deja a consideraci�n de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 0016D485
	/*if ($this->getLoginUnificado()) {
		$login = new CLL_Login();
		$login->setUsername($this->getUsername());
		
		$answer = CLL_LoginAddWebAccesses($login, array(CLL_WEB_APPLICATION_ID));
		if ($answer->answer) {
			return parent::save($orm);
		} else {
			throw new LoginUnificadoException("No se pudo dar el acceso a la plataforma: " . $answer->answer_description);
		}
	} else {
		$login = new CLL_Login();
		$login->setUsername($this->getUsername());
		$answerLogin = CLL_GetLogin($login);
		if ($answerLogin->answer) {
			$answer = CLL_LoginDeleteWebAccesses($login, array(CLL_WEB_APPLICATION_ID));
			if ($answer->answer) {
				return parent::save($orm);
			} else {
				throw new LoginUnificadoException("No se pudo eliminar el acceso a la plataforma: " . $answer->answer_description);
			}
		} else {
			return parent::save($orm);
		}
	}
	*/
	if (($this->getId() == null) && ($this->getPassword() == "") && ($this->getLoginUnificado() == false)) {
		throw new UnknowORM("El password no puede ser vacío para usuarios locales nuevos");
	}
	
	if (is_null($orm)) {
		if (is_null($this->orm)) {
			throw new UnknowORM("No se ha pasado el ORM al método save()");
		} else {
			$orm = $this->orm;
		}
	}
	if ($this->isAttributeModified("username")) {
		$oUserOcupado = $orm->query("User")
							->attributes("id")
							->filterBy("username", "=",$this->getUsername())
							->filterBy("provider.id", "=", $this->getProvider()->getId())
							->findOne();
		if ($oUserOcupado) {
			throw new UnknowORM("El nombre de usuario ya se encuentra ocupado.");
		}

	}
	if (($this->getId() == null) && ($this->getLoginUnificado())) {
		$this->setForcePasswordChange(false);
	}
	return parent::save($orm);
	
    // Bouml preserved body end 0016D485
  }

  /**
   * Borra f�sicamente un objeto de la base. Al borrarse el objeto adem�s se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relaci�n M:N
   * 
   * @return boolean un booleando TRUE si la operaci�n fue concretada con �xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 0016D685
	/*if ($this->getLoginUnificado()) {
		$login = new CLL_Login();
		$login->setUsername($this->getUsername());
		$answerLogin = CLL_GetLogin($login);
		if ($answerLogin->answer) {
			$answer = CLL_LoginDeleteWebAccesses($login, array(CLL_WEB_APPLICATION_ID));
			if ($answer->answer) {
				return parent::delete();
			} else {
				throw new Exception("No se pudo eliminar el acceso a la plataforma: " . $answer->answer_description);
			}
		} else {
			return parent::delete();
		}
	}*/
	$this->setStatus(User::USER_DISABLED);
	return $this->save();
	//return parent::delete();
    // Bouml preserved body end 0016D685
  }

  /**
   * Busca si un perfil está entre los perfiles asignados al usuario.
   * 
   * @param string $name el nombre del perfil buscado
   * 
   * @return boolean Devuelve true si tiene el perfil o false si no lo tiene.
   */
  public function hasProfile($name)
  {
    // Bouml preserved body begin 001D2005
	foreach($this->getProfiles() as $profile) {/*@var $profile Profile */
		if ($profile->getName() == $name)
			return true;
	}
	return false;
    // Bouml preserved body end 001D2005
  }

}
?>