<?php
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/security/forms/ProviderForm.php';
require_once 'iplan/security/forms/UserForm.php';
require_once 'iplan/security/forms/ProfileForm.php';
require_once 'iplan/security/forms/ActionForm.php';
require_once 'iplan/security/forms/FacadeForm.php';
require_once 'iplan/security/forms/MenuForm.php';
require_once 'iplan/security/forms/UserProfileForm.php';
require_once 'iplan/security/forms/PasswordChange.php';
require_once 'iplan/security/forms/DomainForm.php';
require_once 'iplan/security/forms/MenuLinkForm.php';
require_once 'iplan/security/forms/GlobalForm.php';
require_once 'iplan/security/forms/PasswordRecoveryForm.php';
require_once 'iplan/security/PasswordChangeRequest.php';
require_once 'iplan/security/forms/ProfileGroupForm.php';
require_once 'iplan/security/forms/ManagedUserForm.php';

require_once 'iplan/security/login_unificado/CLL_client_lib.php';

/**
* Author: Jorge Alexis Viqueira
* 
*/
class SecurityManager extends AbstractManager {
  /**
   * Retorna una lista de métodos que pueden ser invocados desde la aplicación.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operación y el valor el nombre del método que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 000AFE85
    return array(
        'defaultPage'=>'defaultPage',
        'login'      => 'login',
        'logout'     => 'logout',
        'mainPage'   => 'mainPage',
        'redirect'   => 'redirect',
        'showErrors' => 'showErrors');
    // Bouml preserved body end 000AFE85
  }

  /**
   * Configura información general para el uso en los templates.
   * 
   * @param ApplicationContext $context el contexto de la aplicación.
   * 
   * @return void 
   */
  public function registerInfo(&$context)
  {
    // Bouml preserved body begin 00162185
	$context->set('Provider', $context->getProvider())
			->set('User', $context->getUser());
    // Bouml preserved body end 00162185
  }

  /**
   * Muesta la home page que se ve sin iniciar sesión
   * @param ApplicationContext $context el contexto donde se solicitó la acción.
   * @return Renderable La página en cuestión
   */
  public function defaultPage(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000AFF05
	$orm = $this->application->getORM();
    $context->set('page_title', 'Bienvenidos clientes de '.$context->getProvider()->getName());
	$profiles = $context->getUser()->getProfiles();
	$atemps = array();
	if ((is_array($profiles)) && (count($profiles) > 0)) {
		foreach($profiles as $profile) {
			if ($profile->getWelcome() != null) {
				//echo $profile->getWelcome();
				$atemps[] = array("profileTempate" => 'profiles_template/' . $profile->getWelcome());

			}

			//$aPerfiles = $orm->query("Profile");
		}
	}
	$context->set('templates_profile', $atemps);
	//for ()
    return new Renderable('welcome.xhtml');
    // Bouml preserved body end 000AFF05
  }

  /**
   * Acción que intenta autenticar un usuario en el sistema o, en caso que se llame sin parámetros, devuelve el formulario de login.
   * @param ApplicationContext $context el contexto donde se solicitó la acción
   * @param boolean $ajax un flag que indica si el llamado requiere una respuesta por AJAX/AJAH
   * @return Renderable Si la autenticación es concretada correctamente retorna un Renderable con la página principal de la aplicación, sino remite de nuevo al login (si hubo error con un mensaje, sino vacio).
   */
  public function login(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000AFF85
	/*@var $context ApplicationContext */
    $app = $this->application;
    //Si están los parámetros valido; sino muestro.
    $username = $context->getParam('username', '', 'PC');
    $password = $context->getParam('password', '', 'PC');
	$context->set("onlineverify", $app->getParam('onlineverify'));
	
    $context->set('username', $username);
    $paramsDefined = ($username != '') && ($password != '');
	
	$lastError=0;
	$form_errors = null;
    if ($paramsDefined) {
        $orm = $app->getORM();
        $user = $orm->query('User')
                ->filterBy('provider.id', '=', $context->getProvider()->getId())
                ->filterBy('username', '=', $username)->findOne();/*@var $user User */
        if ($user) {
			if ($user->getStatus()==User::USER_ACTIVE) {
				if ($user->getLoginUnificado()) {
					$login = new CLL_Login(); //Creo un objeto de Login
					$login->setUsername($username);
					$login->setPassword($password);
					try {
						$userValid = CLL_Authenticate($login); //Pregunto si está autenticado (debería ser una confirmación positiva)
						if ($userValid->answer === true) {
							$webAccess = CLL_GetWebApplicationsByLogin($login);//Listo las aplicaciones (debería traer habilitada la actual)
							$hasPermission = false;
							foreach($webAccess->web_applications as $webApp) {//Busco si tiene mi aplicación en su lista
								if ($webApp->id == CLL_WEB_APPLICATION_ID) {
									$hasPermission = true;
									break;
								}
							}
							if ($hasPermission) {
								
								//Si tiene permiso para la aplicación, pregunto si se deben refrescar permisos
								if ($user->getRefreshLoginUnificado()) {
									
									foreach($user->getProfiles() as $profile) {
										$user->delProfile($profile);
									}
									
									$save = false;
									foreach($context->getProvider()->getFacades() as $facade) {/*@var $facade AbstractManager */
										$manager = $context->getManager($facade->getAlias());
										$save = $save || $manager->newLoginUnificado($context, $user, $userValid);
									}
									
									if ($save) {
										$user->save();
										$_SESSION['uws_user_id']=$user->getId();
										$context->setUser($user);
										$facades = $orm->query('Facade')->filterBy('actions.profiles.users.id', '=', $user->getId())->find();
										if ($facades) {
											foreach($facades as $facade) {
												$context->getManager($facade->getAlias())->registerInfo($context);
											}
										}
										return $this->mainPage($context, $ajax);
									} else {
										$form_errors['messages'][$lastError++]['descriptions']='Sus credenciales son válidas pero no tiene permiso para acceder a las acciones de éste sistema';
										$context->set('errors', $form_errors);
									}
								} else {
									$_SESSION['uws_user_id']=$user->getId();
									$context->setUser($user);
									$facades = $orm->query('Facade')->filterBy('actions.profiles.users.id', '=', $user->getId())->find();
									if ($facades) {
										foreach($facades as $facade) {
											$context->getManager($facade->getAlias())->registerInfo($context);
										}
									}
									return $this->mainPage($context, $ajax);
								} 
							} else {
								$form_errors['messages'][$lastError++]['descriptions']='Sus credenciales son válidas pero no tiene permiso para acceder a las acciones de éste sistema';
								$context->set('errors', $form_errors);
							}
						} else {
							$form_errors['messages'][$lastError++]['descriptions']='El login no es válido';
								$context->set('errors', $form_errors);
						}
					} catch(Exception $e) {
						$form_errors['messages'][$lastError++]['descriptions']='No se pudo conectar con el servio de autenticacion de Login Unificado.';
						$context->set('errors', $form_errors);
					}

				} else {
					if ($user->getPassword()==sha1($password)) {
						$_SESSION['uws_user_id']=$user->getId();
						$context->setUser($user);
						$facades = $orm->query('Facade')->filterBy('actions.profiles.users.id', '=', $user->getId())->find();
						if ($facades) {
							foreach($facades as $facade) {
								$context->getManager($facade->getAlias())->registerInfo($context);
							}
						}
						return $this->mainPage($context, $ajax);
					} else {
						$form_errors['messages'][$lastError++]['descriptions']="Usuario o contraseña incorrectos";
					}
				}
			} else {
				$form_errors['messages'][$lastError++]['descriptions']='Lo sentimos, pero su usuario ha sido deshabilitado. Comuníquese con la administración.';
				$context->set('errors', $form_errors);
			}
		} elseif ($context->getDomain()->getLoginUnificado()) {//Pruebo con login unificado
			$login = new CLL_Login(); //Creo un objeto de Login
			$login->setUsername($username);
			$login->setPassword($password);
			try {
				$userValid = CLL_Authenticate($login); //Pregunto si está autenticado (debería ser una confirmación positiva)
				if ($userValid->answer === true) {
					$webAccess = CLL_GetWebApplicationsByLogin($login);//Listo las aplicaciones (debería traer habilitada la actual)
					$hasPermission = false;
					foreach($webAccess->web_applications as $webApp) {
						if ($webApp->id == CLL_WEB_APPLICATION_ID) {
							$hasPermission = true;
							break;
						}
					}
					if ($hasPermission) {
						$provider = $context->getProvider();/*@var $provider Provider*/
						$user = new User();
						//1) COMPLETAR EL USUARIO
						$user->setUsername($username)
							 ->setProvider($provider)
							 ->setLoginUnificado(true)
							 ->setStatus(User::USER_ACTIVE)
							 ->setName($userValid->login->name)
							 ->setForcePasswordChange(false);
						
						//2) Avisar a los módulos
						$save = false;
						foreach($provider->getFacades() as $facade) {/*@var $facade AbstractManager */
							$manager = $context->getManager($facade->getAlias());
							$save = $save || $manager->newLoginUnificado($context, $user, $userValid);
						}
						//3) Guardar si corresponde
						if ($save) {

							$user->addProfile($orm->query('Profile')
									->filterBy('name', '=', 'Usuarios Registrados - iPlan')
									->filterBy('provider.id', '=', $context->getProvider()->getId())
									->findOne());
							
							$orm->save($user);
							
							$query = $orm->query('Client')
										->filterBy('clientNumber', '=', (int)$context->getManager('Application')->cgpToClient($username));
							$client = $query->findOne();
							/* @var $client Client*/
							if ($client) {
								$client->setUser($user);
								$orm->save($client);
							}
							
							$_SESSION['uws_user_id']=$user->getId();
							$context->setUser($user);
							$facades = $orm->query('Facade')->filterBy('actions.profiles.users.id', '=', $user->getId())->find();
							if ($facades) {
								foreach($facades as $facade) {
									$context->getManager($facade->getAlias())->registerInfo($context);
								}
							}
							return $this->mainPage($context, $ajax);
						} else {
							$form_errors['messages'][$lastError++]['descriptions']='Sus credenciales son válidas pero no tiene permiso para acceder a las acciones de éste sistema';
						}
					} else {
						$form_errors['messages'][$lastError++]['descriptions']='Sus credenciales son válidas pero no tiene permiso para acceder a ésta aplicación';
					}
				} else {
					$form_errors['messages'][$lastError++]['descriptions']='Los datos ingresados no son correctos';
				}
			} catch (Exception $e) {
				$form_errors['messages'][$lastError++]['descriptions']='El usuario no existe en la plataforma y no se puede acceder a Login Unificado';
//				$form_errors['messages'][$lastError++]['descriptions']=$e->getMessage();
			}
		}
        $form_errors['title']='Error en la verificación de identidad';
		$context->set('errors', $form_errors);
    } else {
		if ($app->getParam('try', '', 'P')==1) {
			$form_errors['title']='Error al intentar ingresar al sitio';
			if ($username == '') {
				$form_errors['messages'][$lastError]['descriptions']='Debe ingresar un nombre de usuario';
				$form_errors['messages'][$lastError++]['field']='Usuario';
			}
			if ($password == '') {
				$form_errors['messages'][$lastError]['descriptions']='Debe ingresar una clave';
				$form_errors['messages'][$lastError++]['field']='Clave';
			}
			$context->set('errors', $form_errors);
		}
    }
    return new Renderable('login.xhtml');
    // Bouml preserved body end 000AFF85
  }

  /**
   * Termina la sesión y vuelve a la defaultPage.
   * @param ApplicationContext $context el contexto donde se solicitó la acción.
   * @return Renderable La home page que corresponde cuando no se inició sesión.
   */
  public function logout(&$context, &$ajax = false)
  {
    // Bouml preserved body begin 000B0085
    $this->application->reset($context->getProvider()->getId());
	$ajax = false;
    return $this->defaultPage($context, $ajax);
    // Bouml preserved body end 000B0085
  }

  /**
   * Retorna la p�gina principal.
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\Renderable El objeto que permite mostrar la p�gina principal.
   */
  public function mainPage(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000B0005
	if ($context->getUser()->getForcePasswordChange()) {
		return $this->savePassword($context, $ajax);
	} else {
		return $this->defaultPage($context, $ajax);
	}
    //return new Renderable('main.xhtml');
    // Bouml preserved body end 000B0005
  }

  /**
   * Redirige a una p�gina pasada por GET como "url".
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\Renderable El objeto que permite mostrar la p�gina principal.
   */
  public function redirect(&$context, $ajax)
  {
    // Bouml preserved body begin 000BB605
//    header('HTTP/1.1 303 See Other');
    header('Location: '.$context->getParam('params', $context->getParam(0, null)));
//    flush();
//    header("Connection: close");
    exit;
    return false;
    // Bouml preserved body end 000BB605
  }

  /**
   * Devuelve el listado de proveedores.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listProviders(&$context, $ajax)
  {
    // Bouml preserved body begin 0010DB85
	$orm = $this->application->getORM();
	
	//Formulario de filtrado:
	$oLayout1 = new GridLayout(1, 2);
	$oLayout1->addComponent(new TextComponent(array('label'=>'Nombre', 'name'=>'flt_name', 'maps'=>array('name', 'owner.name'),'size'=>20)), 1, 1)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Security.listProviders")
			->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
	        ->loadValues();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn(new Column('Nombre', 'name', true))
			->addColumn(new Column('Tamaño de Fetch', 'maxFetchRows'))
			->addColumn(new Column('Propietario', 'owner.name'))
			->addColumn(new Column('Dominios', 'baseURL'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Security.modifyProvider', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Security.deleteProvider', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Security.addProvider', null, null, 'inline-popup', 'list'))
			->addAction(new ActionButton($context, 'Security.exportProvidersCsv', $oFilter->toURL(), null, 'inline', 'none'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (SecurityManager &$manager, WebList &$oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('Provider')
			      ->attributes('id', 'name', 'maxFetchRows', 'owner.name')
				  ->startGroup()
					  ->filterBy('owner', '=', $context->getProvider()->getId(), null, 'OR')
					  ->filterBy('id', '=', $context->getProvider()->getId(), null, 'OR')
				  ->endGroup()
				  ->dontWorryAbout('owner');

			$oWebList->applyFilter($query)
					 ->limitQuery($query);
			$mainResult = $query->find();
			if (is_array($mainResult) && (count($mainResult) >= 1)) {
				function merge_and_group(&$main, &$ids, &$orm) {
					if (isset($ids) && count($ids)>0) {
						$query2 = $orm->query('Domain')
								->filterBy('provider.id', 'IN', $ids)
							    ->attributes('provider.id', 'id as domainId', 'baseURL')
							    ->orderBy('provider.id', 'baseURL');
						$secondaryResult = $query2->find();
						Utils::merge($main, array('id'=>'provider.id'), $secondaryResult);
					}
				}
				for($i=0; $i<count($mainResult);$i++) {
					$ids[]=$mainResult[$i]['id'];
					if (count($ids)==20) {
						merge_and_group($mainResult, $ids, $orm);
						$ids = null;
					}
				}
				merge_and_group($mainResult, $ids, $orm);
			}

			return $mainResult;
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0010DB85
  }

  /**
   * Guarda/Crea/Borra un Provider.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function saveProvider(&$context, $ajax)
  {
    // Bouml preserved body begin 0010DC05
	$orm = $this->application->getORM();
	$oForm1 = new ProviderForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0010DC05
  }

  /**
   * Lista los usuarios del sistema.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listUsers(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6C05
    $orm = $this->application->getORM();
	$profileOptions = $orm->query('Profile')
                      ->filterBy('provider.id', '=', $context->getProvider()->getId())
                      ->attributes('id AS value', 'name AS description')
					  ->orderBy('name')
                      ->find();

	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider.id');
	$securityManager = $context->getManager('Security');
	$selProvider->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));

	$compNombre = new TextComponent('Nombre o Apellido', 'flt_nombre', array('name', 'surname'));
	$compNombre->setSize("20");

	$compUsuario = new TextComponent('Usuario', 'flt_username', 'username');
	$compUsuario->setSize("20");
	
	$compMail = new TextComponent('Email', 'flt_mail', 'mail');
	$compMail->setSize("20");
	
	$selEstado = new SelectComponent('Estado', 'flt_status', 'status');
	$selEstado->setOptions(	array(
								array('value' => User::USER_ACTIVE, 'description' => "Activo"),
								array('value' => User::USER_DISABLED, 'description' => "Inactivo")
								)
							);
	
	$compPerfiles = new SelectComponent('Perfiles', 'profiles', 'profiles.id');
	$compPerfiles->setOptions($profileOptions);

	$selProvider->addEvent(Component::EVENT_CHANGE, function(ApplicationContext $context, Form $form, ORM $orm) {
														$provider = $context->getParam('provider_id');
														$profileOptions = $orm->query('Profile')
																  ->attributes('id AS value', 'name AS description')
																  ->orderBy('name')
																  ->filterBy('provider.id', '=', (!is_null($provider) && ($provider != ''))?$provider:$context->getProvider()->getId())
																  ->find();
														$profiles = $form->getComponent('profiles');
														$profiles->setOptions($profileOptions);
														$form->updated('profiles');
													 }, $orm);

	$oLayout1 = new GridLayout(2, 4);
	$oLayout1->addComponent($compUsuario, 1, 1)
			 ->addComponent($compNombre, 1, 2)
			 ->addComponent($compMail, 1, 3)
			 ->addComponent($selProvider, 2, 1)
			 ->addComponent($compPerfiles, 2, 2)
			 ->addComponent($selEstado, 2, 3)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4, 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Security.listUsers")
			->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();

	$perfiles = new Column('Perfiles', 'profiles.name', true, null, true, 'Security.modifyProfile');
	$perfiles->setMode('inline-popup')
			 ->setParams(array('id'=>'profiles.id'));
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, false, null, null, true))
			->addColumn(new Column('Apellido, Nombre', array('name', 'surname'), true, "{{surname}}{{ surname and name ? ', ' : '' }}{{name}}"))
			->addColumn(new Column('Usuario', 'username', true))
			->addColumn(new Column("Email", "mail"))
			->addColumn(new Column('Proveedor', 'provider.name'))
			->addColumn(new Column('LoginUnificado', 'loginUnificado', false,"{{ (loginUnificado)?'Usa':'No Usa' }}"))
			->addColumn(new Column('Estado', 'status', false, "{{ status == " . User::USER_DISABLED . " ? 'Inactivo' : 'Activo' }}"))
			->addColumn($perfiles)
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Security.modifyUser', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Security.modifyUserProfiles', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Security.deleteUser', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Security.addUser', null, null, 'inline-popup', 'list'))
			->addAction(new ActionButton($context, 'Security.exportUsersCsv', $oFilter->toURL(), null, 'inline', 'none'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco usuarios
			$query = $orm->query('User')
						 ->filterBy('provider.id', 'IN', $manager->getOwnedProvidersIds($context->getProvider(), true),NULL, 'AND')
						 ->attributes('id', 'name', 'surname', 'username', 'provider.name', 'loginUnificado', 'mail', 'status');	
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			$mainResult = $query->find();
			//Si todo anduvo bien, complemento la información.
			if (is_array($mainResult) && (count($mainResult) >= 1)) {
				for($i=0; $i<count($mainResult);$i++)
					$ids[]=$mainResult[$i]['id'];
				if (isset($ids)) {
					$query2 = $orm->query('Profile');
					$query2->filterBy('users.id','IN', $ids)
						   ->filterBy('provider.id', 'IN', $manager->getOwnedProvidersIds($context->getProvider(), true),NULL, 'AND')
						   ->attributes('users.id', 'id', 'name' )
						   ->orderBy('users.id', 'name');
					if ($providerId = $oWebList->getValueOf('provider_id')) {
						$query2->filterBy('provider.id', '=', $providerId);
					}
					$secondaryResult = $query2->find();
				}
				Utils::merge($mainResult, array('id'=>'users.id'), $secondaryResult, array('name'=>'profiles.name', 'id'=>'profiles.id'));
			}
			return $mainResult;
		}
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 000C6C05
  }

  /**
   * Agrega un usuario al sistema, bajo el dominio del provider o presenta un formulario para dar de alta un usuario nuevo.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveUser(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6C85
    $orm = $this->application->getORM();
	$userForm = new UserForm($orm, $context);
	return $userForm->deploy($context, $orm);
    // Bouml preserved body end 000C6C85
  }

  /**
   * Configura los perfiles a los que tiene acceso un usuario, bajo el dominio del provider configurado.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveUserProfiles(&$context, $ajax)
  {
    // Bouml preserved body begin 00154185
    $orm = $this->application->getORM();
	$userProfileForm = new UserProfileForm($orm, $context);
	return $userProfileForm->deploy($context, $orm);
    // Bouml preserved body end 00154185
  }

  /**
   * Lista los perfiles relacionados al provider.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listProfiles(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6E05
	$orm = $this->application->getORM();

	//Preparo el filtro
	$compNombre = new TextComponent('Nombre', 'flt_name', 'name');
	$compNombre->setMaxlength("10")
               ->setSize("20");
	
	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider.id');
	$securityManager = $context->getManager('Security');
	$selProvider->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));
	
	$oLayout1 = new GridLayout(1, 3);
	$oLayout1->addComponent($compNombre, 1, 1)
			 ->addComponent($selProvider, 1, 2)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Security.listProfiles")
			->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();

	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn(new Column('Nombre', 'name', true))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Welcome Template', 'welcome'))
			->addColumn(new Column('Manual', 'manual'))
			->addColumn(new Column('Provider', 'provider.name'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Security.modifyProfile', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Security.deleteProfile', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Security.addProfile', null, null, 'inline-popup', 'list'))
			->addAction(new ActionButton($context, 'Security.exportProfilesCsv', $oFilter->toURL(), null, 'inline', 'none'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('Profile');
			$query->filterBy('provider.id', 'IN', $manager->getOwnedProvidersIds($context->getProvider(), true), NULL, 'AND')
				  ->attributes('id', 'name', 'description', 'welcome', 'provider.name', 'manual');

			$oWebList->applyFilter($query)
					 ->limitQuery($query);
			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 000C6E05
  }

  /**
   * Guarda o modifica el perfil indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveProfile(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6E85
	$orm = $this->application->getORM();
	$profileForm = new ProfileForm($orm, $context);	
	return $profileForm->deploy($context, $orm);
    // Bouml preserved body end 000C6E85
  }

  /**
   * Lista las acciones disponibles para el provider.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listActions(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6F85
	$orm = $this->application->getORM();
	
	$facadeOptions = $orm->query('Facade')
						 ->attributes('id AS value', 'alias AS description')
						 ->filterBy('providers.id', '=', $context->getProvider()->getId())
						 ->find();
	
	$compNombre = new TextComponent('Nombre', 'flt_name', 'name');
	$compNombre->setSize("20");
	$compDescription = new TextComponent('Descripción', 'flt_description', 'description');
	$compDescription->setSize("20");
	$compAlias = new TextComponent('Alias', 'flt_alias', 'alias');
	$compAlias->setSize("20");
	$compUrlCode = new TextComponent('Url code', 'flt_urlCode', 'urlCode');
	$compUrlCode->setSize("20");
	$compFacade = new SelectComponent('Pertenece a', 'flt_facade','facade.id');
	
	$compMethod = new TextComponent('Method', 'flt_method', 'method');
	$compMethod->setSize("20");

	$compFacade->setOptions($facadeOptions);
	$oLayout1 = new GridLayout(2, 4);
	$oLayout1->addComponent($compNombre, 1, 1)
			 ->addComponent($compUrlCode, 1, 2)
			 ->addComponent($compAlias, 1, 3)
			 ->addComponent($compDescription, 2, 1)
			 ->addComponent($compFacade, 2, 2)
			->addComponent($compMethod, 2, 3)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4, 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
            ->setAction("Security.listActions")
            ->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
	        ->loadValues();

	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn(new Column('Nombre', array('name', 'icon'), true, '<span class="icon32 {{icon?icon:"blank"}}32"/> {{name}}'))
			->addColumn(new Column('Alias', 'alias', true))
			->addColumn(new Column('Módulo', 'facade.alias', true))
			->addColumn(new Column('urlCode', 'urlCode', true))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Method', 'method', true))
			->addColumn(new Column('Hint', 'hint'))
			->addColumn(new Column('Parámetros', 'params'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Security.modifyAction', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Security.deleteAction', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Security.addAction', null, null, 'inline-popup', 'list'))
			->addAction(new ActionButton($context, 'Security.exportActionsCsv', $oFilter->toURL(), null, 'inline-popup', 'none'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('Action');
			$query->filterBy('facade.providers.id', '=', $context->getProvider()->getId());
			$query->attributes('id', 'name', 'icon', 'alias', 'facade.alias', 'description', 'method', 'params', 'urlCode', 'hint');
			$oWebList->applyFilter($query)
					 ->limitQuery($query);
			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 000C6F85
  }

  /**
   * Crea o guarda la acci�n indicada
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveAction(&$context, $ajax)
  {
    // Bouml preserved body begin 000C7005
    $orm = $this->application->getORM();
	$actionForm = new ActionForm($orm, $context);
	return $actionForm->deploy($context, $orm);
    // Bouml preserved body end 000C7005
  }

  /**
   * Lista los menues disponibles para el provider.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listMenus(&$context, $ajax)
  {
    // Bouml preserved body begin 0013DA05
	/**
	* Modifica el arreglo para que se vea nas lindo el combo de menu: "name" ("parent_name")
	* 
	* @param array $aMenues Un arreglo con la lista de menues que se quiere modificar.
	*/
	function parentMenu(&$aMenues, $name = "description", $parent_name = "parentName") {
		if (is_array($aMenues) && (count($aMenues) > 0)) {
			foreach ($aMenues as $key => $menu) {
				if ($menu[$parent_name]) {
					$aMenues[$key][$name] = $menu[$name] . " (" . $menu[$parent_name] . ")";
					unset($aMenues[$key][$parent_name]);
				}
			}
		}
	}
	  
	$orm = $this->application->getORM();
	
	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider.id');
	$securityManager = $context->getManager('Security');
	$selProvider->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Nombre', 'name', true))
			->addColumn(new Column('Provider', 'provider.name', true))
			->addColumn(new Column('Ícono', 'icon', false, '<span class="icon16 {{icon|default("blank")}}16"></span> {{icon}}'))
			->addColumn(new Column('Ícono de Acción', 'actionIcon', false, '<span class="icon32 {{actionIcon|default("blank")}}32"></span> {{actionIcon}}'))
			->addColumn(new Column('Acción', array('facadeAlias', 'actionAlias'), false, "{{ facadeAlias ? facadeAlias ~ '.':''}}{{ actionAlias }}"))
			->addColumn(new Column('Parámetros', 'params'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'Security.modifyMenu', 'id'),
									new ActionButton($context, 'Security.deleteMenu', 'id', null, 'alert inline'),
									new ActionButton($context, 'Security.modifyAction', array('id'=>'actionId'))
								)))
			->addAction(new ActionButton($context, 'Security.addMenu'))
			->setListFunction(
					function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Menu')
									 ->attributes('id', 'name', 'params','icon', 'action.id as actionId', 'action.icon as actionIcon', 
												  'action.facade.alias AS facadeAlias', 'action.alias as actionAlias', 'provider.name')
									 ->filterBy('provider.id', 'IN', $manager->getOwnedProvidersIds($context->getProvider(), true),NULL, 'AND')
									 ->dontWorryAbout('action', 'action.facade');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							$mainResult = $query->find();
							for($i=0; $i<count($mainResult);$i++)
								$ids[]=$mainResult[$i]['id'];
							$secondaryResult = array();
							if (isset($ids)) {
								$query2 = $orm->query("MenuLink")
												->attributes("menu.id as menuId", "domain.baseURL as baseURL", "parent.menu.name as parentName")
												->filterBy("menu.id", "IN", $ids);
								$secondaryResult = $query2->find();
								parentMenu($secondaryResult, "parentName", "baseURL");
							}
							Utils::merge($mainResult, array('id'=>'menuId'), $secondaryResult);
							return $mainResult;
					  });

	$layout = new GridLayout(2, 6);
	$layout->addComponent(new TextComponent('Menu', 'name', 'name'), 1, 1)
		   ->addComponent(new TextComponent('Facade', 'FName', 'action.facade.alias'), 1, 2)
		   ->addComponent(new TextComponent('Acción','AName', 'action.name') , 1, 3)
		   ->addComponent($selProvider, 1, 4)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 5)
		   ->addComponent(new HiddenComponent(null, 'id', 'id'), 2, 1);
    $filter = new Form();
	$filter->setMethod('post')
		   ->setAction('Security.listMenus')
		   ->setTitle('Lista de Menues')
		   ->addComponent($layout);
	
	$webList->setFilter($filter);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0013DA05
  }

  /**
   * Crea o guarda el men� indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveMenu(&$context, $ajax)
  {
    // Bouml preserved body begin 0013DA85
    $orm = $this->application->getORM();
	$formMenu = new MenuForm($orm, $context);
	return $formMenu->deploy($context, $orm);
    // Bouml preserved body end 0013DA85
  }

  /**
   * Lista los Facades o M�dulos habilitados para el provider.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listFacades(&$context, $ajax)
  {
    // Bouml preserved body begin 0013DB05
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Alias', 'alias'))
			->addColumn(new Column('Clase', 'class'))
			->addColumn(new Column('Archivo', 'file'))
			->addColumn(new Column('Acciones' , null, false, null, false, null, array(
									new ActionButton($context, 'Security.modifyFacade', 'id'),
									new ActionButton($context, 'Security.deleteFacade', 'id', null, 'alert inline')
								)))
			->addAction(new ActionButton($context, 'Security.addFacade'))
			->setListFunction(
					function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Facade')
									 ->attributes('id', 'alias', 'class','file');
							if (!$context->getManager('Security')->isMaster()) {
								$query->filterBy('providers.id', '=', $context->getProvider()->getId());
							}
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  });

	$filePath = new TextComponent('Archivo', 'file', 'file');
	$filePath->setSize(50);
	$layout = new GridLayout(1, 4);
	$layout->addComponent(new TextComponent('Alias de la Clase', 'alias', 'alias'), 1, 1)
		   ->addComponent(new TextComponent('Nombre de la Clase', 'class', 'class'), 1, 2)
		   ->addComponent($filePath , 1, 3)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4);
    $filter = new Form();
	$filter->setMethod('post')
		   ->setAction('Security.listFacades')
		   ->setTitle('Lista de Facades')
		   ->addComponent($layout);
	
	$webList->setFilter($filter);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0013DB05
  }

  /**
   * Crea o guarda un Facade nuevo
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveFacade(&$context, $ajax)
  {
    // Bouml preserved body begin 0013DB85
    $orm = $this->application->getORM();
	$formFacade = new FacadeForm($orm, $context);
	return $formFacade->deploy($context, $orm);
    // Bouml preserved body end 0013DB85
  }

  /**
   * Lista los dominios que un provider tiene registrados.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listDomains(&$context, $ajax)
  {
    // Bouml preserved body begin 0019E385
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Dominio', 'baseURL'))
			->addColumn(new Column('Alias', 'alias'))
			->addColumn(new Column('Paginado', 'pageRows'))
			->addColumn(new Column('LoginUnificado', 'loginUnificado', false,"{{ (loginUnificado)?'Usa':'No Usa' }}"))
			->addColumn(new Column('Acciones' , null, false, null, false, null, array(
									new ActionButton($context, 'Security.modDomain', 'id'),
									new ActionButton($context, 'Security.deleteDomain', 'id', null, 'alert inline')
								)))
			->addAction(new ActionButton($context, 'Security.addDomain'))
			->setListFunction(
					function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Domain')
									 ->attributes('id', 'baseURL', 'alias', 'pageRows','loginUnificado')
									 ->startGroup()
									 ->filterBy('provider.id', '=', $context->getProvider()->getId(), null, 'OR')
									 ->filterBy('provider.owner', '=', $context->getProvider()->getId(), null, 'OR')
									;
							/*if (!$context->getManager('Security')->isMaster()) {
								$query->filterBy('provider.id', '=', $context->getProvider()->getId());
							}*///Para ver... la posibilidad de crear nuevos master está, pero un master no puede modificar lo de otro master.
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  });
	$layout = new GridLayout(1, 3);
	$layout->addComponent(new TextComponent('Dominio', 'baseURL', 'baseURL'), 1, 1)
		   ->addComponent(new TextComponent('Alias', 'alias', 'alias'), 1, 2)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
    $filter = new Form();
	$filter->setMethod('post')
		   ->setAction('Security.listDomains')
		   ->setTitle('Listado de Dominios')
		   ->addComponent($layout);
	
	$webList->setFilter($filter);
	
	return $webList->deploy($context, $orm);

    // Bouml preserved body end 0019E385
  }

  /**
   * Crea o guarda un Dominio para el provider actual
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pantalla a visualizar al usuario
   */
  public function saveDomain(&$context, $ajax)
  {
    // Bouml preserved body begin 0019E405
	$orm = $this->application->getORM();
	$domainForm = new DomainForm($orm, $context);
	return $domainForm->deploy($context, $orm);
    // Bouml preserved body end 0019E405
  }

  /**
   * Lista los Facades o M�dulos habilitados para el provider.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listMenuLinks(&$context, $ajax)
  {
    // Bouml preserved body begin 0019FF05
	$orm = $this->application->getORM();
	

	$webList = new WebList($this);
	$webList->addColumn(new Column('Dominio', 'domain.baseURL', true))
			->addColumn(new Column('Nombre', 'menu.name', true))
			->addColumn(new Column('Orden', 'order', true))
			->addColumn(new Column('Padre', 'parent.menu.name', true))
			->addColumn(new Column('Ícono', 'menuIcon', false, '<span class="icon16 {{icon|default("blank")}}16"></span> {{icon}}'))
			->addColumn(new Column('Ícono de Acción', 'actionIcon', false, '<span class="icon32 {{actionIcon|default("blank")}}32"></span> {{actionIcon}}'))
			->addColumn(new Column('CSS', 'cssClass', false))
			->addColumn(new Column('Acción', array('facadeAlias', 'actionAlias'), false, "{{ facadeAlias ? facadeAlias ~ '.':''}}{{ actionAlias }}"))
			->addColumn(new Column('Parámetros', 'menu.params', false))
			->addColumn(new Column('Acciones', 'menuProvider', false, '', false, null, array(
									new ActionButton($context, 'Security.modifyMenuLink', 'id', null, null, null, '{{menuProvider=='.$context->getProvider()->getId().'}}'),
									new ActionButton($context, 'Security.deleteMenuLink', 'id', null, 'alert inline'),
									new ActionButton($context, 'Security.listMenus', array('id'=>'menu.id'),'menubar_go')
								)))
			->addAction(new ActionButton($context, 'Security.addMenuLink'))
			->setListFunction(
					function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('MenuLink')
									 ->attributes('id', 'order', 'menu.id', 'menu.name', 'menu.params','parent','parent.menu.name', 'domain.baseURL',
												  'menu.icon as menuIcon', 'menu.action.icon as actionIcon', 'menu.action.facade.alias as facadeAlias',
												  'menu.action.alias as actionAlias', 'cssClass', 'menu.provider.id as menuProvider')
									 ->filterBy('menu.provider.id', 'IN', $manager->getOwnedProvidersIds($context->getProvider(), true),NULL, 'AND')
									 ->dontWorryAbout('parent', 'parent.menu', 'menu.action', 'menu.action.facade')
									 ;
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  });

	$selProvider = new SelectComponent('Provider', 'provider_id', 'menu.provider.id');
	$selProvider->setOptions($this->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));
	
	$layout = new GridLayout(2, 6);
	$layout->addComponent(new TextComponent('Menu', 'name', 'menu.name'), 1, 1)
		   ->addComponent(new TextComponent('Padre', 'pName', 'parent.menu.name'), 1, 2)
		   ->addComponent(new TextComponent('Facade', 'FName', 'menu.action.facade.alias'), 1, 3)
		   ->addComponent(new TextComponent('Acción','AName', 'menu.action.name') , 1, 4)
		   ->addComponent($selProvider, 2, 1)
		   ->addComponent(new SelectComponent(array('label'=>'Dominio', 'name'=>'domain', 'maps'=>'domain.id',
													'options'=>$orm->query('Domain')
																   ->filterBy('provider', 'IN', $this->getOwnedProvidersIds($context->getProvider()))
																   ->attributes('id as value', 'baseURL as description')
																   ->find())) , 2, 2)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 5)
		   ;
    $filter = new Form();
	$filter->setMethod('post')
		   ->setAction('Security.listMenuLinks')
		   ->setTitle('Lista de Menues')
		   ->addComponent($layout);
	
	$selProvider->addEvent(Component::EVENT_CHANGE, function(ApplicationContext $cont, Form $form, $orm) {
		$selDomain = $form->getComponent('domain');/*@var $selDomain SelectComponent*/
		$securityManager = $cont->getManager('Security');
		$query=$orm->query('Domain')
				   ->filterBy('provider', 'IN', $securityManager->getOwnedProvidersIds($cont->getProvider()))
				   ->attributes('id as value', 'baseURL as description');
		if (($selectedProvider = $form->getValueOf('provider_id')))
			$query->filterBy('provider', '=', $selectedProvider);
		$selDomain->setOptions($query->find());
		$form->updated('domain');
	}, $orm);
	$webList->setFilter($filter);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0019FF05
  }

  /**
   * Crea o guarda un Dominio para el provider actual
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pantalla a visualizar al usuario
   */
  public function saveMenuLink(&$context, $ajax)
  {
    // Bouml preserved body begin 0019FF85
    $orm = $this->application->getORM();
	$formMenuLink = new MenuLinkForm($orm, $context);
	return $formMenuLink->deploy($context, $orm);
    // Bouml preserved body end 0019FF85
  }

  /**
   * Muestra los datos globales registrados por la aplicación, los facades y módulos
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listGlobals(&$context, $ajax)
  {
    // Bouml preserved body begin 001C6F05
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Nombre', 'name'))
			->addColumn(new Column('Valor', 'value'))
			->addColumn(new Column('Provider', 'provider.name'))
			->addColumn(new Column('Domain', 'domain.baseURL'))
			->addColumn(new Column('Facade', 'facade.alias'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'Security.modifyGlobalData', 'id'),
				new ActionButton($context, 'Security.deleteGlobalData', 'id', null, 'alert inline'),
			)))
			->setListFunction(function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('GlobalData')
										 ->attributes('id', 'name', 'value', 'provider.name', 'domain.baseURL', 'facade.alias')
										 ->dontWorryAbout("domain", "provider", "facade")
										 /*->filterBy('provider.id', '=', $context->getProvider()->getId())*/
									;
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							$res = $query->find();
							return $res;
					  })
			->addAction(new ActionButton($context, 'Security.addGlobalData'))
			;
	
	$layout = new GridLayout(1, 6);
	$layout->addComponent(new TextComponent(array("label" => "Nombre", "maps" => "name")), 1, 1)
			->addComponent(new TextComponent(array("label" => "Valor", "maps" => "value")), 1, 2)
			->addComponent(new SelectComponent(array('label'=>'Provider', 'name'=>'provider_id', 'maps'=>'provider.id',
										  'options'=>$orm->query('Provider')->attributes('id as value', 'name as description')->find())), 1, 3)
			->addComponent(new SelectComponent(array('label'=>'Domain', 'name'=>'domain_id', 'maps'=>'domain.id',
										  'options'=>$orm->query('Domain')->attributes('id as value', 'baseURL as description')->find())), 1, 4)
			->addComponent(new SelectComponent(array('label'=>'Facade', 'name'=>'facade_id', 'maps'=>'facade.id',
										  'options'=>$orm->query('Facade')->attributes('id as value', 'alias as description')->find())), 1, 5)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 6);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de datos Globales')
		 ->setAction('Security.listGlobalData');
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001C6F05
  }

  /**
   * Edita o crea un global de sistema, facade o módulo.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function saveGlobal(&$context, $ajax)
  {
    // Bouml preserved body begin 001C6F85
	$orm = $this->application->getORM();
	$formGlobal = new GlobalForm($orm, $context);
	return $formGlobal->deploy($context, $orm);
    // Bouml preserved body end 001C6F85
  }

  /**
   * Lista los grupos de perfiles del sistema
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listProfileGroups(&$context, $ajax)
  {
    // Bouml preserved body begin 001D5A85
	$orm = $this->application->getORM();

	//Preparo el filtro
	$compNombre = new TextComponent('Nombre', 'flt_name', 'name');
	$compNombre->setMaxlength("10")
               ->setSize("20");
	
	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider.id');
	$securityManager = $context->getManager('Security');
	$selProvider->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));
	
	$oLayout1 = new GridLayout(1, 3);
	$oLayout1->addComponent($compNombre, 1, 1)
			 ->addComponent($selProvider, 1, 2)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Security.listProfileGroups")
			->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();

	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn(new Column('Nombre', 'name', true))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Admin. Grupo', 'adminProfile.name'))
			->addColumn(new Column('Provider', 'provider.name'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Security.modifyProfileGroup', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Security.deleteProfileGroup', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Security.addProfileGroup', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('ProfileGroup');
			$query->filterBy('provider.id', 'IN', $manager->getOwnedProvidersIds($context->getProvider(), true), NULL, 'AND')
				  ->attributes('id', 'name', 'description', 'adminProfile.name', 'provider.name');

			$oWebList->applyFilter($query)
					 ->limitQuery($query);
			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001D5A85
  }

  /**
   * Crea, edita o borra un ProfileGroup determinado
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function saveProfileGroup(&$context, $ajax)
  {
    // Bouml preserved body begin 001D5B05
	$orm = $this->application->getORM();
	$oForm = new ProfileGroupForm($orm, $context);
	return $oForm->deploy($context, $orm);
    // Bouml preserved body end 001D5B05
  }

  /**
   * Lista los usuarios creados a través de la customización de perfiles en ProfileGrops.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listManagedUsers(&$context, $ajax)
  {
    // Bouml preserved body begin 001D7585
	$orm = $this->application->getORM();
	
	$aIdProfiles = array();
	$aPerfiles = $context->getUser()->getProfiles();
	if (is_a($aPerfiles, 'ORMCollection') && count($aPerfiles) > 0) {
		foreach ($aPerfiles as $perfil) {
			$aIdProfiles[] = $perfil->getId();
		}
	}
	
	$profileOptions = $orm->query("Profile")
								->filterBy("profileGroups.adminProfile.id", "IN", $aIdProfiles)
								->attributes('id AS value', 'name AS description')
								->orderBy('name')
			                    ->find();
	
	$selProvider = new SelectComponent('Provider', 'provider_id', 'provider.id');
	$securityManager = $context->getManager('Security');
	$selProvider->setOptions($securityManager->getOwnedProviders($context->getProvider(), array('id as value', 'name as description'), true));

	$compNombre = new TextComponent('Nombre o Apellido', 'flt_nombre', array('name', 'surname'));
	$compNombre->setSize("20");

	$compUsuario = new TextComponent('Usuario', 'flt_username', 'username');
	$compUsuario->setSize("20");
	
	$compMail = new TextComponent('Email', 'flt_mail', 'mail');
	$compMail->setSize("20");
	
	$selEstado = new SelectComponent('Estado', 'flt_status', 'status');
	$selEstado->setOptions(	array(
								array('value' => User::USER_ACTIVE, 'description' => "Activo"),
								array('value' => User::USER_DISABLED, 'description' => "Inactivo")
								)
							);
	
	$compPerfiles = new MultiselectComponent('Perfiles', 'profiles', 'profiles.id');
	$compPerfiles->setOptions($profileOptions)->setOptional(false);

	$selProvider->addEvent(Component::EVENT_CHANGE, function(ApplicationContext $context, Form $form, ORM $orm) {
														$provider = $context->getParam('provider_id');
														$profileOptions = $orm->query('Profile')
																  ->attributes('id AS value', 'name AS description')
																  ->orderBy('name')
																  ->filterBy('provider.id', '=', (!is_null($provider) && ($provider != ''))?$provider:$context->getProvider()->getId())
																  ->find();
														$profiles = $form->getComponent('profiles');
														$profiles->setOptions($profileOptions);
														$form->updated('profiles');
													 }, $orm);
													 
	$chkOtros = new CheckboxComponent("Ver todos los usuarios", "otros");
	$chkOtros->setValue("1");
	
	$oLayout1 = new GridLayout(2, 5);
	$oLayout1->addComponent($compUsuario, 1, 1)
			 ->addComponent($compNombre, 1, 2)
			 ->addComponent($compMail, 1, 3)
			 ->addComponent($selProvider, 2, 1)
			 ->addComponent($chkOtros, 2, 2)
			 ->addComponent($compPerfiles, 1, 4, 1, 2)
			 ->addComponent($selEstado, 2, 3)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 5, 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Security.listManagedUsers")
			->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();

	$perfiles = new Column('Perfiles', 'profiles.name', true, null, true, 'Security.modifyProfile');
	$perfiles->setMode('inline-popup')
			 ->setParams(array('id'=>'profiles.id'));
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, false, null, null, true))
			->addColumn(new Column('Apellido, Nombre', array('name', 'surname'), true, "{{surname}}{{ surname and name ? ', ' : '' }}{{name}}"))
			->addColumn(new Column('Usuario', 'username', true))
			->addColumn(new Column("Email", "mail"))
			->addColumn(new Column('Proveedor', 'provider.name'))
			->addColumn(new Column('LoginUnificado', 'loginUnificado', false,"{{ (loginUnificado)?'Usa':'No Usa' }}"))
			->addColumn(new Column('Estado', 'status', false, "{{ status == " . User::USER_DISABLED . " ? 'Inactivo' : 'Activo' }}"))
			->addColumn($perfiles)
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Security.modifyManagedUser', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Security.deleteManagedUser', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Security.addManagedUser', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco Perfiles que administra
			$aIdProfiles = array();
			$aPerfiles = $context->getUser()->getProfiles();
			if (is_a($aPerfiles, 'ORMCollection') && count($aPerfiles) > 0) {
				foreach ($aPerfiles as $perfil) {
					$aIdProfiles[] = $perfil->getId();
				}
			}
			$otros = $context->getParam("otros", null);
			//Busco usuarios
			$query = $orm->query('User')
						 ->filterBy('provider.id', 'IN', $manager->getOwnedProvidersIds($context->getProvider(), true),NULL, 'AND')
						 
						 
						 ->distinct()
						 ->attributes('id', 'name', 'surname', 'username', 'provider.name', 'loginUnificado', 'mail', 'status');
			
			$cPerfilUsuarioRegistrado = "Usuarios Registrados - iPlan";
			$oPerfilUsuarioRegistrado = $orm->query("Profile")->filterBy("name", "=", $cPerfilUsuarioRegistrado)->findOne();
			
			if ($otros) {
				$query->startGroup();
				$query->filterBy("profiles.id", "=", $oPerfilUsuarioRegistrado->getId(), null, "OR");
				$query->filterBy("profiles.profileGroups.adminProfile.id", "IN", $aIdProfiles, null, "OR");
				$query->dontWorryAbout("profiles", "profiles.profileGroups", "profiles.profileGroups.adminProfile");
				
				$query->endGroup();
			} else {
				$query->filterBy("profiles.profileGroups.adminProfile.id", "IN", $aIdProfiles);
				$query->dontWorryAbout("profiles", "profiles.profileGroups", "profiles.profileGroups.adminProfile");
			}
			//var_dump(Utils::debugQuery($query));
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			$mainResult = $query->find();
			//Si todo anduvo bien, complemento la información.
			if (is_array($mainResult) && (count($mainResult) >= 1)) {
				for($i=0; $i<count($mainResult);$i++)
					$ids[]=$mainResult[$i]['id'];
				if (isset($ids)) {
					$query2 = $orm->query('Profile');
					$query2->filterBy('users.id','IN', $ids)
						   ->filterBy('provider.id', 'IN', $manager->getOwnedProvidersIds($context->getProvider(), true),NULL, 'AND')
						   ->attributes('users.id', 'id', 'name' )
						   ->filterBy("profileGroups.adminProfile.id", "IN", $aIdProfiles)
						   ->distinct()
						   ->orderBy('users.id');
					if ($providerId = $oWebList->getValueOf('provider_id')) {
						$query2->filterBy('provider.id', '=', $providerId);
					}
					$secondaryResult = $query2->find();
				}
				Utils::merge($mainResult, array('id'=>'users.id'), $secondaryResult, array('name'=>'profiles.name', 'id'=>'profiles.id'));
			}
			return $mainResult;
		}
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001D7585
  }

  /**
   * Agrega, modifica o borra permisos de usuarios creados a través de la customización de perfiles en ProfileGrops.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmManagedUsers(&$context, $ajax)
  {
    // Bouml preserved body begin 001D7605
	$orm = $this->application->getORM();
	$oForm = new ManagedUserForm($orm, $context);
	return $oForm->deploy($context, $orm);
    // Bouml preserved body end 001D7605
  }

  /**
   * Cambia la contrase�a del usuario actual.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function savePassword(&$context, $ajax)
  {
    // Bouml preserved body begin 00164F05
	$orm = $this->application->getORM();
	$formPassword = new PasswordChange($orm, $context);
	return $formPassword->deploy($context, $orm);
    // Bouml preserved body end 00164F05
  }

  /**
   * Muestra un menu como un conjunto de botones.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function showMenu(&$context, $ajax)
  {
    // Bouml preserved body begin 00169405
	/*function buildMenuTree($nodes, &$menu, $parent = null) {
		if ((is_array($nodes)) && (count($nodes)>0)) {
			foreach($nodes as $key=>$node) {
				$cond1 = is_null($node->getParent()) && is_null($parent);
				$cond2 = (!is_null($node->getParent()) && ($node->getParent()->getId()==$parent));
				if ( $cond1 || $cond2) {
					$menu[$node->getOrder()]['menu']=$node;
					$menu[$node->getOrder()]['submenu']=array();
					$nodes=array_diff_key($nodes, array($key=>null));//<-por Compatibilidad versión anterior
					buildMenuTree($nodes, $menu[$node->getOrder()]['submenu'], $node->getId());
				}
			}
		}
	}*/
  
	$idMenu = $context->getParam("id_menu", null, "GP");
    $orm = $this->application->getORM();

	//Primero traigo todos los menues relacionados a acciones para las cuales tengo permisos.
    /*$query = $orm->query('Menu')
                 ->filterBy('provider.id', '=', $context->getProvider()->getId())
                 ->filterBy('profiles.users.id', '=', $context->getUser()->getId())
				 ->filterBy('id', '=', $idMenu)
				 ->filterBy('visible','=',true)
				 ->orderBy('order');
    $nodes = $query->find();
	
	$menus = array();
    buildMenuTree($nodes, $menus);
	$context->set("menuses", $menus);*/
	
	$query = $orm->query('Menu')
				 ->attributes(	'links.submenus.menu.id AS menuId', 
								'links.submenus.menu.dynamic as menuDynamic', 
								'links.submenus.menu.name AS menuName', 
								'links.submenus.menu.params AS menuParams', 
								'links.submenus.menu.icon as menuIcon', 
								'links.submenus.menu.action.icon as actionIcon', 
								'links.submenus.menu.action.hint as actionHint', 
								'links.submenus.menu.action AS actionId', 
								'links.submenus.menu.action.facade.alias AS facadeAlias', 
								'links.submenus.menu.action.alias as actionAlias',
								'links.submenus.order')
				 ->dontWorryAbout('links.submenus.menu.action')
				 ->dontWorryAbout('links.submenus.menu.action.facade')
                 ->filterBy('provider.id', '=', $context->getProvider()->getId())
                 ->filterBy('profiles.users.id', '=', $context->getUser()->getId())
				 ->filterBy('id', '=', $idMenu)
				 ->filterBy('visible','=',true)
				 ->filterBy('links.domain.profiles.users.id', '=', $context->getUser()->getId())
				 ->filterBy('links.domain.id', '=', $context->getDomain()->getId())
				 ->filterBy('links.domain.provider.id', '=', $context->getProvider()->getId())
				 ->filterBy('links.submenus.menu.profiles.users.id', '=', $context->getUser()->getId())
				 ->filterBy('links.submenus.menu.visible','=',true)
				 ->distinct(true)
				 ->orderBy('links.submenus.order');
    $nodes = $query->find();
	
	$query = $orm->query('Menu')
                 ->filterBy('provider.id', '=', $context->getProvider()->getId())
                 ->filterBy('profiles.users.id', '=', $context->getUser()->getId())
				 ->filterBy('id', '=', $idMenu)
				 ->filterBy('visible','=',true)
				 ->filterBy('links.domain.id', '=', $context->getDomain()->getId())
				 ;
    $menuPrincipal = $query->findOne();
	
	/*if ($menuPrincipal) {*/

	$actionIcon = ($menuPrincipal->getIcon()) ? $menuPrincipal->getIcon() : (($menuPrincipal->getAction())?$menuPrincipal->getAction()->getIcon():'');
		$context->set("menuName", $menuPrincipal->getName());
		$context->set("menuIcon", $menuPrincipal->getIcon());
		$context->set("actionIcon", $actionIcon);
	/*}*/
	$context->set("menuses", $nodes);
    return new Renderable("lib/menuToButtons.xhtml");
    // Bouml preserved body end 00169405
  }

  /**
   * Crea o guarda un Facade nuevo
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function assignFacade(&$context, $ajax)
  {
    // Bouml preserved body begin 0013F505
	return new Renderable('sorry.xhtml');
    // Bouml preserved body end 0013F505
  }

  /**
   * Muestra un mensaje de error personalizado
   */
  public function showError(&$context, $ajax)
  {
    // Bouml preserved body begin 000D1105
    $app = $this->application;

    $title = $app->getParam('title', 'Error Desconocido', 'PG');
    $msg = $app->getParam('msg', 'No hay Descripción', 'PG');
    $mainicon = $app->getParam('mainicon', 'blank', 'PG');
    $icon = $app->getParam('icon', 'blank', 'PG');

    $errors['title']   = $title;
    $errors['subject'] = '';
    $errors['icon']= $mainicon;
    $errors['messages'][0]['icon'] = $icon;
    $errors['messages'][0]['description'] = $msg;

    $context->set('errors', $errors);
    return new Renderable('lib/show_errors.xhtml');
//errors[title]
//errors[subject]
//errors[messages][0][icon]
//errors[messages][0][description]
//errors[messages][0][field]
    // Bouml preserved body end 000D1105
  }

  /**
   * Recupera la lista de identificadores de los providers dependientes del provider padre.
   * 
   * @param Provider $provider el Provider del cual se desean conocer sus dependientes.
   * @param array $columns si en vez de obtener los objetos provider se quiere obtener la lista se pasan las columnas como un arreglo de string. Soporta alias :)
   * @param boolean $includeOwner indica si se debe devolver el propietario como parte del conjunto de resultados.
   * @return array Un arreglo con los ids de los Providers que dependen del dado o null si no hay ninguno.
   */
  public function getOwnedProviders($provider, $columns = null, $includeOwner = false)
  {
    // Bouml preserved body begin 0010DB05
	$orm = $this->application->getORM();
	$query = $orm->query('Provider')
			     ->filterBy('owner.id', '=', $provider->getId());
	$childs = $query->find();
	if ($childs != false) {
		$tmp_childs=array();
		foreach($childs as $child) {
			$subChilds = $this->getOwnedProviders($child);
			if (!is_null($subChilds))
				array_merge ($tmp_childs, $subChilds);
		}
		array_merge ($childs, $tmp_childs);
		if (!is_null($columns)) {
			$idChilds=array();
			foreach($childs as $child)
				$idChilds[]=$child->getId();
			$query = $orm->query('Provider')
			     ->filterBy('id', 'IN', $idChilds)
				 ->attributes ($columns);
			if ($includeOwner)
				$query->filterBy('id', '=', $provider->getId(), NULL, 'OR');
			return $query->find();
		} else {
			if ($includeOwner)
				$childs = array_merge(array($provider), $childs);
			else
				return $childs;
		}
	} else {
		if ($includeOwner) {
			if ($columns) {
				$query= $orm->query('Provider')
					->filterBy('id', '=', $provider->getId())
					->attributes ($columns);
				$res = $query->find();
				return $res;
			} else {
				array($provider);
			}
		} else {
			return null;
		}
	}
    // Bouml preserved body end 0010DB05
  }

  /**
   * Esta funci�n recupera una lista de los identificadores de los Providers hijos de un Provider dado.
   * Especificando includeOwner en true se indica que adem�s devuelva el provider que se pas� como par�metro como primer componente de la lista.
   */
  public function getOwnedProvidersIds($provider, $includeOwner = true)
  {
    // Bouml preserved body begin 00150D85
	$f = function ($from, &$to, $f) {
		foreach ($from as $key => $value) {
			if (is_array($value)) $f($value, $to, $f);
			else $to[]=$value;
		}
	};
	$owneds = $this->getOwnedProviders($provider, array('id'), $includeOwner);
	$list=array();
	if (is_array($owneds) && (count($owneds) > 0)) {
		$f($owneds, $list, $f);
	}
	return $list;
    // Bouml preserved body end 00150D85
  }

  /**
   * Indica si el Provider actual es un provider maestro o no.
   * 
   * @return boolean Devuelve TRUE si el Provider no tiene due�os, es decir es de la m�xima jerarqu�a, FALSE sino.
   */
  public function isMaster()
  {
    // Bouml preserved body begin 00141405
	$provider = $this->application->getContext()->getProvider();
	return is_null($provider->getOwner());
    // Bouml preserved body end 00141405
  }

  /**
   * Abre el formulario de recuperación de password
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable la página a visualizar.
   */
  public function passwordRecovery(&$context, $ajax)
  {
    // Bouml preserved body begin 001CE505
	$orm = $this->application->getORM();
	$oForm = new PasswordRecoveryForm($context);
	return $oForm->deploy($context);
    // Bouml preserved body end 001CE505
  }

  /**
   * Recibe los datos del formulario de recovery password y si coinciden con algún usuario de la base le envía un link al mail para que acepte el reseteo del password.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable la página a visualizar.
   */
  public function passwordRecoverySend(&$context, $ajax)
  {
    // Bouml preserved body begin 001CE685
	$user = $context->getParam("user", null);
	$mail = $context->getParam("mail", null);
	
	$orm = $this->application->getORM();
	
	$oUsuario = $orm->query("User")
					->filterBy("provider.id", "=", $context->getProvider()->getId())
					->filterBy("username", "=", $user)
					->filterBy("mail", "=", $mail)
					->findOne()
					;
	
	if ($oUsuario) {
		
		/* Verifico que el usuario no tenga peticiones que no hayan expirado */
		
		$oNoExpirada = $orm->query("PasswordChangeRequest")
						   ->filterBy("expire", ">", new DateTime())
						   ->filterBy("user.id", "=", $oUsuario->getId())
						   ->findOne();
		if ($oNoExpirada) {
			$resultadoOperacion = "Fallo al iniciar recuperación de contraseña";
			$mensaje = "Ya existe un pedido de recuperación de contraseña para esta cuenta, no puede iniciar otro pedido hasta que se complete el anterior o expire.";
		} else {
			
			/* Seteo los parámetros del template de mail */
			$aNombres = array();
			if ($oUsuario->getName()) $aNombres[] = $oUsuario->getName();
			if ($oUsuario->getSurname()) $aNombres[] = $oUsuario->getSurname();
			$aParametros = array();
			$aParametros["usuario"] = implode(", ", $aNombres);
			$aParametros["verificacion"] = sha1(time());
			$aParametros["domain"] = $context->getDomain()->getBaseURL();
			$aParametros["accion"] = "verificar";
			$aParametros["titulo_mail"] = "IPLAN - Recuperación de contrase&ntilde;as";
			

			/* Genero un registro con el pedido de cambio */
			$oPasswordChangeRequest = new PasswordChangeRequest();
			$oPasswordChangeRequest->setUser($oUsuario);
			$oPasswordChangeRequest->setHash($aParametros["verificacion"]);
			$date = new DateTime();
			$oPasswordChangeRequest->setDate($date);
			$date->add(new DateInterval("PT1H"));
			$oPasswordChangeRequest->setExpire($date);
			$orm->save($oPasswordChangeRequest);
			
			/* Parseo el template de mail y lo mando */
			$genManager = $context->getManager("Application");
			$template_mail = $this->application->parse("lib/recover_password.xhtml", $aParametros);
			$resultado_mail = $genManager->mailTo("notificacionesaltaservicio@iplan.com.ar", $mail, "IPLAN - Recuperación de contraseña", $template_mail);

			if ($resultado_mail) {
				$resultadoOperacion = "Recuperación de contraseña iniciada";
				$mensaje = "Se ha enviado un correo con los pasos a seguir.";
			} else {
				$resultadoOperacion = "Error al enviar el mail";
				$mensaje = "No se ha podido enviar un mail a su correo, comuníquese con atención al cliente al 0800-345-0112 o el administrador de la plataforma si lo conoce.";
			}
			
		}
	} else {
		//$aErr
		//$context->set("errors", $aErrores);
		$resultadoOperacion = "Error de usuario";
		$mensaje = "No hay concurrencias para ese usuario con ese correo.";
	}
	
	if ($mensaje !== null) {
		$reporte = new ListReport("Recuperación de Contraseña", "reporte_principal");
		$reporte->createSection($resultadoOperacion, "reporte_seccion");
		$reporte->addItem($mensaje);
		$context->set("reporte", $reporte->toArray());
		$context->set("volver_automaticamente", true);
		$renderable = new Renderable($reporte->getTemplate(), false);
		return $renderable;
	}
	
    // Bouml preserved body end 001CE685
  }

  /**
   * Este método se invoca como resultado de que el usuario haga clic en el link que se le envia por correo y genera un password aleatorio y se lo asigna efectivamente al usuario.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable la página a visualizar.
   */
  public function passwordRecoveryValidate(&$context, $ajax)
  {
    // Bouml preserved body begin 001CE785
	$verificacion = $context->getParam("verify", null);
	
	$orm = $this->application->getORM();
	
	if ($verificacion) {
		$oResetear = $orm->query("PasswordChangeRequest")
						 ->filterBy("hash", "=", $verificacion)
						 ->findOne();
		if ($oResetear) {
			
			$oUsuarioReset = $oResetear->getUser();
			
			/* Preparo un password nuevo para el usuario */
			$nuevoPass = substr(sha1(microtime()), 0, 8);
			
			/* Envío un mail al usuario */
			$aNombres = array();
			if ($oUsuarioReset->getName()) $aNombres[] = $oUsuarioReset->getName();
			if ($oUsuarioReset->getSurname()) $aNombres[] = $oUsuarioReset->getSurname();
			$aParametros = array();
			$aParametros["usuario"] = implode(", ", $aNombres);
			$aParametros["user"] = $oUsuarioReset->getUsername();
			$aParametros["password"] = $nuevoPass;
			$aParametros["domain"] = $context->getDomain()->getBaseURL();
			$aParametros["accion"] = "nuevopassword";
			$aParametros["titulo_mail"] = "IPLAN - Recuperación de contrase&ntilde;as";
			$mail = $oUsuarioReset->getMail();
			
			/* Parseo el template de mail y lo mando */
			$genManager = $context->getManager("Application");
			$template_mail = $this->application->parse("lib/recover_password.xhtml", $aParametros);
			$resultado_mail = $genManager->mailTo("notificacionesaltaservicio@iplan.com.ar", $mail, "IPLAN - Recuperación de contraseña", $template_mail);

			if ($resultado_mail) {
				$resultadoOperacion = "Recuperación de contraseña finalizada";
				$mensaje = "Se ha enviado un correo con sus nuevos datos.";
				
				$oUsuarioReset->setPassword(sha1($nuevoPass));
				$oUsuarioReset->setForcePasswordChange(true);
				$orm->save($oUsuarioReset);
				$orm->delete($oResetear);
				
			} else {
				$resultadoOperacion = "Error al enviar el mail";
				$mensaje = "No se ha podido enviar un mail a su correo, comuníquese con atención al cliente al 0800-345-0112 o el administrador de la plataforma si lo conoce.";
			}
			
			
		} else {
			//$aErr
			//$context->set("errors", $aErrores);
			$resultadoOperacion = "Error de Verificación";
			$mensaje = "No se encuentra el registro de verificación de correo.";
		}
	} else {
		//$aErr
		//$context->set("errors", $aErrores);
		$resultadoOperacion = "Error de Verificación";
		$mensaje = "No se encuentra el registro de verificación de correo.";
	}
	
	if ($mensaje !== null) {
		$reporte = new ListReport("Recuperación de Contraseña", "reporte_principal");
		$reporte->createSection($resultadoOperacion, "reporte_seccion");
		$reporte->addItem($mensaje);
		$context->set("reporte", $reporte->toArray());
		$context->set("volver_automaticamente", true);
		$renderable = new Renderable($reporte->getTemplate(), false);
		return $renderable;
	}
	
    // Bouml preserved body end 001CE785
  }

  /**
   * Genera una clave aleatoria para un usuario y se la remite al mail.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable la página a visualizar.
   */
  public function resetUserPassword(&$context, $ajax)
  {
    // Bouml preserved body begin 001CE705
    // Bouml preserved body end 001CE705
  }

  /**
   * Descarga un manual de usuario en base a un ID de perfil.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function downloadManual(&$context, $ajax)
  {
    // Bouml preserved body begin 001DB305
	$id_perfil = $context->getParam("profile", null);
	$orm = $this->application->getORM();
	
	$oPerfil = $orm->retrieve("Profile", $id_perfil);
	if (!$oPerfil) $oPerfil = $orm->load("Profile", $id_perfil);
	
	$mensaje = null;
	
	if ($oPerfil) {
		if ($context->getUser()->hasProfile($oPerfil->getName())) {
			
			//ManualdeUsuario-AdministradorImplementaciones
			
			$renderable = new Renderable();
			$renderable->addHeader("Content-Type", 'application/pdf');
			$renderable->addHeader("Content-Disposition", 'attachment; filename="'. basename($oPerfil->getManual()) . '"');
			$renderable->loadFile("templates/default/" . $oPerfil->getManual());
			$renderable->setDownlodeable(true);
			return $renderable;
		} else {
			//Usuario no tiene perfil
			$mensaje = "Usuario no tiene perfil";
		}
	} else {
		//Perfil Inválido
		$mensaje = "Perfil Inválido";
	}
	$reporte = new ListReport("Error de perfil", "reporte_principal");
	$reporte->createSection("Detalle", "reporte_seccion");
	$reporte->addItem($mensaje);
	$context->set("reporte", $reporte->toArray());
	$context->set("volver_automaticamente", true);
	return new Renderable($reporte->getTemplate(), false);
    // Bouml preserved body end 001DB305
  }

  /**
   * Lista el conjunto de manuales en base a los perfiles del usuario logueado.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listManuals(&$context, $ajax)
  {
    // Bouml preserved body begin 001DB505
	$orm = $this->application->getORM();
	
	$manual = new Column('Manual', 'manual', false, null, false, 'Security.downloadManual');
	$manual->setMode('inline-popup')
			 ->setParams(array('profile'=>'id'));
	
	$webList = new WebList($this);
	$webList->addColumn(new Column("Perfil", "name"))
			->addColumn($manual);
	$webList->setListFunction(
		function (SecurityManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('Profile');
			$query->filterBy('users.id', '=', $context->getUser()->getId())
					->filterBy("manual", "IS NOT NULL")
					 ->attributes('id', 'manual', "name");

			$oWebList->applyFilter($query)
					 ->limitQuery($query);
			$resultados = $query->find();
			if (is_array($resultados) && (count($resultados) > 0))
			for($i = 0; $i < count($resultados); $i++) {
				$resultados[$i]["manual"] = basename($resultados[$i]["manual"]);
			}
			return $resultados;
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001DB505
  }

  /**
   * Lista los Facades o M�dulos habilitados para el provider.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function testMethod(&$context, $ajax)
  {
    // Bouml preserved body begin 00180505
	$orm = $this->application->getORM();
	
	$query = $orm->query('Client')
				 ->filterBy('id', '<', 100)
				 ->attributes('name', 'username', 'user.name');
	krumo(Utils::debugQuery($query));
	return new Renderable('test.xhtml');
    // Bouml preserved body end 00180505
  }

  /**
   * Lista las acciones disponibles para el provider.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listModules(&$context, $ajax)
  {
    // Bouml preserved body begin 00194C05
	function file_array($path, $exclude = ".|..", $recursive = true) {
		$path = rtrim($path, "/") . "/";
		$folder_handle = opendir($path);
		$exclude_array = explode("|", $exclude);
		$result = array();
		while(false !== ($filename = readdir($folder_handle))) {
			if(!in_array(strtolower($filename), $exclude_array)) {
				if(is_dir($path . $filename . "/")) {
									// Need to include full "path" or it's an infinite loop
					if($recursive) $result[] = file_array($path . $filename . "/", $exclude, true);
				} else {
					$result[] = $filename;
				}
			}
		}
		return $result;
	}
	
	krumo(file_array('./iplan/'));
    // Bouml preserved body end 00194C05
  }

  /**
   * Crea o guarda el men� indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function installModule(&$context, $ajax)
  {
    // Bouml preserved body begin 00194C85
    // Bouml preserved body end 00194C85
  }

  /**
   * Crea o guarda el men� indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function backupModule(&$context, $ajax)
  {
    // Bouml preserved body begin 00194D05
    // Bouml preserved body end 00194D05
  }

  /**
   * Crea o guarda el men� indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function restoreModule(&$context, $ajax)
  {
    // Bouml preserved body begin 00194D85
    // Bouml preserved body end 00194D85
  }

  /**
   * Crea o guarda el men� indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function updateModule(&$context, $ajax)
  {
    // Bouml preserved body begin 00194E05
    // Bouml preserved body end 00194E05
  }

  /**
   * Crea o guarda el men� indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function reinstallModule(&$context, $ajax)
  {
    // Bouml preserved body begin 00194E85
    // Bouml preserved body end 00194E85
  }

  /**
   * Crea o guarda el men� indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function uninstallModule(&$context, $ajax)
  {
    // Bouml preserved body begin 00194F05
    // Bouml preserved body end 00194F05
  }

}
?>