<?php
require_once 'iplan/security/Menu.php';
require_once 'iplan/security/User.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/security/Facade.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Domain.php';
require_once 'iplan/security/ProfileGroup.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/GlobalData.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * El Provider es la entidad que representa a los proveedores de servicio. Un provider típicamente es la empresa que presta servicios a un conjunto de usuarios, aunque también puede ser proveedor de otro provider.
 * 
 * @method string getName()
 * @method Provider setName()
 * @method string getDescription()
 * @method Provider setDescription()
 * @method array getUsers()
 * @method int getMaxFetchRows()
 * @method Provider setMaxFetchRows()
 * @method Provider addUser()
 * @method Provider delUser()
 * @method array getProfiles()
 * @method Provider addProfile()
 * @method Provider delProfile()
 * @method Provider getOwner()
 * @method Provider setOwner()
 * @method array getFacades()
 * @method Provider addFacade()
 * @method Provider delFacade()
 * @method User getAnonymous()
 * @method Provider setAnonymous()
 * @method Provider addDomain()
 * @method Provider delDomain()
 * @method ORMCollection getDomains()
 * @method Provider setMainDomain()
 * @method Domain getMainDomain()
 */
class Provider extends ORMObject {
  /**
   * @var string el nombre del proveedor del servicio
   */
  protected $name;

  /**
   * @var int la cantidad de filas que se recuperan como m�ximo en las consultas autom�ticas (Exportaci�n).
   */
  protected $maxFetchRows;

  /**
   * @var array la lista de menues que pertenecen al provider
   */
  protected $menus;

  /**
   * @var array una colección de los usuarios que pertenecen al proveedor de servicio en cuestión
   */
  protected $users;

  /**
   * @var array la lista de perfiles asociados al proveedor
   */
  protected $profiles;

  /**
   * @var array la lista de Facades habilitados al provider
   */
  protected $facades;

  protected $anonymous;

  /**
   * Qui�n es el propietario directo del Provider. El �nico que deber�a ser null en este atributo es iPlan.
   */
  protected $owner;

  /**
   * @var ORMCollection la lista de dominios asociados al provider
   */
  protected $domains;

  /**
   * @var Domain el dominio principal de configuración de las aplicaciones
   */
  protected $mainDomain;

  /**
   * @var ORMCollection la lista de grupos de perfiles que pertenecen al provider
   */
  protected $profileGroups;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 000B3505
    return parent::define($orm)
            ->setClass('Provider')
            ->setTable('UWS_PROVIDER')
            ->addField('id', 'PROVIDER_ID', ORMDefinition::INTEGER, null, null, FALSE)
            ->setKey('id')
            ->addField('name', 'PROVIDER_NAME', ORMDefinition::STRING, 25, 0, FALSE)
			->addField('maxFetchRows', 'PROVIDER_MAXFETCH', ORMDefinition::INTEGER, 6, 0, FALSE, 1000)
            ->addInstance('anonymous', 'ANONYMOUS_ID', 'User', true, null, ORMDefinition::LAZY_LOAD)
            ->addInstance('owner', 'PROVIDER_OWNER', 'Provider', true, null, ORMDefinition::LAZY_LOAD)
			->addInstance('mainDomain', 'PROVIDER_MAIN_DOMAIN', 'Domain')
            ->addRelation1xN('profiles', 'PROVIDER_ID', 'Profile')
            ->addRelation1xN('menus', 'PROVIDER_ID', 'Menu')
            ->addRelation1xN('users', 'PROVIDER_ID', 'User')
			->addRelation1xN('domains', 'DOMAIN_ID', 'Domain')
            ->addRelationNxM('facades', 'UWS_PROVIDER_FACADE', 'PROVIDER_ID', 'Facade', 'FACADE_ID');
    // Bouml preserved body end 000B3505
  }

  /**
   * Agrega un valor global al Provider. Esta valor puede ser consultado por todos los dominios y módulos del sistema.
   * 
   * @param string $name el nombre del parámetro
   * @param string $value el valor a almacenar
   * 
   * @return Provider devuelve el Provider tras guardar el valor.
   */
  public function registerGlobal($name, $value)
  {
    // Bouml preserved body begin 0019DE85
	$globalData = $this->orm->query('GlobalData')->filterBy('name', '=', $name)
											 ->filterBy('provider', '=', $this->id)
											 ->filterBy('domain', 'IS NULL')
											 ->filterBy('module', 'IS NULL')
						->findOne();
	if ($globalData) {
		$globalData->setValue($value);
		$globalData->save();
	} else {
		$globalData = new GlobalData($this->orm);
		$globalData->setName($name)
				   ->setValue($value)
				   ->setProvider($this)
				   ->save();
	}
	return this;
    // Bouml preserved body end 0019DE85
  }

  /**
   * Recupera un valor global al Provider
   * 
   * @param string $name el nombre del parámetro
   * 
   * @return string|false El valor almacenado en la variable global o false en caso de no encontrarse coincidencias
   */
  public function getGlobal($name)
  {
    // Bouml preserved body begin 0019DF05
	$globalData = $this->orm->query('GlobalData')->filterBy('name', '=', $name)
											 ->filterBy('provider', '=', $this->id)
											 ->filterBy('domain', 'IS NULL')
											 /*->filterBy('module', 'IS NULL')*/
											 ->attributes('value')
						->findOne();
	if ($globalData) return $globalData["value"];
	else return false;
    // Bouml preserved body end 0019DF05
  }

}
?>