<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Agrupa un conjunto de perfiles para su administración automática.
 * 
 * @method ProfileGroup setName()
 * @method string getName()
 * @method ProfileGroup setDescription()
 * @method string getDescription()
 * @method ProfileGroup setProvider()
 * @method Provider getProvider()
 * @method ProfileGroup setProfiles()
 * @method ORMCollection getProfiles()
 * @method ProfileGroup addProfile()
 * @method Profile getProfile()
 * @method ProfileGroup delProfile()
 * 
 */
class ProfileGroup extends ORMObject {
  /**
   * @var string el nombre del agrupador
   */
  protected $name;

  /**
   * @var string la descripción del propósito del grupo
   */
  protected $description;

  /**
   * @var Provider el provider para el cual se creó el grupo
   */
  protected $provider;

  /**
   * @var ORMCollection la lista de perfiles que forman parte del grupo
   */
  protected $profiles;

  /**
   * @var Profile el perfil administrador del grupo
   */
  protected $adminProfile;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return iplan\orm\ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001D2505
	return parent::define($orm)
            ->setClass('ProfileGroup')
            ->setTable('UWS_PROFILEGROUP')
            ->addField('id', 'PROFILEGROUP_ID', ORMDefinition::INTEGER, null, null, FALSE)
			->addField('name', 'PROFILEGROUP_NAME', ORMDefinition::STRING, 50, null, FALSE)
			->addField('description', 'PROFILEGROUP_DESC', ORMDefinition::STRING, 255, null, FALSE)
			->addInstance("adminProfile", "PROFILEGROUP_ADMINPROFILE", "Profile", false)
			->addInstance("provider", "PROFILEGROUP_PROVIDER", "Provider", false)
			->addRelationNxM("profiles", "UWS_PROFILEGROUP_PROFILE", "PROFILEGROUP_ID", "Profile", "PROFILE_ID")
            ->setKey('id')
			;
    // Bouml preserved body end 001D2505
  }

}
?>