<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/User.php';
require_once 'iplan/security/Action.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/security/Menu.php';
require_once 'iplan/security/Domain.php';
require_once 'iplan/security/ProfileGroup.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un perfil es una entidad que nuclea el un conjunto de acciones para realizar una tarea o un conjunto de tareas relacionadas.
 * Los perfiles se relacionan del mismo modo con los usuarios habilit�ndo a �stos �ltimos a realizar dichas tareas.
 * Los son creados por el Provider y dependen de �l.
 * 
 * @method string getName()
 * @method Profile setName()
 * @method string getDescription()
 * @method Profile setDescription()
 * @method Provider getProvider()
 * @method Profile setProvider()
 * @method array getActions()
 * @method array getUsers()
 * @method Profile addAction()
 * @method Profile delAction()
 * @method Profile addUser()
 * @method Profile delUser()
 * @method Profile setWelcome()
 * @method string getWelcome()
 */
class Profile extends ORMObject {
  protected $name;

  protected $description;

  /**
   * @var array $users la lista de usuarios del perfil
   */
  protected $users;

  /**
   * @var array $actions la lista de acciones relacionadas al perfil
   */
  protected $actions;

  /**
   * @var \iplan\security\Provider el proveedor que configur� el grupo
   */
  protected $provider;

  /**
   * @var string Un template a incluir en la bienvenida cuando el usuario tenga este perfil.
   */
  protected $welcome;

  /**
   * @var ORMCollection la lista de menues que tiene habilitado el perfil
   */
  protected $menus;

  /**
   * @var ORMCollection la lista de dominios para los cuales está hecho el perfil
   */
  protected $domains;

  /**
   * @var ORMCollection la lista de grupos a los cuales pertenece el perfil
   */
  protected $profileGroups;

  /**
   * @var string el path al manual del perfil
   */
  protected $manual;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 000A6005
    return parent::define($orm)
                ->setClass('Profile')
                ->setTable('UWS_PROFILE')
                ->addField('id', 'PROFILE_ID', ORMDefinition::INTEGER, 10, null, FALSE)
                ->setKey('id')
                ->addField('name', 'PROFILE_NAME', ORMDefinition::STRING, 50, 0, FALSE)
                ->addField('description', 'PROFILE_DESCRIPTION', ORMDefinition::STRING, 2048)
				->addField('welcome', 'PROFILE_WELCOME', ORMDefinition::STRING, 200)
				->addField('manual', 'PROFILE_MANUAL', ORMDefinition::STRING, 200)
                ->addInstance('provider', 'PROVIDER_ID', 'Provider', FALSE)
                ->addRelationNxM('menus', 'UWS_PROFILE_MENU', 'PROFILE_ID', 'Menu', 'MENU_ID')
                ->addRelationNxM('users', 'UWS_USER_PROFILE', 'PROFILE_ID', 'User', 'USER_ID')
                ->addRelationNxM('actions', 'UWS_PROFILE_ACTION', 'PROFILE_ID', 'Action', 'ACTION_ID')
				->addRelationNxM('domains', 'UWS_DOMAIN_PROFILE', 'PROFILE_ID', 'Domain', 'DOMAIN_ID')
				->addRelationNxM('profileGroups', 'UWS_PROFILEGROUP_PROFILE', 'PROFILE_ID', 'ProfileGroup', 'PROFILEGROUP_ID')
				;
    // Bouml preserved body end 000A6005
  }

}
?>