<?php
require_once 'iplan/security/User.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
class PasswordChangeRequest extends ORMObject {
  /**
   * @var User el usuario que solicitó el cambio
   */
  protected $user;

  /**
   * @var DateTime fecha de creación del pedido
   */
  protected $date;

  /**
   * @var DateTime el período de tiempo por el cual es válido el token
   */
  protected $expire;

  /**
   * @var string el hash aleatorio que se generó y que valida la solicitud
   */
  protected $hash;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return iplan\orm\ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001CE805
	return parent::define($orm)
		   ->setClass('PasswordChangeRequest')
		   ->setTable('UWS_PASS_CHANGE_REQUEST')
		   ->addField('id', 'PASSWORDCHANGEREQUEST_ID', ORMDefinition::INTEGER, 10, 0, FALSE)
		   ->setKey('id')
		   ->addField('date', 'PASSWORDCHANGEREQUEST_DATE', ORMDefinition::DATETIME, null, null, false, 'NOW()')
		   ->addField('expire', 'PASSWORDCHANGEREQUEST_EXPIRES', ORMDefinition::DATETIME)
		   ->addField('hash', 'PASSWORDCHANGEREQUEST_HASH', ORMDefinition::STRING, 40)
		   ->addInstance('user', 'USER_ID', 'User')
	;

    // Bouml preserved body end 001CE805
  }

}
?>