<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Menu.php';
require_once 'iplan/security/Domain.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method int getOrder()
 * @method MenuLink setOrder()
 * @method string getCssClass()
 * @method MenuLink setCssClass()
 * @method Domain getDomain()
 * @method MenuLink setDomain()
 * @method MenuLink getParent()
 * @method MenuLink setParent()
 * @method ORMCollection getSubmenus()
 * @method MenuLink addSubmenu()
 * @method MenuLink delSubmenu()
 * @method Menu getMenu()
 * @method MenuLink setMenu()
 */
class MenuLink extends ORMObject {
  /**
   * @var int el orden de anidamiento respecto del padre
   */
  protected $order;

  /**
   * @var MenuLink el padre en caso de que exista
   */
  protected $parent;

  /**
   * @var ORMCollection la lista de menues hijos del menú actual
   */
  protected $submenus;

  /**
   * @var Menu el menú al cual hace referencia el link
   */
  protected $menu;

  /**
   * @var string una clase o más clases de CSS que pueden se usadas para distintos fines.
   */
  protected $cssClass;

  /**
   * @var Domain el dominio al que pertenece la referencia del menú
   */
  protected $domain;
  
  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return iplan\orm\ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0019E205
	return parent::define($orm)
				   ->setClass('MenuLink')
				   ->setTable('UWS_MENULINK')
				   ->addField('id', 'MENULINK_ID', ORMDefinition::INTEGER, 5, 0, FALSE)
				   ->setKey('id')
				   ->addField('order', 'MENULINK_ORDER', ORMDefinition::INTEGER, 3, 0, FALSE)
				   ->addField('cssClass', 'MENULINK_CSS', ORMDefinition::STRING, 100)
				   ->addInstance('domain', 'DOMAIN_ID', 'Domain')
				   ->addInstance('parent', 'MENULINK_PARENT', 'MenuLink')
				   ->addRelation1xN('submenus', 'MENULINK_PARENT', 'MenuLink')
				   ->addInstance('menu', 'MENU_ID', 'Menu')
			;
    // Bouml preserved body end 0019E205
  }

  /**
   * Mueve el menú un lugar por sobre los hermanos.
   * 
   * @return MenuLink el menú con su orden alterado un lugar
   */
  public function moveUp()
  {
    // Bouml preserved body begin 0019E285
	throw new Exception('Falta implementar MenuLink::moveUp()');
    // Bouml preserved body end 0019E285
  }

  /**
   * Mueve el menú un lugar por debajo de sus hermanos.
   * 
   * @return MenuLink el link al menu con el orden alterado
   */
  public function moveDown()
  {
    // Bouml preserved body begin 0019E305
	throw new Exception('Falta implementar MenuLink::moveUp()');
    // Bouml preserved body end 0019E305
  }

}
?>