<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Action.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/security/MenuLink.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un menu representa una opción que ve el usuario para acceder a las funciones del sistema. Permite personalizar los rotulos y organizar varias acciones en una jerarquía Cada menú se traduce en una acción del sistema.
 * 
 * @method string getName()
 * @method Menu setName()
 * @method string getParams()
 * @method Menu setParams()
 * @method string getIcon()
 * @method Menu setIcon()
 * @method int getOrder()
 * @method Menu setOrder()
 * @method boolean getDynamic()
 * @method Menu setDynamic()
 * @method Action getAction()
 * @method Menu setAction()
 * @method array getSubmenus()
 * @method Menu addSubmenu()
 * @method Menu delSubmenu()
 * @method Provider getProvider()
 * @method Menu setProvider()
 * @method Menu getParent()
 * @method Menu setParent()
 * @method Menu setVisible()
 * @method boolean getVisible()
 * @method Menu addProfile()
 * @method Menu delProfile()
 * @method Menu getProfiles()
 * @method Menu setCssClass()
 * @method string getCssClass()
 * @method ORMCollection getLinks()
 * @method Menu addLink()
 * @method Menu delLink()
 */
class Menu extends ORMObject {
  protected $name;

  /**
   * @var string par�metros adicionales para pasar por GET a la acci�n
   */
  protected $params;

  /**
   * @var string el nombre del estilo del �cono
   */
  protected $icon;

  /**
   * @var boolean indica si el men� es visible o no.
   */
  protected $visible;

  /**
   * Indica si este menú se carga preferentemente a través de AJAH o si directamente redirige el sitio a otro lado.
   */
  protected $dynamic;

  /**
   * @var Action $action la acci�n que ejecuta el men�
   */
  protected $action;

  /**
   * @var iplan\security\Provider la lista de proveedores que tienen configurado este menu
   */
  protected $provider;

  /**
   * @var ORMCollection la lista de perfiles que tienen permiso para ver el men�
   */
  protected $profiles;

  /**
   * @var ORMCollection la lista de links que hacen referencia al menú en los distintos dominios.
   */
  protected $links;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return iplan\orm\ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 000BB585
    return parent::define($orm)
            ->setClass('Menu')
            ->setTable('UWS_MENU')
            ->addField('id', 'MENU_ID', ORMDefinition::INTEGER, null, null, FALSE)
            ->setKey('id')
            ->addField('name', 'MENU_NAME', ORMDefinition::STRING, 25)
            ->addField('params', 'MENU_PARAMS', ORMDefinition::STRING, 255)
            ->addField('icon', 'MENU_ICON', ORMDefinition::STRING, 40)
            ->addField('dynamic', 'MENU_DYNAMIC', ORMDefinition::BOOLEAN, 1, 0, FALSE, TRUE)
            ->addField('visible', 'MENU_VISIBLE', ORMDefinition::BOOLEAN, 1, 0, FALSE, TRUE)
            ->addInstance('action', 'ACTION_ID', 'Action')
            ->addInstance('provider', 'PROVIDER_ID', 'Provider', FALSE)
			->addRelationNxM('profiles', 'UWS_PROFILE_MENU', 'MENU_ID', 'Profile', 'PROFILE_ID')
			->addRelation1xN('links', 'MENU_ID', 'MenuLink')
			;
    // Bouml preserved body end 000BB585
  }

}
?>