<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Provider.php';
//require_once 'iplan/security/Module.php';
require_once 'iplan/security/Facade.php';
require_once 'iplan/security/Domain.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un valor almacenado en la base de datos que puede ser accedido y reconocido por distintas componentes del software
 * 
 * @method string getName()
 * @method GlobalData setName()
 * @method string getValue()
 * @method GlobalData setValue()
 * @method Provider getProvider()
 * @method GlobalData setProvider()
 * @method Domain getDomain()
 * @method GlobalData setDomain()
 * @method Module getModule()
 * @method GlobalData setModule()
 */
class GlobalData extends ORMObject {
  /**
   * @var Provider el dueño del dato en caso que sea una global de Provider
   */
  protected $provider;

  /**
   * @var Module el módulo al cual pertenece el valor en caso que sea de nivel de módulo
   */
  protected $module;

  /**
   * @var Facade el facade al que pertenece el global
   */
  protected $facade;

  /**
   * @var Domain el dominio al que pertenece el valor en caso que se trate de un valor de dominio
   */
  protected $domain;

  /**
   * @var string el nombre del valor global
   */
  protected $name;

  /**
   * @var string el valor del valor global
   */
  protected $value;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return iplan\orm\ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0019DC85
	return parent::define($orm)
            ->setClass('Global')
            ->setTable('UWS_GLOBALDATA')
            ->addField('id', 'GLOBALDATA_ID', ORMDefinition::INTEGER, 10, null)
            ->setKey('id')
            ->addField('name', 'GLOBALDATA_NAME', ORMDefinition::STRING, 50, 0, FALSE)
            ->addField('value', 'GLOBALDATA_VALUE', ORMDefinition::STRING, 255, 0, FALSE)
            ->addInstance('provider', 'PROVIDER_ID', 'Provider')
            ->addInstance('domain', 'DOMAIN_ID', 'Domain')
            ->addInstance('facade', 'FACADE_ID', 'Facade')
            //->addInstance('module', 'MODULE_ID', 'Module')
			;
    // Bouml preserved body end 0019DC85
  }

}
?>