<?php



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GeneralManager extends \AbstractManager {
  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 000ACA05
    return array('mailTo', 'toHTML', 'url', 'sessionData');
    // Bouml preserved body end 000ACA05
  }

  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function listMethods()
  {
    // Bouml preserved body begin 000BD105
    // Bouml preserved body end 000BD105
  }

  /**
   * Recupera la un arreglos con los datos necesarios para crear el menu de la aplicaci�n.
   * @return array La lista de los menues de la aplicaci�n.
   */
  public function getMenus()
  {
    // Bouml preserved body begin 000BD005
    $context = $this->application->getContext();
    $orm = $this->application->getORM();
    $result = array();
	//Primero traigo todos los menues relacionados a acciones para las cuales tengo permisos.
	$query = $orm->query('MenuLink')
                 ->filterBy('domain.provider', '=', $context->getProvider()->getId())
                 ->filterBy('domain.id', '=', $context->getDomain()->getId())
                 ->filterBy('domain.profiles.users.id', '=', $context->getUser()->getId())
                 ->filterBy('menu.profiles.users.id', '=', $context->getUser()->getId())
				 ->filterBy('menu.profiles.domains.id', '=', $context->getDomain()->getId())
				 ->filterBy('menu.visible','=',true)
				 ->attributes('id', 'parent', 'order', 'cssClass', 'menu',
							  'menu.icon', 'menu.action.icon',  'menu.action.id', 'menu.action.description', 'menu.name',
							  'menu.action', 'menu.action.hint', 'menu.params', 'menu.id', 'menu.dynamic', 
							  'menu.action.alias', 'menu.action.facade.alias', 'menu.action.params', 'menu.action.urlCode')
				 ->dontWorryAbout('parent', 'menu.action', 'menu.action.facade')
				 ->distinct(true)
				 ->orderBy('parent DESC', 'order ASC')
			;
//	echo "<pre>".Utils::debugQuery($query)."</pre>";
    $nodes = $query->find();

	//Contruir el link y el request para llavar via ajax
	if ($nodes) {
		$baseURL = $context->getDomain()->getBaseURL();
		for($i = 0; $i < count($nodes); $i++) {
			$params = '';
			if (isset($nodes[$i]['menu.action.id'])) {
				$params .= 'action='.$nodes[$i]['menu.action.urlCode'];
				if ($nodes[$i]['menu.action.params']) {
					$params .= '&'.$nodes[$i]['menu.action.params'];
				}
			}

			if (isset($nodes[$i]['menu.params'])) {
				$params .= '&'.$nodes[$i]['menu.params'];
			}
			
			if (strlen($params) > 0) {
				$jsParams = '';
				$action_params = explode('&', $params);
				foreach ($action_params as $param) {
					if ($param != '') {
						list($key, $value)=explode("=",$param);
						$jsParams .= "'$key':'$value',";
					}
				}
				$jsParams = substr($jsParams, 0, strlen($jsParams)-1);
			}
			$nodes[$i]['baseURL'] = $baseURL;
			if (strlen($params) > 0) {
				$nodes[$i]['params'] = $params;
				$nodes[$i]['jsParams'] = $jsParams;
			}
		}
	}
	
    //echo "<pre>".print_r($nodes)."</pre>";
    $this->buildMenuTree($nodes, $menus);
    //echo "<pre>".print_r($menus)."</pre>";
    return $menus;
    // Bouml preserved body end 000BD005
  }

  private function buildMenuTree($nodes, &$menu, $parent = null)
  {
    // Bouml preserved body begin 000BEB85
    if ((is_array($nodes)) && (count($nodes)>0)) {
		reset($nodes);
		$keys = array();
		$myNodes = array_filter($nodes, function($element) use ($parent, &$nodes, &$keys) {
														if ($element['parent']==$parent) {
															$keys[key($nodes)]=null;
															return true;
														} else return false;
													});
		$nodes=array_diff_key($nodes, $keys);
        foreach($myNodes as $key=>$node) {
            $cond1 = is_null($node['parent']) && is_null($parent);
            $cond2 = (!is_null($node['parent']) && ($node['parent']==$parent));
            if ( $cond1 || $cond2) {
                $menu[$node['order']]['menu']=$node;
                $menu[$node['order']]['submenu']=array();
                $this->buildMenuTree($nodes, $menu[$node['order']]['submenu'], $node['id']);
            }
        }
    }
    // Bouml preserved body end 000BEB85
  }

  /**
   * Env�a un email a trav�s del smtp del sistema.
   * 
   * @param string $from la direcci�n de correo remitente. Puede usarse el formato "Nombre" <mail@dominio> (el nombre incluye las comillas)
   * @param array $to una lista de direcciones a las cuales enviar el mensaje, cada direcci�n de correo destino se rigue bajo las mismas reglas de formato de $from
   * @param string $title el t�tulo del mensaje
   * @param string $body el cuerpo del mensaje, puede ser c�digo html
   * @param array $cc la lista de destinatarios con copia, puede usar formato "Nombre" <mail@dominio>
   * @param array $bcc la lista de destinatarios con copia oculta, puede usar el formato anterior
   */
  public function mailTo($from, $to, $title, $body, $cc = null, $bcc = null)
  {
    // Bouml preserved body begin 000A7A85
	//$attatch = array("filename" => "hola.xd", "fileatt_type" => "text/plain", "filedata" => "asdasXDD");
	  	if ((!$to)||(!$from)||(!$title)) {
	  		$bEstado = false;
	  	} else {
			$headers="From:$from";
			$message="";
			if (isset($attatch)&&(isset($attatch["filedata"]))) {
			  	$attatch["filedata"] = (!$attatch["filedata"]) ? "archivo" : $attatch["filedata"];
				$attatch["fileatt_type"] = (!$attatch["fileatt_type"]) ? "text/plain" : $attatch["fileatt_type"];
				$semi_rand = md5(time() . microtime());
				$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
		
				$headers .= "\nMIME-Version: 1.0\n" .
							"Content-Type: multipart/mixed;\n" .
							" boundary=\"{$mime_boundary}\"";
		
				$message =	"This is a multi-part message in MIME format.\n\n" .
							"--{$mime_boundary}\n" .
							"Content-Type: text/html; charset=\"UTF-8\"\n" .
							"Content-Transfer-Encoding: 7bit\n\n" .
							$body .
		        $message . "\n\n";
				
				$data = chunk_split(base64_encode($attatch["filedata"]));
				
				$message .= "--{$mime_boundary}\n" .
							"Content-Type: {$attatch["fileatt_type"]};\n" .
							" name=\"{$attatch["filename"]}\"\n" .
							"Content-Disposition: attachment;\n" .
							" filename=\"{$attatch["filename"]}\"\n" .
							"Content-Transfer-Encoding: base64\n\n" .
							$data . "\n\n" . "--{$mime_boundary}--\n";
			} else {
				$headers .=	"\nMIME-Version: 1.0\n" .
							"Content-Type: text/html; charset=\"UTF-8\"\n".
							"Content-Transfer-Encoding: 7bit\n\n";
				$message = $body;
			}
			
			$bEstado = mail($to, $title, $message, $headers);
		}
		return($bEstado);
    // Bouml preserved body end 000A7A85
  }

  /**
   * Transforma acentos y caracteres especiales a un formato compatible HTML
   * @param string $text el texto a convertir
   * @result string Un texto equivalente en HTML al original.
   */
  public function toHTML($text)
  {
    // Bouml preserved body begin 000AC985
    $text = htmlentities($text, ENT_NOQUOTES, 'UTF-8'); // Convertir caracteres especiales a entidades
    $text = htmlspecialchars_decode($text, ENT_NOQUOTES); // Dejar <, & y > como estaban
    return $text;
    // Bouml preserved body end 000AC985
  }

  /**
   * Convierte una URL dada en otra que sirve para obtener el archivo deseado de acuerdo al contexto.
   * @param string $url la url del recurso
   * @return string una direcci�n
   */
  public function url($url)
  {
    // Bouml preserved body begin 000B1B85
    return "Test: $url";
    // Bouml preserved body end 000B1B85
  }

  /**
   * Devuelve la informaci�n de los datos de sesi�n mediante un vardump()
   */
  public function sessionData()
  {
    // Bouml preserved body begin 000C5185
    var_dump($_SESSION);
    var_dump($_POST);
    var_dump($_GET);
    return "= FIN DUMPS =";
    // Bouml preserved body end 000C5185
  }

  /**
   * Convierte un n�mero de cliente de TenFold a su correspondiente CGP (C�digo de Gesti�n Personal).
   * 
   * @param int $tenfoldId el identificador de TenFold.
   * 
   * @return string el CGP.
   */
  public function clientToCGP($tenfoldId)
  {
    // Bouml preserved body begin 00169205
	//Get a 6-digit customer code with leading 0s
	$whit_mask = str_pad($tenfoldId, 6, '0', STR_PAD_LEFT);
	// Extrae todos los digitos
	$barcode = str_split($whit_mask, 1);
	
	$verificationDigit = floor(($barcode[0] * 1 + $barcode[1] * 3 + $barcode[2] * 5 + $barcode[3] * 7 + $barcode[4] * 9 + $barcode[5] * 3) / 2) % 10;
	// Devuelve el numero de cliente (con los ceros) mas el digito de verificacion
	return trim($whit_mask . $verificationDigit);
    // Bouml preserved body end 00169205
  }

  /**
   * Toma un c�digo de CGP y retorna el n�mero de TenFold correspondiente.
   * 
   * @param string $cgp un c�digo de CGP
   * 
   * @return int el n�mero de cliente TenFold.
   */
  public function cgpToClient($cgp)
  {
    // Bouml preserved body begin 00169285
	return ltrim(substr($cgp, 0, -1), "0");
    // Bouml preserved body end 00169285
  }

}
?>