<?php
require_once 'iplan/security/Action.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * El Facade puede verse como el padre o contenedor de un conjunto de acciones. Se trata de una especie de librer�a o m�dulo en el cual se define el comportamiento de un conjunto de acciones. El Facade apunta a un archivo .php que tiene el codigo de una clase que hereda de AbstractManager.
 * Los Facades tienen relaci�n con los providers de tal forma que "habilitan o no" a �stos el uso de las acciones que contiene.
 * 
 * @method string getClass()
 * @method Facade setClass()
 * @method string getFile()
 * @method Facade setFile()
 * @method string getAlias()
 * @method Facade setAlias()
 * @method array getActions()
 * @method Facade addAction()
 * @method Facade delAction()
 * @method array getProviders()
 * @method Facade addProvider()
 * @method Facade delProvider()
 */
class Facade extends ORMObject {
  /**
   * @var string $class el nombre de la clase "Facade"
   */
  protected $class;

  /**
   * @var string file el archivo donde se encuentra el facade
   */
  protected $file;

  /**
   * @var string $alias un t�tulo descriptivo para el usuario
   */
  protected $alias;

  /**
   * @var array la lista de acciones actualmente autorizadas del facade
   */
  protected $actions;

  /**
   * @var array la colecci�n de Proveedores que tienen habilitado el Facade
   */
  protected $providers;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return iplan\orm\ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 000A6105
    $definition = parent::define($orm)
            ->setClass('Facade')
            ->setTable('UWS_FACADE')
            ->addField('id', 'FACADE_ID', ORMDefinition::INTEGER, null, null, FALSE)
            ->setKey('id')
            ->addField('class', 'FACADE_CLASS', ORMDefinition::STRING, 50, 0, FALSE)
            ->addField('file', 'FACADE_FILE', ORMDefinition::STRING, 255, 0, FALSE)
            ->addField('alias', 'FACADE_ALIAS', ORMDefinition::STRING, 25, 0, FALSE)
            ->addRelation1xN('actions', 'FACADE_ID', 'Action')
            ->addRelationNxM('providers', 'UWS_PROVIDER_FACADE','FACADE_ID', 'Provider', 'PROVIDER_ID');
    return $definition;
    // Bouml preserved body end 000A6105
  }

}
?>