<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/security/MenuLink.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/GlobalData.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa un sitio o URL donde el Provider brinda algún servicio.
 * 
 * @method string getBaseURL()
 * @method Domain setBaseURL()
 * @method int getPageRows()
 * @method Domain setPageRows()
 * @method boolean getLoginUnificado()
 * @method Domain setLoginUnificad()
 * @method string getAlias()
 * @method Domain setAlias()
 * @method Provider getProvider()
 * @method Domain setProvider()
 */
class Domain extends ORMObject {
  /**
   * @var string el nombre de un dominio
   */
  protected $baseURL;

  /**
   * @var int La configuraci�n del proveedor de la cantidad de filas por p�gina que desea ver.
   */
  protected $pageRows;

  /**
   * @var boolean Indica si el soporte para "Login Unificado" est� habilitado para este provider.
   */
  protected $loginUnificado;

  /**
   * @var string el nombre del directorio donde se encuentran los templates del sitio.
   */
  protected $alias;

  /**
   * @var Provider el dueño del dominio
   */
  protected $provider;

  /**
   * @var ORMCollection la lista de perfiles de acceso que sirven para este dominio
   */
  protected $profiles;

  /**
   * @var ORMCollection la lista de menues a visualizar en el sitio
   */
  protected $menus;

  /**
   * Retorna un objeto de definición predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definición
   * @return iplan\orm\ORMDefinition la definición default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0019C305
	return parent::define($orm)
				   ->setClass('Domain')
				   ->setTable('UWS_DOMAIN')
				   ->addField('id', 'DOMAIN_ID', ORMDefinition::INTEGER, 5, 0, FALSE)
				   ->setKey('id')
				   ->addField('baseURL', 'DOMAIN_URL', ORMDefinition::STRING, 255, 0, FALSE)
				   ->addField('pageRows', 'DOMAIN_PAGE_ROWS', ORMDefinition::INTEGER, 3, 0, true, 10)
				   ->addField('loginUnificado', 'DOMAIN_USE_LU', ORMDefinition::BOOLEAN, null, null, true, false)
				   ->addField('alias', 'DOMAIN_ALIAS', ORMDefinition::STRING, 50, 0, true, 'default')
				   ->addInstance('provider', 'PROVIDER_ID', 'Provider')
				   ->addRelation1xN('menus', 'DOMAIN_ID', 'MenuLink')
				   ->addRelationNxM('profiles', 'UWS_DOMAIN_PROFILE', 'DOMAIN_ID', 'Profile', 'PROFILE_ID')
				;
    // Bouml preserved body end 0019C305
  }

  /**
   * Agrega un valor global al dominio. Esta valor puede ser consultado por todos los dominios y módulos del sistema.
   * 
   * @param string $name el nombre del parámetro
   * @param string $value el valor a almacenar
   * 
   * @return Domain devuelve el dominio tras guardar el valor.
   */
  public function registerGlobal($name, $value)
  {
    // Bouml preserved body begin 0019DD85
	$globalData = $this->orm->query('GlobalData')->filterBy('name', '=', $name)
											 ->filterBy('provider', '=', $this->getProvider()->getId())
											 ->filterBy('domain', '=', $this->id)
											 //->filterBy('module', 'IS NULL')
						->findOne();
	if ($globalData) {
		$globalData->setValue($value);
		$globalData->save();
	} else {
		$globalData = new GlobalData($this->orm);
		$globalData->setName($name)
				   ->setValue($value)
				   ->setProvider($this->getProvider())
				   ->setDomain($this)
				   ->save();
	}
	return this;
    // Bouml preserved body end 0019DD85
  }

  /**
   * Recupera un valor global al Dominio
   * 
   * @param string $name el nombre del parámetro
   * 
   * @return string|false El valor almacenado en la variable global o false si no se encontró una coincidencia
   */
  public function getGlobal($name)
  {
    // Bouml preserved body begin 0019DF85
	$globalData = $this->orm->query('GlobalData')->filterBy('name', '=', $name)
											 ->filterBy('provider', '=', $this->getProvider()->getId())
											 ->filterBy('domain', '=', $this->id)
											 //->filterBy('module', 'IS NULL')
											 ->attributes('value')
						->findOne();
	if ($globalData) return $globalData['value'];
	else return false;
    // Bouml preserved body end 0019DF85
  }

}
?>