<?php
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/Menu.php';
require_once 'iplan/security/Action.php';
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/GlobalData.php';

require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/OracleDatabase.php';

require_once 'lib/Twig/Autoloader.php';
require_once 'iplan/twig/IPlanExtension.php';
require_once 'lib/PHPMailer_5.2.1/class.phpmailer.php';

/**
* Author: Jorge Alexis Viqueira
* 
*/
class Application {
  /**
   * @var Application variable que alberga la instancia de la aplicaci�n
   */
  private static $instance;

  /**
   * @var ORM la instancia del manejador de objetos de la aplicaci�n
   */
  private $orm;

  /**
   * @var Twig_Environment la instancia del motor de templates
   */
  private $twig;

  /**
   * @var string indica cuál es el entorno de trabajo actual. Development, Test o Production
   */
  private $environment;

  /**
   * @var Enviroment una instancia con los valores globales registrados por los usuarios
   */
  private $context;

  /**
   * @var array la lista de menus de la aplicaci�n
   */
  private $menus;

  /**
   * @var Action la acci�n que se est� ejecutando actualmente.
   */
  private $currentAction;

  private function __construct()
  {
    // Bouml preserved body begin 000A9405

    //TODO parametrizar esto
    $this->orm = ORM::getInstance('EN');
	$this->environment = 'Development';//Test Production
	//Maqueta
	//$connection = new OracleConnection("ADMIN_IUNI", "wholesale2010", "sswmc", "172.16.213.28", 1521,  "ADMIN_IUNI", OCI_DEFAULT);
	$connection = new OracleConnection("ADMIN_IUNI", "wholesale2010", "SSWMC");
	//Data Guard
	//$connection = new OracleConnection("172.16.57.25", 1521, "AUTOPROPDB_dguard", "ADMIN_IUNI", "wholesale2010");
	//$connection = new OracleConnection("ADMIN_IUNI", "wholesale2010", "AUTOPROPDB");
	$database = new OracleDatabase($connection);
	//$database->enableBoost(true);
	$this->orm->setDatabase($database);
    if ($this->getParam('destroy_session', false)) {
        session_destroy();
        session_start();
    }
    //Cargo el proveedor, por default el 1 = IPlan
	$domain=false;
    //...para ello primero me fijo en la sesión, si hay uno de sesión vale ese...
    if (!isset($_SESSION['uws_provider_id'])) {
        //...si no hay en la sesión me fijo si lo mandaron por parámetro, si lo pasaron, vale ese...
        $tmp_id=$this->getParam ('uws_provider_id', null);
        //...y por último trato de deducirlo de la URL, al final si todo falla pongo el de IPlan
        if (is_null($tmp_id)) {
			$hostxd = (isset($_SERVER['HTTP_HOST'])) ? $_SERVER['HTTP_HOST'] : "";
            $query= $this->orm->query('Domain')->filterBy('baseURL','LIKE', '%'.$hostxd.dirname($_SERVER['SCRIPT_NAME']).'%');
            $domain =$query->findOne();
            if ($domain===false) {
                $tmp_id=1;
            } else {
                $tmp_id=$domain->getProvider()->getId();
            }
        }
		$_SESSION['uws_provider_id']=$tmp_id;
    }
    $provider = $this->orm->load('Provider', $_SESSION['uws_provider_id']);/*@var $provider Provider*/

    //Cargo el alias del directorio desde el dominio encontrado o desde el main domain del provider
	if (!$domain) {
		if (isset($_SESSION['uws_domain_id'])) {
			$domain = $this->orm->query('Domain')
								->filterBy('provider', '=', $provider->getId())
								->filterBy('id', '=', $_SESSION['uws_domain_id'])
								->findOne();
			if (!$domain) {
				$domain = $provider->getMainDomain();
				$_SESSION['uws_domain_id']=$domain->getId();//Si me pasaron cualquier fruta como dominio, fuerzo el predeterminado
			}
		} else {
			$domain = $provider->getMainDomain();
		}
	}
	if (!isset($_SESSION['uws_domain_id']))
		$_SESSION['uws_domain_id'] = $domain->getId();
	
    if (!isset($_SESSION['uws_client']))  $_SESSION['uws_client']= $domain->getAlias();

    //Cargo el usuario de la sesión o el anónimo si el mismo no está especificado
    if ($setUser = !isset($_SESSION['uws_user_id'])) {
        $user = $provider->getAnonymous();
    } else {
        $query = $this->orm->query('User')
                ->filterBy('id', '=', $_SESSION['uws_user_id'])
                ->filterBy('provider.id', '=', $provider->getId());
        $user = $query->findOne();
    }
    if ($user == false) throw new Exception('El usuario no existe');
    else if ($setUser) $_SESSION['uws_user_id']=$user->getId();
	
	//Genera el contexto
	$context = new ApplicationContext($this, $user, $provider, $domain);
	$this->context = $context;
	
	//$useragent=$_SERVER['HTTP_USER_AGENT'];
	//if (preg_match('/android.+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(di|rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($useragent,0,4)))
	
    //Cargo el entorno de Twig
	$twigDebug = $domain->getGlobal("twigDebug");
	$twigAutoReload = $domain->getGlobal("twigAutoReload");
    $loader = new Twig_Loader_Filesystem(array('templates/'.$domain->getAlias(), 'templates/default', 'templates'));
    $twig = new Twig_Environment($loader, array('cache'=>'cache', 'auto_reload'=>$twigAutoReload == "1", 'debug'=>$twigDebug == "1"));//TODO quitar DEBUG
    $twig->addExtension(new IPlanExtension($this));
//    $twig->clearTemplateCache();

    //Carga los "módulos" o Facades...
    $facades = $provider->getFacades();
    foreach($facades as $facade) {
        require_once $facade->getFile();
    }

    
/* Esto debería hacerse en el CONTEXTO cuando se configure el SANDBOX, acá no es posible limitar las acciones
   del template.
    //Cargo los managers habilitados para el usuario al contexto
    $queryFacades = $this->orm->query('Facade')
                              ->filterBy('actions.profiles.users.id', '=', $user->getId())
                              ->filterBy('actions.profiles.provider.id', '=', $provider->getId());
    krumo($queryFacades->decrypt($queryFacades->build()));
    $enabledFacades = $queryFacades->find();
    krumo($enabledFacades);


    foreach($enabledFacades as $facade) {
  */
    
    foreach($facades as $facade) {
        $class   = $facade->getClass();
        $manager = new $class($this, $facade->getAlias());
		$manager->registerInfo($context);
        $context->addManager($facade->getAlias(), $manager);
    }
    $context->set('application_name', $provider->getName());

    $this->twig = $twig;
    return $this;
    // Bouml preserved body end 000A9405
  }

  /**
   * Resetea los datos de sesi�n y vuelve a cargar la informaci�n de la aplicaci�n (permisos, etc).
   * TODO: Este m�todo nunca deber�a ser tocado desde los templates.
   */
  public function reset($provider_id = null, $user_id = null)
  {
    // Bouml preserved body begin 000C5205
    session_destroy();
	header('Location: '.$this->context->getDomain()->getBaseURL());
	exit(0);
    // Bouml preserved body end 000C5205
  }

  /**
   * Devuelve la aplicaci�n actual o, en caso de no existir, genera una nueva.
   * 
   * @return Application La instancia de la aplicaci�n
   */
  public static function getInstance()
  {
    // Bouml preserved body begin 000A9485
    if (is_null(self::$instance)) {
        self::$instance = new Application();
    }
    return self::$instance;
    // Bouml preserved body end 000A9485
  }

  /**
   * Recupera el contexto de la aplicaci�n.
   * 
   * @return ApplicationContext El contexto de la aplicaci�n en curso
   */
  public function getContext()
  {
    // Bouml preserved body begin 000B6885
    return $this->context;
    // Bouml preserved body end 000B6885
  }

  /**
   * Recupera un parámetro pasado al script.
   * 
   * @param string $name el nombre del parámetro
   * @param mixed $default el valor a devolver en caso que el parámetro no se encuentre
   * @param string $where un string que indica en qué contexto buscar: P=POST, G=GET, A=Argument, R=REQUEST, F=FILES. Inicialmente viene preconfigurado para usarse en un entorno web.
   * 
   * @return mixed El valor recuperado
   */
  public function getParam($name, $default = null, $where = 'PGRF')
  {
    // Bouml preserved body begin 000A5D85
    $where = strtoupper($where);
    for($i=0; $i<strlen($where); $i++) {
        switch($where[$i]) {
            case 'P': if (isset($_POST[$name])) return $_POST[$name]; break;
            case 'G': if (isset($_GET[$name])) return $_GET[$name]; break;
            case 'R': if (isset($_REQUEST[$name])) return $_REQUEST[$name]; break;
            case 'F': if (isset($_FILES[$name])) {
							if (($_FILES[$name]['size']>0) || ($_FILES[$name]['name'] != ""))
								return $_FILES[$name];
					} 
					break;
            case 'A': if (isset($argv) && isset($argv[$name])) return $argv[$name]; break;
            default:
                throw new Exception("Error al recuperar parámetro $name en ".  strtoupper($where));
        }
    }
    return $default;
    // Bouml preserved body end 000A5D85
  }

  /**
   * Recupera el ORM de la aplicaci�n.
   * 
   * @return ORM El ORM de la aplicaci�n.
   */
  public function getORM()
  {
    // Bouml preserved body begin 000B6805
    return $this->orm;
    // Bouml preserved body end 000B6805
  }

  /**
   * Devuelve la acci�n que se est� ejecutando.
   * 
   * @return Action La acci�n en curso.
   */
  final public function getCurrentAction()
  {
    return $this->currentAction;
  }

  /**
   * Verifica qué se debe hacer según los parámetros de la URL.
   * @param Boolean $isAjax indica si el código debe ser devuelto como código Ajax o como HTML
   * @return boolean True si todo anda bien, False sino.
   */
  public function parseParams($isAjax)
  {
    // Bouml preserved body begin 000A5C85
    
	if ($this->context->getUser()->getForcePasswordChange()) {
		$urlCode = $this->getParam('action', null,'PG');
		if ($urlCode != "logout") {
			$urlCode = "passChange";
		}
	} else {
		$urlCode = $this->getParam('action', 'default','PG');
	}
    $actionQuery = $this->orm->query('Action')
                   ->filterBy('urlCode', '=', $urlCode)
                   ->filterBy('profiles.provider.id', '=', $this->context->getProvider()->getId())
                   ->filterBy('profiles.domains.id', '=', $this->context->getDomain()->getId())
                   ->filterBy('profiles.users.id', '=', $this->context->getUser()->getId())
                   ->orderBy('id ASC');
	//krumo(Utils::debugQuery($actionQuery));
    $action = $actionQuery->findOne();
	/* @var $action Action */
	// ((($urlCode === "login") || ($urlCode === "logout")) ||  
	if (($action === false) && (($this->context->getUser()->getId() == $this->context->getProvider()->getAnonymous()->getId()))) {
		$actionQuery = $this->orm->query('Action')
                   ->filterBy('urlCode', '=', 'login')
                   ->filterBy('profiles.provider.id', '=', $this->context->getProvider()->getId())
                   ->filterBy('profiles.domains.id', '=', $this->context->getDomain()->getId())
                   ->orderBy('id ASC');
		$action = $actionQuery->findOne();
	}
	if (($action === false) && (($this->context->getUser()->getId() != $this->context->getProvider()->getAnonymous()->getId())) && ($urlCode === "login")) {
		$actionQuery = $this->orm->query('Action')
                   ->filterBy('urlCode', '=', 'default')
                   ->filterBy('profiles.provider.id', '=', $this->context->getProvider()->getId())
                   ->filterBy('profiles.domains.id', '=', $this->context->getDomain()->getId())
                   ->orderBy('id ASC');
		$action = $actionQuery->findOne();
	}
    if ($action == FALSE) {
        $renderable = new Renderable("lib/show_errors.xhtml");
        $errors['title']="Error de acceso";
        $errors['messages'][0]['description']='El usuario "'.$this->context->getUser()->getUsername()."\" no tiene permisos para ejecutar: $urlCode";
        $this->context->set('errors', $errors);
    } else {
		$this->currentAction = $action;
		$this->context->set('currentAction', $action->getFacade()->getAlias().".".$action->getAlias());
        $managerInstance = $this->context->getManager($action->getFacade()->getAlias());
        $method = $action->getMethod();
        $this->context->set('AJAX', $isAjax);
        $renderable = $managerInstance->$method($this->context, $isAjax);
		$managerInstance->registerInfo($this->context);
		/* @var $renderable Renderable */
		
		/* Calculo las "crumbs" si es que existe */
		$qmenu = $this->orm->query('MenuLink')
						  ->filterBy('menu.action.id','=',$action->getId())
						  ->filterBy('menu.provider.id', '=', $this->context->getProvider()->getId())
						  ->filterBy('menu.action.profiles.users.id', '=', $this->context->getUser()->getId());
		$menuLink = $qmenu->findOne();
		/* @var $menuLink MenuLink */
		if ($menuLink) {
			while(!is_null($menuLink->getParent())) {
				if ($menuLink->getMenu()->getAction()) {//$menu->getAction()->getFacade()->getAlias().".".$menu->getAction()->getAlias()
					$crumbs[]=array($menuLink, $menuLink->getMenu()->getName());
				}
				$menuLink = $menuLink->getParent();
			}
		}
		$crumbs[]=array('Security.defaultPage', 'Home');
		/*if ($this->getParam("openAs") == "popup") {
			$renderable->setDownlodeable(true);
		} else {*/
			$this->context->set('crumbs',  array_reverse($crumbs));
		/*}*/
    }

    if ($renderable) {
		$headers = $renderable->getHeaders();
		if ($headers != null) {
			foreach ($headers as $type => $value)
				header("$type: $value");
		}
        $template_file=$renderable->getTemplate();
		if ($template_file != null) {
			if ($isAjax || $renderable->isDownlodeable()) {
				$template = $this->twig->loadTemplate($template_file);
			} else {
				if ($this->getParam("openAs") == "popup") {
					$template = $this->twig->loadTemplate("popup.xhtml");
				} else {
					$template = $this->twig->loadTemplate("index.xhtml");
					//header('Content-Type: application/xhtml+xml');
				}
				$this->context->set('MainContent', $template_file);
			}
			$template->display($this->context->toTwigArguments());
			$isForIFrame = $this->getParam('UWS_IFRAME', null);
			if (!is_null($isForIFrame)) {
				echo '<script id="UWS_RETURN_SCRIPT" language="javascript" type="text/javascript">window.top.window.uws_moveContent(\''.$isForIFrame.'\')</script>';
			}			
		} else {
			echo $renderable->getContent();
		}
    }
    // Bouml preserved body end 000A5C85
  }

  /**
   * Ejecuta una acción en base a su codificación de alias.
   * 
   * @param string $action la acción codificada como FacadeAlias.ActionAlias
   * 
   * @return boolean un TRUE si todo funcionó o FALSE si no.
   */
  public function execute($action)
  {
    // Bouml preserved body begin 001A1E05
	if (strpos($action, ".")) { //Si no tiene Alias.Action está mal
		$parts = explode('.', $action);
		if (count($parts)==2) {
			$facadeAlias = $parts[0];
			$actionAlias = $parts[1];
		} else {
			throw new Exception('La accción debe expresarse como FacadeAlias.ActionAlias'); //No hay 2 partes
		}
	} else return false; // No hay punto
	
    $urlCode = $this->getParam('action', 'default','PG');
    $actionQuery = $this->orm->query('Action')
                   ->filterBy('alias', '=', $actionAlias)
                   ->filterBy('facade.alias', '=', $facadeAlias)
                   ->filterBy('profiles.provider.id', '=', $this->context->getProvider()->getId())
                   ->filterBy('profiles.domains.id', '=', $this->context->getDomain()->getId())
                   ->filterBy('profiles.users.id', '=', $this->context->getUser()->getId())
                   ->orderBy('id ASC');
    $actionObj = $actionQuery->findOne();
	
	if ($actionObj == false) return false; //Si no existe la acción o no tiene permiso
	
	$this->currentAction = $actionObj;
	$this->context->set('currentAction', $action);
	$managerInstance = $this->context->getManager($actionObj->getFacade()->getAlias());
	$method = $actionObj->getMethod();
	$this->context->set('AJAX', false);
	$renderable = $managerInstance->$method($this->context, false);
	$managerInstance->registerInfo($this->context);
	/* @var $renderable Renderable */

    return $renderable;
    // Bouml preserved body end 001A1E05
  }

  /**
   * Destruye las variables de sesi�n.
   * Nota: La sesi�n se destruye pero SE CREA de nuevo inmediatamente y se guarda el id del Provider.
   * 
   * @return boolean un boleano indicando con TRUE que la operaci�n fue realizada con �xito
   */
  public function destroy_session()
  {
    // Bouml preserved body begin 000BB685
    if (session_destroy()) {
        session_start();
        $_SESSION['provider_id']=$this->context->getProvider()->getId();
        return true;
    } else return false;
    // Bouml preserved body end 000BB685
  }

  /**
   * Recupera una acci�n (si es que est� permitida) a trav�s de su representaci�n en string.
   * 
   * @param string $actionAlias una cadena de texto con la forma "FacadeAlias.ActionAlias"
   * 
   * @return Action La acci�n que responde a ese alias o null si la misma no existe o no est� permitida.
   */
  public function getActionByAlias($actionAlias)
  {
    // Bouml preserved body begin 0013A285
	$iPlanExtension = $this->twig->getExtension('IPlan');
	/*@var $iPlanExtension IPlanExtension */
	return $iPlanExtension->getActionByAlias($actionAlias);
	
	/*
	 * Esta función se implementó, junto con la correspondiente de IPlanExtension,
	 * para facilitar la gestión de los ActionButtons de los listados y para que
	 * ese cálculo no se desaproveche, dejando los resultados ya en la caché de
	 * IPlanExtension y ahorrando querys.
	 */
	
    // Bouml preserved body end 0013A285
  }

  /**
   * ATENCI�N: DROPEA TODAS LAS TABLAS, RELACIONES, CONTRAINTS Y GENERADORES.
   * 
   * M�todo para generar los valores iniciales en las tablas:
   * - Usuarios: Admin, Client
   * - Profiles: Administrator, Client
   * - Actions: Login, Logout
   * - Facades: GeneralManager, UserManager
   * 
   * @return boolean retorna true para el caso que todo salga bien
   */
  public static function install()
  {
    // Bouml preserved body begin 000A9505

    /********************             DROPS              ********************/
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_ACTION CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_ACTION');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_FACADE CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_FACADE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROFILE CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROFILE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROFILE_ACTION CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROFILE_ACTION');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROFILE_MENU CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROFILE_MENU');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_USER CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_USER');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_MENU CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_MENU CASCADE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROVIDER_USER CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROVIDER_USER');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_USER_PROFILE CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_USER_PROFILE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROVIDER_FACADE CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROVIDER_FACADE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROVIDER CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROVIDER');
	//$sql[]=array("begin execute immediate 'DROP TABLE RECURSOS_SERVICEPROVIDER CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando RECURSOS_LICENCIATARIO');
	//$sql[]=array("begin execute immediate 'DROP TABLE SERVICE_PROVIDER CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando SERVICE_PROVIDER');
	//$sql[]=array("begin execute immediate 'DROP TABLE RECURSOS CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando RECURSOS');
//JAV	$sql[]=array("begin execute immediate 'DROP TABLE BLOQUES CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando BLOQUES');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_ACTION'; exception when others then null;end;", 'Borrando secuencia UWS_USER_PROFILE');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_FACADE'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_FACADE');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_PROFILE'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_PROFILE');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_USER'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_USER');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_PROVIDER'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_PROVIDER');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_MENU'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_MENU');
	//$sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_SERVICE_PROVIDER'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_MENU');
	//$sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_RECURSOS'; exception when others then null;end;", 'Borrando secuencia SEQ_RECURSOS');
//JAV	$sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_BLOQUES'; exception when others then null;end;", 'Borrando secuencia SEQ_BLOQUES');

    /********************             TABLAS Y PK              ********************/
    $sql[]=array('CREATE TABLE UWS_ACTION
               ( 
                ACTION_ID NUMBER  NOT NULL , 
                ACTION_NAME VARCHAR2 (30)  NOT NULL , 
                ACTION_DESCRIPTION VARCHAR2 (2048) , 
				ACTION_ALIAS VARCHAR2 (25) NOT NULL , 
                ACTION_METHOD VARCHAR2 (25)  , 
                ACTION_URL_CODE VARCHAR2 (25)  NOT NULL ,
                ACTION_HINT VARCHAR2 (40) , 
                ACTION_ICON VARCHAR2 (255) , 
                ACTION_PARAMS VARCHAR2 (255) , 
                ACTION_AJAX NUMERIC(1), 
                FACADE_ID NUMBER  NOT NULL 
               ) LOGGING ', 'Creando UWS_ACTION');
    $sql[]=array('ALTER TABLE UWS_ACTION
               ADD CONSTRAINT UWS_ACTION_PK PRIMARY KEY ( ACTION_ID ) ', '--->Estableciendo clave primaria ACTION_ID');
    $sql[]=array('CREATE TABLE UWS_FACADE
                ( 
                FACADE_ID NUMBER  NOT NULL ,
                FACADE_CLASS VARCHAR2 (50)  NOT NULL ,
                FACADE_FILE VARCHAR2 (255)  NOT NULL ,
                FACADE_ALIAS VARCHAR2 (25)  NOT NULL
               ) LOGGING', 'Creando UWS_FACADE');
    $sql[]=array('ALTER TABLE UWS_FACADE
                ADD CONSTRAINT UWS_FACADE_PK PRIMARY KEY ( FACADE_ID )', '--->Estableciendo clave primaria FACADE_ID');
    $sql[]=array('CREATE TABLE UWS_PROFILE
            (
             PROFILE_ID NUMBER  NOT NULL ,
             PROFILE_NAME VARCHAR2 (50)  NOT NULL ,
             PROFILE_DESCRIPTION VARCHAR2 (2048),
			 PROFILE_WELCOME VARCHAR2 (200),
             PROVIDER_ID NUMBER  NOT NULL 
            ) LOGGING', 'Creando UWS_PROFILE');
    $sql[]=array('ALTER TABLE UWS_PROFILE
            ADD CONSTRAINT UWS_PROFILE_PK PRIMARY KEY ( PROFILE_ID ) ', '--->Estableciendo clave primaria PROFILE_ID');
    $sql[]=array('CREATE TABLE UWS_PROFILE_ACTION
            (
             PROFILE_ID NUMBER  NOT NULL ,
             ACTION_ID NUMBER  NOT NULL
            ) LOGGING', 'Creando UWS_PROFILE_ACTION');
    $sql[]=array('ALTER TABLE UWS_PROFILE_ACTION
            ADD CONSTRAINT UWS_PROFILE_ACTION_PK PRIMARY KEY ( PROFILE_ID, ACTION_ID ) ', '--->Estableciendo clave primaria  ( PROFILE_ID, ACTION_ID )');
    $sql[]=array('CREATE TABLE UWS_PROVIDER
            (
             PROVIDER_ID NUMBER  NOT NULL ,
             PROVIDER_NAME VARCHAR2 (25)  NOT NULL ,
             PROVIDER_ALIAS VARCHAR2 (25)  NOT NULL ,
             PROVIDER_URL VARCHAR2 (255)  NOT NULL,
			 PROVIDER_PAGEROWS NUMBER NOT NULL,
			 PROVIDER_MAXFETCH NUMBER NOT NULL,
             ANONYMOUS_ID NUMBER ,
             PROVIDER_OWNER NUMBER,
			 PROVIDER_USE_LU NUMBER(1,0)
            )', 'Creando UWS_PROVIDER');
    $sql[]=array('ALTER TABLE UWS_PROVIDER
            ADD CONSTRAINT UWS_PROVIDER_PK PRIMARY KEY ( PROVIDER_ID )', '--->Estableciendo clave primaria PROVIDER_ID');
    $sql[]=array('CREATE TABLE UWS_PROVIDER_FACADE
            (
             PROVIDER_ID NUMBER  NOT NULL ,
             FACADE_ID NUMBER  NOT NULL
            ) ', 'Creando UWS_PROVIDER_FACADE');
    $sql[]=array('ALTER TABLE UWS_PROVIDER_FACADE
            ADD CONSTRAINT UWS_PROVIDER_FACADE_PK PRIMARY KEY ( PROVIDER_ID, FACADE_ID )', '--->Estableciendo clave primaria (PROVIDER_ID, FACADE_ID)');
    $sql[]=array('CREATE TABLE UWS_USER
            (
             USER_ID NUMBER  NOT NULL ,
             USER_USERNAME VARCHAR2 (25) ,
             USER_PASSWORD VARCHAR2 (40 CHAR) ,
             USER_NAME VARCHAR2 (25) ,
             USER_SURNAME VARCHAR2 (25),
             PROVIDER_ID NUMBER  NOT NULL ,
			 USER_LOGINUNIFICADO NUMBER(1) ,
			 USER_LOGINUNIFICADOREFRESH NUMBER(1) ,
			 USER_STATUS NUMBER(1) DEFAULT 0 NOT NULL ,
			 USER_MAIL VARCHAR2 (255 CHAR) 

            ) LOGGING', 'Creando UWS_USER');
    $sql[]=array('ALTER TABLE UWS_USER
            ADD CONSTRAINT UWS_USER_PK PRIMARY KEY ( USER_ID )', '--->Estableciendo clave primaria USER_ID');
    $sql[]=array('CREATE TABLE UWS_USER_PROFILE
            (
             USER_ID NUMBER  NOT NULL ,
             PROFILE_ID NUMBER  NOT NULL
            ) LOGGING', 'Creando UWS_USER_PROFILE');
    $sql[]=array('ALTER TABLE UWS_USER_PROFILE
            ADD CONSTRAINT UWS_USER_PROFILE_PK PRIMARY KEY ( USER_ID, PROFILE_ID )', '--->Estableciendo clave primaria ( USER_ID, PROFILE_ID )');
    $sql[]=array('CREATE TABLE UWS_MENU
            (
             MENU_ID NUMBER  NOT NULL ,
             MENU_NAME VARCHAR2 (25)  NOT NULL ,
             MENU_PARAMS VARCHAR2 (255) ,
             MENU_ICON VARCHAR2 (40) ,
             ACTION_ID NUMBER,
             MENU_PARENT NUMBER,
             MENU_ORDER NUMBER (2),
             MENU_DYNAMIC SMALLINT  NOT NULL ,
             MENU_VISIBLE SMALLINT  NOT NULL ,
             PROVIDER_ID NUMBER  NOT NULL
            )', 'Creando UWS_MENU');
    $sql[]=array('ALTER TABLE UWS_MENU
            ADD CONSTRAINT UWS_MENU_PK PRIMARY KEY ( MENU_ID )', '--->Estableciendo clave primaria MENU_ID');
	

    $sql[]=array('CREATE TABLE UWS_PROFILE_MENU
            (
             PROFILE_ID NUMBER  NOT NULL ,
             MENU_ID NUMBER  NOT NULL
            ) LOGGING', 'Creando UWS_PROFILE_MENU');
    $sql[]=array('ALTER TABLE UWS_PROFILE_MENU
            ADD CONSTRAINT UWS_PROFILE_MENU_PK PRIMARY KEY ( PROFILE_ID, MENU_ID )', '--->Estableciendo clave primaria ( PROFILE_ID, MENU_ID )');

	
	/*$sql[]=array('CREATE TABLE SERVICE_PROVIDER 
			(
			  SERVICEPROVIDER_ID NUMBER(8, 0) NOT NULL ,
			  DESCRIPCION VARCHAR2(255) ,
			  IDENTIFICADOR VARCHAR2(255) ,
			  LICENCIATARIO_ID NUMBER(8, 0) 
            )', 'Creando SERVICE_PROVIDER');
    $sql[]=array('ALTER TABLE SERVICE_PROVIDER
            ADD CONSTRAINT SERVICE_PROVIDER_PK PRIMARY KEY ( SERVICEPROVIDER_ID )', '--->Estableciendo clave primaria SERVICEPROVIDER_ID');
	*/
	/*$sql[]=array('CREATE TABLE RECURSOS
			(
			  RECURSO_ID NUMBER(8, 0) NOT NULL ,
			  DESCRIPCION VARCHAR2(255) ,
			  CAMPO VARCHAR2(255)
            )', 'Creando RECURSOS');*/
	
    /*$sql[]=array('ALTER TABLE RECURSOS
            ADD CONSTRAINT RECURSOS_PK PRIMARY KEY ( RECURSO_ID )', '--->Estableciendo clave primaria RECURSO_ID');*/
	
	/*$sql[]=array('CREATE TABLE RECURSOS_SERVICEPROVIDER
			(
			  RECURSO_ID NUMBER(8, 0) NOT NULL ,
			  SERVICEPROVIDER_ID NUMBER(8, 0) 
            )', 'Creando RECURSOS_SERVICEPROVIDER');*/
	
	
	/*
	 * 
	 * Referencial entre tipo de licencia y licenciatario
	 
	$sql[]=array('CREATE TABLE TIPOLICENCIA_SERVICE_PROVIDER
			(
			  T_LICENCIA_ID NUMBER(8, 0) NOT NULL ,
			  SERVICEPROVIDER_ID NUMBER(8, 0) NOT NULL
            )', 'Creando TIPOLICENCIA_LICENCIATARIO');*/
	
	
	/*CREATE TABLE  
(
  BLOQUE_ID NUMBER NOT NULL 
, FROM_NUMBER VARCHAR2(20) NOT NULL 
, TO_NUMBER VARCHAR2(20) NOT NULL 
, RESELLER_ID NUMBER 
, CONSTRAINT BLOQUES_PK PRIMARY KEY 
  (
    BLOQUE_ID 
  )
  ENABLE 
);

	 */
	
/* JAV	
	$sql[]=array('CREATE TABLE BLOQUES
			(
			  BLOQUE_ID NUMBER(8, 0) NOT NULL ,
			  FROM_NUMBER VARCHAR2(20) NOT NULL ,
			  TO_NUMBER VARCHAR2(20) NOT NULL ,
			  LICENCIATARIO_ID NUMBER (8, 0)
			  
            )', 'Creando BLOQUES');
	$sql[]=array('ALTER TABLE BLOQUES
            ADD CONSTRAINT BLOQUES_PK PRIMARY KEY ( BLOQUE_ID )', '--->Estableciendo clave primaria BLOQUE_ID');
	$sql[]=array('ALTER TABLE BLOQUES
            ADD CONSTRAINT BLOQUES_FK1 FOREIGN KEY
            (
             LICENCIATARIO_ID
            )
            REFERENCES LICENCIATARIO
            (
             LICENCIATARIO_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea BLOQUES.LICENCIATARIO_ID');
FIN JAV */	
	
    /*$sql[]=array('ALTER TABLE RECURSOS_SERVICEPROVIDER
            ADD CONSTRAINT RECURSOS_SERVICEPROVIDER_PK PRIMARY KEY ( RECURSO_ID, SERVICEPROVIDER_ID )', '--->Estableciendo clave primaria RECURSO_ID, SERVICEPROVIDER_ID');
	*/
	
	
	/*$sql[]=array('ALTER TABLE RECURSOS_SERVICEPROVIDER
            ADD CONSTRAINT REC_SERV_FK1 FOREIGN KEY
            (
             SERVICEPROVIDER_ID
            )
            REFERENCES SERVICE_PROVIDER
            (
             SERVICEPROVIDER_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea RECURSOS_SERVICEPROVIDER.SERVICEPROVIDER_ID');*/
	
	/*$sql[]=array('ALTER TABLE RECURSOS_SERVICEPROVIDER
            ADD CONSTRAINT REC_SERV_FK2 FOREIGN KEY
            (
             RECURSO_ID
            )
            REFERENCES RECURSOS
            (
             RECURSO_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea RECURSOS_SERVICEPROVIDER.RECURSO_ID');*/
	
	
	/*
	 * Referencial entre tipo de licencia y licenciatario
	 * 
	 * $sql[]=array('ALTER TABLE TIPOLICENCIA_SERVICE_PROVIDER
            ADD CONSTRAINT TL_LICEN_FK1 FOREIGN KEY
            (
             SERVICEPROVIDER_ID
            )
            REFERENCES SERVICE_PROVIDER
            (
             SERVICEPROVIDER_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea TIPOLICENCIA_SERVICE_PROVIDER.SERVICEPROVIDER_ID');
	
	$sql[]=array('ALTER TABLE TIPOLICENCIA_SERVICE_PROVIDER
            ADD CONSTRAINT TL_LICEN_FK2 FOREIGN KEY
            (
             T_LICENCIA_ID
            )
            REFERENCES TIPOLICENCIA
            (
             T_LICENCIA_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea TIPOLICENCIA_SERVICE_PROVIDER.T_LICENCIA_ID');*/
	
	/*$sql[]=array('ALTER TABLE SERVICE_PROVIDER
            ADD CONSTRAINT SERV_PROV_LICEN_FK FOREIGN KEY
            (
             LICENCIATARIO_ID
            )
            REFERENCES LICENCIATARIO
            (
             LICENCIATARIO_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea SERVICE_PROVIDER.LICENCIATARIO_ID');*/
//    $sql[]=array('CREATE TABLE UWS_PROVIDER_USER
//            (
//             PROVIDER_ID NUMBER  NOT NULL ,
//             USER_ID NUMBER  NOT NULL
//            )', 'Creando UWS_PROVIDER_USER');
//    $sql[]=array('ALTER TABLE UWS_PROVIDER_USER
//    ADD CONSTRAINT UWS_PROVIDER_USER_PK PRIMARY KEY ( PROVIDER_ID, USER_ID )', '--->Estableciendo clave primaria (PROVIDER_ID, USER_ID)');
    $sql[]=array('ALTER TABLE UWS_ACTION
            ADD CONSTRAINT UWS_ACTION_UWS_FACADE_FK FOREIGN KEY
            (
             FACADE_ID
            )
            REFERENCES UWS_FACADE
            (
             FACADE_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_ACTION.FACADE_ID');
    $sql[]=array('ALTER TABLE UWS_PROFILE_ACTION
            ADD CONSTRAINT UWS_PROFILE_ACTION_ACTION FOREIGN KEY
            (
             ACTION_ID
            )
            REFERENCES UWS_ACTION
            (
             ACTION_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_PROFILE_ACTION.ACTION_ID');
    $sql[]=array('ALTER TABLE UWS_PROFILE_ACTION
            ADD CONSTRAINT UWS_PROFILE_ACTION_PROFILE FOREIGN KEY
            (
             PROFILE_ID
            )
            REFERENCES UWS_PROFILE
            (
             PROFILE_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_PROFILE_ACTION.PROFILE_ID');
    $sql[]=array('ALTER TABLE UWS_USER_PROFILE
            ADD CONSTRAINT UWS_USER_PROFILE_PROFILE FOREIGN KEY
            (
             PROFILE_ID
            )
            REFERENCES UWS_PROFILE
            (
             PROFILE_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_USER_PROFILE.PROFILE_ID');
    $sql[]=array('ALTER TABLE UWS_USER_PROFILE
            ADD CONSTRAINT UWS_USER_PROFILE_USER FOREIGN KEY
            (
             USER_ID
            )
            REFERENCES UWS_USER
            (
             USER_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_USER_PROFILE.USER_ID');
    $sql[]=array('ALTER TABLE UWS_USER
            ADD CONSTRAINT UWS_USER_PROVIDER_ID_FK FOREIGN KEY
            (
             PROVIDER_ID
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            )', 'Creando clave for&aacute;nea UWS_USER.PROVIDER_ID');
    $sql[]=array('ALTER TABLE UWS_PROVIDER
            ADD CONSTRAINT UWS_PROVIDER_UWS_USER_FK FOREIGN KEY
            (
             ANONYMOUS_ID
            )
            REFERENCES UWS_USER
            (
             USER_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROVIDER.ANONYMOUS_ID');
    $sql[]=array('ALTER TABLE UWS_PROVIDER
            ADD CONSTRAINT UWS_PROVIDER_PROVIDER_FK FOREIGN KEY
            (
             PROVIDER_OWNER
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROVIDER.PROVIDER_OWNER');
    $sql[]=array('ALTER TABLE UWS_PROVIDER_FACADE
            ADD CONSTRAINT UWS_PROVIDER_FACADE_FK FOREIGN KEY
            (
             FACADE_ID
            )
            REFERENCES UWS_FACADE
            ( 
             FACADE_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROVIDER_FACADE.FACADE_ID');
    $sql[]=array('ALTER TABLE UWS_PROVIDER_FACADE
            ADD CONSTRAINT UWS_PROVIDER_FACADE_FK2 FOREIGN KEY
            (
             PROVIDER_ID
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROVIDER_FACADE.PROVIDER_ID');
    $sql[]=array('ALTER TABLE UWS_PROFILE
            ADD CONSTRAINT PROVIDER_ID FOREIGN KEY
            ( 
             PROVIDER_ID
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROFILE.PROVIDER_ID');
    $sql[]=array('ALTER TABLE UWS_MENU
            ADD CONSTRAINT UWS_MENU_ACTION FOREIGN KEY
            (
             ACTION_ID
            )
            REFERENCES UWS_ACTION
            (
             ACTION_ID
            )  ', 'Creando clave for&aacute;nea UWS_MENU.ACTION_ID');
    $sql[]=array('ALTER TABLE UWS_MENU
            ADD CONSTRAINT UWS_MENU_PARENT_FK FOREIGN KEY
            (
             MENU_PARENT
            )
            REFERENCES UWS_MENU
            (
             MENU_ID
            ) ', 'Creando clave for&aacute;nea UWS_MENU.MENU_PARENT');
    $sql[]=array('ALTER TABLE UWS_MENU
            ADD CONSTRAINT UWS_MENU_PROVIDER_FK FOREIGN KEY
            (
             PROVIDER_ID
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            ) ', 'Creando clave for&aacute;nea UWS_MENU.PROVIDER_ID');
    $sql[]=array('ALTER TABLE UWS_PROFILE_MENU
            ADD CONSTRAINT UWS_MENU_PROFILE_FK FOREIGN KEY
            (
             MENU_ID
            )
            REFERENCES UWS_MENU
            (
             MENU_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROFILE_MENU.MENU_ID');
    $sql[]=array('ALTER TABLE UWS_PROFILE_MENU
            ADD CONSTRAINT UWS_PROFILE_PROFILE_FK FOREIGN KEY
            (
             PROFILE_ID
            )
            REFERENCES UWS_PROFILE
            (
             PROFILE_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROFILE_MENU.PROFILE_ID');
    /********************             SECUENCIAS              ********************/
	/*$sql[]=array('CREATE SEQUENCE SEQ_RECURSOS
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_RECURSOS');*/
	/*$sql[]=array('CREATE SEQUENCE SEQ_SERVICE_PROVIDER
            START WITH 10
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_SERVICE_PROVIDER');*/
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_ACTION
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_ACTION');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_FACADE
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_FACADE');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_PROFILE
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_PROFILE');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_USER
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_USER');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_PROVIDER
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_PROVIDER');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_MENU
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_MENU');
/* JAV
	$sql[]=array('CREATE SEQUENCE SEQ_BLOQUES
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_BLOQUES');

FIN JAV  */
    require_once('iplan/database/OracleConnection.php');
	//Maqueta
	//$conn = new OracleConnection("172.16.213.28", 1521, "sswmc", "ADMIN_IUNI", "wholesale2010");
	$connection = new OracleConnection("ADMIN_IUNI", "wholesale2010", "SSWMC");
	//Data Guard
	// $conn = new OracleConnection("172.16.57.25", 1521, "AUTOPROPDB_dguard", "ADMIN_IUNI", "wholesale2010");
	//$connection = new OracleConnection("ADMIN_IUNI", "wholesale2010", "AUTOPROPDB");
    $conn->connect();
    echo "<html><head><title>Instalaci&oacute;n autom&aacute;tica</title></head><body><h1>Instalaci&oacute;n</h1><h2>Creaci&oacute;n de Estructura</h2><pre>";
    foreach($sql as $queryDesc) {
        echo str_pad($queryDesc[1], 80, '.',STR_PAD_RIGHT);
        if ($conn->execute($queryDesc[0])) {
            echo str_pad('OK', 5, ' ',STR_PAD_LEFT)."<br>";
        } else {
            echo str_pad('ERROR', 5, ' ',STR_PAD_LEFT);
            return false;
        }
    }
    echo "</pre><h2>Inicializando Datos del Sistema</h2><pre>";
    $orm = ORM::getInstance();
    $orm->setDatabase(new OracleDatabase());

    /***********************             DATOS              ***********************/
    //Se general la instancia del Manager para imprimir texto con escapeo automático
    require_once "iplan/security/GeneralManager.php";
    $generalManager = new GeneralManager($this, 'Application');

    //Crear Proveedores
    echo "<br><b>Proveedores de Servicios</b><br>";
    $iplanProvider = new Provider($orm);
    $iplanProvider->setName('IPlan S.A.')
                  ->setAlias('iplan')
                  ->setBaseURL('http://iuniwholesale.iplantech.com.ar/');
    $clientProvider = new Provider($orm);
    $clientProvider->setName('Cliente de Prueba')
                  ->setAlias('client1')
                  ->setBaseURL('http://localhost/wholesale/')
                  ->setOwner($iplanProvider);
	$localhostProvider = new Provider($orm);
    $localhostProvider->setName('Localhostero')
                  ->setAlias('default')
                  ->setBaseURL('http://localhost/wholesale/')
				  ->setOwner($iplanProvider)
				  ->setPageRows(10);
    $iplanProvider->save(); echo "Creado el proveedor ".$iplanProvider->getName()."<br/>";
	$localhostProvider->save(); echo "Creado el proveedor ".$localhostProvider->getName()."<br/>";
	$clientProvider->save(); echo "Creado el proveedor ".$clientProvider->getName()."<br/>";

    //Facades
    echo "<b>Facades</b><br>";
    $securityFacade = new Facade($orm);
    $securityFacade->setClass('SecurityManager')
                   ->setFile('iplan/security/SecurityManager.php')
                   ->setAlias('Security')
                   ->addProvider($iplanProvider)
                   ->addProvider($clientProvider)
				   ->addProvider($localhostProvider);
    $generalFacade = new Facade($orm);
    $generalFacade->setClass('GeneralManager')
                  ->setFile('iplan/security/GeneralManager.php')
                  ->setAlias('Application')
                  ->addProvider($iplanProvider)
                  ->addProvider($clientProvider)
				  ->addProvider($localhostProvider);
	$wholesaleFacade = new Facade($orm);
    $wholesaleFacade->setClass('WholesaleManager')
                    ->setFile('iplan/models/wholesale/WholesaleManager.php')
                    ->setAlias('Wholesale')
                    ->addProvider($iplanProvider)
                    ->addProvider($clientProvider)
				    ->addProvider($localhostProvider);
	$autoProvisioningFacade = new Facade($orm);
    $autoProvisioningFacade->setClass('ProvisioningManager')
                    ->setFile('iplan/models/provisioning/ProvisioningManager.php')
                    ->setAlias('AutoProvisioning')
                    ->addProvider($iplanProvider)
                    ->addProvider($clientProvider)
				    ->addProvider($localhostProvider);
    $orm->save($securityFacade); echo $generalManager->toHTML("Creado registro de Facade SecurityManager (con su relación con IPlan y Client Providers)")."<br>";
    $orm->save($generalFacade);  echo $generalManager->toHTML("Creado registro de Facade GeneralManager  (con su relación con IPlan y Client Providers)")."<br>";
	$orm->save($wholesaleFacade);  echo $generalManager->toHTML("Creado registro de Facade WholesaleManager  (con su relación con IPlan y Client Providers)")."<br>";
	$orm->save($autoProvisioningFacade);  echo $generalManager->toHTML("Creado registro de Facade ProvisioingManager (con su relación con IPlan y Client Providers)")."<br>";

    //Profiles
    echo "<br><b>Perfiles</b><br>";
    $adminProfile = new Profile($orm);
    $adminProfile->setName('Administrador de Sitio - iPlan')
                 ->setDescription('Perfil del administrador del sitio')
                 ->setProvider($iplanProvider);
    $registeredProfile = new Profile($orm);
    $registeredProfile->setName('Usuarios Registrados - iPlan')
                 ->setDescription('Perfil de los usuarios registrados del sitio')
                 ->setProvider($iplanProvider);
    $anonymuosProfile = new Profile($orm);
    $anonymuosProfile->setName('Usuarios Anónimos - iPlan')
                 ->setDescription('Perfil de los usuarios anónimos o no registrados')
                 ->setProvider($iplanProvider);
    $orm->save($adminProfile);      echo "Creando perfil de Administrador (para iPlan)<br>";
    $orm->save($registeredProfile); echo "Creando perfil de Usuarios Registrados (para iPlan)<br>";
    $orm->save($anonymuosProfile);  echo "Creando perfil An&oacute;nimo (para iPlan)<br>";
    
    $adminProfile2 = new Profile($orm);
    $adminProfile2->setName('Administrador de Sitio - Client')
                 ->setDescription('Perfil del administrador del sitio')
                 ->setProvider($clientProvider);
    $registeredProfile2 = new Profile($orm);
    $registeredProfile2->setName('Usuarios Registrados - Client')
                 ->setDescription('Perfil de los usuarios registrados del sitio')
                 ->setProvider($clientProvider);
    $anonymuosProfile2 = new Profile($orm);
    $anonymuosProfile2->setName('Usuarios Anónimos - Client')
                 ->setDescription('Perfil de los usuarios anónimos o no registrados')
                 ->setProvider($clientProvider);
    $orm->save($adminProfile2);      echo "Creando perfil de Administrador (para Client)<br>";
    $orm->save($registeredProfile2); echo "Creando perfil de Usuarios Registrados (para Client)<br>";
    $orm->save($anonymuosProfile2);  echo "Creando perfil An&oacute;nimo (para Client)<br>";
	
	$adminProfile3 = new Profile($orm);
    $adminProfile3->setName('Administrador')
                 ->setDescription('Administradores')
                 ->setProvider($localhostProvider);
    $registeredProfile3 = new Profile($orm);
    $registeredProfile3->setName('Usuario comun')
                 ->setDescription('Usuarios comunes')
                 ->setProvider($localhostProvider);
    $anonymuosProfile3 = new Profile($orm);
    $anonymuosProfile3->setName('Usuario anónimo')
                 ->setDescription('Usuarios anónimos')
                 ->setProvider($localhostProvider);
    $orm->save($adminProfile3);      echo "Creando perfil de Administrador (para Localhostero)<br>";
    $orm->save($registeredProfile3); echo "Creando perfil de Usuarios Registrados (para Localhostero)<br>";
    $orm->save($anonymuosProfile3);  echo "Creando perfil An&oacute;nimo (para Localhostero)<br>";
	
	

    //Acciones
    echo "<br><b>Acciones</b><br>";
    $defaultAction = new Action($orm);
    $defaultAction->setName('Default Action')
                  ->setDescription('La acción predeterminada')
                  ->setAlias('defaultPage')
                  ->setMethod('defaultPage')
                  ->setUrlCode('default')
                  ->setHint('Página predeterminada')
                  ->setFacade($securityFacade);
    $loginAction = new Action($orm);
    $loginAction->setName('Login')
                  ->setDescription('Iniciar sesión o mostrar el formulario de inicio')
                  ->setAlias('login')
                  ->setMethod('login')
                  ->setUrlCode('login')
                  ->setHint('Iniciar sesión')
                  ->setFacade($securityFacade);
    $logoutAction = new Action($orm);
    $logoutAction->setName('Logout')
                  ->setDescription('Terminar la sesión')
                  ->setAlias('logout')
                  ->setMethod('logout')
                  ->setUrlCode('logout')
                  ->setHint('Finalizar la sesión')
                  ->setFacade($securityFacade);
    $mainAction = new Action($orm);
    $mainAction->setName('Main Page')
                  ->setDescription('Template de la página principal del sistema')
                  ->setAlias('mainPage')
                  ->setMethod('mainPage')
                  ->setUrlCode('main')
                  ->setHint('Página principal')
                  ->setFacade($securityFacade);
    $redirectAction = new Action($orm);
    $redirectAction->setName('Redirect')
                  ->setDescription('Redirige hacia otro sitio')
                  ->setAlias('redirect')
                  ->setMethod('redirect')
                  ->setUrlCode('goto')
                  ->setHint('')
                  ->setFacade($securityFacade);
    $NothingAction = new Action($orm);
    $NothingAction->setName('Nothing Action')
                  ->setDescription('La acción de no hacer nada')
                  ->setAlias('none')
                  ->setMethod('none')
                  ->setUrlCode('nothing')
                  ->setHint('')
                  ->setFacade($securityFacade);
    $AnnNothingAction = new Action($orm);
    $AnnNothingAction->setName('Nothing Action')
                  ->setDescription('La acción de no hacer nada Para el Anónimo')
                  ->setAlias('noneAnnonymous')
                  ->setMethod('none')
                  ->setUrlCode('nothing')
                  ->setHint('')
                  ->setFacade($securityFacade);
    $listUsersAction = new Action($orm);
    $listUsersAction->setName('List Users')
                  ->setDescription('Lista los usuarios que están en la órbita del proveedor')
                  ->setAlias('listUsers')
                  ->setMethod('listUsers')
                  ->setUrlCode('listUsers')
				  ->setIcon('user')
                  ->setHint('Listado de usuarios')
                  ->setFacade($securityFacade);
	$exportCSVUsersAction = new Action($orm);
    $exportCSVUsersAction->setName('Export Users CSV')
					    ->setDescription('Exporta la lista de usuarios a CSV')
                        ->setAlias('exportUsersCsv')
                        ->setMethod('listUsers')
                        ->setUrlCode('expUsersCSV')
                        ->setHint('Exportar Usuarios a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($securityFacade);
    $addUserAction = new Action($orm);
    $addUserAction->setName('Add User')
                  ->setDescription('Agrega un usuario a la órbita del proveedor')
                  ->setAlias('addUser')
                  ->setMethod('saveUser')
                  ->setUrlCode('addUser')
				  ->setIcon('user_add')
                  ->setHint('Agregar usuario')
                  ->setFacade($securityFacade);
	$delUserAction = new Action($orm);
    $delUserAction->setName('Del User')
                  ->setDescription('Elimina un usuario a la órbita del proveedor')
                  ->setAlias('deleteUser')
                  ->setMethod('saveUser')
                  ->setUrlCode('delUser')
				  ->setIcon('user_delete')
                  ->setHint('Eliminar usuario')
                  ->setParams('user_action=DELETE&')
                  ->setFacade($securityFacade);
	$modUserAction = new Action($orm);
    $modUserAction->setName('Mod User')
                  ->setDescription('Modifica un usuario a la órbita del proveedor')
                  ->setAlias('modifyUser')
                  ->setMethod('saveUser')
                  ->setUrlCode('modUser')
				  ->setIcon('user_edit')
                  ->setHint('Modificar usuario')
                  ->setParams('user_action=MODIFY&')
                  ->setFacade($securityFacade);
	$changePasswordAction = new Action($orm);
    $changePasswordAction->setName('Cambiar Passsword')
                  ->setDescription('Accion para cambiar el password del usuario logueado.')
                  ->setAlias('passChange')
                  ->setMethod('savePassword')
                  ->setUrlCode('passChange')
				  ->setIcon('user_edit')
                  ->setHint('Cambiar Password')
                  ->setParams('user_action=MODIFY&')
                  ->setFacade($securityFacade);
	$modUserProfilesAction = new Action($orm);
    $modUserProfilesAction->setName('Assign Profiles')
                  ->setDescription('Asigna perfiles del provider al usuario')
                  ->setAlias('modifyUserProfiles')
                  ->setMethod('saveUserProfiles')
                  ->setUrlCode('modUserProfs')
				  ->setIcon('user_edit')
                  ->setHint('Modificar perfiles')
                  ->setParams('user_action=MODIFY&')
                  ->setFacade($securityFacade);
	$savUserAction = new Action($orm);
    $savUserAction->setName('save User')
                  ->setDescription('Guarda un usuario a la órbita del proveedor')
                  ->setAlias('saveUser')
                  ->setMethod('saveUser')
                  ->setUrlCode('saveUser')
                  ->setHint('Guardar usuario')
                  ->setParams('user_action=SAVE&')
                  ->setFacade($securityFacade);
    $listProfilesAction = new Action($orm);
    $listProfilesAction->setName('List Profiles')
                  ->setDescription('Lista los prefiles de usuario que están en la órbita del proveedor')
                  ->setAlias('listProfiles')
                  ->setMethod('listProfiles')
                  ->setUrlCode('listProfs')
				  ->setIcon('group')
                  ->setHint('Listado de perfiles')
                  ->setFacade($securityFacade);
	$exportCSVProfilesAction = new Action($orm);
    $exportCSVProfilesAction->setName('Export Profiles CSV')
						    ->setDescription('Exporta la lista de perfiles a CSV')
						    ->setAlias('exportProfilesCsv')
					        ->setMethod('listProfiles')
					        ->setUrlCode('expProfilesCSV')
					        ->setHint('Exportar Perfiles a CSV')
							->setIcon('file_extension_csv')
							->setUseAjax(false)
						    ->setParams('uws_list_action=EXPORT&uws_format=CSV&')
					        ->setFacade($securityFacade);
    $addProfilesAction = new Action($orm);
    $addProfilesAction->setName('Add Profile')
                  ->setDescription('Agrega un perfil de usuario a la órbita del proveedor')
                  ->setAlias('addProfile')
                  ->setMethod('saveProfile')
                  ->setUrlCode('addProfile')
				  ->setIcon('group_add')
                  ->setHint('Agregar perfil')
                  ->setFacade($securityFacade);
	
	$modProfilesAction = new Action($orm);
    $modProfilesAction->setName('Mod Profile')
                  ->setDescription('Modifica un perfil de usuario a la órbita del proveedor')
                  ->setAlias('modifyProfile')
                  ->setMethod('saveProfile')
                  ->setUrlCode('modProfile')
                  ->setHint('Modificar perfil')
				  ->setIcon('group_edit')
				  ->setParams('user_action=MODIFY&')
                  ->setFacade($securityFacade);
	$delProfilesAction = new Action($orm);
    $delProfilesAction->setName('Del Profile')
                  ->setDescription('Elimina un perfil de usuario a la órbita del proveedor')
                  ->setAlias('deleteProfile')
                  ->setMethod('saveProfile')
                  ->setUrlCode('delProfile')
                  ->setHint('Eliminar perfil')
				  ->setIcon('group_delete')
				  ->setParams('user_action=DELETE&')
                  ->setFacade($securityFacade);
	
	$listProvidersAction = new Action($orm);
    $listProvidersAction->setName('List Providers')
					    ->setDescription('Lista los proveedores')
                        ->setAlias('listProviders')
                        ->setMethod('listProviders')
                        ->setUrlCode('listProviders')
						->setIcon('administrator')
                        ->setHint('Listado de Proveedores')
                        ->setFacade($securityFacade);
	$exportCSVProvidersAction = new Action($orm);
    $exportCSVProvidersAction->setName('Export Providers CSV')
					    ->setDescription('Exporta la lista de proveedores a CSV')
                        ->setAlias('exportProvidersCsv')
                        ->setMethod('listProviders')
                        ->setUrlCode('expProvidersCSV')
                        ->setHint('Exportar Proveedores a CSV')
						->setUseAjax(false)
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
                        ->setFacade($securityFacade);
	$addProviderAction = new Action($orm);
    $addProviderAction->setName('Add Provider')
					->setDescription('Agrega un proveedor')
					->setAlias('addProvider')
					->setMethod('saveProvider')
					->setUrlCode('addProvider')
					->setIcon('administrator_add')
					->setHint('Agregar proveedor')
					->setFacade($securityFacade);
	$modProviderAction = new Action($orm);
	$modProviderAction->setName('Mod Provider')
					->setDescription('Modifica un proveedor')
					->setAlias('modifyProvider')
					->setMethod('saveProvider')
					->setUrlCode('modProvider')
					->setIcon('administrator_edit')
					->setHint('Modificar proveedor')
					->setParams('user_action=MODIFY&')
					->setFacade($securityFacade);
	$delProviderAction = new Action($orm);
    $delProviderAction->setName('Del Provider')
					->setDescription('Elimina un proveedor')
					->setAlias('deleteProvider')
					->setMethod('saveProvider')
					->setUrlCode('delProvider')
					->setIcon('administrator_delete')
					->setHint('Eliminar provider')
					->setParams('user_action=DELETE&')
					->setFacade($securityFacade);
	
	
    $listActionsAction = new Action($orm);
    $listActionsAction->setName('List Actions')
                  ->setDescription('Lista las acciones que están en la órbita del proveedor')
                  ->setAlias('listActions')
                  ->setMethod('listActions')
                  ->setUrlCode('listActs')
				  ->setIcon('link')
                  ->setHint('Listado de usuarios')
                  ->setFacade($securityFacade);
    $addActionAction = new Action($orm);
    $addActionAction->setName('Add Action')
                  ->setDescription('Agrega una acción a la órbita del proveedor')
                  ->setAlias('addAction')
                  ->setMethod('saveAction')
                  ->setUrlCode('addAction')
				  ->setIcon('link_add')
                  ->setHint('Agregar acción')
                  ->setFacade($securityFacade);
	$modActionAction = new Action($orm);
	$modActionAction->setName('Mod Action')
					->setDescription('Modifica una acción en la órbita del proveedor')
					->setAlias('modifyAction')
					->setMethod('saveAction')
					->setUrlCode('modAction')
					->setHint('Modificar acción')
					->setIcon('link_edit')
					->setParams('user_action=MODIFY&')
					->setFacade($securityFacade);
	$delActionAction = new Action($orm);
    $delActionAction->setName('Del Action')
					->setDescription('Elimina una acción en la órbita del proveedor')
					->setAlias('deleteAction')
					->setMethod('saveAction')
					->setUrlCode('delAction')
					->setIcon('link_delete')
					->setHint('Eliminar acción')
					->setParams('user_action=DELETE&')
					->setFacade($securityFacade);
	$exportCSVActionsAction = new Action($orm);
    $exportCSVActionsAction->setName('Export Actions CSV')
					    ->setDescription('Exporta la lista de acciones a CSV')
                        ->setAlias('exportActionsCsv')
                        ->setMethod('listActions')
                        ->setUrlCode('expActionsCSV')
                        ->setHint('Exportar acciones a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($securityFacade);	
	
    $showErrorAction = new Action($orm);
    $showErrorAction->setName('Show Error')
                  ->setDescription('Muestra un mensaje de error')
                  ->setAlias('showError')
                  ->setMethod('showError')
                  ->setUrlCode('showError')
                  ->setHint('Mostrar Error')
                  ->setFacade($securityFacade);
	
	$listMenusAction = new Action();
    $listMenusAction->setName('List Menus')
                  ->setDescription('Muestra un listado de las opciones de menú')
                  ->setAlias('listMenus')
                  ->setMethod('listMenus')
                  ->setUrlCode('listMenus')
				  ->setIcon('menubar')
                  ->setHint('Listado de menues')
                  ->setFacade($securityFacade);
    $addMenuAction = new Action($orm);
    $addMenuAction->setName('Add Menu')
                  ->setDescription('Agrega un menú al proveedor')
                  ->setAlias('addMenu')
                  ->setMethod('saveMenu')
                  ->setUrlCode('addMenu')
				  ->setIcon('menubar_add')
                  ->setHint('Agregar Menú')
                  ->setFacade($securityFacade);
	$modMenuAction = new Action($orm);
	$modMenuAction->setName('Mod Menu')
					->setDescription('Modifica un menú al proveedor')
					->setAlias('modifyMenu')
					->setMethod('saveMenu')
					->setUrlCode('modMenu')
					->setHint('Modificar Menú')
					->setIcon('menubar_edit')
					->setParams('user_action=MODIFY&')
					->setFacade($securityFacade);
	$delMenuAction = new Action($orm);
    $delMenuAction->setName('Del Menu')
					->setDescription('Elimina un menú del proveedor')
					->setAlias('deleteMenu')
					->setMethod('saveMenu')
					->setUrlCode('delMenu')
					->setIcon('menubar_delete')
					->setHint('Eliminar Menú')
					->setParams('user_action=DELETE&')
					->setFacade($securityFacade);

	$listFacadesAction = new Action();
    $listFacadesAction->setName('List Facades')
                  ->setDescription('Muestra un listado de los facades')
                  ->setAlias('listFacades')
                  ->setMethod('listFacades')
                  ->setUrlCode('listFacades')
				  ->setIcon('bricks')
                  ->setHint('Listado de facades')
                  ->setFacade($securityFacade);
    $addFacadeAction = new Action($orm);
    $addFacadeAction->setName('Add Facade')
                  ->setDescription('Agrega un facade')
                  ->setAlias('addFacade')
                  ->setMethod('saveFacade')
                  ->setUrlCode('addFacade')
				  ->setIcon('bricks_add')
                  ->setHint('Agregar Facade')
                  ->setFacade($securityFacade);
    $installFacadeAction = new Action($orm);
    $installFacadeAction->setName('Install Facade')
					  ->setDescription('Instala un facade')
					  ->setAlias('installFacade')
					  ->setMethod('installFacade')
					  ->setUrlCode('instFacade')
					  ->setIcon('bricks_go')
					  ->setHint('Instalar Facade')
					  ->setFacade($securityFacade);
    $assignFacadeAction = new Action($orm);
    $assignFacadeAction->setName('Assign Facade To')
					  ->setDescription('Le otorga permisos sobre un Facade a un grupo')
					  ->setAlias('assignFacade')
					  ->setMethod('assignFacade')
					  ->setUrlCode('asgnFacade')
					  ->setIcon('bricks_go')
					  ->setHint('Asignar Facade')
					  ->setFacade($securityFacade);
	$modFacadeAction = new Action($orm);
	$modFacadeAction->setName('Mod Menu')
					->setDescription('Modifica un menú al proveedor')
					->setAlias('modifyFacade')
					->setMethod('saveFacade')
					->setUrlCode('modFacade')
					->setHint('Modificar Menú')
					->setIcon('bricks_edit')
					->setParams('user_action=MODIFY&')
					->setFacade($securityFacade);
	$delFacadeAction = new Action($orm);
    $delFacadeAction->setName('Del Menu')
					->setDescription('Elimina un menú del proveedor')
					->setAlias('deleteFacade')
					->setMethod('saveFacade')
					->setUrlCode('delFacade')
					->setIcon('bricks_delete')
					->setHint('Eliminar Menú')
					->setParams('user_action=DELETE&')
					->setFacade($securityFacade);

    $orm->save($defaultAction);     echo "Creada la acci&oacute;n predeterminada del sistema (Default Action)<br>";
    $orm->save($loginAction);       echo "Creada la acci&oacute;n de inicio de sesi&oacute;n (Login)<br>";
    $orm->save($logoutAction);      echo "Creada la acci&oacute;n de fin de sesi&oacute;n (Logout)<br>";
    $orm->save($mainAction);        echo "Creada la acci&oacute;n de la p&aacute;gina principal (Main Page)<br>";
    $orm->save($redirectAction);    echo "Creada la acci&oacute;n de redirecci&oacute;n (Redirect)<br>";
    $orm->save($NothingAction);     echo "Creada la acci&oacute;n de no hacer nada (Nothing)<br>";
    $orm->save($AnnNothingAction);  echo "Creada la acci&oacute;n de no hacer nada para anónimos (Nothing)<br>";
    $orm->save($listUsersAction);   echo "Creada la acci&oacute;n de listar usuarios (listUsers)<br>";
	$orm->save($exportCSVUsersAction);   echo "Creada la acci&oacute;n de listar usuarios (exportUsers)<br>";
    $orm->save($addUserAction);     echo "Creada la acci&oacute;n de agregar usuarios (addUsers)<br>";
	$orm->save($modUserAction);     echo "Creada la acci&oacute;n de modificar usuarios (modUsers)<br>";
	$orm->save($changePasswordAction);     echo "Creada la acci&oacute;n de cambiar password (passChange)<br>";
	$orm->save($modUserProfilesAction);     echo "Creada la acci&oacute;n de modificar usuarios (modUserProfs)<br>";
	$orm->save($delUserAction);     echo "Creada la acci&oacute;n de eliminar usuarios (delUsers)<br>";
	$orm->save($savUserAction);     echo "Creada la acci&oacute;n de guardar usuarios (delUsers)<br>";
    $orm->save($listProfilesAction);echo "Creada la acci&oacute;n de listar perfiles (listProfs)<br>";
	$orm->save($exportCSVProfilesAction);echo "Creada la acci&oacute;n de exportar perfiles (expProfs)<br>";
    $orm->save($addProfilesAction); echo "Creada la acci&oacute;n de agregar perfiles (addProfile)<br>";
	$orm->save($modProfilesAction); echo "Creada la acci&oacute;n de modificar perfiles (modProfile)<br>";
	$orm->save($delProfilesAction); echo "Creada la acci&oacute;n de eliminar perfiles (delProfile)<br>";
	$orm->save($listProvidersAction);echo "Creada la acci&oacute;n de listar proveedores (listProvider)<br>";
	$orm->save($exportCSVProvidersAction);echo "Creada la acci&oacute;n de exportar proveedores (exportProvider)<br>";
	$orm->save($addProviderAction); echo "Creada la acci&oacute;n de agregar proveedores (addProvider)<br>";
	$orm->save($modProviderAction); echo "Creada la acci&oacute;n de modificar proveedores (modProvider)<br>";
	$orm->save($delProviderAction); echo "Creada la acci&oacute;n de eliminar proveedores (delProvider)<br>";
    $orm->save($listActionsAction); echo "Creada la acci&oacute;n de listar acciones (listActions)<br>";
    $orm->save($addActionAction);   echo "Creada la acci&oacute;n de agregar acciones (addAction)<br>";
	$orm->save($exportCSVActionsAction);   echo "Creada la acci&oacute;n de exportar acciones (exportActions)<br>";
    $orm->save($showErrorAction);   echo "Creada la acci&oacute;n de mostrar errores (showErrorAction)<br>";
    $orm->save($listMenusAction);   echo "Creada la acci&oacute;n de listar menues (listMenus)<br>";
    $orm->save($addMenuAction);   echo "Creada la acci&oacute;n de agregar menues (addMenu)<br>";
    $orm->save($modMenuAction);   echo "Creada la acci&oacute;n de editar menues (modifyMenu)<br>";
    $orm->save($delMenuAction);   echo "Creada la acci&oacute;n de borrar menues (deleteMenu)<br>";
    $orm->save($listFacadesAction);   echo "Creada la acci&oacute;n de listar facades (listFacades)<br>";
    $orm->save($addFacadeAction);   echo "Creada la acci&oacute;n de agregar facades (addFacade)<br>";
    $orm->save($modFacadeAction);   echo "Creada la acci&oacute;n de editar facades (modifyFacade)<br>";
    $orm->save($delFacadeAction);   echo "Creada la acci&oacute;n de borrar facades (deleteFacade)<br>";
	
	/* Wholesale Facade */
	$listResellersAction = new Action($orm);
    $listResellersAction->setName('Listado de Resellers')
					    ->setDescription('Lista los Resellers')
                        ->setAlias('listResellers')
                        ->setMethod('listResellers')
                        ->setUrlCode('listResellers')
						->setIcon('reseller_account')
                        ->setHint('Listado de Resellers')
                        ->setFacade($wholesaleFacade);
	$addResellersAction = new Action($orm);
    $addResellersAction->setName('Add Reseller')
                  ->setDescription('Agrega un Reseller')
                  ->setAlias('addReseller')
                  ->setMethod('saveReseller')
                  ->setUrlCode('addReseller')
				  ->setIcon('reseller_account_add')
                  ->setHint('Agregar Reseller')
                  ->setFacade($wholesaleFacade);
	$modResellersAction = new Action($orm);
	$modResellersAction->setName('Mod Reseller')
					->setDescription('Modifica un Reseller')
					->setAlias('modifyReseller')
					->setMethod('saveRealReseller')
					->setUrlCode('modReseller')
					->setIcon('reseller_account_edit')
					->setHint('Modificar Reseller')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delResellersAction = new Action($orm);
    $delResellersAction->setName('Del Resellers')
					   ->setDescription('Elimina un Reseller')
					   ->setAlias('deleteReseller')
					   ->setMethod('saveRealReseller')
					   ->setUrlCode('delReseller')
					   ->setIcon('reseller_account_delete')
					   ->setHint('Eliminar Reseller')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	$detResellerAction = new Action($orm);
    $detResellerAction->setName('Reseller Detail')
					   ->setDescription('Detalle Reseller')
					   ->setAlias('detailReseller')
					   ->setMethod('detailReseller')
					   ->setUrlCode('detailReseller')
					   ->setIcon('reseller_account_go')
					   ->setHint('Detalle de Reseller')
					   ->setFacade($wholesaleFacade);
	$exportCSVResellersAction = new Action($orm);
    $exportCSVResellersAction->setName('Export Resellers CSV')
					    ->setDescription('Exporta la lista de revendedores a CSV')
                        ->setAlias('exportResellersCsv')
                        ->setMethod('listResellers')
                        ->setUrlCode('expResellersCSV')
                        ->setHint('Exportar revendedores a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($wholesaleFacade);	
	$listClientsAction = new Action($orm);
    $listClientsAction->setName('Listado de Clientes')
					  ->setDescription('Lista los Clientes')
                      ->setAlias('listClients')
                      ->setMethod('listClients')
                      ->setUrlCode('listClients')
					  ->setIcon('customer')
                      ->setHint('Listado de Clientes')
                      ->setFacade($wholesaleFacade);
	$addClientsAction = new Action($orm);
    $addClientsAction->setName('Add Client')
                     ->setDescription('Agrega un Cliente')
                     ->setAlias('addClient')
                     ->setMethod('saveClient')
                     ->setUrlCode('addCliente')
					 ->setIcon('customer_add')
                     ->setHint('Agregar Cliente')
                     ->setFacade($wholesaleFacade);
	$modClientsAction = new Action($orm);
	$modClientsAction->setName('Mod Client')
					->setDescription('Modifica un Cliente')
					->setAlias('modifyClient')
					->setMethod('saveClient')
					->setUrlCode('modClient')
					->setIcon('customer_edit')
					->setHint('Modificar Cliente')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delClientsAction = new Action($orm);
    $delClientsAction->setName('Del Client')
					   ->setDescription('Elimina un Cliente')
					   ->setAlias('deleteClient')
					   ->setMethod('saveClient')
					   ->setUrlCode('delClient')
					   ->setIcon('customer_delete')
					   ->setHint('Eliminar Cliente')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	$detClientAction = new Action($orm);
    $detClientAction->setName('Client Detail')
					   ->setDescription('Detalle Cliente')
					   ->setAlias('detailClient')
					   ->setMethod('detailClient')
					   ->setUrlCode('detailClient')
					   ->setIcon('customer_go')
					   ->setHint('Detalle de Cliente')
					   ->setFacade($wholesaleFacade);
	$exportCSVClientAction = new Action($orm);
    $exportCSVClientAction->setName('Export Client CSV')
					    ->setDescription('Exporta la lista de clientes a CSV')
                        ->setAlias('exportClientsCsv')
                        ->setMethod('listClients')
                        ->setUrlCode('expClientsCSV')
                        ->setHint('Exportar Clientes a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($wholesaleFacade);

	$listSitesAction = new Action($orm);
    $listSitesAction->setName('Listado de Sitios')
					  ->setDescription('Lista los Sitios')
                      ->setAlias('listSites')
                      ->setMethod('listSites')
                      ->setUrlCode('listSites')
					  ->setIcon('chart_organisation')
                      ->setHint('Listado de Sitios')
                      ->setFacade($wholesaleFacade);
	$addSitesAction = new Action($orm);
    $addSitesAction->setName('Add Sites')
                     ->setDescription('Agrega un Sitio')
                     ->setAlias('addSite')
                     ->setMethod('saveSite')
                     ->setUrlCode('addSite')
					 ->setIcon('chart_organisation_add')
                     ->setHint('Agregar Sitios')
                     ->setFacade($wholesaleFacade);
	$modSitesAction = new Action($orm);
	$modSitesAction->setName('Mod Site')
					->setDescription('Modifica un Sitio')
					->setAlias('modifySite')
					->setMethod('saveSite')
					->setUrlCode('modSite')
					->setIcon('chart_organisation_edit')
					->setHint('Modificar Sitio')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delSitesAction = new Action($orm);
    $delSitesAction->setName('Del Site')
					   ->setDescription('Elimina un Sitio')
					   ->setAlias('deleteSite')
					   ->setMethod('saveSite')
					   ->setUrlCode('delSite')
					   ->setIcon('chart_organisation_delete')
					   ->setHint('Eliminar Sitio')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	
	$detSiteAction = new Action($orm);
    $detSiteAction->setName('Site Detail')
					   ->setDescription('Detalle Sitio')
					   ->setAlias('detailSite')
					   ->setMethod('detailSite')
					   ->setUrlCode('detailSite')
					   ->setIcon('chart_organisation_go')
					   ->setHint('Detalle de Sitio')
					   ->setFacade($wholesaleFacade);
	$exportCSVSitesAction = new Action($orm);
    $exportCSVSitesAction->setName('Export Client CSV')
					    ->setDescription('Exporta la lista de sitios a CSV')
                        ->setAlias('exportSitesCsv')
                        ->setMethod('listSites')
                        ->setUrlCode('expsitesCSV')
                        ->setHint('Exportar Sitios a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($wholesaleFacade);

	$listLinesAction = new Action($orm);
    $listLinesAction->setName('Listado de Lineas')
					  ->setDescription('Lista las Lineas')
                      ->setAlias('listLines')
                      ->setMethod('listLines')
                      ->setUrlCode('listLines')
					  ->setIcon('telephone')
                      ->setHint('Listado de Lineas')
                      ->setFacade($wholesaleFacade);
	$addLinesAction = new Action($orm);
    $addLinesAction->setName('Add Lines')
                     ->setDescription('Agrega una Linea')
                     ->setAlias('addLine')
                     ->setMethod('saveLine')
                     ->setUrlCode('addLine')
					 ->setIcon('telephone_add')
                     ->setHint('Agregar Lineas')
                     ->setFacade($wholesaleFacade);
	$modLinesAction = new Action($orm);
	$modLinesAction->setName('Mod Line')
					->setDescription('Modifica una Linea')
					->setAlias('modifyLine')
					->setMethod('saveLine')
					->setUrlCode('modLine')
					->setIcon('telephone_edit')
					->setHint('Modificar Linea')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delLinesAction = new Action($orm);
    $delLinesAction->setName('Del Line')
					   ->setDescription('Elimina una Linea')
					   ->setAlias('deleteLine')
					   ->setMethod('saveLine')
					   ->setUrlCode('delLine')
					   ->setIcon('telephone_delete')
					   ->setHint('Eliminar Linea')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	$detLineAction = new Action($orm);
    $detLineAction->setName('Line Detail')
					   ->setDescription('Detalle Linea')
					   ->setAlias('detailLine')
					   ->setMethod('detailLine')
					   ->setUrlCode('detailLine')
					   ->setIcon('telephone_go')
					   ->setHint('Detalle de Linea')
					   ->setFacade($wholesaleFacade);
	$exportCSVLinesAction = new Action($orm);
    $exportCSVLinesAction->setName('Export Lines CSV')
					    ->setDescription('Exporta la lista de líneas a CSV')
                        ->setAlias('exportLinesCsv')
                        ->setMethod('listLines')
                        ->setUrlCode('expLinesCSV')
                        ->setHint('Exportar líneas a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($wholesaleFacade);	
	
	$listLineTypesAction = new Action($orm);
    $listLineTypesAction->setName('Listado de Lineas')
						->setDescription('Lista los Tipos de Linea')
						->setAlias('listLineTypes')
						->setMethod('listLineTypes')
						->setUrlCode('listLineTypes')
						->setIcon('layer')
						->setHint('Listado de Tipos de Linea')
						->setFacade($wholesaleFacade);
	$addLineTypeAction = new Action($orm);
    $addLineTypeAction->setName('Add Line Type')
                     ->setDescription('Agrega un tipo de Linea')
                     ->setAlias('addLineType')
                     ->setMethod('saveLineType')
                     ->setUrlCode('addLineType')
					 ->setIcon('layer_add')
                     ->setHint('Agregar Tipos de Linea')
                     ->setFacade($wholesaleFacade);
	$modLineTypeAction = new Action($orm);
	$modLineTypeAction->setName('Mod Line Type')
					->setDescription('Modifica una Linea')
					->setAlias('modifyLineType')
					->setMethod('saveLineType')
					->setUrlCode('modLineType')
					->setIcon('layer_edit')
					->setHint('Modificar Tipo de Linea')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delLineTypeAction = new Action($orm);
    $delLineTypeAction->setName('Del Line Type')
					   ->setDescription('Elimina un tipo de Linea')
					   ->setAlias('deleteLineType')
					   ->setMethod('saveLineType')
					   ->setUrlCode('delLineType')
					   ->setHint('Eliminar tipo de Linea')
					   ->setIcon('layer_delete')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	
	$listNumerationBlocksAction = new Action($orm);
    $listNumerationBlocksAction->setName('Listado de Bloques')
						->setDescription('Lista los Bloques de Numeración')
						->setAlias('listNumerationBlocks')
						->setMethod('listNumerationBlocks')
						->setUrlCode('listNumerationBlocks')
						->setIcon('brick')
						->setHint('Listado de Bloques de Numeración')
						->setFacade($wholesaleFacade);
	$addNumerationBlockAction = new Action($orm);
    $addNumerationBlockAction->setName('Add Numeration Block')
                     ->setDescription('Agrega un Bloque de Numeración')
                     ->setAlias('addNumerationBlock')
                     ->setMethod('saveNumerationBlock')
                     ->setUrlCode('addNumerationBlock')
					 ->setIcon('brick_add')
                     ->setHint('Agregar Bloque de Numeración')
                     ->setFacade($wholesaleFacade);
	$modNumerationBlockAction = new Action($orm);
	$modNumerationBlockAction->setName('Mod Numeration Block')
					->setDescription('Modifica un bloque de Numeración')
					->setAlias('modifyNumerationBlock')
					->setMethod('saveNumerationBlock')
					->setUrlCode('modNumerationBlock')
					->setIcon('brick_edit')
					->setHint('Modificar Bloque de Numeración')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delNumerationBlockAction = new Action($orm);
    $delNumerationBlockAction->setName('Del Numeration Block')
					   ->setDescription('Elimina un bloque de Numeración')
					   ->setAlias('deleteNumerationBlock')
					   ->setMethod('saveNumerationBlock')
					   ->setUrlCode('delNumerationBlock')
					   ->setIcon('brick_delete')
					   ->setHint('Eliminar bloque de Numeración')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	
	
	$listServicePacksAction = new Action($orm);
    $listServicePacksAction->setName('Listado de ServicePacks')
						->setDescription('Lista los ServicePacks')
						->setAlias('listServicePacks')
						->setMethod('listServicePacks')
						->setIcon('package')
						->setUrlCode('listServicePacks')
						->setHint('Listado de ServicePacks')
						->setFacade($wholesaleFacade);
	$addServicePackAction = new Action($orm);
    $addServicePackAction->setName('Add ServicePack')
                     ->setDescription('Agrega un ServicePack')
                     ->setAlias('addServicePack')
                     ->setMethod('saveServicePack')
                     ->setUrlCode('addServicePack')
					 ->setIcon('package_add')
                     ->setHint('Agregar ServicePack')
                     ->setFacade($wholesaleFacade);
	$modServicePackAction = new Action($orm);
	$modServicePackAction->setName('Mod ServicePack')
					->setDescription('Modifica un ServicePack')
					->setAlias('modifyServicePack')
					->setMethod('saveServicePack')
					->setUrlCode('modServicePack')
					->setIcon('package_edit')
					->setHint('Modificar ServicePack')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delServicePackAction = new Action($orm);
    $delServicePackAction->setName('Del ServicePack')
					   ->setDescription('Elimina un ServicePack')
					   ->setAlias('deleteServicePack')
					   ->setMethod('saveServicePack')
					   ->setIcon('package_delete')
					   ->setUrlCode('delServicePack')
					   ->setHint('Eliminar ServicePack')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	
	
	$listResourcesAction = new Action($orm);
    $listResourcesAction->setName('Listado de Recursos')
						->setDescription('Lista los Recursos')
						->setAlias('listResources')
						->setMethod('listResources')
						->setIcon('plugin')
						->setUrlCode('listResources')
						->setHint('Listado de Recursos')
						->setFacade($wholesaleFacade);
	$addResourceAction = new Action($orm);
    $addResourceAction->setName('Add Resource')
                     ->setDescription('Agrega un Recurso')
                     ->setAlias('addResource')
                     ->setMethod('saveResource')
                     ->setUrlCode('addResource')
					 ->setIcon('plugin_add')
                     ->setHint('Agregar Recurso')
                     ->setFacade($wholesaleFacade);
	$modResourceAction = new Action($orm);
	$modResourceAction->setName('Mod Resource')
					->setDescription('Modifica un Recurso')
					->setAlias('modifyResource')
					->setMethod('saveResource')
					->setUrlCode('modResource')
					->setIcon('plugin_edit')
					->setHint('Modificar Recurso')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delResourceAction = new Action($orm);
    $delResourceAction->setName('Del Resource')
					   ->setDescription('Elimina un Recurso')
					   ->setAlias('deleteResource')
					   ->setMethod('saveResource')
					   ->setIcon('plugin_delete')
					   ->setUrlCode('delResource')
					   ->setHint('Eliminar Recurso')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	
	$listRecepcionistTypesAction = new Action($orm);
    $listRecepcionistTypesAction->setName('Listado de Recepcionistas')
						->setDescription('Lista los Tipos de Recepcionista')
						->setAlias('listRecepcionistTypes')
						->setMethod('listRecepcionistTypes')
						->setUrlCode('listRecepcionistTypes')
						->setIcon('sound')
						->setHint('Listado de Tipos de Recepcionista')
						->setFacade($wholesaleFacade);
	$addRecepcionistTypeAction = new Action($orm);
    $addRecepcionistTypeAction->setName('Add RecepcionistType')
                     ->setDescription('Agrega un Tipo de Recepcionista')
                     ->setAlias('addRecepcionistType')
                     ->setMethod('saveRecepcionistType')
                     ->setUrlCode('addRecepcionistType')
					 ->setIcon('sound_add')
                     ->setHint('Agregar Tipo de Recepcionista')
                     ->setFacade($wholesaleFacade);
	$modRecepcionistTypeAction = new Action($orm);
	$modRecepcionistTypeAction->setName('Mod RecepcionistType')
					->setDescription('Modifica un Tipo de Recepcionista')
					->setAlias('modifyRecepcionistType')
					->setMethod('saveRecepcionistType')
					->setUrlCode('modRecepcionistType')
					->setIcon('sound_edit')
					->setHint('Modificar Tipo de Recepcionista')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delRecepcionistTypeAction = new Action($orm);
    $delRecepcionistTypeAction->setName('Del RecepcionistType')
					   ->setDescription('Elimina un Tipo de Recepcionista')
					   ->setAlias('deleteRecepcionistType')
					   ->setMethod('saveRecepcionistType')
					   ->setUrlCode('delRecepcionistType')
					   ->setIcon('sound_delete')
					   ->setHint('Eliminar Tipo de Recepcionista')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	
	$listServiceProvidersAction = new Action($orm);
    $listServiceProvidersAction->setName('Listado ServiceProvider')
						->setDescription('Lista los ServiceProvider')
						->setAlias('listServiceProviders')
						->setMethod('listServiceProviders')
						->setIcon('server')
						->setUrlCode('listServiceProviders')
						->setHint('Listado de ServiceProviders')
						->setFacade($wholesaleFacade);
	$addServiceProviderAction = new Action($orm);
    $addServiceProviderAction->setName('Add ServiceProvider')
                     ->setDescription('Agrega un ServiceProvider')
                     ->setAlias('addServiceProvider')
                     ->setMethod('saveServiceProvider')
                     ->setUrlCode('addServiceProvider')
					 ->setIcon('server_add')
                     ->setHint('Agregar ServiceProvider')
                     ->setFacade($wholesaleFacade);
	$modServiceProviderAction = new Action($orm);
	$modServiceProviderAction->setName('Mod ServiceProvider')
					->setDescription('Modifica ServiceProvider')
					->setAlias('modifyServiceProvider')
					->setMethod('saveServiceProvider')
					->setUrlCode('modServiceProvider')
					->setIcon('server_edit')
					->setHint('Modificar ServiceProvider')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delServiceProviderAction = new Action($orm);
    $delServiceProviderAction->setName('Del ServiceProvider')
					   ->setDescription('Elimina un ServiceProvider')
					   ->setAlias('deleteServiceProvider')
					   ->setMethod('saveServiceProvider')
					   ->setUrlCode('delServiceProvider')
					   ->setIcon('server_delete')
					   ->setHint('Eliminar ServiceProvider')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	
	$listPayPlansAction = new Action($orm);
    $listPayPlansAction->setName('Listado de PayPlans')
						->setDescription('Lista los PayPlan')
						->setAlias('listPayPlans')
						->setMethod('listPayPlans')
						->setUrlCode('listPayPlans')
						->setIcon('money_bag')
						->setHint('Listado de PayPlans')
						->setFacade($wholesaleFacade);
	$addPayPlanAction = new Action($orm);
    $addPayPlanAction->setName('Add PayPlan')
                     ->setDescription('Agrega un PayPlan')
                     ->setAlias('addPayPlan')
                     ->setMethod('savePayPlan')
                     ->setUrlCode('addPayPlan')
					 ->setIcon('money_bag_add')
                     ->setHint('Agregar PayPlan')
                     ->setFacade($wholesaleFacade);
	$modPayPlanAction = new Action($orm);
	$modPayPlanAction->setName('Mod PayPlan')
					->setDescription('Modifica PayPlan')
					->setAlias('modifyPayPlan')
					->setMethod('savePayPlan')
					->setUrlCode('modPayPlan')
					->setIcon('money_bag_edit')
					->setHint('Modificar PayPlan')
					->setParams('user_action=MODIFY&')
					->setFacade($wholesaleFacade);
	$delPayPlanAction = new Action($orm);
    $delPayPlanAction->setName('Del PayPlan')
					   ->setDescription('Elimina un PayPlan')
					   ->setAlias('deletePayPlan')
					   ->setMethod('savePayPlan')
					   ->setUrlCode('delPayPlan')
					   ->setIcon('money_bag_delete')
					   ->setHint('Eliminar PayPlan')
					   ->setParams('user_action=DELETE&')
					   ->setFacade($wholesaleFacade);
	/* Grupos de Prefijos */
	$listPrefixGroupsAction = new Action($orm);
    $listPrefixGroupsAction->setName('List PrefixGroup')
					    ->setDescription('Muestra los grupos de prefijos')
                        ->setAlias('listPrefixGroups')
                        ->setMethod('listPrefixGroups')
                        ->setUrlCode('listPrefixGroups')
                        ->setHint('Ver Grupos de Prefijos')
						->setIcon('elements')
                        ->setFacade($wholesaleFacade);
	$addPrefixGroupAction = new Action($orm);
    $addPrefixGroupAction->setName('Add PrefixGroup')
					    ->setDescription('Agrega un grupo de prefijos')
                        ->setAlias('addPrefixGroup')
                        ->setMethod('savePrefixGroup')
                        ->setUrlCode('addPrefixGroup')
                        ->setHint('Agregar Grupo de Prefijos')
						->setIcon('elements_add')
                        ->setFacade($wholesaleFacade);
	$modPrefixGroupAction = new Action($orm);
    $modPrefixGroupAction->setName('Mod PrefixGroup')
					    ->setDescription('Modifica un grupo de prefijos')
                        ->setAlias('modPrefixGroup')
                        ->setMethod('savePrefixGroup')
                        ->setUrlCode('modPrefixGroup')
                        ->setHint('Modificar Grupo de Prefijos')
						->setIcon('elements_edit')
                        ->setFacade($wholesaleFacade);
	$delPrefixGroupAction = new Action($orm);
    $delPrefixGroupAction->setName('Del PrefixGroup')
					    ->setDescription('Quita un grupo de prefijos')
                        ->setAlias('delPrefixGroup')
                        ->setMethod('savePrefixGroup')
                        ->setUrlCode('delPrefixGroup')
                        ->setHint('Quitar Grupo de Prefijos')
						->setIcon('elements_delete')
                        ->setFacade($wholesaleFacade);
	/* Prefijos */
	$listPrefixesAction = new Action($orm);
    $listPrefixesAction->setName('Listar Prefijos')
					    ->setDescription('Muestra los prefijos disponibles')
                        ->setAlias('listPrefixes')
                        ->setMethod('listPrefixes')
                        ->setUrlCode('listPrefixes')
                        ->setHint('Ver Prefijos')
						->setIcon('tag')
                        ->setFacade($wholesaleFacade);
	$addPrefixAction = new Action($orm);
    $addPrefixAction->setName('Agregar Prefijo')
					    ->setDescription('Crea un nuevo Prefijo')
                        ->setAlias('addPrefix')
                        ->setMethod('savePrefix')
                        ->setUrlCode('addPrefix')
                        ->setHint('Agregar Prefijos')
						->setIcon('tag_add')
                        ->setFacade($wholesaleFacade);
	$modPrefixAction = new Action($orm);
    $modPrefixAction->setName('Modificar Prefijo')
					    ->setDescription('Modifica un Prefijo')
                        ->setAlias('modPrefix')
                        ->setMethod('savePrefix')
                        ->setUrlCode('modPrefix')
                        ->setHint('Modificar Prefijos')
						->setIcon('tag_edit')
                        ->setFacade($wholesaleFacade);
	$delPrefixAction = new Action($orm);
    $delPrefixAction->setName('Quitar Prefijo')
					    ->setDescription('Borra un Prefijo')
                        ->setAlias('delPrefix')
                        ->setMethod('savePrefix')
                        ->setUrlCode('delPrefix')
                        ->setHint('Quitar Prefijo')
						->setIcon('tag_delete')
                        ->setFacade($wholesaleFacade);
	/* Listas de Precios */
	$listPricesListsAction = new Action($orm);
    $listPricesListsAction->setName('Ver Listas de Precios')
					    ->setDescription('Muestra las listas de precios subidas al sistema')
                        ->setAlias('listPricesLists')
                        ->setMethod('listPricesLists')
                        ->setUrlCode('listPricesLists')
                        ->setHint('Ver Listas de Precios')
						->setIcon('sallary_deferrais')
                        ->setFacade($wholesaleFacade);
	$addPricesListAction = new Action($orm);
    $addPricesListAction->setName('Agregar Lista de Precios')
					    ->setDescription('Importa una lista de precios desde un archivo CSV')
                        ->setAlias('addPricesList')
                        ->setMethod('addPricesList')
                        ->setUrlCode('addPricesList')
                        ->setHint('Importar Lista de Precios')
						->setIcon('sallary_deferrais_add')
                        ->setFacade($wholesaleFacade);
	$modPricesListAction = new Action($orm);
    $modPricesListAction->setName('Modifica la Lista de Precios')
					    ->setDescription('Edita los detalles de una lista de precios')
                        ->setAlias('modPricesList')
                        ->setMethod('savePricesList')
                        ->setUrlCode('modPricesList')
                        ->setHint('Modificar Lista de Precios')
						->setIcon('sallary_deferrais_edit')
                        ->setFacade($wholesaleFacade);
	$delPricesListAction = new Action($orm);
    $delPricesListAction->setName('Quitar Lista de Precios')
					    ->setDescription('Borra una lista de precios')
                        ->setAlias('delPricesList')
                        ->setMethod('savePricesList')
                        ->setUrlCode('delPricesList')
                        ->setHint('Borrar Lista de Precios')
						->setIcon('sallary_deferrais_delete')
                        ->setFacade($wholesaleFacade);
	/* Precios individuales */
	$listPricesAction = new Action($orm);
    $listPricesAction->setName('Ver Precios')
					    ->setDescription('Muestra los precios registrados en el sistema')
                        ->setAlias('listPrices')
                        ->setMethod('listPrices')
                        ->setUrlCode('listPrices')
                        ->setHint('Ver Precios')
						->setIcon('total_plan_cost')
                        ->setFacade($wholesaleFacade);
	$addPriceAction = new Action($orm);
    $addPriceAction->setName('Agregar Precio')
					    ->setDescription('Agrega un precio al sistema')
                        ->setAlias('addPrice')
                        ->setMethod('savePrice')
                        ->setUrlCode('addPrice')
                        ->setHint('Agregar Precio')
						->setIcon('total_plan_cost_add')
                        ->setFacade($wholesaleFacade);
	$modPriceAction = new Action($orm);
    $modPriceAction->setName('Modificar Precio')
					    ->setDescription('Modifica un precio del sistema')
                        ->setAlias('modifyPrice')
                        ->setMethod('savePrice')
                        ->setUrlCode('modPrice')
                        ->setHint('Modificar Precio')
						->setIcon('total_plan_cost_edit')
                        ->setFacade($wholesaleFacade);
	$delPriceAction = new Action($orm);
    $delPriceAction->setName('Borrar Precio')
					    ->setDescription('Borra un precio del sistema')
                        ->setAlias('deletePrice')
                        ->setMethod('savePrice')
                        ->setUrlCode('delPrice')
                        ->setHint('Borrar Precio')
						->setIcon('total_plan_cost_delete')
                        ->setFacade($wholesaleFacade);
	$exportCSVPricesAction = new Action($orm);
    $exportCSVPricesAction->setName('Exportar Precios a CSV')
					    ->setDescription('Exporta la lista de precios a CSV')
                        ->setAlias('exportPricesCsv')
                        ->setMethod('listPrices')
                        ->setUrlCode('exportPricesCsv')
                        ->setHint('Exportar Precios a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($wholesaleFacade);	
	/* Tarifas */
	$listRatesAction = new Action($orm);
    $listRatesAction->setName('Listado de Tarifas')
					  ->setDescription('Lista las tarifas')
                      ->setAlias('listRates')
                      ->setMethod('listRates')
                      ->setUrlCode('listRates')
					  ->setIcon('reseller_account_template')
                      ->setHint('Listado de Tarifas')
                      ->setFacade($wholesaleFacade);
	$exportCSVRatesAction = new Action($orm);
    $exportCSVRatesAction->setName('Exportar Tarifas a CSV')
					    ->setDescription('Exporta la lista de tarifas a CSV')
                        ->setAlias('exportRatesCsv')
                        ->setMethod('listRates')
                        ->setUrlCode('expRatesCSV')
                        ->setHint('Exportar Tarifas a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($wholesaleFacade);	

	$listCDRsAction = new Action($orm);
    $listCDRsAction->setName('Listado de CDRs')
					  ->setDescription('Lista CDRs')
                      ->setAlias('listCDRs')
                      ->setMethod('listCDRs')
                      ->setUrlCode('listCDRs')
					  ->setIcon('document_information')
                      ->setHint('Listado de CDRs')
                      ->setFacade($wholesaleFacade);
	$detCDRsAction = new Action($orm);
    $detCDRsAction->setName('Detalle de CDR')
					  ->setDescription('Detalle de CDR')
                      ->setAlias('detailCDR')
                      ->setMethod('detailCDR')
                      ->setUrlCode('detailCDR')
					  ->setIcon('document_inspect')
                      ->setHint('Detalle de CDR')
                      ->setFacade($wholesaleFacade);
	$exportCSVCDRsAction = new Action($orm);
    $exportCSVCDRsAction->setName('Export CDRs CSV')
					    ->setDescription('Exporta la lista de CDRs a CSV')
                        ->setAlias('exportCDRsCsv')
                        ->setMethod('listCDRs')
                        ->setUrlCode('expCDRsCSV')
                        ->setHint('Exportar CDRs a CSV')
						->setIcon('file_extension_csv')
						->setParams('uws_list_action=EXPORT&uws_format=CSV&')
						->setUseAjax(false)
                        ->setFacade($wholesaleFacade);
	
	
	/* Wholesale Facade */
	$orm->save($listResellersAction); echo "Creada la acci&oacute;n de listar Resellers (listResellers)<br>";
	$orm->save($addResellersAction);  echo "Creada la acci&oacute;n de agregar Resellers (addResellers)<br>";
	$orm->save($modResellersAction);  echo "Creada la acci&oacute;n de modificar Resellers (modResellers)<br>";
	$orm->save($delResellersAction);  echo "Creada la acci&oacute;n de eliminar Resellers (delResellers)<br>";
	$orm->save($detResellerAction);  echo "Creada la acci&oacute;n de Detalle de Reseller (detResellers)<br>";
	$orm->save($exportCSVResellersAction);  echo "Creada la acci&oacute;n de Exportar Resellers (exportResellersCsv)<br>";

	$orm->save($listClientsAction);   echo "Creada la acci&oacute;n de listar Clientes (listClient)<br>";
	$orm->save($addClientsAction);    echo "Creada la acci&oacute;n de agregar Clientes (addClient)<br>";
	$orm->save($modClientsAction);    echo "Creada la acci&oacute;n de modifica Clientes (modClient)<br>";
	$orm->save($delClientsAction);    echo "Creada la acci&oacute;n de elimina Clientes (delClient)<br>";
	$orm->save($detClientAction);    echo "Creada la acci&oacute;n de Detalle Cliente (detClient)<br>";
	$orm->save($exportCSVClientAction);    echo "Creada la acci&oacute;n de Exportar Clientes (exportClientsCsv)<br>";

	$orm->save($listSitesAction);     echo "Creada la acci&oacute;n de listar Sitios (listSite)<br>";
	$orm->save($addSitesAction);      echo "Creada la acci&oacute;n de agregar Sitios (addSite)<br>";
	$orm->save($modSitesAction);      echo "Creada la acci&oacute;n de modifica Sitios (modSite)<br>";
	$orm->save($delSitesAction);      echo "Creada la acci&oacute;n de elimina Sitios (delSite)<br>";
	$orm->save($detSiteAction);      echo "Creada la acci&oacute;n de Detalle Sitios (detSite)<br>";
	$orm->save($exportCSVSitesAction);echo "Creada la acci&oacute;n de Exportar Sitios (exportSitesCsv)<br>";
	
	$orm->save($listLinesAction);     echo "Creada la acci&oacute;n de listar Lineas (listLine)<br>";
	$orm->save($addLinesAction);      echo "Creada la acci&oacute;n de agregar Lineas (addLine)<br>";
	$orm->save($modLinesAction);      echo "Creada la acci&oacute;n de modifica Lineas (modLine)<br>";
	$orm->save($delLinesAction);      echo "Creada la acci&oacute;n de elimina Lineas (delLine)<br>";
	$orm->save($detLineAction);      echo "Creada la acci&oacute;n de Detalle Linea (detLine)<br>";
	$orm->save($exportCSVLinesAction);      echo "Creada la acci&oacute;n de Exportar Lineas (exportLinesCsv)<br>";

	$orm->save($listLineTypesAction); echo "Creada la acci&oacute;n de listar tipos de Linea (listLineTypes)<br>";
	$orm->save($addLineTypeAction);  echo "Creada la acci&oacute;n de agregar tipo de Linea (addLineType)<br>";
	$orm->save($modLineTypeAction);   echo "Creada la acci&oacute;n de modifica tipo de Linea (modLineType)<br>";
	$orm->save($delLineTypeAction);   echo "Creada la acci&oacute;n de elimina tipo de Linea (delLineType)<br>";
	
	$orm->save($listNumerationBlocksAction); echo "Creada la acci&oacute;n de listar bloques de numeración (listNumerationBlocks)<br>";
	$orm->save($addNumerationBlockAction);  echo "Creada la acci&oacute;n de agregar bloque de numeración (addNumerationBlock)<br>";
	$orm->save($modNumerationBlockAction);   echo "Creada la acci&oacute;n de modificar bloque de numeración (modNumerationBlock)<br>";
	$orm->save($delNumerationBlockAction);   echo "Creada la acci&oacute;n de eliminar bloque de numeración (delNumerationBlock)<br>";
	
	$orm->save($listServicePacksAction); echo "Creada la acci&oacute;n de listar ServicePacks (listServicePacks)<br>";
	$orm->save($addServicePackAction);  echo "Creada la acci&oacute;n de agregar ServicePack (addServicePack)<br>";
	$orm->save($modServicePackAction);   echo "Creada la acci&oacute;n de modificar ServicePack (modServicePack)<br>";
	$orm->save($delServicePackAction);   echo "Creada la acci&oacute;n de eliminar ServicePack (delServicePack)<br>";
	
	$orm->save($listResourcesAction); echo "Creada la acci&oacute;n de listar Resources (listResources)<br>";
	$orm->save($addResourceAction);  echo "Creada la acci&oacute;n de agregar Resource (addResource)<br>";
	$orm->save($modResourceAction);   echo "Creada la acci&oacute;n de modificar Resource (modResource)<br>";
	$orm->save($delResourceAction);   echo "Creada la acci&oacute;n de eliminar Resource (delResource)<br>";
	
	$orm->save($listRecepcionistTypesAction); echo "Creada la acci&oacute;n de listar RecepcionistTypes (listRecepcionistTypes)<br>";
	$orm->save($addRecepcionistTypeAction);  echo "Creada la acci&oacute;n de agregar RecepcionistType (addRecepcionistType)<br>";
	$orm->save($modRecepcionistTypeAction);   echo "Creada la acci&oacute;n de modificar RecepcionistType (modRecepcionistType)<br>";
	$orm->save($delRecepcionistTypeAction);   echo "Creada la acci&oacute;n de eliminar RecepcionistType (delRecepcionistType)<br>";
	
	$orm->save($listServiceProvidersAction); echo "Creada la acci&oacute;n de listar ServiceProviders (listServiceProviders)<br>";
	$orm->save($addServiceProviderAction);  echo "Creada la acci&oacute;n de agregar ServiceProvider (addServiceProvider)<br>";
	$orm->save($modServiceProviderAction);   echo "Creada la acci&oacute;n de modificar ServiceProvider (modServiceProvider)<br>";
	$orm->save($delServiceProviderAction);   echo "Creada la acci&oacute;n de eliminar ServiceProvider (delServiceProvider)<br>";
	
	$orm->save($listPayPlansAction); echo "Creada la acci&oacute;n de listar PayPlans (listPayPlans)<br>";
	$orm->save($addPayPlanAction);  echo "Creada la acci&oacute;n de agregar PayPlan (addPayPlan)<br>";
	$orm->save($modPayPlanAction);   echo "Creada la acci&oacute;n de modificar PayPlan (modPayPlan)<br>";
	$orm->save($delPayPlanAction);   echo "Creada la acci&oacute;n de eliminar PayPlan (delPayPlan)<br>";
	//Grupos de Prefijos
	$orm->save($listPrefixGroupsAction);		echo "Creada la acci&oacute;n de Listar los Grupos de Prefijos (listPrefixGroups)<br>";
	$orm->save($addPrefixGroupAction);		echo "Creada la acci&oacute;n de Agregar Grupo de Prefijos (addPrefixGroup)<br>";
	$orm->save($modPrefixGroupAction);		echo "Creada la acci&oacute;n de Modificar Grupo de Prefijos (modPrefixGroup)<br>";
	$orm->save($delPrefixGroupAction);		echo "Creada la acci&oacute;n de Quitar Grupo de Prefijos (delPrefixGroup)<br>";
	//Prefijos
	$orm->save($listPrefixesAction);		echo "Creada la acci&oacute;n de Listar los Prefijos (listPrefix)<br>";
	$orm->save($addPrefixAction);		echo "Creada la acci&oacute;n de Agregar Prefijos (addPrefix)<br>";
	$orm->save($modPrefixAction);		echo "Creada la acci&oacute;n de Modificar Prefijos (modPrefix)<br>";
	$orm->save($delPrefixAction);		echo "Creada la acci&oacute;n de Borrar Prefijos (delPrefix)<br>";
	// Listas de Precios
	$orm->save($listPricesListsAction);  echo "Creada la acci&oacute;n de Mostrar las Listas de Precios (listPricesLists)<br>";
	$orm->save($addPricesListAction);    echo "Creada la acci&oacute;n de Subir una Lista de Precios desde CSV(addPricesList)<br>";
	$orm->save($modPricesListAction);    echo "Creada la acci&oacute;n de Subir una Lista de Precios desde CSV(modPricesList)<br>";
	$orm->save($delPricesListAction);    echo "Creada la acci&oacute;n de Quitar una Lista de Precios desde CSV(delPricesList)<br>";
	
	//Precios
	$orm->save($listPricesAction);      echo "Creada la acci&oacute;n de listar Precios (listPrices)<br>";
	$orm->save($addPriceAction);		echo "Creada la acci&oacute;n de agregar Precios (addPrices)<br>";
	$orm->save($modPriceAction);		echo "Creada la acci&oacute;n de modificar Precios (modPrices)<br>";
	$orm->save($delPriceAction);		echo "Creada la acci&oacute;n de borrar Precios (delPrices)<br>";
	$orm->save($exportCSVPricesAction);		echo "Creada la acci&oacute;n de exportar Precios (exportPricesCsv)<br>";
	
	//Tarifas
	$orm->save($listRatesAction);		echo "Creada la acci&oacute;n de listar Tarifas (listRates)<br>";
	$orm->save($exportCSVRatesAction);  echo "Creada la acci&oacute;n de exportar Tarifas a CSV(expRatesCSV)<br>";
	
	$orm->save($listCDRsAction);		echo "Creada la acci&oacute;n de listar CDRs (listCDRs)<br>";
	$orm->save($detCDRsAction);			echo "Creada la acci&oacute;n de detalle CDR (detCDR)<br>";
	$orm->save($exportCSVCDRsAction);   echo "Creada la acci&oacute;n de Exportar CDR (exportCDRsCsv)<br>";
	
	
	/* Provisioning Facade */

	$provisioningAction = new Action($orm);
    $provisioningAction->setName('AutoAprovisionar')
					  ->setDescription('Aprovisiona desde Tenfold')
                      ->setAlias('autoProvisioning')
                      ->setMethod('autoProvisioning')
                      ->setUrlCode('autoProvisioning')
					  ->setIcon('document_information')
                      ->setHint('AutoAprovisionar')
                      ->setFacade($autoProvisioningFacade);
	$orm->save($provisioningAction);	echo "Creada la acci&oacute;n de AutoAprovisionar (provisioningAction)<br>";

	$viewErrorsAction = new Action($orm);
    $viewErrorsAction->setName('Ver Log')
					  ->setDescription('Muestra errores de autoaprovisionamiento')
                      ->setAlias('listLogs')
                      ->setMethod('listLogs')
                      ->setUrlCode('listLogs')
					  ->setIcon('report_magnify')
                      ->setHint('Ver Log')
                      ->setFacade($autoProvisioningFacade);
	$orm->save($viewErrorsAction);	echo "Creada la acci&oacute;n de Ver Errores (listLogs)<br>";
	
	$listServiceOrderTaskAction = new Action($orm);
    $listServiceOrderTaskAction->setName('Ver ServiceOrderTask')
					  ->setDescription('Muestra el listado de ServiceOrderTasks')
                      ->setAlias('listServiceOrderTasks')
                      ->setMethod('listServiceOrderTasks')
                      ->setUrlCode('listServiceOrderTasks')
					  ->setIcon('report_magnify')
                      ->setHint('Ver ServiceOrderTask')
                      ->setFacade($autoProvisioningFacade);
	$orm->save($listServiceOrderTaskAction);	echo "Creada la acci&oacute;n de Ver Errores (listLogs)<br>";
	
	$listSerivceOrderLogsAction = new Action($orm);
    $listSerivceOrderLogsAction->setName('Ver Logs ServiceOrder')
					  ->setDescription('Listado de Logs de ServiceOrderTask')
                      ->setAlias('listSOLogs')
                      ->setMethod('listServiceOrderTaskLogs')
                      ->setUrlCode('listSOLogs')
					  ->setIcon('report_magnify')
                      ->setHint('Ver ServiceOrder Logs')
                      ->setFacade($autoProvisioningFacade);
	$orm->save($listSerivceOrderLogsAction);	echo "Creada la acci&oacute;n de Ver Logs ServiceOrder (listLogsSO)<br>";

	$listProcessAction = new Action($orm);
    $listProcessAction->setName('Mostrar Procesos')
					  ->setDescription('Muestra el listado de procesos')
                      ->setAlias('listProcess')
                      ->setMethod('listProcess')
                      ->setUrlCode('listProcess')
					  ->setIcon('layer')
                      ->setHint('Ver Procesos')
                      ->setFacade($autoProvisioningFacade);
	$orm->save($listProcessAction);	echo "Creada la acci&oacute;n de Listar Procesos (listProcess)<br>";
	
	$viewProcessXMLAction = new Action($orm);
    $viewProcessXMLAction->setName('Ver XMLs de Proceso')
					  ->setDescription('Muestra un detalle de un los mensajes XML')
                      ->setAlias('listXMLProcess')
                      ->setMethod('listXMLProcess')
                      ->setUrlCode('listXMLProc')
					  ->setIcon('information')
                      ->setHint('Ver XMLs')
                      ->setFacade($autoProvisioningFacade);
	$orm->save($viewProcessXMLAction);	echo "Creada la acci&oacute;n de Ver XMLs de un Proceso (listXMLProcess)<br>";
	
	
	
	$listOperationTypeAction = new Action($orm);
    $listOperationTypeAction->setName('Listado de Tipos de Operación')
					    ->setDescription('Muestra los Tipos de Operación')
                        ->setAlias('listOperationTypes')
                        ->setMethod('listOperationTypes')
                        ->setUrlCode('listOperationTypes')
                        ->setHint('Ver Tipos de Operación')
						->setIcon('information')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($listOperationTypeAction);	echo "Creada la acci&oacute;n de Listado de Tipos de Operación (listOperationTypes)<br>";
	
	$addOperationTypeAction = new Action($orm);
    $addOperationTypeAction->setName('Agregar Tipo de Operación')
					    ->setDescription('Agrega un Tipo de Operación')
                        ->setAlias('addOperationType')
                        ->setMethod('saveOperationType')
                        ->setUrlCode('addOperationType')
                        ->setHint('Agregar Tipo de Operación')
						->setIcon('information')
						->setParams('user_action=NEW&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($addOperationTypeAction);	echo "Creada la acci&oacute;n de Agregar Listado de Tipos de Operación (addOperationType)<br>";
	
	$modOperationTypeAction = new Action($orm);
    $modOperationTypeAction->setName('Modificar Tipo de Operación')
					    ->setDescription('Modifica un Tipo de Operación')
                        ->setAlias('modifyOperationType')
                        ->setMethod('saveOperationType')
                        ->setUrlCode('modOperationType')
                        ->setHint('Modificar OperationType')
						->setIcon('information')
						->setParams('user_action=MODIFY&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($modOperationTypeAction);	echo "Creada la acci&oacute;n de Modificar de Tipo de Operación (modifyOperationType)<br>";
	$delOperationTypeAction = new Action($orm);
    $delOperationTypeAction->setName('Borrar Tipo de Operación')
					    ->setDescription('Borra un Tipo de Operación')
                        ->setAlias('deleteOperationType')
                        ->setMethod('saveOperationType')
                        ->setUrlCode('delOperationType')
                        ->setHint('Borrar Tipo de Operación')
						->setIcon('information')
						->setParams('user_action=DELETE&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($delOperationTypeAction);	echo "Creada la acci&oacute;n de Eliminar Tipo de Operación (deleteOperationType)<br>";
	
	$listPlataformsAction = new Action($orm);
    $listPlataformsAction->setName('Listado de Plataformas')
					    ->setDescription('Muestra las Plataformas')
                        ->setAlias('listPlataforms')
                        ->setMethod('listPlataforms')
                        ->setUrlCode('listPlataforms')
                        ->setHint('Ver Plataformas')
						->setIcon('information')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($listPlataformsAction);	echo "Creada la acci&oacute;n de Listado de Plataformas (listPlataforms)<br>";
	
	$addPlataformAction = new Action($orm);
    $addPlataformAction->setName('Agregar Plataforma')
					    ->setDescription('Agrega Plataforma')
                        ->setAlias('addPlataform')
                        ->setMethod('savePlataform')
                        ->setUrlCode('addPlataform')
                        ->setHint('Agregar Plataforma')
						->setIcon('information')
						->setParams('user_action=NEW&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($addPlataformAction);	echo "Creada la acci&oacute;n de Agregar Plataforma (addPlataform)<br>";
	
	$modPlataformAction = new Action($orm);
    $modPlataformAction->setName('Modificar Plataforma')
					    ->setDescription('Modifica una Plataforma')
                        ->setAlias('modifyPlataform')
                        ->setMethod('savePlataform')
                        ->setUrlCode('modPlataform')
                        ->setHint('Modificar Plataforma')
						->setIcon('information')
						->setParams('user_action=MODIFY&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($modPlataformAction);	echo "Creada la acci&oacute;n de Modificar Plataforma (modifyPlataform)<br>";
	
	$delPlataformTypeAction = new Action($orm);
    $delPlataformTypeAction->setName('Borrar Plataforma')
					    ->setDescription('Borra una Plataforma')
                        ->setAlias('deletePlataform')
                        ->setMethod('savePlataform')
                        ->setUrlCode('delPlataform')
                        ->setHint('Borrar Plataforma')
						->setIcon('information')
						->setParams('user_action=DELETE&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($delPlataformTypeAction);	echo "Creada la acci&oacute;n de Eliminar Plataforma (deletePlataform)<br>";
	
	
	$listProvisionableClassAction = new Action($orm);
    $listProvisionableClassAction->setName('Listado de Clases')
					    ->setDescription('Muestra las Clases Aprovisionables')
                        ->setAlias('listClasses')
                        ->setMethod('listClasses')
                        ->setUrlCode('listClasses')
                        ->setHint('Ver Clases Aprovisionables')
						->setIcon('information')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($listProvisionableClassAction);	echo "Creada la acci&oacute;n de Listado de Clases Aprovisionables (listClasses)<br>";
	
	$addProvisionableClassAction = new Action($orm);
    $addProvisionableClassAction->setName('Agregar Clase')
					    ->setDescription('Agrega Clase Aprovisionable')
                        ->setAlias('addClass')
                        ->setMethod('saveClass')
                        ->setUrlCode('addClass')
                        ->setHint('Agregar Clases Aprovisionable')
						->setIcon('information')
						->setParams('user_action=NEW&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($addProvisionableClassAction);	echo "Creada la acci&oacute;n de Agregar Clase Aprovisionable (addClass)<br>";
	
	$modProvisionableClassAction = new Action($orm);
    $modProvisionableClassAction->setName('Modificar Clase')
					    ->setDescription('Modifica una Clase Aprovisionable')
                        ->setAlias('modifyClass')
                        ->setMethod('saveClass')
                        ->setUrlCode('modClass')
                        ->setHint('Modificar Clases Aprovisionable')
						->setIcon('information')
						->setParams('user_action=MODIFY&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($modProvisionableClassAction);	echo "Creada la acci&oacute;n de Modificar Clase Aprovisionable (modifyClass)<br>";
	
	$delProvisionableClassAction = new Action($orm);
    $delProvisionableClassAction->setName('Borrar Clase')
					    ->setDescription('Borra una Clase Aprovisionable')
                        ->setAlias('deleteClass')
                        ->setMethod('saveClass')
                        ->setUrlCode('delClass')
                        ->setHint('Borrar Plataforma')
						->setIcon('information')
						->setParams('user_action=DELETE&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($delProvisionableClassAction);	echo "Creada la acci&oacute;n de Eliminar Clase Aprovisionable (deleteClass)<br>";
	
	
	$listTaskConfigurationAction = new Action($orm);
    $listProvisionableClassAction->setName('Listado TaskConfigurations')
					    ->setDescription('Muestra las Configuraciones de Tarea')
                        ->setAlias('listTaskConfigurations')
                        ->setMethod('listTaskConfigurations')
                        ->setUrlCode('listTaskConfigurations')
                        ->setHint('Ver Configuraciones de Tarea')
						->setIcon('information')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($listProvisionableClassAction);	echo "Creada la acci&oacute;n de Listado de Configuraciones de Tareas (listTaskConfigurations)<br>";
	
	$addTaskConfigurationAction = new Action($orm);
    $addTaskConfigurationAction->setName('Agregar TaskConfigurations')
					    ->setDescription('Agrega Configuración de Tarea')
                        ->setAlias('addTaskConfiguration')
                        ->setMethod('saveTaskConfiguration')
                        ->setUrlCode('addTaskConfiguration')
                        ->setHint('Agregar Configuración de Tarea')
						->setIcon('information')
						->setParams('user_action=NEW&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($addTaskConfigurationAction);	echo "Creada la acci&oacute;n de Agregar Configuración de Tarea (addTaskConfiguration)<br>";
	
	$modTaskConfigurationAction = new Action($orm);
    $modTaskConfigurationAction->setName('Modificar TaskConfigurations')
					    ->setDescription('Modifica una Configuración de Tarea')
                        ->setAlias('modifyTaskConfiguration')
                        ->setMethod('saveTaskConfiguration')
                        ->setUrlCode('modTaskConfiguration')
                        ->setHint('Modificar Configuración de Tarea')
						->setIcon('information')
						->setParams('user_action=MODIFY&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($modTaskConfigurationAction);	echo "Creada la acci&oacute;n de Modificar Configuración de Tarea (modifyTaskConfiguration)<br>";
	
	$delTaskConfigurationAction = new Action($orm);
    $delTaskConfigurationAction->setName('Borrar TaskConfigurations')
					    ->setDescription('Borra una Configuración de Tarea')
                        ->setAlias('deleteTaskConfiguration')
                        ->setMethod('saveTaskConfiguration')
                        ->setUrlCode('delTaskConfiguration')
                        ->setHint('Borrar Configuración de Tarea')
						->setIcon('information')
						->setParams('user_action=DELETE&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($delTaskConfigurationAction);	echo "Creada la acci&oacute;n de Eliminar Configuración de Tarea (deleteTaskConfiguration)<br>";

	$listStatusAction = new Action($orm);
    $listStatusAction->setName('Listado de Estados')
					    ->setDescription('Muestra los Estados de Provisioning')
                        ->setAlias('listStatus')
                        ->setMethod('listStatus')
                        ->setUrlCode('listStatus')
                        ->setHint('Ver Estados de Provisioning')
						->setIcon('information')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($listStatusAction);	echo "Creada la acci&oacute;n de Listado de Estado de Provisioning (listStatus)<br>";
	
	$addStatusAction = new Action($orm);
    $addStatusAction->setName('Agregar Estado')
					    ->setDescription('Agrega Estado de Provisioning')
                        ->setAlias('addStatus')
                        ->setMethod('saveStatus')
                        ->setUrlCode('addStatus')
                        ->setHint('Agregar Estado de Provisioning')
						->setIcon('information')
						->setParams('user_action=NEW&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($addStatusAction);	echo "Creada la acci&oacute;n de Agregar Estado de Provisioning (addStatus)<br>";
	
	$modStatusAction = new Action($orm);
    $modStatusAction->setName('Modificar Estado')
					    ->setDescription('Modifica un Estado de Provisioning')
                        ->setAlias('modifyStatus')
                        ->setMethod('saveStatus')
                        ->setUrlCode('modStatus')
                        ->setHint('Modificar Estado de Provisioning')
						->setIcon('information')
						->setParams('user_action=MODIFY&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($modStatusAction);	echo "Creada la acci&oacute;n de Modificar Estado de Provisioning (modifyStatus)<br>";
	
	$delStatusAction = new Action($orm);
    $delStatusAction->setName('Borrar Estado')
					    ->setDescription('Borra un Estado de Provisioning')
                        ->setAlias('deleteStatus')
                        ->setMethod('saveStatus')
                        ->setUrlCode('delStatus')
                        ->setHint('Borrar Estado de Provisioning')
						->setIcon('information')
						->setParams('user_action=DELETE&')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($delStatusAction);	echo "Creada la acci&oacute;n de Eliminar Estado de Provisioning (deleteStatus)<br>";
	
	$listTransactionAction = new Action($orm);
    $listTransactionAction->setName('Listado de Transacciones')
					    ->setDescription('Muestra las Transacciones')
                        ->setAlias('listTransactions')
                        ->setMethod('listTransactions')
                        ->setUrlCode('listTransactions')
                        ->setHint('Ver Transacciones')
						->setIcon('information')
                        ->setFacade($autoProvisioningFacade);
	$orm->save($listTransactionAction);	echo "Creada la acci&oacute;n de Listado de Transacciones (listTransactions)<br>";
	
    //Configurar Perfiles
    echo "<br><b>Configurando Perfiles</b><br>";
    foreach(array($anonymuosProfile, $anonymuosProfile2, $anonymuosProfile3) as $anonymous) {
        $anonymous->addAction($loginAction);     echo $anonymous->getName(). "-&gt;Login<br/>";
        $anonymous->addAction($defaultAction);   echo $anonymous->getName(). "-&gt;Default Action<br/>";
        $anonymous->addAction($redirectAction);  echo $anonymous->getName(). "-&gt;Redirect<br/>";
        $anonymous->addAction($AnnNothingAction);echo $anonymous->getName(). "-&gt;Nothing Annonymous<br/>";
        $anonymous->addAction($showErrorAction); echo $anonymous->getName(). "-&gt;Mostrar Errores<br/>";
        //Le agrego logout hasta que arregle el redirect()
        //TODO: quitar logout
//        $anonymous->addAction($logoutAction);    echo $anonymous->getName()."-&gt;Logout<br/>";
        $anonymous->save();                      echo $anonymous->getName(). " Guardado<br/><br/>";
    }
    foreach(array($registeredProfile, $registeredProfile2, $registeredProfile3) as $registered) {
        $registered->addAction($logoutAction);    echo $registered->getName()."-&gt;Logout<br/>";
        $registered->addAction($mainAction);      echo $registered->getName()."-&gt;Main Action<br/>";
        $registered->addAction($defaultAction);   echo $registered->getName()."-&gt;Default Action<br/>";
        $registered->addAction($redirectAction);  echo $registered->getName()."-&gt;Redirect<br/>";
        $registered->addAction($NothingAction);   echo $registered->getName()."-&gt;Nothing<br/>";
        $registered->addAction($AnnNothingAction);echo $registered->getName(). "-&gt;Nothing Annonymous<br/>";
        $registered->addAction($showErrorAction); echo $registered->getName(). "-&gt;Mostrar Errores<br/>";
        $registered->save();                      echo $registered->getName()." Guardado<br/><br/>";
    }
    foreach(array($adminProfile, $adminProfile2, $adminProfile3) as $admin) {
        $admin->addAction($logoutAction);        echo $admin->getName()."-&gt;Logout<br/>";
        $admin->addAction($mainAction);          echo $admin->getName()."-&gt;Main Action<br/>";
        $admin->addAction($defaultAction);       echo $admin->getName()."-&gt;Default Action<br/>";
        $admin->addAction($redirectAction);      echo $admin->getName()."-&gt;Redirect<br/>";
        $admin->addAction($NothingAction);       echo $admin->getName()."-&gt;Nothing<br/>";
        $admin->addAction($AnnNothingAction);    echo $admin->getName(). "-&gt;Nothing Annonymous<br/>";
        $admin->addAction($listUsersAction);     echo $admin->getName()."-&gt;List Users<br/>";
		$admin->addAction($exportCSVUsersAction);echo $admin->getName()."-&gt;Export Users<br/>";
        $admin->addAction($addUserAction);       echo $admin->getName()."-&gt;Add User<br/>";
		$admin->addAction($modUserAction);       echo $admin->getName()."-&gt;Mod User<br/>";
		$admin->addAction($changePasswordAction);       echo $admin->getName()."-&gt;Change Password<br/>";
		$admin->addAction($modUserProfilesAction);       echo $admin->getName()."-&gt;Mod User Profiles<br/>";
		$admin->addAction($delUserAction);       echo $admin->getName()."-&gt;Del User<br/>";
		$admin->addAction($savUserAction);       echo $admin->getName()."-&gt;Save User<br/>";
        $admin->addAction($listProfilesAction);  echo $admin->getName()."-&gt;List Profiles<br/>";
		$admin->addAction($exportCSVProfilesAction);  echo $admin->getName()."-&gt;Export Profiles<br/>";
        $admin->addAction($addProfilesAction);   echo $admin->getName()."-&gt;Add Profile<br/>";
		$admin->addAction($modProfilesAction);   echo $admin->getName()."-&gt;Mod Profile<br/>";
		$admin->addAction($delProfilesAction);   echo $admin->getName()."-&gt;Del Profile<br/>";
		$admin->addAction($listProvidersAction); echo $admin->getName()."-&gt;List Providers<br/>";
		$admin->addAction($exportCSVProvidersAction); echo $admin->getName()."-&gt;Export Providers<br/>";
		$admin->addAction($addProviderAction);   echo $admin->getName()."-&gt;Add Providers<br/>";
		$admin->addAction($modProviderAction);   echo $admin->getName()."-&gt;Mod Providers<br/>";
		$admin->addAction($delProviderAction);   echo $admin->getName()."-&gt;Del Providers<br/>";
        $admin->addAction($listActionsAction);   echo $admin->getName()."-&gt;List Actions<br/>";
        $admin->addAction($addActionAction);     echo $admin->getName()."-&gt;Add Action<br/>";
		$admin->addAction($modActionAction);     echo $admin->getName()."-&gt;Mod Action<br/>";
		$admin->addAction($delActionAction);     echo $admin->getName()."-&gt;Del Action<br/>";
		$admin->addAction($exportCSVActionsAction); echo $admin->getName()."-&gt;Export Actions<br/>";
        $admin->addAction($showErrorAction);     echo $admin->getName()."-&gt;Mostrar Errores<br/>";
        $admin->addAction($listMenusAction);     echo $admin->getName()."-&gt;List Menus<br/>";
        $admin->addAction($addMenuAction);     echo $admin->getName()."-&gt;Add Menu<br/>";
        $admin->addAction($delMenuAction);     echo $admin->getName()."-&gt;Del Menu<br/>";
        $admin->addAction($modMenuAction);     echo $admin->getName()."-&gt;Mod Menu<br/>";
        $admin->addAction($listFacadesAction);     echo $admin->getName()."-&gt;List Facades<br/>";
        $admin->addAction($addFacadeAction);     echo $admin->getName()."-&gt;Add Facade<br/>";
        $admin->addAction($delFacadeAction);     echo $admin->getName()."-&gt;Del Facade<br/>";
        $admin->addAction($modFacadeAction);     echo $admin->getName()."-&gt;Mod Facade<br/>";
		
		/* Wholesale Facade */
		$admin->addAction($listResellersAction); echo $admin->getName()."-&gt;Listado de Resellers<br/>";
		$admin->addAction($addResellersAction);  echo $admin->getName()."-&gt;Agregar Reseller<br/>";
		$admin->addAction($modResellersAction);  echo $admin->getName()."-&gt;Modificar Reseller<br/>";
		$admin->addAction($delResellersAction);  echo $admin->getName()."-&gt;Eliminar Reseller<br/>";
		$admin->addAction($detResellerAction);  echo $admin->getName()."-&gt;Detalle de  Reseller<br/>";
		$admin->addAction($exportCSVResellersAction);  echo $admin->getName()."-&gt;Exportar Reseller<br/>";
		
		$admin->addAction($listClientsAction);   echo $admin->getName()."-&gt;Listado de Clientes<br/>";
		$admin->addAction($addClientsAction);    echo $admin->getName()."-&gt;Agregar Clientes<br/>";
		$admin->addAction($modClientsAction);    echo $admin->getName()."-&gt;Modificar Clientes<br/>";
		$admin->addAction($delClientsAction);    echo $admin->getName()."-&gt;Eliminar Clientes<br/>";
		$admin->addAction($detClientAction);    echo $admin->getName()."-&gt;Detalle Cliente<br/>";
		$admin->addAction($exportCSVClientAction);    echo $admin->getName()."-&gt;Exportar Clientes<br/>";

		$admin->addAction($listSitesAction);     echo $admin->getName()."-&gt;Listado de Sitios<br/>";
		$admin->addAction($addSitesAction);      echo $admin->getName()."-&gt;Agregar Sitios<br/>";
		$admin->addAction($modSitesAction);      echo $admin->getName()."-&gt;Modificar Sitios<br/>";
		$admin->addAction($delSitesAction);      echo $admin->getName()."-&gt;Eliminar Sitios<br/>";
		$admin->addAction($detSiteAction);      echo $admin->getName()."-&gt;Detalle de Sitio<br/>";
		$admin->addAction($exportCSVSitesAction);echo $admin->getName()."-&gt;Exportar Sitio<br/>";
		
		$admin->addAction($listLinesAction);     echo $admin->getName()."-&gt;Listado de Lineas<br/>";
		$admin->addAction($addLinesAction);      echo $admin->getName()."-&gt;Agregar Lineas<br/>";
		$admin->addAction($modLinesAction);      echo $admin->getName()."-&gt;Modificar Lineas<br/>";
		$admin->addAction($delLinesAction);      echo $admin->getName()."-&gt;Eliminar Lineas<br/>";
		$admin->addAction($detLineAction);      echo $admin->getName()."-&gt;Detalle de Lineas<br/>";
		$admin->addAction($exportCSVLinesAction);echo $admin->getName()."-&gt;Exportar Lineas<br/>";

		$admin->addAction($listLineTypesAction); echo $admin->getName()."-&gt;Listado de tipos de Linea<br/>";
		$admin->addAction($addLineTypeAction);   echo $admin->getName()."-&gt;Agregar tipo de Linea<br/>";
		$admin->addAction($modLineTypeAction);   echo $admin->getName()."-&gt;Modificar tipo de Linea<br/>";
		$admin->addAction($delLineTypeAction);   echo $admin->getName()."-&gt;Eliminar tipo de Linea<br/>";
		
		$admin->addAction($listNumerationBlocksAction); echo $admin->getName()."-&gt;Listado de bloques de numeración<br/>";
		$admin->addAction($addNumerationBlockAction);   echo $admin->getName()."-&gt;Agregar bloque de numeración<br/>";
		$admin->addAction($modNumerationBlockAction);   echo $admin->getName()."-&gt;Modificar bloque de numeración<br/>";
		$admin->addAction($delNumerationBlockAction);   echo $admin->getName()."-&gt;Eliminar bloque de numeración<br/>";
		
		$admin->addAction($listServicePacksAction); echo $admin->getName()."-&gt;Listado de ServicePacks<br/>";
		$admin->addAction($addServicePackAction);   echo $admin->getName()."-&gt;Agregar ServicePack<br/>";
		$admin->addAction($modServicePackAction);   echo $admin->getName()."-&gt;Modificar ServicePack<br/>";
		$admin->addAction($delServicePackAction);   echo $admin->getName()."-&gt;Eliminar ServicePack<br/>";
		
		$admin->addAction($listResourcesAction); echo $admin->getName()."-&gt;Listado de Resources<br/>";
		$admin->addAction($addResourceAction);   echo $admin->getName()."-&gt;Agregar Resource<br/>";
		$admin->addAction($modResourceAction);   echo $admin->getName()."-&gt;Modificar Resource<br/>";
		$admin->addAction($delResourceAction);   echo $admin->getName()."-&gt;Eliminar Resource<br/>";
		
		
		$admin->addAction($listRecepcionistTypesAction); echo $admin->getName()."-&gt;Listado de RecepcionistTypes<br/>";
		$admin->addAction($addRecepcionistTypeAction);   echo $admin->getName()."-&gt;Agregar RecepcionistType<br/>";
		$admin->addAction($modRecepcionistTypeAction);   echo $admin->getName()."-&gt;Modificar RecepcionistType<br/>";
		$admin->addAction($delRecepcionistTypeAction);   echo $admin->getName()."-&gt;Eliminar RecepcionistType<br/>";
		
		$admin->addAction($listServiceProvidersAction); echo $admin->getName()."-&gt;Listado de ServiceProviders<br/>";
		$admin->addAction($addServiceProviderAction);   echo $admin->getName()."-&gt;Agregar ServiceProvider<br/>";
		$admin->addAction($modServiceProviderAction);   echo $admin->getName()."-&gt;Modificar ServiceProvider<br/>";
		$admin->addAction($delServiceProviderAction);   echo $admin->getName()."-&gt;Eliminar ServiceProvider<br/>";
		
		
		$admin->addAction($listPayPlansAction); echo $admin->getName()."-&gt;Listado de PayPlans<br/>";
		$admin->addAction($addPayPlanAction);   echo $admin->getName()."-&gt;Agregar PayPlan<br/>";
		$admin->addAction($modPayPlanAction);   echo $admin->getName()."-&gt;Modificar PayPlan<br/>";
		$admin->addAction($delPayPlanAction);   echo $admin->getName()."-&gt;Eliminar PayPlan<br/>";
		
		//Grupos de Prefijos
		$admin->addAction($listPrefixGroupsAction); echo $admin->getName()."-&gt;Listar Grupos de Prefijos<br/>";
		$admin->addAction($addPrefixGroupAction); echo $admin->getName()."-&gt;Agregar Grupo de Prefijos<br/>";
		$admin->addAction($modPrefixGroupAction); echo $admin->getName()."-&gt;Modificar Grupo de Prefijos<br/>";
		$admin->addAction($delPrefixGroupAction); echo $admin->getName()."-&gt;Borrar Grupo de Prefijos<br/>";

		//Prefijos
		$admin->addAction($listPrefixesAction); echo $admin->getName()."-&gt;Listar Prefijos<br/>";
		$admin->addAction($addPrefixAction); echo $admin->getName()."-&gt;Agregar Prefijo<br/>";
		$admin->addAction($modPrefixAction); echo $admin->getName()."-&gt;Modificar Prefijo<br/>";
		$admin->addAction($delPrefixAction); echo $admin->getName()."-&gt;Borrar Prefijo<br/>";

		//Listas de Precios
		$admin->addAction($listPricesListsAction); echo $admin->getName()."-&gt;Listar Listas de Precios<br/>";
		$admin->addAction($addPricesListAction); echo $admin->getName()."-&gt;Subir Listas de Precios<br/>";
		$admin->addAction($modPricesListAction); echo $admin->getName()."-&gt;Modificar Listas de Precios<br/>";
		$admin->addAction($delPricesListAction); echo $admin->getName()."-&gt;Quitar Listas de Precios<br/>";
		

		//Precios
		$admin->addAction($listPricesAction);      echo $admin->getName()."-&gt;Listado de Precios<br/>";
		$admin->addAction($addPriceAction);      echo $admin->getName()."-&gt;Agregar Precio<br/>";
		$admin->addAction($modPriceAction);      echo $admin->getName()."-&gt;Modificar Precio<br/>";
		$admin->addAction($delPriceAction);      echo $admin->getName()."-&gt;Borrar Precio<br/>";
		$admin->addAction($exportCSVPricesAction); echo $admin->getName()."-&gt;Exportar Precios<br/>";

		//Tarifas
		$admin->addAction($listRatesAction);      echo $admin->getName()."-&gt;Listado de Tarifas<br/>";
		$admin->addAction($exportCSVRatesAction); echo $admin->getName()."-&gt;Exportar Tarifas<br/>";

		$admin->addAction($listCDRsAction);      echo $admin->getName()."-&gt;Listado de CDRs<br/>";
		$admin->addAction($detCDRsAction);      echo $admin->getName()."-&gt;Detalle de CDR<br/>";
		$admin->addAction($exportCSVCDRsAction);echo $admin->getName()."-&gt;Exportar CDRs<br/>";
		
/* AUTOPROVISIONING ACTIONS */
		$admin->addAction($provisioningAction);echo $admin->getName()."-&gt;Autoprovisioning<br/>";
		$admin->addAction($viewErrorsAction);echo $admin->getName()."-&gt;Ver Errores<br/>";
		$admin->addAction($listServiceOrderTaskAction);echo $admin->getName()."-&gt;Ver Listado de ServiceOrderTasks<br/>";
		$admin->addAction($listSerivceOrderLogsAction);echo $admin->getName()."-&gt;Ver Logs de ServiceOrder<br/>";
		$admin->addAction($viewProcessXMLAction);echo $admin->getName()."-&gt;Ver Detalle de Errores<br/>";
		$admin->addAction($listProcessAction);echo $admin->getName()."-&gt;Ver Listado de Procesos<br/>";
		
        $admin->save();                          echo $admin->getName()." Guardado<br/><br/>";
    }

    //Crear Usuarios y configurar Perfiles
    echo "<br><b>Creando Usuarios</b><br>";
    $adminUser = new User($orm);
    $adminUser->setName('iPlan - Admin')
              ->setUsername('admin')
			  ->setSurname('admin')
              ->setpassword(sha1('admin'))
              ->addProfile($adminProfile)
              ->setProvider($iplanProvider);
    $adminUser->save(); echo "Usuario 'admin' (iPlan) asignado a ".$adminProfile->getName()."<br/>";
    $adminUser2 = new User($orm);
    $adminUser2->setName('Client - Admin')
			  ->setSurname('admin')
              ->setUsername('admin')
              ->setpassword(sha1('admin'))
              ->addProfile($adminProfile2)
              ->setProvider($clientProvider);
    $adminUser2->save(); echo "Usuario 'admin' (Client) asignado a ".$adminProfile2->getName()."<br/>";
	$adminUser3 = new User($orm);
    $adminUser3->setName('Administrador localhotero')
              ->setUsername('admin')
			  ->setSurname('admin')
              ->setpassword(sha1('admin'))
              ->addProfile($adminProfile3)
              ->setProvider($localhostProvider);
    $adminUser3->save(); echo "Usuario 'admin' (Localhostero) asignado a ".$adminProfile3->getName()."<br/>";
    $registeredUser = new User($orm);
    $registeredUser->setName('iPlan - Registered')
			   ->setSurname('registered')
              ->setUsername('registered')
              ->setpassword(sha1('registered'))
              ->addProfile($registeredProfile)
              ->setProvider($iplanProvider);
    $registeredUser->save(); echo "Usuario 'registered' (iPlan) asignado a ".$registeredProfile->getName()."<br/>";
    $registeredUser2 = new User($orm);
    $registeredUser2->setName('Client - Registered')
			  ->setSurname('registered')
              ->setUsername('registered')
              ->setpassword(sha1('registered'))
              ->addProfile($registeredProfile2)
              ->setProvider($clientProvider);
    $registeredUser2->save(); echo "Usuario 'registered' (Client) asignado a ".$registeredProfile2->getName()."<br/>";
	$registeredUser3 = new User($orm);
    $registeredUser3->setName('Usuario común')
			   ->setSurname('usuario')
              ->setUsername('usuario')
              ->setpassword(sha1('usuario'))
              ->addProfile($registeredProfile3)
              ->setProvider($localhostProvider);
    $registeredUser3->save(); echo "Usuario 'usuario' (Localhostero) asignado a ".$registeredProfile3->getName()."<br/>";
    $anonymuosUser = new User($orm);
    $anonymuosUser->setName('Anonymous')
			  ->setSurname('anonymous')
              ->setUsername('anonymous')
              ->setpassword(sha1('anonymous'))
              ->addProfile($anonymuosProfile)
              ->setProvider($iplanProvider);
    $anonymuosUser->save(); echo "Usuario 'anonymous' asignado a ".$generalManager->toHTML($anonymuosProfile->getName()).
                                 " y ".$generalManager->toHTML($anonymuosProfile2->getName())." para (iPlan)<br/>";
    $anonymuosUser2 = new User($orm);
    $anonymuosUser2->setName('Anonymous')
			  ->setSurname('anonymous')
              ->setUsername('anonymous')
              ->setpassword(sha1('anonymous'))
              ->addProfile($anonymuosProfile2)
              ->setProvider($clientProvider);
    $anonymuosUser2->save(); echo "Usuario 'anonymous' asignado a ".$generalManager->toHTML($anonymuosProfile2->getName()).
                                 " y ".$generalManager->toHTML($anonymuosProfile2->getName())." para (Client)<br/>";
	$anonymuosUser3 = new User($orm);
    $anonymuosUser3->setName('Anonymous')
			  ->setSurname('anonymous')
              ->setUsername('anonymous')
              ->setpassword(sha1('anonymous'))
              ->addProfile($anonymuosProfile3)
              ->setProvider($localhostProvider);
    $anonymuosUser3->save(); echo "Usuario 'anonymous' asignado a ".$generalManager->toHTML($anonymuosProfile3->getName()).
                                 " y ".$generalManager->toHTML($anonymuosProfile3->getName())." para (Localhost)<br/>";

    $iplanProvider->setAnonymous($anonymuosUser);
    $iplanProvider->save(); echo "Registrando el user ".$anonymuosUser->getName()." con ". $iplanProvider->getName()."<br/>";
    $clientProvider->setAnonymous($anonymuosUser2);
    $clientProvider->save(); echo "Registrando el user ".$anonymuosUser2->getName()." con ". $clientProvider->getName()."<br/>";
	$localhostProvider->setAnonymous($anonymuosUser3);
    $localhostProvider->save(); echo "Registrando el user ".$anonymuosUser3->getName()." con ". $localhostProvider->getName()."<br/>";

    //Crear Menues
    echo "<br/><b>Creando Menues</b><br>";

    foreach(array($iplanProvider, $clientProvider, $localhostProvider) as $provider) {
//Menu Inicio
        $menuInicio = new Menu($orm);
        $menuInicio->setName('Inicio')
                   ->setOrder(1)
				   ->setIcon('home')
                   ->setAction($defaultAction)
                   ->setProvider($provider);
        $menuInicio->save(); echo "Creado el menu Inicio para (".$provider->getName().")<br/>";

//Menu Sistema
        $menuMain = new Menu($orm);
        $menuMain->setName('Sistema')
                   ->setOrder(2)
                   ->setAction($mainAction)
				   ->setIcon('layout')
                   ->setProvider($provider);
        $menuMain->save(); echo "Creado el menu Sistema para (".$provider->getName().")<br/>";
        $usersMenu = new Menu($orm);
        $usersMenu->setName('Usuarios')
                   ->setOrder(4)
                   ->setParent($menuMain)
                   ->setAction($listUsersAction)
                   ->setIcon('user')
                   ->setProvider($provider);
        $usersMenu->save(); echo "Creado el menu Sistema->Usuarios para (".$provider->getName().")<br/>";
        $usersListMenu = new Menu($orm);
        $usersListMenu->setName('Listado de Usuarios')
                   ->setOrder(1)
                   ->setParent($usersMenu)
                   ->setAction($listUsersAction)
                   ->setProvider($provider);
        $usersListMenu->save(); echo "Creado el menu Sistema->Usuarios->Listado para (".$provider->getName().")<br/>";
        $usersAddMenu = new Menu($orm);
        $usersAddMenu->setName('Agregar Usuario')
                   ->setOrder(2)
                   ->setParent($usersMenu)
                   ->setAction($addUserAction)
                   ->setProvider($provider);
        $usersAddMenu->save(); echo "Creado el menu Sistema->Usuarios->Agregar para (".$provider->getName().")<br/>";
        $usersEditMenu = new Menu($orm);
        $usersEditMenu->setName('Editar Usuario')
                   ->setOrder(2)
                   ->setParent($usersMenu)
                   ->setAction($modUserAction)
				   ->setVisible(false)
                   ->setProvider($provider);
        $usersEditMenu->save(); echo "Creado el menu Sistema->Usuarios->Editar para (".$provider->getName().")<br/>";
        $profilesMenu = new Menu($orm);
        $profilesMenu->setName('Perfiles')
                   ->setOrder(2)
                   ->setParent($menuMain)
                   ->setAction($listProfilesAction)
                   ->setIcon('group')
                   ->setProvider($provider);
        $profilesMenu->save(); echo "Creado el menu Sistema->Perfiles para (".$provider->getName().")<br/>";
        $profilesListMenu = new Menu($orm);
        $profilesListMenu->setName('Listado de Perfiles')
                   ->setOrder(1)
                   ->setParent($profilesMenu)
                   ->setAction($listProfilesAction)
                   ->setProvider($provider);
        $profilesListMenu->save(); echo "Creado el menu Sistema->Perfiles->Listado para (".$provider->getName().")<br/>";
        $profilesAddMenu = new Menu($orm);
        $profilesAddMenu->setName('Agregar Perfil')
                   ->setOrder(2)
                   ->setParent($profilesMenu)
                   ->setAction($addProfilesAction)
                   ->setProvider($provider);
        $profilesAddMenu->save(); echo "Creado el menu Sistema->Perfiles->Agregar para (".$provider->getName().")<br/>";
        $profilesEditMenu = new Menu($orm);
        $profilesEditMenu->setName('Editar Perfil')
                   ->setOrder(2)
                   ->setParent($profilesMenu)
                   ->setAction($modProfilesAction)
				   ->setVisible(false)
                   ->setProvider($provider);
        $profilesEditMenu->save(); echo "Creado el menu Sistema->Perfiles->Editar para (".$provider->getName().")<br/>";
		$providerMenu = new Menu($orm);
        $providerMenu->setName('Providers')
                   ->setOrder(1)
                   ->setParent($menuMain)
                   ->setAction($listProvidersAction)
                   ->setIcon('administrator')
                   ->setProvider($provider);
        $providerMenu ->save(); echo "Creado el menu Sistema->Providers para (".$provider->getName().")<br/>";
		$providerListMenu = new Menu($orm);
		$providerListMenu->setName('Listado de Providers')
                   ->setOrder(1)
                   ->setParent($providerMenu)
                   ->setAction($listProvidersAction)
                   ->setProvider($provider);
		$provideraddMenu = new Menu($orm);
		$provideraddMenu->setName('Agregar Provider')
                   ->setOrder(2)
                   ->setParent($providerMenu)
                   ->setAction($addProviderAction)
                   ->setProvider($provider);
        $provideraddMenu ->save(); echo "Creado el menu Sistema->Providers->Agregar para (".$provider->getName().")<br/>";
		$provideraddMenu = new Menu($orm);
		$provideraddMenu->setName('Editar Provider')
                   ->setOrder(2)
                   ->setParent($providerMenu)
                   ->setAction($modProviderAction)
				   ->setVisible(false)
                   ->setProvider($provider);
        $provideraddMenu ->save(); echo "Creado el menu Sistema->Providers->Editar para (".$provider->getName().")<br/>";
        $actionsMenu = new Menu($orm);
        $actionsMenu->setName('Acciones')
                   ->setOrder(3)
                   ->setParent($menuMain)
                   ->setAction($listActionsAction)
                   ->setIcon('link')
                   ->setProvider($provider);
        $actionsMenu ->save(); echo "Creado el menu Sistema->Acciones para (".$provider->getName().")<br/>";
        $actionsListMenu = new Menu($orm);
        $actionsListMenu->setName('Listado de Acciones')
                   ->setOrder(1)
                   ->setParent($actionsMenu)
                   ->setAction($listActionsAction)
                   ->setProvider($provider);
        $actionsListMenu->save(); echo "Creado el menu Sistema->Acciones->Listado para (".$provider->getName().")<br/>";
        $actionsAddMenu = new Menu($orm);
        $actionsAddMenu->setName('Agregar Acción')
                   ->setOrder(2)
                   ->setParent($actionsMenu)
                   ->setAction($addActionAction)
                   ->setProvider($provider);
        $actionsAddMenu->save(); echo "Creado el menu Sistema->Acciones->Agregar para (".$provider->getName().")<br/>";
        $actionsEditMenu = new Menu($orm);
        $actionsEditMenu->setName('Editar Acción')
                   ->setOrder(2)
                   ->setParent($actionsMenu)
				   ->setVisible(false)
                   ->setAction($modActionAction)
                   ->setProvider($provider);
        $actionsEditMenu->save(); echo "Creado el menu Sistema->Acciones->Agregar para (".$provider->getName().")<br/>";
        $menuMenu = new Menu($orm);
        $menuMenu->setName('Menues')
                   ->setOrder(5)
                   ->setParent($menuMain)
                   ->setAction($listMenusAction)
                   ->setProvider($provider);
        $menuMenu->save(); echo "Creado el menu Sistema->Menues para (".$provider->getName().")<br/>";
		$menuListMenu = new Menu($orm);
        $menuListMenu->setName('Listado de Menues')
                   ->setOrder(1)
                   ->setParent($menuMenu)
                   ->setAction($listMenusAction)
                   ->setProvider($provider);
        $menuListMenu->save(); echo "Creado el menu Sistema->Menues->Listado para (".$provider->getName().")<br/>";
        $menuAddMenu = new Menu($orm);
        $menuAddMenu->setName('Agregar Menú')
                   ->setOrder(2)
                   ->setParent($menuMenu)
                   ->setAction($addMenuAction)
                   ->setProvider($provider);
        $menuAddMenu->save(); echo "Creado el menu Sistema->Menues->Agregar Menú para (".$provider->getName().")<br/>";
        $menuEditMenu = new Menu($orm);
        $menuEditMenu->setName('Editar Menú')
                   ->setOrder(3)
                   ->setParent($menuMenu)
				   ->setVisible(false)
                   ->setAction($modMenuAction)
                   ->setProvider($provider);
        $menuEditMenu->save(); echo "Creado el menu Sistema->Menues->Editar Menú para (".$provider->getName().")<br/>";
        $facadeMenu = new Menu($orm);
        $facadeMenu->setName('Facades')
                   ->setOrder(6)
                   ->setParent($menuMain)
                   ->setAction($listFacadesAction)
                   ->setProvider($provider);
        $facadeMenu->save(); echo "Creado el menu Sistema->Facades para (".$provider->getName().")<br/>";
		$facadeListMenu = new Menu($orm);
        $facadeListMenu->setName('Listado de Facades')
                   ->setOrder(1)
                   ->setParent($facadeMenu)
                   ->setAction($listFacadesAction)
                   ->setProvider($provider);
        $facadeListMenu->save(); echo "Creado el menu Sistema->Facades->Listado para (".$provider->getName().")<br/>";
        $facadeAddMenu = new Menu($orm);
        $facadeAddMenu->setName('Agregar Facade')
                   ->setOrder(2)
                   ->setParent($facadeMenu)
                   ->setAction($addFacadeAction)
                   ->setProvider($provider);
        $facadeAddMenu->save(); echo "Creado el menu Sistema->Facades->Agregar Menú para (".$provider->getName().")<br/>";
        $facadeEditMenu = new Menu($orm);
        $facadeEditMenu->setName('Editar Facade')
                   ->setOrder(3)
                   ->setParent($facadeMenu)
				   ->setVisible(false)
                   ->setAction($modFacadeAction)
                   ->setProvider($provider);
        $facadeEditMenu->save(); echo "Creado el menu Sistema->Facades->Editar Menú para (".$provider->getName().")<br/>";
		
//Menu Wholesale
        $menuWholesale = new Menu($orm);
        $menuWholesale->setName('Wholesale')
                   ->setOrder(3)
				   ->setIcon('server_components')
                   ->setAction($NothingAction)
                   ->setProvider($provider);
        $menuWholesale->save(); echo "Creado el menu Wholesale para (".$provider->getName().")<br/>";

		$menuProveedores = new Menu($orm);
        $menuProveedores->setName('Revendedores')
                   ->setOrder(1)
					->setParent($menuWholesale)
                   ->setAction($listResellersAction)
                   ->setProvider($provider);
        $menuProveedores->save(); echo "Creado el menu Proveedores para (".$provider->getName().")<br/>";
		/*$menuListProveedores = new Menu($orm);
        $menuListProveedores->setName('Listado')
                   ->setOrder(1)
					->setParent($menuProveedores)
                   ->setAction($listResellersAction)
                   ->setProvider($provider);
        $menuListProveedores->save(); echo "Creado el menu Proveedores->Listado para (".$provider->getName().")<br/>";
		$menuAddProveedores = new Menu($orm);
        $menuAddProveedores->setName('Agregar')
                   ->setOrder(2)
					->setParent($menuProveedores)
                   ->setAction($addResellersAction)
                   ->setProvider($provider);
        $menuAddProveedores->save(); echo "Creado el menu Proveedores->Agregar para (".$provider->getName().")<br/>";*/
		
		$menuClientes = new Menu($orm);
        $menuClientes->setName('Clientes')
                   ->setOrder(2)
					->setParent($menuWholesale)
                   ->setAction($listClientsAction)
                   ->setProvider($provider);
        $menuClientes->save(); echo "Creado el menu Clientes para (".$provider->getName().")<br/>";
		/*$menuListClientes = new Menu($orm);
        $menuListClientes->setName('Listado')
                   ->setOrder(1)
					->setParent($menuClientes)
                   ->setAction($listClientsAction)
                   ->setProvider($provider);
        $menuListClientes->save(); echo "Creado el menu Clientes->Listado para (".$provider->getName().")<br/>";
		$menuAddClientes = new Menu($orm);
        $menuAddClientes->setName('Agregar')
                   ->setOrder(2)
					->setParent($menuClientes)
                   ->setAction($addClientsAction)
                   ->setProvider($provider);
        $menuAddClientes->save(); echo "Creado el menu Clientes->Agregar para (".$provider->getName().")<br/>";*/
		
		
		$menuSitios = new Menu($orm);
        $menuSitios->setName('Sitios')
                   ->setOrder(3)
					->setParent($menuWholesale)
                   ->setAction($listSitesAction)
                   ->setProvider($provider);
        $menuSitios->save(); echo "Creado el menu Sitios para (".$provider->getName().")<br/>";
		/*$menuListSitios = new Menu($orm);
        $menuListSitios->setName('Listado')
                   ->setOrder(1)
					->setParent($menuSitios)
                   ->setAction($listSitesAction)
                   ->setProvider($provider);
        $menuListSitios->save(); echo "Creado el menu Sitios->Listado para (".$provider->getName().")<br/>";
		$menuAddSitios = new Menu($orm);
        $menuAddSitios->setName('Agregar')
                   ->setOrder(2)
					->setParent($menuSitios)
                   ->setAction($addSitesAction)
                   ->setProvider($provider);
        $menuAddSitios->save(); echo "Creado el menu Sitios->Agregar para (".$provider->getName().")<br/>";*/
		
		
		$menuLineas = new Menu($orm);
        $menuLineas->setName('Lineas')
                   ->setOrder(4)
					->setParent($menuWholesale)
                   ->setAction($listLinesAction)
                   ->setProvider($provider);
        $menuLineas->save(); echo "Creado el menu Lineas para (".$provider->getName().")<br/>";
		/*$menuListLineas = new Menu($orm);
        $menuListLineas->setName('Listado')
                   ->setOrder(1)
					->setParent($menuLineas)
                   ->setAction($listLinesAction)
                   ->setProvider($provider);
        $menuListLineas->save(); echo "Creado el menu Lineas->Listado para (".$provider->getName().")<br/>";
		$menuAddLineas = new Menu($orm);
        $menuAddLineas->setName('Agregar')
                   ->setOrder(2)
					->setParent($menuLineas)
                   ->setAction($addLinesAction)
                   ->setProvider($provider);
        $menuAddLineas->save(); echo "Creado el menu Lineas->Agregar para (".$provider->getName().")<br/>";*/
		
		$menuCDRS = new Menu($orm);
        $menuCDRS->setName('CDRS')
                   ->setOrder(5)
				   ->setParent($menuWholesale)
                   ->setAction($listCDRsAction)
                   ->setProvider($provider);
        $menuCDRS->save(); echo "Creado el menu CDRS para (".$provider->getName().")<br/>";
		//Gerenciamiento de Costos
		$menuCostManager = new Menu($orm);
        $menuCostManager->setName('Gerenciamiento de Costos')
                   ->setOrder(6)
				   ->setAction($NothingAction)
				   ->setIcon('account_balances')
				   ->setParent($menuWholesale)
                   ->setProvider($provider);
        $menuCostManager->save(); echo "Creado el menu Gerenciamiento de Costos para (".$provider->getName().")<br/>";
		
				//Prefijos y Grupos
				$menuPrefixAndGroups = new Menu($orm);
				$menuPrefixAndGroups->setName('Prefijos y Grupos')
						   ->setOrder(1)
						   ->setIcon('prefix')
						   ->setAction($NothingAction)
						   ->setParent($menuCostManager)
						   ->setProvider($provider);
				$menuPrefixAndGroups->save(); echo "Creado el menu Gerenciamiento de Costos -> Prefijos y Grupos para (".$provider->getName().")<br/>";
						//Grupos de Prefijos
						$menuPrefixGroups = new Menu($orm);
						$menuPrefixGroups->setName('Grupos de Prefijos')
								   ->setOrder(1)
								   ->setAction($listPrefixGroupsAction)
								   ->setParent($menuPrefixAndGroups)
								   ->setProvider($provider);
						$menuPrefixGroups->save(); echo "Creado el menu Gerenciamiento de Costos -> Prefijos y Grupos -> Grupos de Prefijos para (".$provider->getName().")<br/>";
						//Prefijos
						$menuPrefixs = new Menu($orm);
						$menuPrefixs->setName('Prefijos')
								   ->setOrder(2)
								   ->setAction($listPrefixesAction)
								   ->setParent($menuPrefixAndGroups)
								   ->setProvider($provider);
						$menuPrefixs->save(); echo "Creado el menu Gerenciamiento de Costos -> Prefijos y Grupos -> Prefijos para (".$provider->getName().")<br/>";
				//Listas de Precios
				$menuPriceLists = new Menu($orm);
				$menuPriceLists->setName('Listas de Precios')
						   ->setOrder(2)
						   ->setAction($listPricesListsAction)
						   ->setParent($menuCostManager)
						   ->setProvider($provider);
				$menuPriceLists->save(); echo "Creado el menu Gerenciamiento de Costos -> Listas de Precios para (".$provider->getName().")<br/>";
				//Precios
				$menuPrices = new Menu($orm);
				$menuPrices->setName('Precios')
						   ->setOrder(3)
						   ->setAction($listPricesAction)
						   ->setParent($menuCostManager)
						   ->setProvider($provider);
				$menuPrices->save(); echo "Creado el menu Gerenciamiento de Costos -> Precios para (".$provider->getName().")<br/>";
				//Tarifas
				$menuTarifas = new Menu($orm);
				$menuTarifas->setName('Tarifas')
						   ->setOrder(4)
						   ->setParent($menuCostManager)
						   ->setAction($listRatesAction)
						   ->setProvider($provider);
				$menuTarifas->save(); echo "Creado el menu Gerenciamiento de Costos -> Tarifas para (".$provider->getName().")<br/>";

		$menuConfiguraciones = new Menu($orm);
        $menuConfiguraciones->setName('Configuraciones')
							->setOrder(7)
							->setParent($menuWholesale)
							->setAction($NothingAction)
							->setIcon('gear_in')
							->setProvider($provider);
        $menuConfiguraciones->save(); echo "Creado el menu Configuraciones para (".$provider->getName().")<br/>";
		
				$menuLineTypes = new Menu($orm);
				$menuLineTypes->setName('Tipos de Linea')
									->setOrder(1)
									->setParent($menuConfiguraciones)
									->setAction($listLineTypesAction)
									->setProvider($provider);
				$menuLineTypes->save(); echo "Creado el menu LineTypes para (".$provider->getName().")<br/>";


				$menuNumerationBlocks = new Menu($orm);
				$menuNumerationBlocks->setName('Bloques de Numeración')
									->setOrder(2)
									->setParent($menuConfiguraciones)
									->setAction($listNumerationBlocksAction)
									->setProvider($provider);
				$menuNumerationBlocks->save(); echo "Creado el menu NumerationBlocks para (".$provider->getName().")<br/>";

				$menuServicePacks = new Menu($orm);
				$menuServicePacks->setName('Service Packs')
									->setOrder(3)
									->setParent($menuConfiguraciones)
									->setAction($listServicePacksAction)
									->setProvider($provider);
				$menuServicePacks->save(); echo "Creado el menu ServicePacks para (".$provider->getName().")<br/>";

				$menuResources = new Menu($orm);
				$menuResources->setName('Recursos')
									->setOrder(4)
									->setParent($menuConfiguraciones)
									->setAction($listResourcesAction)
									->setProvider($provider);
				$menuResources->save(); echo "Creado el menu Resources para (".$provider->getName().")<br/>";

				$menuRecepcionistTypes = new Menu($orm);
				$menuRecepcionistTypes->setName('Tipos de Recepcionista')
									->setOrder(5)
									->setParent($menuConfiguraciones)
									->setAction($listRecepcionistTypesAction)
									->setProvider($provider);
				$menuRecepcionistTypes->save(); echo "Creado el menu RecepcionistTypes para (".$provider->getName().")<br/>";

				$menuServiceProviders = new Menu($orm);
				$menuServiceProviders->setName('Broadsoft ServiceProvider')
									->setOrder(6)
									->setParent($menuConfiguraciones)
									->setAction($listServiceProvidersAction)
									->setProvider($provider);
				$menuServiceProviders->save(); echo "Creado el menu ServiceProviders para (".$provider->getName().")<br/>";

				$menuPayPlans = new Menu($orm);
				$menuPayPlans->setName('Tipos de Pago')
									->setOrder(7)
									->setParent($menuConfiguraciones)
									->setAction($listPayPlansAction)
									->setProvider($provider);
				$menuPayPlans->save(); echo "Creado el menu PayPlans para (".$provider->getName().")<br/>";

//Menu Provisioning
        $menuProvisioning = new Menu($orm);
        $menuProvisioning->setName('Provisioning')
                    ->setOrder(4)
                    ->setAction($NothingAction)
					->setIcon('server')
                    ->setProvider($provider);
		$menuProvisioning->save(); echo "Creado el menu Provisioning para (".$provider->getName().")<br/>";
		
        $menuTasks = new Menu($orm);
		$menuTasks->setName('Tareas de Orden de Servicio')
						->setOrder(1)
						->setAction($listServiceOrderTaskAction)
						->setParent($menuProvisioning)
						->setProvider($provider);
		$menuTasks->save(); echo "Creado el menu Tareas de Orden de Servicio para (".$provider->getName().")<br/>";
		
        $menuProcessList = new Menu($orm);
        $menuProcessList->setName('Procesos')
                   ->setOrder(2)
                   ->setAction($listProcessAction)
                   ->setParent($menuProvisioning)
                   ->setProvider($provider);
		$menuProcessList->save(); echo "Creado el menu AutoProvisioning>>Procesos para (".$provider->getName().")<br/>";
//Menu Cuenta
        $menuAccount = new Menu($orm);
        $menuAccount->setName('Cuenta')
                    ->setOrder(5)
                    ->setAction($AnnNothingAction)
					->setIcon('client_account_template')
                    ->setProvider($provider);
        $menuAccount->save(); echo "Creado el menu Cuenta para (".$provider->getName().")<br/>";
        $menuLogin = new Menu($orm);
        $menuLogin->setName('Login')
                   ->setOrder(1)
				   ->setIcon('key_go')
                   ->setAction($loginAction)
                   ->setParent($menuAccount)
                   ->setProvider($provider);
        $menuLogin->save(); echo "Creado el menu Login para (".$provider->getName().")<br/>";
		$passChangeMenu = new Menu($orm);
        $passChangeMenu->setName('Cambiar Password')
                   ->setOrder(2)
                   ->setParent($menuAccount)
                   ->setAction($changePasswordAction)
                   ->setProvider($provider);
		$passChangeMenu->save(); echo "Creado el menu change password para (".$provider->getName().")<br/>";
        $menuLogout = new Menu($orm);
        $menuLogout->setName('Logout')
                   ->setAction($logoutAction)
                   ->setParent($menuAccount)
                   ->setOrder(3)
				   ->setIcon('delete')
                   ->setDynamic(false)
                   ->setProvider($provider);
        $menuLogout->save(); echo "Creado el menu Logout para (".$provider->getName().")<br/>";
    }

    echo "<br/>FIN DE LA INSTALACI&Oacute;N<br/></pre></body></html>";
    return true;
    // Bouml preserved body end 000A9505
  }

  /**
   * Funcion de test de integraciones con el LOG.
   */
  public static function testintegracion()
  {
    // Bouml preserved body begin 0012E405
	
	//Aca hay cosas de Log
	require_once 'iplan/models/wholesale/provisioning/LogMessages.php';
	
	//Aca estan las centrales xdd
	require_once 'iplan/models/wholesale/provisioning/ProvisioningIUNI.php';
	
	        
	//Traigo la instancia de ORM
	$orm = ORM::getInstance();
	//Seteo la database a ORACLE
	$orm->setDatabase(new OracleDatabase());
	//Tomo la Database
	$db = $orm->getDatabase();
	//Tomo la Conexión a Base de Datos
	$dbconn = $db->getConnection();
	//Traigo la instancia de LOG
	$log = LogMessages::GetInstance($dbconn);
	//Seteo los mensajes que hay en la databse
	LogMessages::getMensajes();
	//Logueo el Inicio de las pruebas
	$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, 'Inicio las Pruebas');

	
	
	//Tomo los Datos de la base de Packs y Recepcionistas
	$servicePacksOptions = $orm->query('ServiceProvider')->filterBy('id', '=', '10')
							->attributes('servicePacks.description AS bs_value', 'servicePacks.attributeName as attr')
							->find();
	$recepcionistTypeOptions = $orm->query('RecepcionistType')
							->attributes('description AS bs_value', 'attributeName as attr')
							->find();
	$servicePacksParaLinea = array();
	if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
		for ($i = 0; $i < count($servicePacksOptions); $i++) {
			$servicePacksParaLinea[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
		}
	}
	$recepcionistTypeParaLinea = array();
	if (is_array($recepcionistTypeOptions) && (count($recepcionistTypeOptions) > 0)) {
		for ($i = 0; $i < count($recepcionistTypeOptions); $i++) {
			$recepcionistTypeParaLinea[$recepcionistTypeOptions[$i]["attr"]] = $recepcionistTypeOptions[$i]["bs_value"];
		}
	}

	//Packs para Laburar CON:
	/*echo "Packs:<pre>";
	var_dump($servicePacksParaLinea);
	echo "</pre>";
	echo "Recepcionistas:<pre>";
	var_dump($recepcionistTypeParaLinea);
	echo "</pre>";*/
	
	
	//Seteo el numero de orden de venta sobre el cual laburo/equisdeo
	$orden = "001144";
	//Preparo la conexion al web service de Broadsoft:
	$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);
	
	//Creo la conexion a los Servicios:
	$serviceCentralIUNI = new ProvisioningIUNI($bsws, $log, $dbconn, $orden);
	
	//Numeraciones a Service Providers:
	//$PyMESlab = new ServiceProviderBroadsoft("fede", "random");
	//$PyMESlab->setServiceProviderId("PyMESlab");
	/*$PyMESlab->addLineaPSTN("1152560733");
	$PyMESlab->addLineaPSTN("1152560734");
	$PyMESlab->addLineaPSTN("1152560735");*/
	
	//AddNumeracionServiceProvider
	
	
	//Creo la Instancia de la CentralIUNI a Aprovisionar
	/*$central = new CentralIUNI("asd", "asd", "95919", "FEDERICO BERNOLDI");
	$central->setServiceProvider($PyMESlab->getServiceProviderId());
	$central->setAddress("Lavalle 643 4to F");
	$central->setContactEmail("fbernoldi@gmail.com");
	$central->setContactName("Federico");
	$central->setContactLastName("Bernoldi");
	$central->setContactNumber("5256-0733");
	$central->setPasswdWebBS("fedefede");
	$central->setUserWebBS("admin_95919");
	$central->setVoiceMessaging("1152560733", "200", "no_le_doy_bola");
	$central->setGroupNameDB("95919-FEDERICO BERNOLDI");*/
	
	//Creo los internos IUNI
	//$internos = new InternosIUNI();
	
	//Interno de prueba 1
	/*$interno = new InternoIUNI($servicePacksParaLinea, $recepcionistTypeParaLinea);
	$interno2 = new InternoIUNI($servicePacksParaLinea, $recepcionistTypeParaLinea);
	$interno3 = new InternoIUNI($servicePacksParaLinea, $recepcionistTypeParaLinea);
	$interno3->setPackPremium(true);*/
	
	/*$interno->setPackPremium(false);
	$interno2->setPackPremium(true);
	$interno->setPackStandard(true);
	$interno->setRecepcionistaOffice(false);
	$interno->setRecepcionistaSmallBusiness(true);
	$interno->setIntegracionOutlook(true);*/
	
	//$interno2->setIntegracionOutlook(true);
	
	/*echo "Pack Premium: [" . $interno->getPackPremium() . "]<br>";
	echo "Pack Standard: [" . $interno->getPackStandard() . "]<br>";
	echo "Recepcionista Office: [" . $interno->getRecepcionistaOffice() . "]<br>";
	echo "Recepcionista SmallBusiness: [" . $interno->getRecepcionistaSmallBusiness() . "]<br>";
	echo "Recepcionista Enterprise: [" . $interno->getRecepcionistaEnterprise() . "]<br>";*/

	/*$interno->setNroPSTN("1152560734");
	$interno->setPassword("fedefede");
	$interno->setNroInterno("201");
	$interno->setGrupoBS("95919-FEDERICO BERNOLDI");*/
	
	/*$interno2->setNroPSTN("1152560735");
	$interno2->setPassword("fedefede2");
	$interno2->setNroInterno("202");*/
	
	//Agrego el Interno a la Lista de Internos
	/*$internos->addInterno($interno);
	$internos->addInterno($interno2);*/
	
	//Agrego Los Internos a la Central
	//$central->setInternos($internos);
	
	/*echo "Service Provider:<pre>";
	var_dump($serviceCentralIUNI->AddNumeracionServiceProvider($PyMESlab));
	echo "</pre>Fin xd<br>";*/
	
	/*$aa = new AutoAttendantIUNI("1152560736", 198);
	$aa2 = new AutoAttendantIUNI("1152560737", 199);
	$aa3 = new AutoAttendantIUNI("1152560741", 198);
	$aa3->setGrupoBS("95919-FEDERICO BERNOLDI");
	$aa2->setGrupoBS("95919-FEDERICO BERNOLDI");
	$central->addAutoAttendant($aa);
	$central->addAutoAttendant($aa2);*/
	
	/*echo "Central IUNI<pre>";
	var_dump($serviceCentralIUNI->AddCentralIUNI($central));
	echo "</pre>Fin xd<br>";*/
	
	
	/*$hg1 = new HuntGroupIUNI("1152560757", "745");
	$hg1->setGrupoBS("95919-FEDERICO BERNOLDI");*/
	
	/*echo "Add AutoAttendant Suelto IUNI<pre>";
	var_dump($serviceCentralIUNI->AddHuntGroupIUNI($hg1, "PyMESlab"));
	echo "</pre>Fin xd<br>";*/
	
	/*echo "Add AutoAttendant Suelto IUNI<pre>";
	var_dump($serviceCentralIUNI->DeleteHuntGroup("PyMESlab", "95919-FEDERICO BERNOLDI", "1152560757"));
	echo "</pre>Fin xd<br>";*/
	
	/*$interno3->setNroPSTN("1152560755");
	$interno3->setPassword("fedefede3");
	$interno3->setNroInterno("208");
	$interno3->setGrupoBS("95919-FEDERICO BERNOLDI");*/
	
	
	//var_dump($serviceCentralIUNI->DeleteInternoIUNI($interno, $PyMESlab->getServiceProviderId()));
	//var_dump($serviceCentralIUNI->ModifyInternoIUNI($interno, $PyMESlab->getServiceProviderId()));
	//var_dump($serviceCentralIUNI->AddInternoIUNI($interno, $PyMESlab->getServiceProviderId()));
	
	//var_dump($serviceCentralIUNI->DeleteCentralIUNINameDB($central));
	
	//var_dump($serviceCentralIUNI->AddInternoIUNI($interno3, $PyMESlab->getServiceProviderId()));
	
	
	//var_dump($serviceCentralIUNI->DeleteAutoAttendant("PyMESlab", "95919-FEDERICO BERNOLDI", "1152560737"));
	
	//$interno2->setGrupoBS("95919-FEDERICO BERNOLDI");
	//$interno->setGrupoBS("95919-FEDERICO BERNOLDI");
	//echo "Interno 2 agregar<pre>";
	//var_dump($serviceCentralIUNI->AddInternoIUNI($interno2, $PyMESlab->getServiceProviderId()));
	///var_dump($serviceCentralIUNI->AddInternoIUNI($interno, $PyMESlab->getServiceProviderId()));
	//echo "</pre>Fin";

	
	/*$central->setGroupNameDB("95919-FEDERICO BERNOLDI");
	echo "setVoicePortal<pre>";
	var_dump($serviceCentralIUNI->setVoicePortal($central));
	echo "</pre>Fin";*/
	/*echo "unsetVoicePortal<pre>";
	var_dump($serviceCentralIUNI->unsetVoicePortal($central));
	echo "</pre>Fin";*/
	
	//var_dump($serviceCentralIUNI->SearchServiceProviderDnGetSummaryList("PyMESlab"));
	//var_dump($serviceCentralIUNI->SearchGroupDnAvailableList("95919-FEDERICO BERNOLDI", "PyMESlab"));
	
	
	//$xdxd = $serviceCentralIUNI->AddNumeracionGroup("PyMESlab", "95919-FEDERICO BERNOLDI", array("1152560735", "1152560758", "1150317242", "1152560756", "1152560888"));
	
	//$xdxd = $serviceCentralIUNI->AddNumeracionGroup("PyMESlab", "95919-FEDERICO BERNOLDI", array());
	
	//$central->setGroupNameDB("95919-FEDERICO BERNOLDI");
	
	/*$xdxd = $serviceCentralIUNI->SearchGroup("95919-FEDERICO BERNOLDI", "PyMESlab");
	$xdxd2 = $serviceCentralIUNI->SearchGroupAutorization("95919-FEDERICO BERNOLDI", "PyMESlab");
	$xdxd3 = $serviceCentralIUNI->SearchGroupDnAvailableList("95919-FEDERICO BERNOLDI", "PyMESlab");
	$xdxd4 = $serviceCentralIUNI->SearchGroupDnList("95919-FEDERICO BERNOLDI", "PyMESlab");
	$xdxd5 = $serviceCentralIUNI->SearchUserAssignedServices("fedefede");
	$xdxd6 = $serviceCentralIUNI->SearchServiceProviderDnAvailableList("PyMESlab");
	$xdxd7 = $serviceCentralIUNI->SearchServiceProviderDnGetSummaryList("PyMESlab");
	$xdxd8 = $serviceCentralIUNI->SearchUsers("95919-FEDERICO BERNOLDI", "PyMESlab");*/
	
	
	//var_dump($serviceCentralIUNI->setVoicePortal($central));
	
	
	
	
	
	//var_dump($xdxd8);
	
	//Logueo el fin de las pruebas
	$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, 'Fin de las Pruebas');
	
	//Cierro el log xd.-
	$log->closeLog();

	//$log->addLog(LOG_ERROR, SYS_WB, 0, 'testmail');
         
    // Bouml preserved body end 0012E405
  }

  /**
   * Retorna el resultado de parsear un template de TWIG con las variables indicadas.
   * Recordar que Twig va recorriendo los paths primero el de iplan, luego el de default.
   * 
   * @param string $template un nombre de archivo.
   * @param array $variables las variables del template.
   * 
   * @return string el resultado del parseo.
   */
  public function parse($template, $variables)
  {
    // Bouml preserved body begin 00169305
	$template = $this->twig->loadTemplate($template);
	return $template->render($variables);
    // Bouml preserved body end 00169305
  }

  /**
   * Agrega un valor global de la aplicación. Esta valor puede ser consultado por todos los providers, dominios y módulos del sistema.
   * 
   * @param string $name el nombre del parámetro
   * @param string $value el valor a almacenar
   * 
   * @return Application devuelve la aplicación tras guardar el valor.
   */
  public function registerGlobal($name, $value)
  {
    // Bouml preserved body begin 0019DD05
	$globalData = $this->orm->query('GlobalData')->filterBy('name', '=', $name)
											 ->filterBy('provider', 'IS NULL')
											 ->filterBy('domain.id', "=", $this->context->getDomain()->getId())
											 ->filterBy('module', 'IS NULL')
											 ->filterBy('facade', 'IS NULL')
						->findOne();
	if ($globalData) {
		$globalData->setValue($value);
		$globalData->save();
	} else {
		$globalData = new GlobalData($this->orm);
		$globalData->setDomain($this->context->getDomain());
		$globalData->setName($name)->setValue($value)->save();
	}
	return $this;
    // Bouml preserved body end 0019DD05
  }

  /**
   * Recupera un valor global a la Aplicación
   * 
   * @param string $name el nombre del parámetro
   * 
   * @return string|false El valor almacenado en la variable global o false en caso de no encontrarse coincidencias
   */
  public function getGlobal($name)
  {
    // Bouml preserved body begin 0019E085
	$globalData = $this->orm->query('GlobalData')->filterBy('name', '=', $name)
											 ->filterBy('provider', 'IS NULL')
											 ->filterBy('domain.id', "=", $this->context->getDomain()->getId())
											 /*->filterBy('module', 'IS NULL')*/
											 ->filterBy('facade', 'IS NULL')
											 ->attributes('value')
						->findOne();
	if ($globalData) return $globalData['value'];
	else return false;
    // Bouml preserved body end 0019E085
  }

  /**
   * Devuelve información del entorno en el cual se está ejecutando la aplicación.
   * 
   * @return string Retorna uno de los siguientes valores:
   * <dl>
   * <dt>Development</dt><dd>La aplicación se está ejecutando en el entorno de desarrollo</dd>
   * <dt>Test</dt><dd>La aplicación se está ejecutando en el entorno de pruebas</dd>
   * <dt>Production</dt><dd>La aplicación se está ejecutando en el entorno productivo</dd>
   * </dl>
   */
  public function getEnvironment()
  {
    // Bouml preserved body begin 001E3B85
	return $this->environment;
    // Bouml preserved body end 001E3B85
  }

  /**
   * Renderiza un renderable (valga la redundancia)
   * 
   * @param Renderable $renderable El renderable a mostrar.
   * 
   * @return string El resultado de la renderización.
   */
  public function render(&$renderable)
  {
    // Bouml preserved body begin 001E3C85
	$headers = $renderable->getHeaders();
	if ($headers != null) {
		foreach ($headers as $type => $value)
			header("$type: $value");
	}
	$template_file=$renderable->getTemplate();
	if ($template_file != null) {
		if ($renderable->isDownlodeable()) {
			if ($renderable->isDownlodeable()) {
				if ($this->getParam("openAs") == "popup") {
					$template = $this->twig->loadTemplate("popup.xhtml");
					$this->context->set('MainContent', $template_file);
				} else {
					$template = $this->twig->loadTemplate($template_file);
				}
			} else {
				$template = $this->twig->loadTemplate($template_file);
			}
		} else {
			$template = $this->twig->loadTemplate("index.xhtml");
			$this->context->set('MainContent', $template_file);
		}
		$template->display($this->context->toTwigArguments());
		$isForIFrame = $this->getParam('UWS_IFRAME', null);
		if (!is_null($isForIFrame)) {
			echo '<script id="UWS_RETURN_SCRIPT" language="javascript" type="text/javascript">window.top.window.uws_moveContent(\''.$isForIFrame.'\')</script>';
		}			
	} else {
		echo $renderable->getContent();
	}
    // Bouml preserved body end 001E3C85
  }

}
?>