<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/security/Facade.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Una acción del sistema es una función particular que puede ser realizada en el mismo. Las acciones pertenecen a un Facade que es una especie de módulo que las aglutina y se relacionan con los usuarios a través de los perfiles.
 * 
 * @method string getDescription()
 * @method Action setDescription()
 * @method string getName()
 * @method Action setName()
 * @method string getMethod()
 * @method Action setMethod()
 * @method string getUrlCode()
 * @method Action setUrlCode()
 * @method string getHint()
 * @method Action setHint()
 * @method string getIcon()
 * @method Action setIcon()
 * @method Facade getFacade()
 * @method Action setFacade()
 * @method array getProfiles()
 * @method Action addProfile()
 * @method Action delProfile()
 * @method string getParams()
 * @method Action setParams()
 * @method Action setAlias()
 * @method string getAlias()
 * @method Action setUseAjax()
 * @method boolean getUseAjax()
 */
class Action extends ORMObject {
  protected $description;

  protected $name;

  /**
   * @var string una forma amena para que la accin sea referenciada de los templates
   */
  protected $alias;

  /**
   * @var string $method el mtodo a llamar
   */
  protected $method;

  /**
   * @var string un cdigo textual del comando
   */
  protected $urlCode;

  /**
   * @var string un texto para mostrar en los componentes que realicen o ejecuten esta accin
   */
  protected $hint;

  /**
   * @var string el nombre del estilo que marca el cono de la accin
   */
  protected $icon;

  /**
   * @var string Guarda parmetros adicionales para ser pasados a la accin.
   */
  protected $params;

  /**
   * @var int $state el estado de la accin: enabled=1, disabled=0
   */
  protected $state;

  /**
   * @var boolean indica si se debe usar ajax al enlazar la accin. Esta opcin ser tratada por la funcin IPlanExtension::AJAH()
   */
  protected $useAjax;

  /**
   * @var array $profiles la lista de perfiles que utilizan la acción
   */
  protected $profiles;

  /**
   * @var Facade $facade Una representación de la clase a ser invocada y su definición
   */
  protected $facade;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 000A6085
    return parent::define($orm)
            ->setClass('Action')
            ->setTable('UWS_ACTION')
            ->addField('id', 'ACTION_ID', ORMDefinition::INTEGER, 10, null)
            ->setKey('id')
            ->addField('name', 'ACTION_NAME', ORMDefinition::STRING, 30, 0, FALSE)
            ->addField('alias', 'ACTION_ALIAS', ORMDefinition::STRING, 25, 0, FALSE)
            ->addField('description', 'ACTION_DESCRIPTION', ORMDefinition::STRING, 2048)
            ->addField('method', 'ACTION_METHOD', ORMDefinition::STRING, 25, null, FALSE)
            ->addField('params', 'ACTION_PARAMS', ORMDefinition::STRING, 255)
            ->addField('urlCode', 'ACTION_URL_CODE', ORMDefinition::STRING, 25, 0, FALSE)
            ->addField('hint', 'ACTION_HINT', ORMDefinition::STRING, 40)
            ->addField('icon', 'ACTION_ICON', ORMDefinition::STRING, 255)
            ->addField('useAjax', 'ACTION_AJAX', ORMDefinition::BOOLEAN,null,null,false, true)
            ->addInstance('facade', 'FACADE_ID', 'Facade', FALSE)
            ->addRelationNxM('profiles', 'UWS_PROFILE_ACTION', 'ACTION_ID', 'Profile');
    // Bouml preserved body end 000A6085
  }

  /**
   * Invoca a las funciones que realizan la accin y retorna un Renderable con el resultado.
   * No me dej ponerle "do()" porque "do" est reservado :S
   * @param iplan\security\Context $context el contexto sobre el que se ejecuta la accin.
   * @param boolean $ajax indica si se invoc va ajax.
   * @return Renderable el objeto que renderiza la salida.
   */
  public function execute(&$context, $ajax)
  {
    // Bouml preserved body begin 000A0B05
    $manager = $context->getManager($this->facade->getAlias());
    $method = $this->method;
    return $manager->$method($context, $ajax);
    // Bouml preserved body end 000A0B05
  }

  /**
   * Recupera la representacin en string de una accin.
   * 
   * @return string Una cadena de texto de la forma <<FacadeAlias>>.<<ActionAlias>>
   */
  public function getStringCommand()
  {
    // Bouml preserved body begin 0012D585
	return $this->getFacade()->getAlias().".".$this->getAlias();
    // Bouml preserved body end 0012D585
  }

}
?>