<?php
require_once 'iplan/security/Application.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/web/TextArea.php';
require_once 'iplan/web/PasswordComponent.php';
require_once 'iplan/web/MultiselectComponent.php';
require_once 'iplan/web/RadioComponent.php';
require_once 'iplan/web/CheckboxComponent.php';
require_once 'iplan/web/ImageButtonComponent.php';
require_once 'iplan/web/FileComponent.php';
require_once 'iplan/web/GridLayout.php';
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/security/Utils.php';
require_once 'iplan/web/ComposedForm.php';
require_once 'iplan/web/LabelComponent.php';
require_once 'iplan/web/DateComponent.php';
require_once 'iplan/web/DetailWebList.php';
require_once 'iplan/web/ListReport.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/User.php';
require_once 'iplan/web/WebList.php';
require_once 'iplan/web/ActionComponent.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
abstract class AbstractManager {
  /**
   * @var string El nombre de la instancia del Manager.
   */
  protected $name;

  /**
   * @var Application la instancia de la aplicacin que maneja la clase
   */
  protected $application;

  /**
   * Crea una instancia del Manager y configura la aplicacin
   * 
   * @param iplan\security\Application $application la aplicacin que es la propietaria del manager
   * @param string $name el nombre que dentro del framework tiene el Manager
   * 
   * @return iplan\security\AbstractManager Una instancia del Manager en cuestin
   */
  public function __construct(&$application, $name)
  {
    // Bouml preserved body begin 000AE505
    $this->application = $application;
	$this->name = $name;
    return $this;
    // Bouml preserved body end 000AE505
  }

  /**
   * Retorna una lista de mtodos que pueden ser invocados desde la aplicacin.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operacin y el valor el nombre del mtodo que le corresponde.
   */
  public abstract function __listActions()
  ;
  /**
   * Notifica al facade que se ha logeado un usuario NUEVO mediante "Login Unificado".
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * @param User $user el usuario nuevo que se logueó
   * @param mixed $extra por el momento se pasa la respuesta del llamado a CLL_Authenticate.
   * 
   * @return boolean un booleando que es TRUE si se desea conservar el usuario o FALSE si el mismo es irrelevante o no debe tener permisos para el Facade.
   */
  public function newLoginUnificado(&$context, &$user, $extra = null)
  {
    // Bouml preserved body begin 00160185
	return FALSE;
    // Bouml preserved body end 00160185
  }

  /**
   * Configura informacin general para el uso en los templates.
   * 
   * @param ApplicationContext $context el contexto de la aplicacin.
   * 
   * @return void 
   */
  public function registerInfo(&$context)
  {
    // Bouml preserved body begin 00162085
	$context->set('User', $context->getUser())
			->set('Provider', $context->getProvider());
    // Bouml preserved body end 00162085
  }

  /**
   * Agrega un valor global del módulo para su autoconsulta interna.
   * 
   * @param string $name el nombre del parámetro
   * @param string $value el valor a almacenar
   * 
   * @return Module devuelve el módulo tras guardar el valor.
   */
  protected function registerGlobal($name, $value)
  {
    // Bouml preserved body begin 001A6C85
	$orm = $this->application->getORM();
	$context = $this->application->getContext();
	$facade = $orm->query('Facade')->filterBy('alias', '=', $this->name)->findOne();
	
	$globalData = $orm->query('GlobalData')->filterBy('name', '=', $name)
										   ->filterBy('facade.id', '=', $facade->getId())
										   ->filterBy('provider', 'IS NULL')
										   ->filterBy('domain', 'IS NULL')
										   /*->filterBy('module', 'IS NULL')*/
					->findOne();/*@var $globalData GlobalData*/
	if ($globalData) {
		$globalData->setValue($value)
				   ->save();
	} else {
		$globalData = new GlobalData($orm);
		$globalData->setName($name)
				   ->setValue($value)
				   ->setFacade($facade)
				   ->save();
	}
	return $this;
    // Bouml preserved body end 001A6C85
  }

  /**
   * Recupera un valor global al Módulo
   * 
   * @param string $name el nombre del parámetro
   * 
   * @return string|false El valor almacenado en la variable global o false en caso de no encontrarse coincidencias
   */
  public function getGlobal($name)
  {
    // Bouml preserved body begin 001A6C05
	$orm = $this->application->getORM();
	$context = $this->application->getContext();
	$facade = $orm->query('Facade')->filterBy('alias', '=', $this->name)->findOne();
	$globalData = $orm->query('GlobalData')->filterBy('name', '=', $name)
										   ->filterBy('facade.id', '=', $facade->getId())
										   ->filterBy('provider', 'IS NULL')
										   ->filterBy('domain', 'IS NULL')
										   /*->filterBy('module', 'IS NULL')*/
										   ->attributes('value')
										   ->findOne();
	if ($globalData) return $globalData['value'];
	else return false;
    // Bouml preserved body end 001A6C05
  }

}
?>