<?php
require_once 'iplan/orm/validations/AlphaValidation.php';
require_once 'iplan/orm/validations/TextValidation.php';
require_once 'iplan/orm/validations/NumericValidation.php';
require_once 'iplan/orm/validations/MailValidation.php';
require_once 'iplan/orm/validations/AlphaNumericValidation.php';
require_once 'iplan/orm/validations/RequiredValidation.php';
require_once 'iplan/orm/validations/MinValidation.php';
require_once 'iplan/orm/validations/MaxValidation.php';
require_once 'iplan/orm/validations/RegexpValidation.php';
require_once 'iplan/orm/validations/FloatValidation.php';
require_once 'iplan/orm/validations/IPValidation.php';
require_once 'iplan/orm/validations/MacValidation.php';
require_once 'iplan/orm/validations/URLValidation.php';
require_once 'iplan/orm/validations/MaxlengthValidation.php';
require_once 'iplan/orm/validations/PrecisionValidation.php';
require_once 'iplan/orm/validations/ScaleValidation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * La factoria de validaciones. Esta clase es la responsable de retornar las instancias correspondientes a cada validaci�n.
 */
abstract class Validation {
  /**
   * @var array una lista de las validaciones instanciadas, de tal forma que hacer una especie de Singleton. Nota: Singleton no se puede hacer porque no todas se crean una vez, solo la mayor�a.
   */
  private static $registeredValidations = array();

  /**
   * Devuelve una instancia de Validation que a trav�s de su m�todo validate() determina si un valor cumple o no la condici�n.
   * 
   * @param string $validation el nombre de la validaci�n
   * @param array $params los par�metros que se consideren necesarios para la validaci�n
   * 
   * @return Validation una instancia de la validaci�n requerida
   */
  public static function getValidation($validation, $params = null)
  {
    // Bouml preserved body begin 000E1805
        $class = strtoupper($validation[0]).substr($validation,1).'Validation';
        if (self::isComplexValidation($validation)) {
            return new $class($params);
        } else {
            if (!isset(self::$registeredValidations[$validation])) {
                self::$registeredValidations[$validation]=new $class();
            }
            return self::$registeredValidations[$validation];
        }
    // Bouml preserved body end 000E1805
  }

  /**
   * Valida un valor contra una expresi�n regular y devuelve true si hay coincidencia.
   * 
   * @param string $expression la expresi�n regular a validar.
   * @param mixed value un valor, debe poder convertirse a una versi�n string.
   * 
   * @return boolean Devuelve TRUE si el patr�n tiene coincidencia y FALSE en caso contrario.
   */
  public static function validateExpression($expression, &$value)
  {
    // Bouml preserved body begin 000FFE05
    preg_match("$expression", $value, $matches);
    if (is_array($matches)) {
        if (isset($matches[0])) {
            return $value == $matches[0];
        } else return false;
    } else return false;
    // Bouml preserved body end 000FFE05
  }

  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripci�n del error en caso contrario.
   */
  public abstract function validate($value)
  ;
  /**
   * Retorna un arreglo con las validaciones existentes.
   * 
   * @return array Las validaciones existentes.
   */
  public static function getRegisteredValidations()
  {
    // Bouml preserved body begin 00162305
	return array('required', 'alpha', 'numeric', 'alphanumeric', 'mail', 'text', 'regexp', 'min', 'max', 'size', 'float', 'mac', 'ip', 'url', 'maxlength', 'precision', 'scale');
    // Bouml preserved body end 00162305
  }

  /**
   * Indica si la validaci�n pasada por par�metro es compleja o no.
   * 
   * @param mixed $validation un string o una instancia de Validation de la que se desea saber si es compleja.
   * @return boolean Retorna TRUE si la validaci�n es compleja, entendiendo como tal a una validaci�n que depende de sus par�metros. False sino.
   */
  public static function isComplexValidation($validation)
  {
    // Bouml preserved body begin 00106805
    switch ($validation) {
        //Estas son estándar y predefinidas
        case 'required':
        case 'alpha':
        case 'numeric':
        case 'float':
        case 'alphanumeric':
        case 'mail':
        case 'text':
		case 'mac':
		case 'ip':
		case 'url':
            return false;
            break;
        //Estas son particulares de cada caso
        case 'regexp':
        case 'min':
        case 'max':
		case 'minvalue':
        case 'maxvalue':
        case 'maxlength':
		case 'precision':
		case 'scale':
		case 'size':
            return true;
            break;
        default:
            throw new Exception("La validación [$validation] es desconocida");
    }
    // Bouml preserved body end 00106805
  }

}
?>