<?php
require_once 'iplan/orm/validations/Validation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class URLValidation extends Validation {
  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripci�n del error en caso contrario.
   */
  public function validate($value)
  {
    // Bouml preserved body begin 0016F085
	  /*
	   * ^(?#Protocol) (?:(?:ht|f)tp(?:s?)\:\/\/|~\/|\/)?
	   *  (?#Username:Password) (?:\w+:\w+@)?
	   *  (?#Subdomains) (?:(?:[-\w]+\.)+
	   *  (?#TopLevel Domains) (?:com|org|net|gov|mil|biz|info|mobi|name|aero|jobs|museum|travel|[a-z]{2}))
	   *  (?#Port) (?::[\d]{1,5})?
	   *  (?#Directories) (?:(?:(?:\/(?:[-\w~!$+|.,=]|%[a-f\d]{2})+)+|\/)+|\?|#)?
	   *  (?#Query) (?:(?:\?(?:[-\w~!$+|.,*:]|%[a-f\d{2}])+=?(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)(?:&(?:[-\w~!$+|.,*:]|%[a-f\d{2}])+=?(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)*)*
	   *  (?#Anchor) (?:#(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)? 
	   * $
	   */
	if (Validation::validateExpression("/^(?:(?:ht|f)tp(?:s?)\:\/\/|~\/|\/)?(?:\w+:\w+@)?(?:(?:[-\w]+\.)+(?:com|org|net|gov|mil|biz|info|mobi|name|aero|jobs|museum|travel|[a-z]{2}))(?::[\d]{1,5})?(?:(?:(?:\/(?:[-\w~!$+|.,=]|%[a-f\d]{2})+)+|\/)+|\?|#)?(?:(?:\?(?:[-\w~!$+|.,*:]|%[a-f\d{2}])+=?(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)(?:&(?:[-\w~!$+|.,*:]|%[a-f\d{2}])+=?(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)*)*(?:#(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)?$|^$/", $value)) {
        return true;
    } else {
        return "URL inválida \"$value\"";
    }
    // Bouml preserved body end 0016F085
  }

}
?>