<?php
require_once 'iplan/orm/validations/Validation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ScaleValidation extends Validation {
  /**
   * @var int el n�mero de digitos decimales
   */
  private $scale;

  /**
   * Crea una instancia de ScaleValidation en base a la escala (lugares decimales) que se pasan por par�metro.
   * 
   * @param int $scale la cantidad de lugares decimales.
   * 
   * @return ScaleValidation El objeto validador de esa expresi�n regular.
   */
  public function __construct($scale)
  {
    // Bouml preserved body begin 00170C05
	$this->scale = $scale;
    return $this;
    // Bouml preserved body end 00170C05
  }

  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripci�n del error en caso contrario.
   */
  public function validate($value)
  {
    // Bouml preserved body begin 00170A85
	if (Validation::validateExpression("/^([+-]?(((\\d+[\\,\\.]?)|(\\d*[\\,\\.](\\d{0," . $this->scale . "})))))$|^$/" , $value)) {
        return true;
    } else {
        return "El valor \"$value\" no cumple tener a lo sumo $this->scale dígitos en su parte decimal";
    }
    // Bouml preserved body end 00170A85
  }

}
?>