<?php
require_once 'iplan/orm/validations/Validation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class RegexpValidation extends Validation {
  /**
   * @var string la expresi�n regular para la que fue creado el objeto
   */
  private $expression;

  /**
   * @var string un mensaje para mostrar en caso que no se cumpla la validación.
   */
  private $message = "El valor %1 no coincide con la expresión [%2]";

  /**
   * Crea una instancia de RegExpValidation en base a la expresi�n que se para por par�metro.
   * 
   * @param string $expression la expresi�n regular seg�n las pautas de PCRE.
   * 
   * @return RegExpValidation El objeto validador de esa expresi�n regular.
   */
  public function __construct($expression)
  {
    // Bouml preserved body begin 000FFE85
	$openTag = substr($expression, 0, 1);
	$lastTag = strpos($expression, $openTag, 1);
	while (substr($expression, $lastTag-1, 1) == '\\')
		$lastTag = strpos($expression, $openTag, $lastTag);
	$message = substr($expression, $lastTag+1);
	if ($message != "")
		$this->message = $message;
    $this->expression = substr($expression, 0, $lastTag+1);
    return $this;
    // Bouml preserved body end 000FFE85
  }

  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripci�n del error en caso contrario.
   */
  public function validate($value)
  {
    // Bouml preserved body begin 000E1D05
    if (Validation::validateExpression($this->expression, $value)) {
        return true;
    } else {
        return sprintf($this->message, $value, $this->expression);
    }
    // Bouml preserved body end 000E1D05
  }

}
?>