<?php
require_once 'iplan/orm/validations/Validation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class PrecisionValidation extends Validation {
  /**
   * @var int la precisi�n en n�mero de digitos
   */
  private $precision;

  /**
   * Crea una instancia de PrecisionValidation en base a la precisi�n que se pasa por par�metro.
   * 
   * @param int $precision la cantidad de lugares enteros.
   * 
   * @return PrecisionValidation El objeto validador de esa expresi�n regular.
   */
  public function __construct($precision)
  {
    // Bouml preserved body begin 00170B85
	$this->precision = $precision;
    return $this;
    // Bouml preserved body end 00170B85
  }

  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripci�n del error en caso contrario.
   */
  public function validate($value)
  {
    // Bouml preserved body begin 00170B05
	if (Validation::validateExpression("/^([+-]?(((\\d{0," . $this->precision . "}[\\,\\.]?)|(\\d{0," . $this->precision . "}[\\,\\.][0-9]+))))$|^$/", $value)) {
        return true;
    } else {
        return "El valor \"$value\" no cumple tener a lo sumo $this->precision dígitos en su parte entera";
    }
    // Bouml preserved body end 00170B05
  }

}
?>