<?php
require_once 'iplan/orm/validations/Validation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class MinValidation extends Validation {
  /**
   * @var float el valor m�nimo que puede tomar un valor dado.
   */
  private $minValue;

  /**
   * Crea un objeto de validaci�n para valor m�nimo.
   * 
   * @param float $minValue el valor m�nimo que puede alcanzar un valor dado para pasar la prueba.
   * 
   * @return MinValidation El objeto validaci�n.
   */
  public function __construct($minValue)
  {
    // Bouml preserved body begin 000FFF85
    $this->minValue = $minValue;
    return $this;
    // Bouml preserved body end 000FFF85
  }

  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripci�n del error en caso contrario.
   */
  public function validate($value)
  {
    // Bouml preserved body begin 000E1C05
    if ((is_object($value)) && in_array('Countable', class_implements($value, false))) {
        if ((count($value) < $this->minValue) && (count($value) > 0))
            return "La cantidad mínima de elementos permitidos es $this->minValue";
    } elseif (is_string($value)) {
        if ((strlen($value) < $this->minValue) && (strlen($value)>0))
            return "La longitud de ($value) tiene que tener como mínimo $this->minValue caracteres";
    } elseif (is_numeric($value)) {
        if ($value < $this->minValue)
            return "El número ($value) debe ser mayor o igual a $this->minValue";
    }
    return true;
    // Bouml preserved body end 000E1C05
  }

}
?>