<?php
require_once 'iplan/orm/validations/Validation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class MaxValidation extends Validation {
  /**
   * @var float el valor mximo al que puede llegar un valor dado.
   */
  protected $maxValue;

  /**
   * Retorna una instancia de la validacin con el lmite indicado.
   * 
   * @param float $maxValue el valor mximo admitido.
   * 
   * @return MaxValidation Una instancia que chequea que no se pase del lmite.
   */
  public function __construct($maxValue)
  {
    // Bouml preserved body begin 000FFF05
    $this->maxValue = $maxValue;
    return $this;
    // Bouml preserved body end 000FFF05
  }

  /**
   * Verifica si un valor o un conjunto de valores cumplen la condicin.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripcin del error en caso contrario.
   */
  public function validate($value)
  {
    // Bouml preserved body begin 000E1C85
    if ((is_object($value)) && in_array('Countable', class_implements($value, false))) {
        if (count($value) > $this->maxValue)
            return "La cantidad máxima de elementos permitidos es $this->maxValue";
    } elseif (is_string($value)) {
        if (strlen($value) > $this->maxValue)
            return "La longitud de ($value) tiene que tener un máximo de $this->maxValue caracteres";
    } elseif (is_numeric($value)) {
        if ($value > $this->maxValue)
            return "El número ($value) debe ser menor o igual a $this->maxValue";
    }
    return true;
    // Bouml preserved body end 000E1C85
  }

}
?>