<?php
require_once 'iplan/orm/validations/Validation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Versión creada para compatibilizar el nombre "alphanumeric" cuando la clase existente era "AlphaNumeric" y al convertir la primer letra a uppercase no se instanciaba correctamente la clase.
 */
class Alphanumeric extends Validation {
  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripci�n del error en caso contrario.
   */
  public function validate($value)
  {
    // Bouml preserved body begin 0019E585
    if (Validation::validateExpression("/^[(0-9|a-z|A-Z|áéíóúñÁÉÍÓÚÑ|\\s)]*$/", $value)) {
        return true;
    } else {
        return "El valor \"$value\" no es alfanumérico";
    }
    // Bouml preserved body end 0019E585
  }

}
?>