<?php
require_once 'iplan/orm/validations/Validation.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class AlphaNumericValidation extends Validation {
  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return TRUE|string TRUE si cumple o un string con la descripci�n del error en caso contrario.
   */
  public function validate($value)
  {
    // Bouml preserved body begin 000E1B05
    if (Validation::validateExpression("/^[(0-9|a-z|A-Z|áéíóúñÁÉÍÓÚÑ|\\s)]*$/", $value)) {
        return true;
    } else {
        return "El valor \"$value\" no es alfanumérico";
    }
    // Bouml preserved body end 000E1B05
  }

}
?>