<?php
require_once 'iplan/orm/ORMQuery.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ORMQueryMTWrapper extends ORMQuery {
  /**
   * @var array el arreglo de la configuración que se debe completar
   */
  private $config;

  /**
   * @var array un arreglo con los anidamientos de grupos
   */
  private $groupPointers;

  /**
   * @var int el contador de grupos
   */
  private $groupCount;

  /**
   * Crea un objeto de consulta especialmente creado para la herrmienta de migración que retorna elementos del tipo de la clase indicada.
   * 
   * @param string $class la clase de objetos que retornará la consulta.
   * @param ORM $orm el objeto ORM al que se ata la consulta.
   * @return ORMQuery un objeto con los criterios de una consulta.
   */
  public function __construct($class, &$orm, &$configuration)
  {
    // Bouml preserved body begin 001D9285
	parent::__construct($class, $orm);
	$this->config = &$configuration;
	$this->groupCount = 0;
	return $this;
    // Bouml preserved body end 001D9285
  }

  /**
   * Establece la cantidad de filas a saltear del conjunto de resultados antes de considerarla v�lida como respuesta.
   * 
   * @param int $row la fila a partir de la cual deseamos que se nos retornen resultados.
   * 
   * @return ORMQuery La consulta modificada. from() siempre debe llamarse antes que to() para calcular el diferencial.
   */
  public function from($row)
  {
    // Bouml preserved body begin 001D9205
	parent::from($row);
	$this->config[$this->getClass()]['query']['limits']['from']=$row;
	return $this;
    // Bouml preserved body end 001D9205
  }

  /**
   * Establece el m�ximo n�mero de fila que quiere recuperarse. Debe ser mayor al valor prefijado en from().
   * 
   * @param int $row el n�mero de fila m�xima del conjunto de resultado.
   * 
   * @return ORMQuery La consulta con el nuevo l�mite aplicado. Debe considerarse que si no se llam� a from() previamente no se va a calcular el diferencial.
   */
  public function to($row)
  {
    // Bouml preserved body begin 001D9385
	parent::to($row);
	$this->config[$this->getClass()]['query']['limits']['to']=$row;
	return $this;
    // Bouml preserved body end 001D9385
  }

  /**
   * Establece cuantas filas se deben recuperar del conjunto de resultados.
   * 
   * @param int $limit la cantidad de filas a recuperar
   * 
   * @return ORMQuery El objeto Query modificado.
   */
  public function top($limit)
  {
    // Bouml preserved body begin 001D9405
	parent::top($limit);
	$this->config[$this->getClass()]['query']['limits']['top']=$limit;
	return $this;
    // Bouml preserved body end 001D9405
  }

  /**
   * Establece una condici�n de b�squeda para la consulta.
   * 
   * @param string $attribute el campo sobre el cual se especifica la condici�n
   * @param int $operator la operaci�n de comparaci�n
   * @param mixed $value el valor utilizado para la comparaci�n
   * @param mixed $other otro valor en caso de ser necesario
   * @param string $connector la palabra 'AND' o 'OR' seg�n se quiera utilizar para concatenar la condici�n
   * 
   * @return ORMQuery la consulta con la condici�n incorporada.
   */
  public function filterBy($attribute, $operator, $value = "", $other = "", $connector = 'AND')
  {
    // Bouml preserved body begin 001D9485
	parent::filterBy($attribute, $operator, $value, $other, $connector);
	if ($this->groupPointers == null) {
		$this->config[$this->getClass()]['query']['filters'][]=array($attribute, $operator, $value, $other, $connector);
	} else {
		$tmp = &$this->config[$this->getClass()]['query'];
		foreach($this->groupPointers as $group) {
			if (!isset($tmp['groups']["$group"]))
				$tmp['groups']["$group"]=array();
			$tmp = &$tmp['groups']["$group"];
			$tmp['filters'][]=array($attribute, $operator, $value, $other, $connector);
		}
	}
	return $this;
    // Bouml preserved body end 001D9485
  }

  /**
   * Inicia un agrupamiento de condiciones. Todas los llamados a filterBy() que vengan luego del startGroup() ser�n considerados como un conjunto.
   * @param string $joinMode indica como se va a unir el conjunto con las siguiente condiciones.
   * @return ORMQuery La consulta con el grupo creado.
   */
  public function startGroup($joinMode = 'AND')
  {
    // Bouml preserved body begin 001D9505
	parent::startGroup($joinMode);
	if (!isset($this->config[$this->getClass()]['query']['groups']))
		$this->config[$this->getClass()]['query']['groups'] = array();
	$this->groupPointers[]=$this->groupCount++;
	return $this;
    // Bouml preserved body end 001D9505
  }

  /**
   * Finaliza un grupo de condiciones previamente iniciado con startGroup().
   * 
   * @return ORMQuery La consulta con el grupo cerrado.
   */
  public function endGroup()
  {
    // Bouml preserved body begin 001D9585
	parent::endGroup();
	array_slice($this->groupPointers, -1, 1);
	if (count($this->groupPointers) == 0)
		$this->groupPointers = null;
	return $this;
    // Bouml preserved body end 001D9585
  }

  /**
   * Ordena el conjunto de resultados por la columna indicada.
   * 
   * @param string $attribute el atributo por el cual se desea ordenar el resultado. No se puede ordenar por atributos relaci�n, ni por los atributos de los elementos de las relaciones o de los atributos entidad. Se puede indicar anteponiendo un espacio si es 'ASC' o 'DESC'
   * 
   * @return ORMQuery La consulta modificada como se indic�.
   */
  public function orderBy($attribute)
  {
    // Bouml preserved body begin 001D9605
	parent::orderBy(func_get_args());
	foreach(func_get_args() as $att) {
		$this->config[$this->getClass()]['query']['orderBy'][]=$att;
	}
	return $this;
    // Bouml preserved body end 001D9605
  }

  /**
   * Define qu� atributos recuperar del conjunto de resultados.
   * 
   * @param string $attribute un atributo a ser devueltos por la consulta. Se pueden pasar varios uno tras otro y son "navegables" a trav�s de puntos.
   * @return ORMQuery retorna la query modificada
   */
  public function attributes($attribute)
  {
    // Bouml preserved body begin 001D9685
	throw new ORMException('No se permite seleccionar atributos en el contexto de una migración');
    // Bouml preserved body end 001D9685
  }

  /**
   * Indica que los datos se traigan a�n en los casos donde el atributo sea null o la relaci�n no exista.
   * @param string $attribute el nombre del atributo, puede anidarse con "." y se pueden pasar varios o un array de strings tambi�n.
   * @return ORMQuery La consulta con el atributo modificado.
   */
  public function dontWorryAbout($attribute)
  {
    // Bouml preserved body begin 001D9705
	parent::dontWorryAbout(func_get_args());
	foreach(func_get_args() as $att) {
		$this->config[$this->getClass()]['query']['dontWorryAbout'][]=$att;
	}
	return $this;
    // Bouml preserved body end 001D9705
  }

  /**
   * Anula una orden dada previamente con dontWorryAbout().
   * @param string $attribute el nombre del atributo, puede anidarse con "." y se pueden pasar varios o un array de strings tambi�n.
   * @return ORMQuery La consulta con el atributo modificado.
   */
  public function worryAbout($attribute)
  {
    // Bouml preserved body begin 001D9785
	parent::worryAbout($attribute);
	foreach(func_get_args() as $att) {
		$this->config[$this->getClass()]['query']['worryAbout'][]=$att;
	}
	return $this;
    // Bouml preserved body end 001D9785
  }

  /**
   * Define qu� atributos deben ser agrupados una vez obtenido el conjunto de resultados masivo.
   * 
   * @param string $attribute un atributo por el cual se debe agrupar el resultado de la consulta. Se pueden pasar varios uno tras otro y son "navegables" a trav�s de puntos.
   * @return ORMQuery retorna la query modificada
   */
  public function groupBy($attribute)
  {
    // Bouml preserved body begin 001D9805
	parent::groupBy(func_get_args());
	foreach(func_get_args() as $att) {
		$this->config[$this->getClass()]['query']['groupBy'][]=$att;
	}
	return $this;
    // Bouml preserved body end 001D9805
  }

}
?>