<?php
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/PrivateAccesor.php';
require_once 'iplan/orm/ORMCollection.php';
require_once 'iplan/orm/LazyLoader.php';
require_once 'iplan/orm/ORM_STATUS.php';
require_once 'iplan/orm/exceptions/InternalError.php';
require_once 'iplan/orm/exceptions/DMLOperationFailed.php';
require_once 'iplan/orm/exceptions/ValueNotDefined.php';
require_once 'iplan/orm/exceptions/UnknowORM.php';
require_once 'iplan/orm/exceptions/InstanceNotSaved.php';
require_once 'iplan/orm/validations/Validation.php';
require_once 'iplan/orm/exceptions/ORMValidationException.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Se trata de una interfaz que implementa los m�todos necesarios para brindar servicios de almacenamiento y recuperaci�n del objeto en la base de datos
 * 
 * En conjunto con ORM y las clases auxiliares, dan una soluci�n integral para la gesti�n del mapeo relacional.
 * 
 * //TODO: se podr�a reducir mucho c�digo haciendo una funci�n "getMyDefinition()" que busque la definici�n del objeto ya sea que tenga o no el ORM.
 */
abstract class ORMObject extends PrivateAccesor implements ORM_STATUS {
  static $definition;

  /**
   * @var int El identificador del objeto
   */
  public $id;

  /**
   * Un estado que puede ser:
   * NEW := NUEVO, es un objeto a�n no persistido en la base de datos, pero que de seguir la secuencia de eventos culminar� insertandose en la base.
   * REMOVED := Es un objeto que se solicit� para remoci�n de la base de datos. Es posible que alguna referencia quede apuntando a �l y accediendo sus valores, pero los mismos deber�an ser descartados. Posiblemente alg�n programa de LOG quiera ver como estaba al momento del DELETE o algo as�.
   * REGISTERED := Significa que el objeto est� persistido en la base de datos y que actualmente est� bajo la vista del sistema ORM para preservar cualquier cambio.
   * UNREGISTERED := Significa que el objeto no est� bajo seguimiento del Manager de ORM.
   */
  private $ORMState;

  /**
   * @var ORM $orm la instancia de ORM que est� gerenciando el objeto o null
   */
  protected $orm;

  private $ORMModifying = false;

  /**
   * @var array un arreglo en el cual se almacenar�n los campos modificados
   */
  private $ORMModifieds;

  public function __destroy()
  {
    // Bouml preserved body begin 00027D05
    /*@todo HACER ESTO BIEN
      if (($this->ORMState == ORM_STATUS::ATTACHED) && $this->isModified() && $this->orm->getAuto...) {
        $this->save();
    }*/
    // Bouml preserved body end 00027D05
  }

  /**
   * Constructor predeterminado de los objetos derivados del ORM. Recibe opcionalmente una instancia del ORM al cual se desea que se registre la instancia. Esto afecta el estado y si la instancia desde su nacimiento va a ser monitoreada por el ORM.
   * @param ORM $orm una instancia del ORM que va a monitorear el objeto.
   * @return ORMObject la instancia del objeto
   */
  public function __construct(&$orm = null)
  {
    // Bouml preserved body begin 0002B385
    $definition = "";
    if (!is_null($orm)) {
        if ($orm->getBindObjectsOnCreate()) {
            $orm->attach($this);
        }
        $this->orm=$orm;
        $definition = $orm->getDefinition(get_class($this));
    } else {
        $this->ORMState = ORM_STATUS::FRESH;
        //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
        $class = get_class($this);
        $params = array();
        $definition = $this->invokeStaticMethod($class, "define", $params);
        //$definition = self::define(null);
    }
    $fields = $definition->getFieldDefinition();
    if (is_array($fields)) {
        foreach($fields as $attribute=>$map) {
            $this->$attribute = $map['default'];
        }
    }

    if ($relations = $definition->getRelationDefinition()) {
        foreach($relations as $attribute=>$map) {
            $this->$attribute = null;//new ORMCollection();
        }
    }

    $this->id = null;
    $this->ORMModifieds=null;
    // Bouml preserved body end 0002B385
  }

  /**
   * ANULADO POR AHORA. Devuelve TRUE si la variable existe.
   * 
   * @param string $variablename el nombre de la variable.
   * 
   * @return boolean Retorna TRUE si la variable se encuentra definida o FALSE sino.
   */
  public function isset__($variablename)
  {
    // Bouml preserved body begin 000B9C05
    return property_exists(get_class($this), $variablename);
    // Bouml preserved body end 000B9C05
  }

  /**
   * Retorna un objeto de definición predeterminado al cual hay que agregarle los mapeos pertinentes.
   * 
   * @param ORM $orm el manejador de ORM para el cual se registra la clase
   * @return \orm\ORMDefinition la definición default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00046585
    return new ORMDefinition($orm);
    // Bouml preserved body end 00046585
  }

  /**
   * Borra f�sicamente un objeto de la base. Al borrarse el objeto adem�s se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relaci�n M:N
   * 
   * @return boolean un booleando TRUE si la operaci�n fue concretada con �xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 00029985
    if (!is_null($this->orm)) {
        if (!is_null($this->id)) {
            $db = $this->orm->getDatabase();
            //Inicio el ciclo de borrado eliminando primero las referencias directas de las relacions 1:1, 1:N y M:N
            $definition = $this->orm->getDefinition(get_class($this));
            $relationsDefs = $definition->getRelationDefinition();
			if (is_array($relationsDefs) && (count($relationsDefs) > 0)) {
				foreach($relationsDefs as $attribute => $relationMap) {
					//Recupero la definición de la clase del otro extremo de la relación
					$targetClassDefinition = $this->orm->getDefinition($relationMap['class']);
					switch($relationMap['type']) {
						case ORM_RELATION_TYPE::OneToOne:
						case ORM_RELATION_TYPE::OneToMany:
							//Guardo la definición de la clave primaria de la clase objetivo
							$targetIdDefinition = $targetClassDefinition->getFieldDefinition('id');
							//Busco en la tabla de la clase objetivo todos los IDs que apunten al objeto a borrar
							$relatedIds = $db->filter($targetIdDefinition['table'], array($targetIdDefinition['fieldName']),
													  array($db->makeCondition('=', $relationMap['fieldName'], $this->getId())));
							//Si hay IDs entonces...
							if ($relatedIds != false) {
								$listOfIds = array();
								//4/4/2012
										$targetAttribute = $targetClassDefinition->getFieldDefinition($relationMap['fieldName'], true);
										$targetAttribute = $targetAttribute['attribute'];
								//Fin 4/4/2012
								//Para cada uno me fijo si está cargado, si lo está disocio el objeto (en memoria)
								foreach($relatedIds as $key=>$relId) {
									if ($relatedObject = $this->orm->retrieve($relationMap['class'], $relId[$targetIdDefinition['fieldName']])) {
										//Esto no provoca que el estado del objeto se altere (es decir, no queda "Modified")
//4/4/2012										$this->setAttribute($relatedObject, $relationMap['fieldName'], null);
										$this->setAttribute($relatedObject, $targetAttribute, null);
										//Nota: no busco el LazyLoad, porque dejar que el LazyLoad traiga NULL es innecesario,
										//también evito que algún llamado reinicialize el valor antes de que yo elimine.
									}
									$listOfIds[]=$relId[$targetIdDefinition['fieldName']];
								}
								//Actualizo todos los registros relacionados poniendo en null el valor que referenciaba el objeto
								$db->update($targetIdDefinition['table'],
											array($relationMap['fieldName']=>'NULL'),
											array($db->makeCondition("IN", $targetIdDefinition['fieldName'], $listOfIds)));
							}
							break;
						case ORM_RELATION_TYPE::ManyToMany:
							//Recuperar ids de objetos relacionados a través de la tabla intermedia
							$relatedIds = $db->filter($relationMap['table'], array($relationMap['associatedFieldName']),
												  array($db->makeCondition('=', $relationMap['fieldName'], $this->getId())));
							//Si hay Ids entonces...
							if ($relatedIds != false) {
								$listOfIds = array();
								$relationDef = $targetClassDefinition->getRelationDefinition($relationMap['table'], true);
								foreach($relatedIds as $key=>$relId) {
									$listOfIds[]=$relId[$relationMap['associatedFieldName']];//...lo guardo y...
									// Lo muevo arriba $relationDef = $targetClassDefinition->getRelationDefinition($relationMap['table'], true);
									//...chequeo si el objeto relacionado ya está en memoria...
									if ($relatedObject = $this->orm->retrieve($relationMap['class'], $relId[$relationMap['associatedFieldName']])) {
										//if ($this->orm->getDebug()) echo "Se ha encontrado que el objeto ".$relationMap['class'].":".$relatedObject->getId()."\n";
										//...si está, entonces busco cuál es la relación que tiene con el objeto a borrar...
										$collection = $this->getAttribute($relatedObject, $relationDef['attribute']);
										//if ($this->orm->getDebug()) echo "Se ha encontrado que el objeto ".$relationMap['class'].":".$relatedObject->getId()."\n";
										//... si la relación es una Collection quiere decir que hay que actualizarla preservando su estado...
										if (is_a($collection, 'ORMCollection')) {
											$reset = $collection->isModified();
											//if ($this->orm->getDebug()) echo $this->getDescription().": Buscando ".$this->getId().":\n";
											foreach($collection as $key=>$value) {
												//if ($this->orm->getDebug()) echo "    ".$relationMap['class'].".".$relationDef['attribute']."[$key]=".$value->getId()."\n";
												if ($value->getId() == $this->getId()) {//Antes $value->getId() == $relId
													//if ($this->orm->getDebug()) echo "    Eliminando offset[$key]\n";
													$collection->offsetUnset($key);
													break;
												}
											}
											if ($reset) $collection->reset();
										}
									}
								}
								$delResult = $db->delRelation($relationMap['table'], array($relationMap['fieldName']=> $this->id) );
								if ($delResult === false) {
									throw new DMLOperationFailed('Error al eliminar registros de '.$relationMap['table'].' [atributo: '.get_class($this).'::'.$relationDef['attribute'].']');
									return false;
								}
							}
							break;
						default:
							throw new ORMDefinitionError('La definición de la clase "'.get_class($this).'" usa un tipo incorrecto para la relación "'.$attribute.'"');
							return false;
					}

				}
			}
            //Luego recorro las definiciones de tablas pero a la inversa y borrando los registros
            $attByTableDef = array_reverse(array_keys($definition->getFieldsByTable()), true);
            foreach($attByTableDef as $table) {
                $db->delete($table, $this->id);
            }

            //Finalmente disocio el objeto del ORM
            $this->orm->dettach($this);
            $this->id=null;
            return true;
        } else {
            throw new InternalError("No se puede borrar una instancia nunca persistida (guardada)");
            return false;
        }
    } else {
        throw new UnknowORM("No hay un ORM configurado para esta instancia");
        return false;
    }
    // Bouml preserved body end 00029985
  }

  /**
   * Recupera una instancia de la clase desde la base de datos. Este m�todo adem�s calcula el hash en base a los atributos. En combinaci�n con el m�todo save() permite abstraer a las clases subyacentes de la necesidad de determinar si el objeto fue alterado o no y si corresponde guardarlo.
   * Finalmente este m�todo registra el objeto en el ORM para su mantenimiento autom�tico.
   * @param $id int el identificador del objeto a recuperar
   * @param $orm ORM el gestor que solicita el objeto
   * @param string $class la clase que se quiere cargar. Si se omite se toma la clase invocada en forma predeterminada
   * @return ORMObject una instancia con los valores precargados
   * 
   * @todo prestar atenci�n en el LOAD que si se hace una carga de objetos masiva, es necesario verificar que los mismos no esten PRE registrados en el ORM o si lo est�n y los hash no son los mismos enviar alguna excepci�n al usuario.
   */
  public static function &load($id, &$orm, $class = "")
  {
    // Bouml preserved body begin 00027C85

    if ($class=="") $class=get_called_class ();

    //Primero intento recuperarlo de la caché:
    if (is_object($cacheObj = $orm->retrieve($class, $id))) {
        if (!$cacheObj->isModified()) {
            return $cacheObj;
        } else {
            $mods = "Atributos: ";
            foreach($cacheObj->getModifiedAttributes() as $att)
                $mods .= "$att, ";
            throw new InstanceNotSaved("Se está intentando cargar mediante ORMObject::load() la instancia $id de la clase $class, que ya está cargada y modificada. $mods");
        }
    }
    //Si no estaba en caché, creo la instancia a inicializar
    $object = new $class($orm);
    $object->setORMState(ORM_STATUS::LOADING);

    //Obtengo la base de datos y las definiciones
    $conn = $orm->getDatabase();
    $definition = $orm->getDefinition($class);

    //Primero recupero los atributos directos, recorriendo los mismos por tabla
    $defByTables = $definition->getFieldsByTable();
    foreach($defByTables as $table=>$tableMaps) {
        unset($fields);
        unset($entities);
        //Elijo qué campos voy a traer de la base de datos, cuáles serán
        //cargados en forma dinámica (LAZY) y cuáles son entidades enteras.
        foreach($tableMaps as $attribute=>$attDefinition) {
            //Si el atributo es un elemento básico lo cargo,
            switch (true) {
                //Si es Lazy creo el objeto y listo
                case $attDefinition['loadStyle']==ORM_LOAD_STYLE::LAZY_LOAD:
// ES
//                    $method = self::setter($attribute);
//                    $object->$method(new LazyLoader($object, $attribute, $orm));
                    parent::stSetAttribute($object, $attribute, new LazyLoader($object, $attribute, $orm));
                    break;
                //Si es una entidad, marco que se tiene que cargar la misma
                //después de recuperar el id, por ello dejo que pase y que
                //agregue el fieldName a la lista de fields
                case $attDefinition['type']==ORMDefinition::ORM_ENTITY:
                    $entities[$attribute]=$attDefinition;
                //Si no es ningún caso anterior es un atributo valor común
                default:
                    $fields[$attribute]=$attDefinition['fieldName'];
            }
        }
        //Recupero los datos de la base

        if ($data = $conn->getData($table, $id, $fields)) {
			if (isset($data["SQL_STATUS"]) && ($data["SQL_STATUS"] == 0)) {
				throw new Exception("Error de datos: " . $data["CODE"] . ": " . $data["DESCRIPTION"]."\nConnection::getData($table,$id,'".  implode(', ', $fields)."')");
			}
            //Para cada valor recuperado, lo configuro en el atributo correspondiente
            foreach($fields as $attribute => $fieldName) {
                //Verifico que el atributo no sea de una entidad, dado que setearlo es de gusto
                if (!isset($entities[$attribute])) {
// ES
//                    $method = self::setter($attribute);
//                    //Para cada atributo realizo la conversión de datos pertinente
//                    $object->$method($conn->db2php($data[$fieldName], $tableMaps[$attribute]['type']));
                    parent::stSetAttribute($object, $attribute, $conn->db2php($data[$fieldName], $tableMaps[$attribute]['type']));

                }
            }
            //Si hay entidades a cargar...
            if (isset($entities)) {
                //...las cargo y las asigno, de a una por vez
                foreach($entities as $attribute => $attDefinition) {
                    if (!is_null($data[$attDefinition['fieldName']])) {
// ES
//                        $method = self::setter($attribute);
//                        $object->$method($orm->load($attDefinition['class'], $data[$attDefinition['fieldName']]));
                        parent::stSetAttribute($object, $attribute, $orm->load($attDefinition['class'], $data[$attDefinition['fieldName']]));
                    }
                }
            }
        } else {
            $error = "$class: Error al invocar a ".get_class($conn)."->getData($table, $id, array(". implode(',', $fields).") en $class ->load(ID: $id)\n";
            throw new InternalError($error);
        }

    }

    //Luego recupero las relaciones
    if ($relations = $definition->getRelationDefinition()) {
        foreach($relations as $attribute => $relationMap) {
// ES
//            $method = self::setter($attribute);
            if ($relationMap['loadStyle']==ORM_LOAD_STYLE::LAZY_LOAD) {
// ES
//                $object->$method(new LazyLoader($object, $attribute, $orm));
                parent::stSetAttribute($object, $attribute,new LazyLoader($object, $attribute, $orm));
            } else {
                //@todo cargar la relación ya ya ya
                //Si bien podría hacer todo de una, la verdad que mejor concentrar el código en un solo lado
                $tmp = new LazyLoader($object, $attribute, $orm);
// ES
//                $object->$method($tmp->load());
                parent::stSetAttribute($object, $attribute, $tmp->load());
            }
        }
    }
    //Indico que el objeto a partir de ahora es monitoreado por el ORM
    //self::stInvokeMethod($object, "setORMState", array(ORM_STATUS::ATTACHED));
    $orm->attach($object);
    
    return $object;
    // Bouml preserved body end 00027C85
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este m�todo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto s�lo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar� una excepci�n.
   * 
   * Se pens� en que se podr�a hacer el cambio de un ORM a otro, pero el ID deber�a limpiarse, con lo cual s�lo un INSERT se podr�a hacer sobre el destino y los objetos relacionados estar�an a�n con otro ORM lo cual es complicado (manejo de objetos distribu�dos) por lo cual se deja a consideraci�n de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 00026285

    //Chequeo que haya un ORM, ya sea el interno o el pasado por parámetro. Obvio que prevalece el del parámetro:
    if (is_null($orm)) {
        if (is_null($this->orm)) {
            //self::debug(get_class($this).": no se proveyó de un ORM!!", 1, true, true);
            throw new UnknowORM("No se ha pasado el ORM al método save()");
        } else {
            if ($this->ORMState==ORM_STATUS::SAVING) {
                //self::debug("Detectado ".get_class($this).":".$this->id." Estado: ".$this->ORMState." (SAVING) => Omitiendo el save", 1, $this->orm->getDebug(), true);
                return true;//Quiere decir que ya se está guardando...
            } else {
                $orm = $this->orm;
                if (is_null($this->id))  $this->ORMState = ORM_STATUS::FRESH;
                //self::debug("Detectado ".get_class($this).":".$this->id." Estado: ".$this->ORMState,1,$orm->getDebug(), true);
            }
        }
    } else {//Si cambio o configuro por primera vez el ORM, se asume que no hay nada consolidado
            //Si el ORM es el mismo está todo bien :)
            //Que sea nuevo significa que, entre otras cosas, no tiene ID.
            //Obvio que se puede poner el ID del objeto, pero el hecho que sea FRESH significa
            //que cualquiera sea el ID, el mismo será pisado y el objeto totalmente insertado.
        if ($this->ORMState==ORM_STATUS::SAVING) {
            if ($this->orm != $orm) throw new InternalError("Se disparó una cadena de 'guardados' con ORM diferentes");
            else return true;
        }

        if (($this->orm != $orm) || (is_null($this->id))) {
            $this->orm = $orm;
            $this->ORMState = ORM_STATUS::FRESH;
            $this->id = null;
        }
    }

    $db = $orm->getDatabase();
    $definition = $orm->getDefinition(get_class($this));

    $allOK = $this->validate();
    if ($allOK !== TRUE) {
		$msg = "No se han pasado las validaciones para el objeto de clase ".  get_class($this)."\n";
		if (is_array($allOK)) {
			foreach($allOK as $attribute => $errorTexts) {
				$msg .= "\tAtributo: $attribute\n";
				foreach($errorTexts as $text)
					$msg .= "\t\t$text\n";
			}
		} else {
			$msg .= $allOK;
		}
        $exception = new ORMValidationException($msg);
        $exception->setFails($allOK);
        throw $exception;
    }

    //Si es nuevo hay que guardar todo, sino hay que seleccionar
    //self::debug(get_class($this).": Nuevo =".(($this->ORMState===ORM_STATUS::FRESH)?'Si':'No'), 1, $orm->getDebug());
    if (($this->ORMState == ORM_STATUS::FRESH)) {
        //Marco como guardando el objeto:
        $this->ORMState = ORM_STATUS::SAVING;
        //self::debug("...el objeto es nuevo",0,$orm->getDebug());
        //self::debug("...marco el objeto como ORM_STATUS::SAVING", 0, $orm->getDebug());

        //Primero los atributos directos
        $byTableDefinition = $definition->getFieldsByTable();
        //Para cada tabla
        $first=true;
        foreach($byTableDefinition as $table => $definitionsMap) {
            //Para cada atributo de la tabla
            foreach($definitionsMap as $attribute => $attDefinition) {
                //Determino el getter porque el valor se trae sí o sí (es nuevo)
                $getMethod = self::getter($attribute);
                //Si es un objeto
                if ($attDefinition['type']==ORM_TYPES::ORM_ENTITY) {
                    $obj = $this->$getMethod();
                    //Me fijo si está seteado y en ese caso traigo su ID, pero antes chequeo que lo tenga y que esté guardado
                    if (!is_null($obj)) {
                        if (is_null($obj->getId()) || $obj->isModified()) {
                            //self::debug("llamando a ".get_class($obj)."->save()",0,$orm->getDebug());
                            $obj->save($orm);//...o sino lo guardo antes
                        }
                        $fields[$attDefinition['fieldName']]=$obj->getId();
                    } else $fields[$attDefinition['fieldName']]=$db->php2db(null, $attDefinition['type']);
                //Si no es un objeto traigo el valor directo a través del get() para asegurarme el valor
                //y lo convierto si hace falta a un formato que la base de datos entienda
                } else {
                    $fields[$attDefinition['fieldName']]=$db->php2db($this->$getMethod(), $attDefinition['type']);
                }
            }
            //Si es la primer tabla inserto y recupero el id
            if ($first) {
                unset($fields[$definitionsMap['id']['fieldName']]);//Quito el ID porque no corresponde
                $this->id=$db->insert($table, $fields);
                $first=false;
            //Si es una tabla secundaria pongo el id principal e inserto sin usar generadores
            } else {
                $fields[$definitionsMap['id']['fieldName']]=$this->id;
                $this->id=$db->insert($table, $fields, false);
            }
        }
        
        //self::debug("...id=".$this->id." (el generado por la DB)", 0, $orm->getDebug());
        
        //...y luego relaciones
        $relationsMap = $definition->getRelationDefinition();
        //A diferencia del UPDATE, acá se recuperan sí o sí las relaciones porque es nuevo y por cada relación...
        if ($relationsMap) {
            foreach($relationsMap as $attribute => $relDefinition) {
                //self::debug("...detectada relacion $attribute", 1, $orm->getDebug());
                //Determino el getter porque el valor se trae sí o sí (es nuevo)
                $getMethod = self::getter($attribute);
                $collection = $this->$getMethod();
                if (is_a($collection, 'ORMCollection')) {
                    $targetDefinition = $orm->getDefinition($relDefinition['class']);
                    //Recorro y guardo todos los objetos
                    //Luego reseteo el flag de modificado de la colección
                    if ($relDefinition['type'] == ORM_RELATION_TYPE::ManyToMany) {
                        $targetRelDefinition = $targetDefinition->getRelationDefinition($relDefinition['table'], true);
                        foreach($collection as $keyObj => $obj) {
                            $collection[$keyObj]->save($orm);
                            $db->addRelation($relDefinition['table'], array($relDefinition['fieldName']=>$this->id,
                                                                            $relDefinition['associatedFieldName']=>$collection[$keyObj]->getId()));
                        }
                    } else {
                        foreach($collection as $keyObj=>$obj)
                            $collection[$keyObj]->save($orm);
                    }
                    $collection->reset();
                }
                //self::debug("...fin de tratamiento de relacion $attribute", -1, $orm->getDebug());
            }
        }
    } else if ($this->isModified()) {
        //Marco como guardando el objeto:
        $this->ORMState = ORM_STATUS::SAVING;
        //self::debug("...esta modificado, tiene id: ".$this->id,0,$orm->getDebug());
        //self::debug("...marco el objeto como ORM_STATUS::SAVING", 0, $orm->getDebug());
        
        //Primero verifico y guardo los atributos:
        if (!is_null($this->ORMModifieds)) {
            
            //Para cada atributo
            foreach(array_keys($this->ORMModifieds) as $attribute) {
                $attMap = $definition->getFieldDefinition($attribute);
                //Verifico que no sea un atributo "objeto", en cuyo caso traigo el ID en vez del valor...
                //...pero para asegurar eso verifico que el objeto tenga un ID, sino lo guardo antes.
                if ($attMap['type']==ORM_TYPES::ORM_ENTITY) {
                    if (!is_null($this->$attribute)) {//Si no es nulo entonces DEBE ser un ORMObject
                        if (is_null($this->$attribute->getId())) $this->$attribute->save($orm);
                        $fieldsToSave[$attMap['table']][$attMap['fieldName']]=$this->$attribute->getId();
                    } else {
                        $fieldsToSave[$attMap['table']][$attMap['fieldName']]=null;
                    }
                } else
                    $fieldsToSave[$attMap['table']][$attMap['fieldName']]=$db->php2db($this->$attribute, $attMap['type']);
                    //Nota: el atributo se pone directamente porque si está modificado no puede ser un LazyLoader.
            }

            //Finalmente se guardan los cambios
            foreach($fieldsToSave as $table => $fields) {
                $fields['id'] = $this->id;
                $db->update($table, $fields);
            }
        }
        //...y luego relaciones

        $relationsMap = $definition->getRelationDefinition();

        //Para guardar las relaciones se asume que aquellas que están como LazyObjects no son
        //objeto de modificación.
        if (!is_null($relationsMap)) {
            foreach($relationsMap as $attribute => $relDefinition) {
                $collection = &$this->$attribute;
                if (is_a($collection, 'ORMCollection')) {
                    $targetDefinition = $orm->getDefinition($relDefinition['class']);
                    if ($collection->isModified()) {
                        if ($relDefinition['type'] == ORM_RELATION_TYPE::ManyToMany) {
                            //Para los objetos agregados, tiene sentido guardarlos si es necesario
                            $added = $collection->getAdded();
                            if (is_array($added))
                                foreach($added as $keyObj=>$obj) {
                                    //if ($this->orm->getDebug()) echo "Hay agregado el elemento ".get_class($obj).":".$obj->getId()."<br/>";
                                    //Tomar el ID del objeto target (guardarlo si no tiene ID o está modificado)
                                    if (is_null($obj->getId()) || $obj->isModified()) $added[$keyObj]->save($orm);
                                    //Con el id local y el del target se agrega la relación a la tabla
                                    $db->addRelation($relDefinition['table'], array($relDefinition['fieldName']=>$this->id,
                                                                                    $relDefinition['associatedFieldName']=>$added[$keyObj]->getId()));
                                }
                            //Para los objetos "desvinculados" sólo se actualiza el estado de la colección
                            //y el objeto queda en el estado en que está
                            $removed = $collection->getRemoved();
                            if (is_array($removed))
                                foreach($removed as $keyObj => $obj) {
                                    //if ($this->orm->getDebug()) echo "Se removi&oacute; el elemento ".get_class($obj).":".$obj->getId()."<br/>";
                                    //Si es null, no hay nada que hacer porque nunca llego a una tabla
                                    if (!is_null($obj->getId())) {
                                        //Remuevo la relación de la tabla
                                        $db->delRelation($relDefinition['table'], array($relDefinition['fieldName']=> $this->id, $relDefinition['associatedFieldName']=> $obj->getId()));
                                    }
                                }
                        } else {
                            //Asignarle $this como valor y guardarlo.
                            //-- Al guardar el objeto solito toma mi ID y se actualiza
                            $added=$collection->getAdded();
                            if (!is_null($added))
                                foreach($added as $keyObj => $obj)
                                    $added[$keyObj]->save($orm);

                            //Asignarle NULL como valor y guardarlo.
                            $removed = $collection->getRemoved();
                            if (!is_null($removed))
                                foreach($removed as $keyObj => $obj)
                                    $removed[$keyObj]->save($orm);
                        }

                        //Finalmente reseteo la colección
                        $collection->reset();
                    }
                }
            }
        }
    }

    //Indico que el objeto a partir de ahora es monitoreado por el ORM
    //-- Esto también quita el estado SAVING
    $orm->attach($this);
    $this->ORMModifieds=null;
    //self::debug("...restaurado a ORM_STATUS::ATTACHED y ORMModifieds=null", -1, $orm->getDebug());
    return true;
    // Bouml preserved body end 00026285
  }

  /**
   * @todo ELIMINAR ESTA FUNCI�N
   * 
   * Retorna un arreglo de todos los atributos p�blicos y protegidos del objeto (adem�s de algunos privados). Es para debug, no debe quedar en el objeto.
   * 
   * @return array La lista de los atributos
   */
  public function getAttributes()
  {
    // Bouml preserved body begin 0007DE85
    return get_object_vars($this);
    // Bouml preserved body end 0007DE85
  }

  final public function getId()
  {
    return $this->id;
  }

  protected function setId($value)
  {
    $this->id = $value;
  }

  final public function getORMState()
  {
    return $this->ORMState;
  }

  protected function setORMState($value)
  {
    $this->ORMState = $value;
  }

  /**
   * Indica si el objeto ha sufrido modificaci�n en sus atributos. Debe destacarse que los atributos directos del objeto son los que participan de esta comprobaci�n, por lo que las modificaciones en objetos asociados no son tenidas en cuenta.
   * 
   * @return boolean true si el objeto ha sido mofificado y falso sino.
   */
  public function isModified()
  {
    // Bouml preserved body begin 00078E05
    //El chequeo de modificaciones se hace en dos pasos:
    //   1) Campos comunes
    //   2) Relaciones
    //Si ya sabemos que hay campos modificados, devuelvo true directamente.
    //Si no hay campos comunes, entonces verifico las relaciones y devuelvo el resultado
    $isModified = ((!is_null($this->ORMModifieds)) && (count($this->ORMModifieds)>0));//Esto no debería aplicar: || (count($this->ORMModifieds)==0);
//    if (!is_null($this->orm)) self::debug(get_class($this)."->isModified():".(($isModified)?"Se detectaron":"No hay")." campos modificados", 0, $this->orm->getDebug());
    if (!$isModified) {
        if (isset($this->orm)) {
            $relations = $this->orm->getDefinition(get_class($this))->getRelationDefinition();
        } else {
            //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
            $class = get_class($this);
            $params = array();
            $relations= $this->invokeStaticMethod($class, "define", $params)->getRelationDefinition();
            //$relations = self::define()->getRelationDefinition();
        }
        //if (!is_null($this->orm) && $this->orm->getDebug()) echo get_class($this)."->isModified(): Buscando en las relaciones...<br/>";
        if ($relations) {
            $relations = array_keys($relations);
            foreach($relations as $attribute) {
                //if (!is_null($this->orm) && $this->orm->getDebug()) echo get_class($this)."->isModified(): ...$attribute ";
                //Si la relación aún no fue cargada entonces no pudo haber sido modificada
                if (is_a($this->$attribute, 'ORMCollection')) {
                    $isModified = $isModified || $this->$attribute->isModified();
                    //if (!is_null($this->orm) && $this->orm->getDebug()) echo ($this->$attribute->isModified())?"modificado!":"sin cambios";
                } else {
                    //if (!is_null($this->orm) && $this->orm->getDebug()) echo "no est&aacute; cargado o es null</br>";
                }
            }
        }
    }
    return $isModified;
    // Bouml preserved body end 00078E05
  }

  /**
   * En el caso de los objetos que ya est�n en base, vuelve a recargar la instancia con los valores de la base.
   * @return boolean true si la recarga fue realizada con �xito o false sino
   */
  public function reload()
  {
    // Bouml preserved body begin 00078E85
	throw new Exception('ORMObject::reload() Método no implementado');
    // Bouml preserved body end 00078E85
  }

  /**
   * Resetea todos los indicadores de cambios del objetos, asumiendo que el estado actual es el de la base de datos si es que est� monitoreado.
   */
  private function reset()
  {
    // Bouml preserved body begin 0007AA05
    $this->ORMModifieds=null;
    // Bouml preserved body end 0007AA05
  }

  /**
   * Magic Method sobreescrito para monitorear los pedidos a getXXX() y setXXX().
   * @param string $method el m�todo invocado
   * @prama array $args la lista de argumentos pasados como par�metro
   * @return mixed|exception si se ejecuta un getXXX se verifica que los argumentos sean vacios y si se ejecuta cun setXXX se chequea que s�lo un argumento sea pasado. Todo lo dem�s arroja una excepci�n en runtime.
   */
  public function __call($method, $args)
  {
    // Bouml preserved body begin 0007AA85
    $methodStart = substr($method, 0, 3);
    //Parche para Twig: si se llama a una propiedad como método, se asume "get" + propiedad.
    if (!in_array($methodStart, array('get', 'set', 'add', 'del'))) {
        $methodStart = 'get';
        $propertyName = $method;
    } else {
        $propertyName = substr($method, 3);
    }
    if(strlen($propertyName) > 0) $propertyName[0]=strtolower($propertyName[0]);
    switch ($methodStart) {
        case "get":
                    //self::debug("Invocado $method", 1, true, true);
                    if (property_exists(get_class($this), $propertyName)) {
                        if (is_a($this->$propertyName, 'LazyLoader')){
                            $this->$propertyName = $this->$propertyName->load();
                        }
                        return $this->$propertyName;
                    }
                    //En caso que no sea una propiedad nativa, puede ser que se intente acceder a un elemento de un array
					try {
						$propertyName2 = $this->pluralize($propertyName);
                        if (is_a($this->$propertyName2, 'LazyLoader')){
                            $this->$propertyName2 = $this->$propertyName2->load();
                        }
                        foreach($this->$propertyName2 as $key => $value) {
                            if ($value->getId() == $args[0]) {
                                return $value;
                            }
                        }
					} catch (ORMException $e) {
                        throw new UnknowAttribute("No se conoce el atributo ".get_class($this)."::$propertyName - fallo en llamado a $method");
                    }
                    break;
        case "set":
                    //self::debug("Invocado $method", 1, true, true);
                    if (property_exists(get_class($this), $propertyName)) {
						if ($this->$propertyName === $args[0]) return $this;//Si se le pasa el mismo valor que ya tiene no se hace NADA.
						
                        $oldValue = $this->$propertyName;
                        $this->$propertyName = $args[0];
                        if ($this->ORMState == ORM_STATUS::ATTACHED)
                            $this->ORMModifieds[$propertyName]=true;

                        if (($this->ORMState != ORM_STATUS::LOADING) && (!$this->ORMModifying)) {

                            $this->ORMModifying = true;

                            //Si el valor es un ORMObject entonces hablamos de un atributo entidad
                            //y del otro lado de la relación es muy probable que exista una relación 1:N
                            //que debe actualizarse.
                            //También puede darse el caso que se le esté asignando NULL a una entidad.

                            //Nota: lo más "correcto" es pedir la definición del campo y chequear por el tipo de campo,
                            //     sin embargo la mayoría de los "sets" son sobre atributos simples y verificar a través
                            //     de la definición de tipos si el valor esperado es o no un objeto penaliza la performance
                            if (is_a($args[0], 'ORMObject') || is_null($args[0])) {
                                //echo get_class($this)."->$method()<br/>";
                                //En base a la definición del atributo, obtengo la definición de la clase de la contraparte
                                if ($this->ORMState == ORM_STATUS::ATTACHED) {
                                    $definition = $this->orm->getDefinition($this);
                                    $myFieldDefinition = $definition->getFieldDefinition($propertyName);
                                } else {
                                    $class = get_class($this);
                                    //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
                                    $params = array();
                                    $definition= $this->invokeStaticMethod($class, "define", $params);
                                    //$definition = $class::define(null);
                                    $myFieldDefinition = $definition->getFieldDefinition($propertyName);
                                }
                                
                                //En este punto ya puedo decidir si lo que se está asignando es o no algo que requiera
                                //actualizar una contraparte. Es decir, hasta acá no sabía (para el caso de null) si era un Int o un Object.
                                if (  (is_null($args[0]) && ($myFieldDefinition['type']==ORM_TYPES::ORM_ENTITY))
                                   || (!is_null($args[0])) ) {

                                    //Esto que está "repetido" es porque acá sí ya conozco que lo que hay del otro lado
                                    //es un objeto del ORM que requiere sincronización
                                    if ($this->ORMState == ORM_STATUS::ATTACHED) {
                                        $otherClassDefinition = $this->orm->getDefinition($myFieldDefinition['class']);
                                    } else {
                                        $class = $myFieldDefinition['class'];
                                        //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
                                        $otherClassDefinition= $this->invokeStaticMethod($class, "define", $params);
                                        //$otherClassDefinition = $class::define(null);
                                    }
                                    
                                    //Luego obtengo la definición del atributo que "colecciona" elementos del tipo del que estoy seteando
                                    $otherRelDefinition = $otherClassDefinition->getRelationDefinition($myFieldDefinition['table'], true);
                                    //echo "...hay que agregarme a ".$myFieldDefinition['class']."->".$otherRelDefinition['attribute']."<br/>";

                                    //Si la relación efectivamente existe...
                                    if (is_array($otherRelDefinition)) {
                                        $getter = self::getter($otherRelDefinition['attribute']);

                                        //Me quito del objeto VIEJO (si no era null o un LazyLoader)
                                        if (!is_null($oldValue)) {
                                            $collection = $this->getAttribute($oldValue, $otherRelDefinition['attribute']);
                                            if (!is_null($collection) && !is_a($collection, 'LazyLoader')) {
                                                foreach($collection as $key=>$value) {
                                                    if ($value === $this) $collection->offsetUnset ($key);
                                                }
                                            }
                                        }
                                        //Me agrego al objeto NUEVO (siempre que no sea la contraparte un LazyLoader)
                                        if (!is_null($args[0])) {
                                            $collection = $this->getAttribute($args[0], $otherRelDefinition['attribute']);
											if (!is_a($collection, 'LazyLoader')) {
												if (is_null($collection)) {
													$collection = new ORMCollection();
													$this->setAttribute($args[0], $otherRelDefinition['attribute'], $collection);
												}
												$collection[]=$this;
											}
                                        }

                                    }
                                }
                            }
                            $this->ORMModifying = false;
                        }
                        return $this;
                    } else {
                        throw new UnknowAttribute("No se conoce el atributo ".get_class($this)."::$propertyName - fallo en llamado a $method");
                    }
                    break;
        case "add":
					try {
						if (property_exists(get_class($this), $propertyName)) {
							$propertyName2 = $propertyName;
						} else {
							$propertyName2 = $this->pluralize($propertyName);
						}
                        //Chequeo si la colección ya está cargada, si es Lazy la cargo
                        if (is_a($this->$propertyName2, 'LazyLoader'))
                            $this->$propertyName2 = $this->$propertyName2->load();
                        //Si la colección queda en null, creo una nueva
                        if (is_null($this->$propertyName2))
                            $this->$propertyName2 = new ORMCollection();
                        //Le asigno el objeto
                        $array = &$this->$propertyName2;
                        $array[]=$args[0];
						//Si ya estaba asignado no hago nada
						$objsAdded = $array->getAdded();
						if (is_null($objsAdded) || !in_array($args[0], $objsAdded, true)) {
								//echo "Omitida instancia ".$args[0]->getId()." de la clase ".get_class($args[0])." porque ya estaba<br/>";
								return $this;
						}
                        if (($this->ORMState != ORM_STATUS::LOADING) && (!$this->ORMModifying)) {
                            $this->ORMModifying=true;
                            //En base a la definición del atributo, obtengo la definición de la clase de la contraparte
                            if ($this->ORMState == ORM_STATUS::ATTACHED) {
                                $definition = $this->orm->getDefinition($this);
                                $myFieldDefinition = $definition->getRelationDefinition($propertyName2);
                                $otherClassDefinition = $this->orm->getDefinition($myFieldDefinition['class']);
                            } else {
                                $class = get_class($this);
                                //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
                                $params = array();
                                $definition= $this->invokeStaticMethod($class, "define", $params);
                                //$definition = $class::define(null);
                                $myFieldDefinition = $definition->getRelationDefinition($propertyName2);
                                $class = $myFieldDefinition['class'];
                                //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
                                $otherClassDefinition= $this->invokeStaticMethod($class, "define", $params);
                                //$otherClassDefinition = $class::define(null);
                            }
                            switch($myFieldDefinition['type']) {
                                case ORM_RELATION_TYPE::ManyToMany:
                                        $otherRelDefinition = $otherClassDefinition->getRelationDefinition($myFieldDefinition['table'], true);
                                            //Fuerzo la carga por si es un Lazy
                                            $getter = self::getter($otherRelDefinition['attribute']);
                                            $args[0]->$getter();
                                        $collection = $this->getAttribute($args[0], $otherRelDefinition['attribute']);
                                        if (is_null($collection)) {
                                            $collection = new ORMCollection();
                                            $this->setAttribute($args[0], $otherRelDefinition['attribute'], $collection);
                                        }
                                        $collection[]=$this;
                                    break;
                                case ORM_RELATION_TYPE::OneToMany:
                                case ORM_RELATION_TYPE::OneToOne:
                                        $otherFieldDefinition = $otherClassDefinition->getFieldDefinition($myFieldDefinition['fieldName'], true);
                                        $setter = self::setter($otherFieldDefinition['attribute']);
                                        $args[0]->$setter($this);
                                    break;
                            }
                            $this->ORMModifying=false;
                        }
                        return $this;
                    } catch (ORMException $e) {
						throw new UnknowAttribute("No se conoce el atributo ".get_class($this)."::$propertyName - fallo en llamado a $method");
					}
                    break;
         case "del":
                    //Para entender esto ver: "set" y "add". Si no se entendieron los anteriores, este no es más fácil.
					if (property_exists(get_class($this), $propertyName)) {
						$propertyName2 = $propertyName;
					} else {
						$propertyName2 = $this->pluralize($propertyName);
					}
                    if (property_exists(get_class($this), $propertyName2)) {
                        if (is_a($this->$propertyName2, 'LazyLoader'))
                            $this->$propertyName2 = $this->$propertyName2->load();
                        
                        //Si la colección es nula no hay nada que hacer
                        if (!is_null($this->$propertyName2)) {
                            foreach($this->$propertyName2 as $key => $value) {
                                if ($value === $args[0]) {
                                    $this->$propertyName2->offsetUnset($key);
                                    
                                    //Se agrega este código para hacer el mantenimiento de los objetos relacionados en memoria
                                    if (($this->ORMState != ORM_STATUS::LOADING) && (!$this->ORMModifying)) {
                                        $this->ORMModifying=true;
                                        
                                        //En base a la definición del atributo, obtengo la definición de la clase de la contraparte
                                        if ($this->ORMState == ORM_STATUS::ATTACHED) {
                                            $definition = $this->orm->getDefinition($this);
                                            $myFieldDefinition = $definition->getRelationDefinition($propertyName2);
                                            $otherClassDefinition = $this->orm->getDefinition($myFieldDefinition['class']);
                                        } else {
                                            $class = get_class($this);
                                            //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
                                            $params = array();
                                            $definition= $this->invokeStaticMethod($class, "define", $params);
                                            //$definition = $class::define(null);
                                            $myFieldDefinition = $definition->getRelationDefinition($propertyName2);
                                            $class = $myFieldDefinition['class'];
                                            //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
                                            $otherClassDefinition= $this->invokeStaticMethod($class, "define", $params);
                                            //$otherClassDefinition = $class::define(null);
                                        }
                                        switch($myFieldDefinition['type']) {
                                            case ORM_RELATION_TYPE::ManyToMany:
                                                    $otherRelDefinition = $otherClassDefinition->getRelationDefinition($myFieldDefinition['table'], true);
                                                    /* YA NO FUERZO la carga, dado que si es un Lazy se va a dar cuenta solo.
													//Fuerzo la carga por si es un Lazy
                                                    $getter = self::getter($otherRelDefinition['attribute']);
                                                    $args[0]->$getter();*/
                                                    $collection = $this->getAttribute($args[0], $otherRelDefinition['attribute']);
                                                    if (!is_null($collection) && !is_a($collection, 'LazyLoader')) {
                                                        //TODO: VER COMO CARAJO SACO EL OBJETO
                                                        foreach($collection as $key2=>$value2) {
                                                            if ($value2 === $this) {
                                                                $this->$propertyName2->offsetUnset($key);
                                                            }
                                                        }
                                                    }
                                                break;
                                            case ORM_RELATION_TYPE::OneToMany:
                                            case ORM_RELATION_TYPE::OneToOne:
                                                    $otherFieldDefinition = $otherClassDefinition->getFieldDefinition($myFieldDefinition['fieldName'], true);
                                                    $setter = self::setter($otherFieldDefinition['attribute']);
                                                    $args[0]->$setter(null);
                                                break;
                                        }
                                        $this->ORMModifying=false;                                        
                                    }
                                    
                                    
                                    //Esta es una forma no muy linda, pero rápida de hacer break+return =)
                                    return $this;
                                }
                            }
                        }
                        return false;
                    }
                    break;
        default:

    }
    // Bouml preserved body end 0007AA85
  }

  /**
   * Retorna el plural de un nombre de atributo.
   * 
   * @param string $attribute el nombre de atributo que queremos poner el plural
   * 
   * @return string el nombre el plural.
   */
  protected function pluralize($attribute)
  {
    // Bouml preserved body begin 00086305
	if ($this->orm !== null) {
		$orm = $this->orm;
	} else {
		$orm = ORM::getInstance();
	}
	$definition = $orm->getDefinition(get_class($this));
	return $definition->pluralize($attribute);
    // Bouml preserved body end 00086305
  }

  /**
   * Genera el string correspondiente al getter del atributo. Por ejemplo: getter('miNombre') = 'getMiNombre'.
   * @param string $attribute el nombre del atributo.
   * @return string el getter
   */
  public static function getter($attribute)
  {
    // Bouml preserved body begin 000DB005
    return "get".strtoupper($attribute[0]).substr($attribute, 1);
    // Bouml preserved body end 000DB005
  }

  /**
   * Retorna el plural de un nombre de atributo.
   * 
   * @param string $attribute el nombre de atributo que queremos poner el plural
   * 
   * @return string el nombre el plural.
   */
  public static function setter($attribute)
  {
    // Bouml preserved body begin 000DB085
    return "set".strtoupper($attribute[0]).substr($attribute, 1);
    // Bouml preserved body end 000DB085
  }

  /**
   * Chequea si se est� en modo debug y en dicho caso imprime el mensaje indicado con la identaci�n indicada
   */
  public static function debug($msj, $ident = 0, $inDebug = false, $autoback = false)
  {
    // Bouml preserved body begin 000E3705
    if ($inDebug) {
        $colores = array('blue', 'green', 'red', 'grey');
        if ($ident > 0) self::$identLvl += $ident;
        
        if (self::$identLvl<1) self::$identLvl=1;
        for($i=1; $i< self::$identLvl; $i++)
            echo "&nbsp;&nbsp;&nbsp;&nbsp;";
        $color = $colores[self::$identLvl % count($colores)];
        echo "<span style=\"color:$color;\">$msj</span><br/>";
        if ($autoback) self::$identLvl -= $ident;
        
        if ($ident < 0) self::$identLvl += $ident;
    }
    // Bouml preserved body end 000E3705
  }

  /**
   * @var el nivel de identaci�n (1 nivel = 4 espacios)
   */
  private static $identLvl;

  /**
   * Valida los atributos DIRECTOS del objeto seg�n las reglas especificadas en la propia definici�n.
   * No llama recursivo porque ser�a muy "engorroso" y factible de caer en la circunstancia de tener una recursi�n infinita.
   * Tampoco se consideran en la validaci�n aquellos atributos asignados con un LazyLoader, dado que si est�n en base se asume que est�n OK.
   * 
   * @return mixed Retorna TRUE si todo est� bien y una matriz 3 dimensional indexada por atributo, validaci�n y errores. En caso que algo falle retorna una matr�z con el siguiente formato:
   * 
   * array (
   * 	0 = > array (
   * 		attribute, array("Error 1", "Error 2")
   * 		)
   * 	...
   * )
   */
  public function validate()
  {
    // Bouml preserved body begin 000FE485

    //Obtengo la definición
    if (isset($this->orm)) {
        $definition = $this->orm->getDefinition(get_class($this));
    } else {
        //Moco para compatibilidad con PHP 5.2.xx
        $params = array();
        $definition= $this->invokeStaticMethod(get_class($this), "define", $params);
    }
    
    //Obtengo los datos básicos desde la definición y preparo el arreglo de aquellas validaciones
    //que sé tienen argumentos "variables".
    $validations = $definition->getValidation();
    $relations = $definition->getRelationDefinition();
    if (is_array($relations))
        $attributes = array_merge($definition->getFieldDefinition(), $relations);
    else $attributes = $definition->getFieldDefinition();
    $errors = array();//Por default no hay errores.
    
    //Primero valido los atributos directos
    foreach($attributes as $attribute => $data) {
        //El único campo que NO se valida es el ID, porque en los objetos nuevos
        //al guardarlos el ID DEBE SER NULO		
        if ($attribute!="id") {
                //Verifico si hay validaciones para el atributo y que el atributo NO SEA un LazyLoader
                if (isset($validations[$attribute]) && (!is_a($this->$attribute, 'LazyLoader')) ) {
                    //Para cada validación
                    foreach($validations[$attribute] as $validation=>$expressions) {
                        if (Validation::isComplexValidation($validation)) {
                            foreach($expressions as $expression) {
                                $validationObj = Validation::getValidation($validation, $expression);
                                $result = $validationObj->validate($this->$attribute);
                                if ($result !== TRUE) {
                                    $errors[$attribute][]=$result;
                                }
                            }
                        } else {
                            $validationObj = Validation::getValidation($validation);
                            $result = $validationObj->validate($this->$attribute);
                            if ($result !== TRUE) {
                                $errors[$attribute][]=$result;
                            }
                        }

                    }
                }
        }
    }
    if (count($errors) <= 0) return true;
    else return $errors;
    // Bouml preserved body end 000FE485
  }

  /**
   * Devuelve si está o no modificado un cierto atributo.
   * 
   * @param string $attribute El nombre del atributo a verificar.
   * 
   * @return boolean un TRUE si el atributo ha sido efectivamente modificado, FALSE sino.
   */
  public function isAttributeModified($attribute)
  {
    // Bouml preserved body begin 00170F85
	return (isset($this->ORMModifieds[$attribute]) && $this->ORMModifieds[$attribute]);
    // Bouml preserved body end 00170F85
  }

  /**
   * Retorna la lista de atributos modificados de la última sincronización con la base de datos.
   * 
   * @return array Una lista de strings donde cada string es el nombre de un atributo modificado desde la última operación de sincronización.
   */
  public function getModifiedAttributes()
  {
    // Bouml preserved body begin 00187F85
	if ($this->ORMModifieds != null)
		return array_keys($this->ORMModifieds);
	else
		return Array();
    // Bouml preserved body end 00187F85
  }

}
?>
