<?php
require_once 'iplan/orm/exceptions/DMLOperationFailed.php';
require_once 'iplan/database/Connection.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Ac se abstraer la plataforma de base de datos
 */
abstract class AbstractDataBase {
  /**
   * Dada una tabla y el identificador de registros, devuelve los valores de los campos especificados.
   * @abstract
   * @param $table string el nombre de la tabla
   * @param $id long el identificador de la fila en la que estamos interesados
   * @param $fields array un arreglo de strings con los nombres de las columnas a recuperar
   * @return array|false un arreglo asociativo (field=>value) con los valores recuperados de la base o false si hubo algn error.
   */
  public abstract function getData($table, $id, $fields = "")
  ;
  /**
   * Retorna el valor del campo especificado. El nombre de la columna debe ser el simil al campo definido en la base de datos. La intencin es usarlo para recuperar campos BLOB, CLOB y otros "pesados" sobre demanda.
   * 
   * @param string $table el nombre de la tabla
   * @param int $id el identificador del registro
   * @param string $field el nombre del campo a recuperar
   * 
   * @return mixed el valor del campo recuperado.
   */
  public abstract function getField($table, $id, $field)
  ;
  /**
   * Igual a getData() pero mltiples filas. La idea sera recibir "cuaternas" que armen el SQL a ejecutar en base a la iteracin sobre los parmetros (hasta que se acaben) y un gran switch sobre "operation".
   * @param string $table el nombre de la tabla desde la cual recuperar los datos
   * @param array $fields un arreglo de strings con los nombres de los campos a recuperar
   * @param array $conditions otro arreglo con los condicionales codificados, cada uno, de la siguiente forma:array(operation, leftValue, rightValue, connector). Usar AbstractDataBase::makeCondition().
   * @param array $order se pasa aqu un arreglo de strings con formato "nombreColumna [ASC|DESC]", lo cual ordenar el conjunto de resultados.
   * @param int $from indica a partir de qu fila del resultset se desea acceder. Si se indica null trae desde la primer fila.
   * @param int $count indica cuntas filas a partir del $from se deben recuperar, si se indica null se recuperan todas.
   * @return array|false el conjunto de resultados o falso si hubo algn error
   */
  public abstract function filter($table, $fields, $conditions = "", $order = "", $from = null, $count = null)
  ;
  /**
   * Inserta un registro en la tabla con los campos que se indiquen.
   * 
   * @param string $table el nombre de la tabla en la que se desea insertar
   * @param array $fields un arreglo con los campos a insertar. Ntese que las claves son los FieldNames y que all se instarn los valores de dichas claves.
   * @param boolean $useGenerator un booleano que indica si al hacer un insert se debe autodetectar la clave primaria y emplear el generador de dicha clave o si slo se emplean los valores pasados por parmetro.
   * 
   * @return int el identificador con el cual qued el registro en la tabla.
   */
  public abstract function insert($table, $fields, $useGenerator = true)
  ;
  /**
   * Realiza un UPDATE sobre la tabla y los campos indicados, es parecido a filter.
   * 
   * @param string $table el nombre de la tabla a actualizar
   * @param array $fields un arreglo cuyas claves son los nombres de los campos a actualizar.
   * @param array $conditions otro arreglo donde cada elemento es un arreglo con el siguiente formato: array(field, operation, value1, value2, connector) el cual se puede generar con la funcin makeCondition() de cualquier miembro de la jerarqua de AbstractDataBase.
   * 
   * @return int|false el nmero de filas afectadas o false si hubo error
   */
  public abstract function update($table, $fields, $conditions = "")
  ;
  /**
   * Borra un registro de la tabla segn su id o un conjunto de condiciones.
   * 
   * @param string $table el nombre de la tabla sobre la cual hacer el borrado.
   * @param int|array $what puede ser un entero (el id) o un arreglo de condiciones.
   * 
   * @return int|false la cantidad de filas afectadas o false si hubo error
   */
  public abstract function delete($table, $what)
  ;
  /**
   * Agrega un registro de relacin de una relacin M:N
   * 
   * @param string $table el nombre de la tabla relacin
   * @param array $fields un arreglo indexado por el nombre del campo de la base de datos
   * 
   * @return boolean Retorna TRUE si la operacin se realiz con xito, FALSE sino.
   */
  public abstract function addRelation($table, $fields)
  ;
  /**
   * Quita un registro de relacin de una relacin M:N
   * 
   * @param string $table el nombre de la tabla relacin
   * @param array $fields un arreglo indexado por el nombre del campo de la base de datos para filtrar
   * 
   * @return boolean Retorna TRUE si la operacin se realiz con xito, FALSE sino.
   */
  public abstract function delRelation($table, $fields)
  ;
  /**
   * Similar a execute() pero slo contabiliza la cantidad de registros.
   */
  public abstract function count(&$coded_sql)
  ;
  /**
   * Funcin de utilera para crear una condicin
   * 
   * @param string $operation la operacin de comparacin o verificacin: =, &lt;&gt;, LIKE, IN, NOT, BETWEEN. En el caso de IN la funcin espera que el rightValue sea un array y separa sus componentes por "," y los encierra entre parntesis.
   * @param mixed $leftValue el primer operando
   * @param mixed $rightValue el segundo operando
   * @connector string $connector el conector con el que se debe unir esta condicin con la siguiente (AND, OR)
   * @return array el arreglo de la condicin formateado
   */
  public abstract function makeCondition($operation, $leftValue, $rightValue, $connector = "")
  ;
  /**
   * Convierte valores PHP a la representacin necesaria para que la base de datos lo entienda. Debe ser utilizado para pasar los "values" en las funciones.
   * @param mixed $value el valor nativo de PHP que se desea convertir
   * @param int $type el tipo al que queremos castear, adopta las constates de ORM_TYPES
   * 
   * @return mixed El valor que requiere la base de datos
   */
  public abstract function php2db($value, $type)
  ;
  /**
   * Convierte valores devueltos por la base de datos a la representacin PHP solicitada. Debe ser utilizado para pasar los "values" en las funciones.
   * @param mixed $value el valor nativo de PHP que se desea convertir
   * @param int $type el tipo al que queremos castear, adopta las constates de ORM_TYPES
   * 
   * @return mixed El valor convertido a su representacin PHP ms prxima
   */
  public abstract function db2php($value, $type)
  ;
  /**
   * Retorna un valor de fecha y hora de la base.
   * 
   * @return datetime El momento en el cual se efecta el llamado segn la base de datos.
   */
  public abstract function getDateTime()
  ;
  /**
   * Devuelve la conexin usada por la instancia.
   * 
   * @return Connection La conexin que utiliza la instancia de base de datos
   */
  public abstract function getConnection()
  ;
}
?>