<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class SiteForm extends ABMForm {
  /**
   * Crea un formulario de ABM de un Site
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122E85
	parent::__construct($orm, $context);
	
	$this->setClass("Site")
		   ->setTitle("Sitio")
		   ->setMethod("post")
			->setFormType(Form::FORM_OK_CANCEL)
		   ->setId("id_form_site");
	
	$this->context = $context;
	$client_id = $this->getValueOf("cliente_id");
	
	//Agrego el componente hidden de site_id
	$client = new HiddenComponent();
	$client->setMaps('client')
			->setName("cliente_id")
		   ->setValue($client_id);
	
		
	$payplanOptions = $orm->query('PayPlan')
						  ->attributes('id AS value', 'description')
						  ->find();
	

	$description = new TextComponent();
	$description->setLabel("Descripcion")
				->setMaps('description');
	
	$payplan = new SelectComponent();
	$payplan->setLabel("Plan de Pago")
			    ->setMaps('payPlan')
				->setOptions($payplanOptions);
	
	
	$status = new SelectComponent();
	$status->setLabel("Estado")
			->setMaps('status')
			->setSelected("1")
			->setOptions(array(array("value" => "1", "description" => "Activo"), array("value" => "0", "description" => "Inactivo")));

	$location = new TextComponent();
	$location->setLabel("ID Location Tenfold")
			->setMaps('location');
	
	$subscription = new TextComponent();
	$subscription->setLabel("ID Subscription Tenfold")
			->setMaps('subscription');
	
	$group = new TextComponent();
	$group->setLabel("ID Grupo BS")
			->setMaps('group');
	
	$username = new TextComponent();
	$username->setLabel("Admin Username BS")
			->setMaps('username');
	
	$password = new TextComponent();
	$password->setLabel("Admin Password BS")
			->setMaps('password');
	
	$serviceProviderOptions = $orm->query('Client')->attributes('reseller.serviceProviders.id AS value', 'reseller.serviceProviders.description AS description')
									->filterBy('id', '=', $client_id)
									->find();
	
	$serviceProvider = new SelectComponent();
	$serviceProvider->setLabel("Service Provider")
					->setMaps('serviceProvider')
					->setOptions($serviceProviderOptions);
	

	/*$compBotonete = new ButtonComponent();
	$compBotonete->setLabel("")
				 ->setId('id_sumb')
				 ->setName('subm')
				 ->setAction('submit')
				 ->setValue("Aceptar");*/

	$oLayout1 = new GridLayout(9 /*15*/, 1);
	$oLayout1->addComponent($serviceProvider, 1, 1)
			 ->addComponent($description, 2, 1)
			 ->addComponent($location, 3, 1)
			 ->addComponent($status, 4, 1)
			 ->addComponent($subscription, 5, 1)
			 ->addComponent($payplan, 6, 1)
			 ->addComponent($group, 7, 1)
			 ->addComponent($username, 8, 1)
			 ->addComponent($password, 9, 1)
			 /*->addComponent($compBotonete, 10, 1)*/;

	$this->addComponent($oLayout1)->addComponent($client);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122E85
  }

}
?>