<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ServiceProviderForm extends ABMForm {
  /**
   * Crea un formulario de ABM de un ServiceProvider
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122C85
	parent::__construct($orm, $context);

	$description = new TextComponent();
	$description->setLabel("Descripcion")
		->setMaps('description');

	$identifier = new TextComponent();
	$identifier->setLabel("Broadsoft ID")
		->setMaps('identifier');

	$servicePacksOptions = $orm->query('ServicePack')
		->attributes('id AS value', 'description')
		->find();
	
	$servicePacks = new MultiselectComponent();
	$servicePacks->setLabel("Service Packs Autorizados")
		->setMaps('servicePacks')
		->setOptions($servicePacksOptions);
	
	$productoOptions = $orm->query('Product')
		->attributes('id AS value', 'description')
		->find();
	
	$producto = new SelectComponent();
	$producto->setLabel("Producto")
		->setMaps('product')
		->setOptional(false)
		->setOptions($productoOptions);

	$recursoOptions = $orm->query('Resource')
		->attributes('id AS value', 'description')
		->find();

	$recurso = new MultiselectComponent();
	$recurso->setLabel("Recursos Autorizados")
		->setMaps('resources')
		->setOptions($recursoOptions);

/*	$resellerOptions = $orm->query('Reseller')
		->attributes('id AS value', 'provider.name AS description')
		->find();*/
	$wholesale = $context->getManager('Wholesale');
	$currentReseller = $wholesale->getCurrentReseller();
    $resellerOptions = $wholesale->getOwnedResellers($currentReseller,array('id AS value', 'provider.name AS description'));
	
	$reseller = new SelectComponent();
	$reseller->setLabel("Revendedor")
		->setMaps('reseller')
		->setOptions($resellerOptions);

	/*$compBotonete = new ButtonComponent();
	$compBotonete->setLabel("")
		->setId('id_sumb')
		->setName('subm')
		->setAction('submit')
		->setValue("Aceptar");*/

	$oLayout1 = new GridLayout(3 /*4*/, 2);
	$oLayout1->addComponent($reseller, 1, 1)
		->addComponent($producto, 1, 2)
		->addComponent($description, 2, 1)
		->addComponent($identifier, 2, 2)
		->addComponent($servicePacks, 3, 1)
		->addComponent($recurso, 3, 2)
		/*->addComponent($compBotonete, 4, 1, 2, 1)*/;

	$this->setClass("ServiceProvider")
		->setTitle("Service Provider")
		->setMethod("post")
		->setId("id_form_ServiceProvider")
		->setFormType(Form::FORM_OK_CANCEL)
		->addComponent($oLayout1);

	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122C85
  }

}
?>