<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ServicePackForm extends ABMForm {
  /**
   * Crea un formulario de ABM de un Pack de servicios
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00123085
	parent::__construct($orm, $context);
	
	$description = new TextComponent();
	$description->setLabel("Broadsoft ID")
				->setSize('40')
				->setMaps('description');
	
	$attributeName = new TextComponent();
	$attributeName->setLabel("Atributo")
				  ->setSize('40')
				  ->setMaps('attributeName');
	
	$fieldName = new TextComponent();
	$fieldName->setLabel("Field Name")
				  ->setSize('40')
				  ->setMaps('fieldName');
	
	/*$compBotonete = new ButtonComponent();
	$compBotonete->setLabel("")
				 ->setId('id_sumb')
				 ->setName('subm')
				 ->setAction('submit')
				 ->setValue("Aceptar");*/

	$oLayout1 = new GridLayout(2, 2);
	$oLayout1->addComponent($description, 1, 1)
			 ->addComponent($attributeName, 1, 2)
			 ->addComponent($fieldName, 2, 1)
			 /*->addComponent($compBotonete, 2, 1, 2, 1)*/;

	$this->setClass("ServicePack")
		   ->setTitle("Service Pack")
		   ->setMethod("post")
		   ->setId("id_form_servicepack")
			->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);

	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00123085
  }

}
?>