<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ResourceForm extends ABMForm {
  /**
   * Crea un formulario de ABM de Resource
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122C05
	parent::__construct($orm, $context);
	
	$description = new TextComponent();
	$description->setLabel("Broadsoft ID")
		 ->setMaps('description');
	
	$field = new TextComponent();
	$field->setLabel("Campo Mapea")
		  ->setMaps('field');

	/*$compBotonete = new ButtonComponent();
	$compBotonete->setLabel("")
				 ->setId('id_sumb')
				 ->setName('subm')
				 ->setAction('submit')
				 ->setValue("Aceptar");*/

	$oLayout1 = new GridLayout(2 /*3*/, 1);
	$oLayout1->addComponent($description, 1, 1)
			 ->addComponent($field, 2, 1)
			 /*->addComponent($compBotonete, 3, 1)*/;

	$this->setClass("Resource")
		   ->setTitle("Recursos")
		   ->setMethod("post")
		   ->setId("id_form_resources")
		   ->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);

	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122C05
  }

}
?>