<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/wholesale/Reseller.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ResellerForm extends ABMForm {
  /**
   * Crea un formulario de ABM de Reseller
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122B85
	parent::__construct($orm, $context);
	
	$blockOptions = $orm->query('NumerationBlock')
						 ->attributes('id AS value', 'from', 'to')
						 ->find();
	
	if (is_array($blockOptions)) {
		for ($i = 0; $i < count($blockOptions); $i++) {
			$blockOptions[$i]["description"] = $blockOptions[$i]["from"] . ' ~ ' . $blockOptions[$i]["to"];
			unset($blockOptions[$i]["from"]);
			unset($blockOptions[$i]["to"]);
		}
	}

//	$providerOptions = $orm->query('Provider')
//							->attributes('id AS value', 'alias AS description')
//							->find();
	
	$serviceProvidersOptions = $orm->query('ServiceProvider')
							->filterBy('reseller', 'IS NULL')
							->attributes('id AS value', 'description')
							->find();
	
	$name = new TextComponent();
	$name->setLabel("Revendedor")
		      ->setSize(50)
			  ->setMaps('name');
	
	$prefix = new TextComponent();
	$prefix->setLabel("Prefijo")
			->setMaps('prefix');

	$tenfoldId = new TextComponent();
	$tenfoldId->setLabel("Tenfold ID")
			  ->setMaps("tenfoldId");
	
	$blocks = new MultiselectComponent();
	$blocks->setLabel("Bloques de Numeración")
			->setMaps('blocks')
			->setOptions($blockOptions);
	
	$accountAndOrder = new SelectComponent();
	$accountAndOrder->setLabel("Cuenta & Orden")
					->setMaps('accountAndOrder')
					->setOptional(false)
					->setOptions(array(array("value" => "0", "description" => "No"), array("value" => "1", "description" => "Si")));
	
	$status = new SelectComponent();
	$status->setLabel("Estado")
		   ->setMaps('status')
		   ->setOptions(array(array("value" => "1", "description" => "Activo"), array("value" => "0", "description" => "Inactivo")));
	
	$provider = new SelectComponent();
	$provider->setLabel("Provider")
			 ->setMaps('provider');
	
	$serviceProviders = new MultiselectComponent();
	$serviceProviders->setLabel("Service Provider BS")
					 ->setMaps('serviceProviders')
					 ->setOptions($serviceProvidersOptions);
	

	$compBotonete = new ButtonComponent();
	$compBotonete->setLabel("")
				 ->setId('id_sumb_reseller')
				 ->setName('subm')
				 ->setAction('submit')
				 ->setValue("Aceptar");

	$oLayout1 = new GridLayout(5 /*6*/, 2);
	$oLayout1->addComponent($name, 1, 1, 2, 1, 'left')
			 ->addComponent($prefix, 2, 1)
			 ->addComponent($tenfoldId, 2, 2)
			 ->addComponent($blocks, 3, 1)
			 ->addComponent($accountAndOrder, 2, 2)
			 ->addComponent($status, 4, 1)
			 ->addComponent($provider, 5, 1)
			 ->addComponent($serviceProviders, 5, 2)
			 /*->addComponent($compBotonete, 6, 1, 2, 1)*/;
	
	$this->setClass("Reseller")
		   ->setTitle("Revendedor")
		   ->setMethod("post")
		   ->setId("id_form_reseller")
		   ->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122B85
  }

  /**
   * Funcin invocada para crear una instancia del objeto que representa el formulario
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali bien y un FALSE sino.
   */
  public function fresh($context, $orm)
  {
    // Bouml preserved body begin 00129C05
	$providerOptions = $context->getManager('Security')->getOwnedProviders($context->getProvider(), array('id AS value', 'alias AS description'));
	$this->getComponent('provider')->setOptions($providerOptions);
	return true;
    // Bouml preserved body end 00129C05
  }

  /**
   * Funcin invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00129C85
	  
	//ResellerOptions
	$oResellerModificar = $orm->load('Reseller', $this->getValueOf('id'));
	$serviceProvidersOptions = $orm->query('ServiceProvider')
						->filterBy('reseller', 'IS NULL')
						->filterBy("reseller.id", "=", $this->getValueOf("id"), null, "OR")
						->attributes('id AS value', 'description')
						->find();
	$this->getComponent("serviceProviders")->setOptions($serviceProvidersOptions);
	
	//ProviderOptions
	$providerOptions = $context->getManager('Security')->getOwnedProviders($oResellerModificar->getProvider(), array('id AS value', 'name AS description'), true);
	$this->getComponent('provider')->setOptions($providerOptions);
	
	$this->getValuesFromObject($oResellerModificar);
	return true;
    // Bouml preserved body end 00129C85
  }

  /**
   * Funcin invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return Reseller El objeto ya guardado si todo sali bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 00129D05

	//Validaciones
	$valido = $this->validate();
	if ($valido === true) {
		$id = $this->getValueOf('id');
		if (is_null($id) || ($id=="")) {
			$oReseller = new Reseller();
		} else {
			$oReseller = $orm->load('Reseller', $this->getValueOf('id'));
		}
		$this->setValuesToObject($oReseller);
		$orm->save($oReseller);
		return $oReseller;
	} else {
		//Seteo error de contexto de validacion xd.-
		return $valido;
	}
    // Bouml preserved body end 00129D05
  }

  /**
   * Funcin invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 00129D85
	$oReseller = $orm->load('Reseller', $this->getValueOf('id'));
	$orm->delete($oReseller);
	return true;
    // Bouml preserved body end 00129D85
  }

}
?>